/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.iterable.SingletonIterator;
import explicit.MDP;
import explicit.modelviews.MDPView;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import parser.State;
import parser.Values;
import parser.VarList;

public class MDPAdditionalChoices
extends MDPView {
    private MDP model;
    private IntFunction<List<Iterator<Map.Entry<Integer, Double>>>> choices;
    private IntFunction<List<Object>> actions;

    public MDPAdditionalChoices(MDP mDP, IntFunction<List<Iterator<Map.Entry<Integer, Double>>>> intFunction, IntFunction<List<Object>> intFunction2) {
        this.model = mDP;
        this.choices = intFunction;
        this.actions = intFunction2;
    }

    public MDPAdditionalChoices(MDPAdditionalChoices mDPAdditionalChoices) {
        super(mDPAdditionalChoices);
        this.model = mDPAdditionalChoices.model;
        this.choices = mDPAdditionalChoices.choices;
        this.actions = mDPAdditionalChoices.actions;
    }

    public MDPView clone() {
        return new MDPAdditionalChoices(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public int getNumChoices(int n) {
        return this.model.getNumChoices(n) + this.getNumAdditionalChoices(n);
    }

    @Override
    public Object getAction(int n, int n2) {
        int n3 = this.model.getNumChoices(n);
        if (n2 < n3) {
            return this.model.getAction(n, n2);
        }
        if (this.actions == null) {
            int n4 = n3 + this.getNumAdditionalChoices(n);
            if (n2 < n4) {
                return null;
            }
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        List<Object> list = this.actions.apply(n);
        return list == null ? null : list.get(n2 - n3);
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        return this.model.areAllChoiceActionsUnique() && super.areAllChoiceActionsUnique();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        int n3 = this.model.getNumChoices(n);
        if (n2 < n3) {
            return this.model.getTransitionsIterator(n, n2);
        }
        try {
            return this.choices.apply(n).get(n2 - n3);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
    }

    @Override
    protected void fixDeadlocks() {
        assert (!this.fixedDeadlocks) : "deadlocks already fixed";
        this.model = MDPAdditionalChoices.fixDeadlocks(this.clone());
        this.choices = n -> null;
        this.actions = null;
    }

    private int getNumAdditionalChoices(int n) {
        List<Iterator<Map.Entry<Integer, Double>>> list = this.choices.apply(n);
        return list == null ? 0 : list.size();
    }

    public static MDPView fixDeadlocks(MDP mDP) {
        BitSet bitSet = new BitSet();
        mDP.getDeadlockStates().forEach(bitSet::set);
        MDPView mDPView = MDPAdditionalChoices.addSelfLoops(mDP, bitSet);
        mDPView.deadlockStates = bitSet;
        mDPView.fixedDeadlocks = true;
        return mDPView;
    }

    public static MDPView addSelfLoops(MDP mDP, BitSet bitSet) {
        return MDPAdditionalChoices.addSelfLoops(mDP, bitSet::get);
    }

    public static MDPView addSelfLoops(MDP mDP, final IntPredicate intPredicate) {
        IntFunction<List<Iterator<Map.Entry<Integer, Double>>>> intFunction = new IntFunction<List<Iterator<Map.Entry<Integer, Double>>>>(){

            @Override
            public List<Iterator<Map.Entry<Integer, Double>>> apply(int n) {
                if (intPredicate.test(n)) {
                    AbstractMap.SimpleImmutableEntry<Integer, Double> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Integer, Double>(n, 1.0);
                    return Collections.singletonList(new SingletonIterator.Of<AbstractMap.SimpleImmutableEntry<Integer, Double>>(simpleImmutableEntry));
                }
                return null;
            }
        };
        return new MDPAdditionalChoices(mDP, intFunction, null);
    }
}

