/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.iterable.FilteringIterator;
import common.iterable.SingletonIterator;
import explicit.DTMC;
import explicit.modelviews.DTMCView;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import parser.State;
import parser.Values;
import parser.VarList;

public class DTMCAlteredDistributions
extends DTMCView {
    private static final Predicate<Map.Entry<Integer, Double>> nonZero = entry -> (Double)entry.getValue() > 0.0;
    private DTMC model;
    private IntFunction<Iterator<Map.Entry<Integer, Double>>> mapping;

    public DTMCAlteredDistributions(DTMC dTMC, IntFunction<Iterator<Map.Entry<Integer, Double>>> intFunction) {
        this.model = dTMC;
        this.mapping = intFunction;
    }

    public DTMCAlteredDistributions(DTMCAlteredDistributions dTMCAlteredDistributions) {
        super(dTMCAlteredDistributions);
        this.model = dTMCAlteredDistributions.model;
        this.mapping = dTMCAlteredDistributions.mapping;
    }

    public DTMCAlteredDistributions clone() {
        return new DTMCAlteredDistributions(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.mapping.apply(n);
        if (iterator == null) {
            return this.model.getTransitionsIterator(n);
        }
        return new FilteringIterator.Of<Map.Entry<Integer, Double>>(iterator, nonZero);
    }

    @Override
    protected void fixDeadlocks() {
        assert (!this.fixedDeadlocks) : "deadlocks already fixed";
        this.model = DTMCAlteredDistributions.fixDeadlocks(this.clone());
        this.mapping = n -> null;
    }

    public static DTMCAlteredDistributions fixDeadlocks(DTMC dTMC) {
        BitSet bitSet = new BitSet();
        dTMC.getDeadlockStates().forEach(bitSet::set);
        DTMCAlteredDistributions dTMCAlteredDistributions = DTMCAlteredDistributions.addSelfLoops(dTMC, bitSet);
        dTMCAlteredDistributions.deadlockStates = bitSet;
        dTMCAlteredDistributions.fixedDeadlocks = true;
        return dTMCAlteredDistributions;
    }

    public static DTMCAlteredDistributions addSelfLoops(DTMC dTMC, final BitSet bitSet) {
        IntFunction<Iterator<Map.Entry<Integer, Double>>> intFunction = new IntFunction<Iterator<Map.Entry<Integer, Double>>>(){

            @Override
            public Iterator<Map.Entry<Integer, Double>> apply(int n) {
                if (bitSet.get(n)) {
                    AbstractMap.SimpleImmutableEntry<Integer, Double> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Integer, Double>(n, 1.0);
                    return new SingletonIterator.Of<Map.Entry<Integer, Double>>(simpleImmutableEntry);
                }
                return null;
            }
        };
        return new DTMCAlteredDistributions(dTMC, intFunction);
    }
}

