/*
 * Decompiled with CFR 0.152.
 */
package explicit.graphviz;

import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.StateRewards;
import java.util.Collections;
import java.util.List;

public class ShowStateRewardsDecorator
implements Decorator {
    private List<StateRewards> rewards;
    private boolean showAllZero;

    public ShowStateRewardsDecorator(StateRewards stateRewards, boolean bl) {
        this(Collections.singletonList(stateRewards), bl);
    }

    public ShowStateRewardsDecorator(List<StateRewards> list, boolean bl) {
        this.rewards = list;
        this.showAllZero = bl;
    }

    @Override
    public Decoration decorateState(int n, Decoration decoration) {
        boolean bl = true;
        for (StateRewards object : this.rewards) {
            double d = 0.0;
            if (object instanceof MCRewards) {
                d = ((MCRewards)((Object)this.rewards)).getStateReward(n);
            } else if (object instanceof MDPRewards) {
                d = ((MDPRewards)((Object)this.rewards)).getStateReward(n);
            }
            if (d == 0.0) continue;
            bl = false;
            break;
        }
        if (bl && !this.showAllZero) {
            return decoration;
        }
        Object object = "";
        for (StateRewards stateRewards : this.rewards) {
            double d = 0.0;
            if (stateRewards instanceof MCRewards) {
                d = ((MCRewards)((Object)this.rewards)).getStateReward(n);
            } else if (stateRewards instanceof MDPRewards) {
                d = ((MDPRewards)((Object)this.rewards)).getStateReward(n);
            }
            if (!((String)object).isEmpty()) {
                object = (String)object + ",";
            }
            object = (String)object + d;
        }
        decoration.labelAddBelow((String)object);
        return decoration;
    }
}

