/*
 * Decompiled with CFR 0.152.
 */
package explicit.graphviz;

import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;

public class ShowRewardDecorator
implements Decorator {
    private Rewards rewards;
    private boolean showZero;

    public ShowRewardDecorator(Rewards rewards) {
        this(rewards, false);
    }

    public ShowRewardDecorator(Rewards rewards, boolean bl) {
        this.rewards = rewards;
        this.showZero = bl;
    }

    @Override
    public Decoration decorateState(int n, Decoration decoration) {
        double d = 0.0;
        if (this.rewards instanceof MCRewards) {
            d = ((MCRewards)this.rewards).getStateReward(n);
        } else if (this.rewards instanceof MDPRewards) {
            d = ((MDPRewards)this.rewards).getStateReward(n);
        }
        if (d == 0.0 && !this.showZero) {
            return decoration;
        }
        decoration.labelAddBelow("+" + d);
        return decoration;
    }

    @Override
    public Decoration decorateTransition(int n, int n2, Decoration decoration) {
        if (!(this.rewards instanceof MDPRewards)) {
            return decoration;
        }
        double d = ((MDPRewards)this.rewards).getTransitionReward(n, n2);
        if (d == 0.0 && !this.showZero) {
            return decoration;
        }
        decoration.labelAddBelow("+" + d);
        return decoration;
    }
}

