/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import parser.State;
import parser.ast.ExpressionFunc;
import parser.ast.RelOp;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismUtils;
import prism.StateVector;

public class StateValues
implements StateVector {
    protected Type type;
    protected int size;
    protected int[] valuesI;
    protected double[] valuesD;
    protected BitSet valuesB;
    protected List<State> statesList;

    public StateValues() {
        this.type = null;
        this.size = 0;
        this.valuesI = null;
        this.valuesD = null;
        this.valuesB = null;
    }

    public StateValues(Type type, Model model) throws PrismLangException {
        this(type, model.getNumStates());
        this.statesList = model.getStatesList();
    }

    public StateValues(Type type, int n) throws PrismLangException {
        this(type, n, type.defaultValue());
    }

    public StateValues(Type type, Object object, Model model) throws PrismLangException {
        this(type, model.getNumStates(), object);
        this.statesList = model.getStatesList();
    }

    public StateValues(Type type, int n, Object object) throws PrismLangException {
        this.type = type;
        this.size = n;
        if (type instanceof TypeInt) {
            this.valuesI = new int[n];
            Integer n2 = ((TypeInt)type).castValueTo(object);
            int n3 = n2;
            for (int i = 0; i < n; ++i) {
                this.valuesI[i] = n3;
            }
        } else if (type instanceof TypeDouble) {
            this.valuesD = new double[n];
            Double d = ((TypeDouble)type).castValueTo(object).doubleValue();
            double d2 = d;
            for (int i = 0; i < n; ++i) {
                this.valuesD[i] = d2;
            }
        } else if (type instanceof TypeBool) {
            Boolean bl = ((TypeBool)type).castValueTo(object);
            boolean bl2 = bl;
            if (bl2) {
                this.valuesB = new BitSet(n);
                this.valuesB.set(0, n);
            } else {
                this.valuesB = new BitSet();
            }
        } else {
            throw new PrismLangException("Cannot create a vector of type " + type);
        }
    }

    public static StateValues createFromIntegerArray(int[] nArray, Model model) {
        StateValues stateValues = new StateValues();
        stateValues.type = TypeInt.getInstance();
        stateValues.size = nArray.length;
        stateValues.valuesI = nArray;
        stateValues.statesList = model.getStatesList();
        return stateValues;
    }

    public static StateValues createFromDoubleArray(double[] dArray, Model model) {
        StateValues stateValues = new StateValues();
        stateValues.type = TypeDouble.getInstance();
        stateValues.size = dArray.length;
        stateValues.valuesD = dArray;
        stateValues.statesList = model.getStatesList();
        return stateValues;
    }

    public static StateValues createFromBitSet(BitSet bitSet, Model model) {
        StateValues stateValues = new StateValues();
        stateValues.type = TypeBool.getInstance();
        stateValues.size = model.getNumStates();
        stateValues.valuesB = bitSet;
        stateValues.statesList = model.getStatesList();
        return stateValues;
    }

    public static StateValues createFromBitSetAsDoubles(BitSet bitSet, Model model) {
        int n = model.getNumStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bitSet.get(i) ? 1.0 : 0.0;
        }
        return StateValues.createFromDoubleArray(dArray, model);
    }

    public BitSet getBitSetFromInterval(String string, double d) throws PrismException {
        return this.getBitSetFromInterval(RelOp.parseSymbol(string), d);
    }

    public BitSet getBitSetFromInterval(RelOp relOp, double d) throws PrismException {
        BitSet bitSet;
        block21: {
            block22: {
                block20: {
                    bitSet = new BitSet();
                    if (!(this.type instanceof TypeInt)) break block20;
                    switch (relOp) {
                        case GEQ: {
                            for (int i = 0; i < this.size; ++i) {
                                bitSet.set(i, (double)this.valuesI[i] >= d);
                            }
                            break block21;
                        }
                        case GT: {
                            for (int i = 0; i < this.size; ++i) {
                                bitSet.set(i, (double)this.valuesI[i] > d);
                            }
                            break block21;
                        }
                        case LEQ: {
                            for (int i = 0; i < this.size; ++i) {
                                bitSet.set(i, (double)this.valuesI[i] <= d);
                            }
                            break block21;
                        }
                        case LT: {
                            for (int i = 0; i < this.size; ++i) {
                                bitSet.set(i, (double)this.valuesI[i] < d);
                            }
                            break block21;
                        }
                        default: {
                            throw new PrismException("Unsupported operator " + relOp + " for getBitSetFromInterval()");
                        }
                    }
                }
                if (!(this.type instanceof TypeDouble)) break block22;
                switch (relOp) {
                    case GEQ: {
                        for (int i = 0; i < this.size; ++i) {
                            bitSet.set(i, this.valuesD[i] >= d);
                        }
                        break block21;
                    }
                    case GT: {
                        for (int i = 0; i < this.size; ++i) {
                            bitSet.set(i, this.valuesD[i] > d);
                        }
                        break block21;
                    }
                    case LEQ: {
                        for (int i = 0; i < this.size; ++i) {
                            bitSet.set(i, this.valuesD[i] <= d);
                        }
                        break block21;
                    }
                    case LT: {
                        for (int i = 0; i < this.size; ++i) {
                            bitSet.set(i, this.valuesD[i] < d);
                        }
                        break block21;
                    }
                    default: {
                        throw new PrismException("Unsupported operator " + relOp + " for getBitSetFromInterval()");
                    }
                }
            }
            throw new PrismException("Can't getBitSetFromInterval for a vector of type " + this.type);
        }
        return bitSet;
    }

    public BitSet getBitSetFromCloseValue(Object object, double d, boolean bl) throws PrismException {
        BitSet bitSet = new BitSet();
        if (this.type instanceof TypeInt) {
            int n = (Integer)object;
            for (int i = 0; i < this.size; ++i) {
                bitSet.set(i, PrismUtils.doublesAreClose(this.valuesI[i], n, d, bl));
            }
        } else if (this.type instanceof TypeDouble) {
            double d2 = (Double)object;
            for (int i = 0; i < this.size; ++i) {
                bitSet.set(i, PrismUtils.doublesAreClose(this.valuesD[i], d2, d, bl));
            }
        } else {
            throw new PrismException("Can't getBitSetFromCloseValue for a vector of type " + this.type);
        }
        return bitSet;
    }

    public void setIntValue(int n, int n2) {
        this.valuesI[n] = n2;
    }

    public void setDoubleValue(int n, double d) {
        this.valuesD[n] = d;
    }

    public void setBooleanValue(int n, boolean bl) {
        this.valuesB.set(n, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyITE(StateValues stateValues, StateValues stateValues2) throws PrismException {
        if (!(stateValues.type instanceof TypeBool)) {
            throw new PrismException("Type error in ? operator");
        }
        if (this.type instanceof TypeInt) {
            if (stateValues2.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = stateValues.valuesB.get(i) ? stateValues2.valuesI[i] : this.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues2.type instanceof TypeDouble)) throw new PrismException("Type error in ? operator");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = stateValues.valuesB.get(i) ? stateValues2.valuesD[i] : this.valuesD[i];
                }
                this.valuesI = null;
            }
            return;
        } else if (this.type instanceof TypeDouble) {
            if (stateValues2.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = stateValues.valuesB.get(i) ? (double)stateValues2.valuesI[i] : this.valuesD[i];
                }
                return;
            } else {
                if (!(stateValues2.type instanceof TypeDouble)) throw new PrismException("Type error in ? operator");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = stateValues.valuesB.get(i) ? stateValues2.valuesD[i] : this.valuesD[i];
                }
            }
            return;
        } else {
            if (!(this.type instanceof TypeBool)) throw new PrismException("Type error in ? operator");
            if (!(stateValues2.type instanceof TypeBool)) throw new PrismException("Type error in ? operator");
            int n = stateValues.valuesB.nextSetBit(0);
            while (n >= 0) {
                this.valuesB.set(n, stateValues2.valuesB.get(n));
                n = stateValues.valuesB.nextSetBit(n + 1);
            }
        }
    }

    public void applyBinaryOp(int n, StateValues stateValues) throws PrismException {
        switch (n) {
            case 1: {
                this.implies(stateValues);
                break;
            }
            case 2: {
                this.iff(stateValues);
                break;
            }
            case 3: {
                this.or(stateValues);
                break;
            }
            case 4: {
                this.and(stateValues);
                break;
            }
            case 5: {
                this.equals(stateValues);
                break;
            }
            case 6: {
                this.notEquals(stateValues);
                break;
            }
            case 7: {
                this.greaterThan(stateValues);
                break;
            }
            case 8: {
                this.greaterThanEquals(stateValues);
                break;
            }
            case 9: {
                this.lessThan(stateValues);
                break;
            }
            case 10: {
                this.lessThanEquals(stateValues);
                break;
            }
            case 11: {
                this.plus(stateValues);
                break;
            }
            case 12: {
                this.minus(stateValues);
                break;
            }
            case 13: {
                this.times(stateValues);
                break;
            }
            case 14: {
                this.divide(stateValues);
                break;
            }
            default: {
                throw new PrismException("Unknown binary operator");
            }
        }
    }

    public void implies(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.type instanceof TypeBool)) {
            throw new PrismException("Operator => can only be applied to Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
        this.valuesB.or(stateValues.valuesB);
    }

    public void iff(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.type instanceof TypeBool)) {
            throw new PrismException("Operator <=> can only be applied to Boolean vectors");
        }
        this.valuesB.xor(stateValues.valuesB);
        this.valuesB.flip(0, this.size);
    }

    public void or(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.type instanceof TypeBool)) {
            throw new PrismException("Operator | can only be applied to Boolean vectors");
        }
        this.valuesB.or(stateValues.valuesB);
    }

    public void and(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.type instanceof TypeBool)) {
            throw new PrismException("Operator & can only be applied to Boolean vectors");
        }
        this.valuesB.and(stateValues.valuesB);
    }

    public void complement() throws PrismException {
        if (!(this.type instanceof TypeBool)) {
            throw new PrismException("Can only complement Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
    }

    public void equals(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] == stateValues.valuesI[i]);
                }
            } else if (stateValues.type instanceof TypeDouble) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] == stateValues.valuesD[i]);
                }
            }
        } else if (this.type instanceof TypeDouble) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] == (double)stateValues.valuesI[i]);
                }
            } else if (stateValues.type instanceof TypeDouble) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] == stateValues.valuesD[i]);
                }
            }
        } else if (this.type instanceof TypeBool && stateValues.type instanceof TypeBool) {
            this.valuesB.xor(stateValues.valuesB);
            this.valuesB.flip(0, this.size);
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    public void notEquals(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] != stateValues.valuesI[i]);
                }
            } else if (stateValues.type instanceof TypeDouble) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] != stateValues.valuesD[i]);
                }
            }
        } else if (this.type instanceof TypeDouble) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] != (double)stateValues.valuesI[i]);
                }
            } else if (stateValues.type instanceof TypeDouble) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] != stateValues.valuesD[i]);
                }
            }
        } else if (this.type instanceof TypeBool && stateValues.type instanceof TypeBool) {
            this.valuesB.xor(stateValues.valuesB);
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void greaterThan(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] > stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator > cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] > stateValues.valuesD[i]);
                }
            }
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator > cannot be applied to Boolean vectors");
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] > (double)stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator > cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] > stateValues.valuesD[i]);
                }
            }
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void greaterThanEquals(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] >= stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator >= cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] >= stateValues.valuesD[i]);
                }
            }
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator >= cannot be applied to Boolean vectors");
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] >= (double)stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator >= cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] >= stateValues.valuesD[i]);
                }
            }
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lessThan(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] < stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator < cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] < stateValues.valuesD[i]);
                }
            }
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator < cannot be applied to Boolean vectors");
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] < (double)stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator < cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] < stateValues.valuesD[i]);
                }
            }
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lessThanEquals(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesI[i] <= stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator <= cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, (double)this.valuesI[i] <= stateValues.valuesD[i]);
                }
            }
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator <= cannot be applied to Boolean vectors");
            this.valuesB = new BitSet();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] <= (double)stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator <= cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesB.set(i, this.valuesD[i] <= stateValues.valuesD[i]);
                }
            }
        }
        this.type = TypeBool.getInstance();
        this.valuesI = null;
        this.valuesD = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void plus(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesI[n] = this.valuesI[n] + stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator + cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = (double)this.valuesI[i] + stateValues.valuesD[i];
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator + cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] + (double)stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator + cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] + stateValues.valuesD[i];
                }
            }
        }
    }

    public void plusConstant(int n) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n2 = 0;
            while (n2 < this.size) {
                int n3 = n2++;
                this.valuesI[n3] = this.valuesI[n3] + n;
            }
        } else if (this.type instanceof TypeDouble) {
            int n4 = 0;
            while (n4 < this.size) {
                int n5 = n4++;
                this.valuesD[n5] = this.valuesD[n5] + (double)n;
            }
        } else {
            throw new PrismException("Operator + cannot be applied to Boolean vectors");
        }
    }

    public void plusConstant(double d) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesD = new double[this.size];
            this.type = TypeDouble.getInstance();
            for (int i = 0; i < this.size; ++i) {
                this.valuesD[i] = (double)this.valuesI[i] + d;
            }
            this.valuesI = null;
        } else if (this.type instanceof TypeDouble) {
            int n = 0;
            while (n < this.size) {
                int n2 = n++;
                this.valuesD[n2] = this.valuesD[n2] + d;
            }
        } else {
            throw new PrismException("Operator + cannot be applied to Boolean vectors");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void minus(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesI[n] = this.valuesI[n] - stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator - cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = (double)this.valuesI[i] - stateValues.valuesD[i];
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator - cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] - (double)stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator - cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] - stateValues.valuesD[i];
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void times(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesI[n] = this.valuesI[n] * stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator * cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = (double)this.valuesI[i] * stateValues.valuesD[i];
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator * cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] * (double)stateValues.valuesI[i];
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator * cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    int n = i;
                    this.valuesD[n] = this.valuesD[n] * stateValues.valuesD[i];
                }
            }
        }
    }

    public void timesConstant(int n) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n2 = 0;
            while (n2 < this.size) {
                int n3 = n2++;
                this.valuesI[n3] = this.valuesI[n3] * n;
            }
        } else if (this.type instanceof TypeDouble) {
            int n4 = 0;
            while (n4 < this.size) {
                int n5 = n4++;
                this.valuesD[n5] = this.valuesD[n5] * (double)n;
            }
        } else {
            throw new PrismException("Operator + cannot be applied to Boolean vectors");
        }
    }

    public void timesConstant(double d) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesD = new double[this.size];
            this.type = TypeDouble.getInstance();
            for (int i = 0; i < this.size; ++i) {
                this.valuesD[i] = (double)this.valuesI[i] * d;
            }
            this.valuesI = null;
        } else if (this.type instanceof TypeDouble) {
            int n = 0;
            while (n < this.size) {
                int n2 = n++;
                this.valuesD[n2] = this.valuesD[n2] * d;
            }
        } else {
            throw new PrismException("Operator + cannot be applied to Boolean vectors");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void divide(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesD = new double[this.size];
            this.type = TypeDouble.getInstance();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = (double)this.valuesI[i] / (double)stateValues.valuesI[i];
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator / cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = (double)this.valuesI[i] / stateValues.valuesD[i];
                }
            }
            this.valuesI = null;
            return;
        }
        if (!(this.type instanceof TypeDouble)) throw new PrismException("Operator / cannot be applied to Boolean vectors");
        if (stateValues.type instanceof TypeInt) {
            for (int i = 0; i < this.size; ++i) {
                int n = i;
                this.valuesD[n] = this.valuesD[n] / (double)stateValues.valuesI[i];
            }
            return;
        } else {
            if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Operator / cannot be applied to Boolean vectors");
            for (int i = 0; i < this.size; ++i) {
                int n = i;
                this.valuesD[n] = this.valuesD[n] / stateValues.valuesD[i];
            }
        }
    }

    public void applyUnaryOp(int n) throws PrismException {
        switch (n) {
            case 1: {
                this.not();
                break;
            }
            case 2: {
                this.minus();
                break;
            }
            default: {
                throw new PrismException("Unknown binary operator");
            }
        }
    }

    public void not() throws PrismException {
        if (!(this.type instanceof TypeBool)) {
            throw new PrismException("Operator ! can only be applied to Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
    }

    public void minus() throws PrismException {
        if (this.type instanceof TypeInt) {
            for (int i = 0; i < this.size; ++i) {
                this.valuesI[i] = -this.valuesI[i];
            }
        } else if (this.type instanceof TypeDouble) {
            for (int i = 0; i < this.size; ++i) {
                this.valuesD[i] = -this.valuesD[i];
            }
        } else {
            throw new PrismException("Operator - cannot be applied to Boolean vectors");
        }
    }

    public void applyFunctionUnary(int n) throws PrismException {
        switch (n) {
            case 2: {
                this.floor();
                break;
            }
            case 3: {
                this.ceil();
                break;
            }
            case 4: {
                this.round();
                break;
            }
            default: {
                throw new PrismException("Unknown unary function");
            }
        }
    }

    public void floor() throws PrismException {
        if (!(this.type instanceof TypeInt)) {
            if (this.type instanceof TypeDouble) {
                this.valuesI = new int[this.size];
                this.type = TypeInt.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = ExpressionFunc.evaluateFloor(this.valuesD[i]);
                }
                this.valuesD = null;
            } else {
                throw new PrismException("Function floor cannot be applied to Boolean vectors");
            }
        }
    }

    public void ceil() throws PrismException {
        if (!(this.type instanceof TypeInt)) {
            if (this.type instanceof TypeDouble) {
                this.valuesI = new int[this.size];
                this.type = TypeInt.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = ExpressionFunc.evaluateCeil(this.valuesD[i]);
                }
                this.valuesD = null;
            } else {
                throw new PrismException("Function ceil cannot be applied to Boolean vectors");
            }
        }
    }

    public void round() throws PrismException {
        if (!(this.type instanceof TypeInt)) {
            if (this.type instanceof TypeDouble) {
                this.valuesI = new int[this.size];
                this.type = TypeInt.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = ExpressionFunc.evaluateRound(this.valuesD[i]);
                }
                this.valuesD = null;
            } else {
                throw new PrismException("Function round cannot be applied to Boolean vectors");
            }
        }
    }

    public void applyFunctionBinary(int n, StateValues stateValues) throws PrismException {
        switch (n) {
            case 5: {
                this.pow(stateValues);
                break;
            }
            case 6: {
                this.mod(stateValues);
                break;
            }
            case 7: {
                this.log(stateValues);
                break;
            }
            case 0: {
                this.min(stateValues);
                break;
            }
            case 1: {
                this.max(stateValues);
                break;
            }
            default: {
                throw new PrismException("Unknown binary function");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pow(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = ExpressionFunc.evaluatePowInt(this.valuesI[i], stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function pow() cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = ExpressionFunc.evaluatePowDouble(this.valuesI[i], stateValues.valuesD[i]);
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Function pow() cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = ExpressionFunc.evaluatePowDouble(this.valuesD[i], stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function pow() cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = ExpressionFunc.evaluatePowDouble(this.valuesD[i], stateValues.valuesD[i]);
                }
            }
        }
    }

    public void mod(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeInt) || !(stateValues.type instanceof TypeInt)) {
            throw new PrismException("Function mod() can only be applied to integer vectors");
        }
        for (int i = 0; i < this.size; ++i) {
            this.valuesI[i] = ExpressionFunc.evaluateMod(this.valuesI[i], stateValues.valuesI[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void log(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.valuesD = new double[this.size];
            this.type = TypeDouble.getInstance();
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = ExpressionFunc.evaluateLog(this.valuesI[i], stateValues.valuesI[i]);
                }
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function log() cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = ExpressionFunc.evaluateLog(this.valuesI[i], stateValues.valuesD[i]);
                }
            }
            this.valuesI = null;
            return;
        }
        if (!(this.type instanceof TypeDouble)) throw new PrismException("Function log() cannot be applied to Boolean vectors");
        if (stateValues.type instanceof TypeInt) {
            for (int i = 0; i < this.size; ++i) {
                this.valuesD[i] = ExpressionFunc.evaluateLog(this.valuesD[i], stateValues.valuesI[i]);
            }
            return;
        } else {
            if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function log() cannot be applied to Boolean vectors");
            for (int i = 0; i < this.size; ++i) {
                this.valuesD[i] = ExpressionFunc.evaluateLog(this.valuesD[i], stateValues.valuesD[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void min(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = Math.min(this.valuesI[i], stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function min() cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.min((double)this.valuesI[i], stateValues.valuesD[i]);
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Function min() cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.min(this.valuesD[i], (double)stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function min() cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.min(this.valuesD[i], stateValues.valuesD[i]);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void max(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeInt) {
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesI[i] = Math.max(this.valuesI[i], stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function max() cannot be applied to Boolean vectors");
                this.valuesD = new double[this.size];
                this.type = TypeDouble.getInstance();
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.max((double)this.valuesI[i], stateValues.valuesD[i]);
                }
                this.valuesI = null;
            }
            return;
        } else {
            if (!(this.type instanceof TypeDouble)) throw new PrismException("Function max() cannot be applied to Boolean vectors");
            if (stateValues.type instanceof TypeInt) {
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.max(this.valuesD[i], (double)stateValues.valuesI[i]);
                }
                return;
            } else {
                if (!(stateValues.type instanceof TypeDouble)) throw new PrismException("Function max() cannot be applied to Boolean vectors");
                for (int i = 0; i < this.size; ++i) {
                    this.valuesD[i] = Math.max(this.valuesD[i], stateValues.valuesD[i]);
                }
            }
        }
    }

    public double dotProduct(StateValues stateValues) throws PrismException {
        if (this.type instanceof TypeDouble) {
            double d = 0.0;
            for (int i = 0; i < this.size; ++i) {
                d += this.valuesD[i] * stateValues.valuesD[i];
            }
            return d;
        }
        throw new PrismException("Dot product can only be applied to double vectors");
    }

    public void readFromFile(File file) throws PrismException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if (!"".equals(string = string.trim())) {
                    if (string.contains("=")) {
                        bl = true;
                        String[] stringArray = string.split("=");
                        n2 = Integer.parseInt(stringArray[0]);
                        string = stringArray[1];
                    }
                    if (n2 + 1 > this.size) {
                        bufferedReader.close();
                        throw new PrismException("Too many values in file \"" + file + "\" (more than " + this.size + ")");
                    }
                    if (this.type instanceof TypeInt) {
                        int n3 = Integer.parseInt(string);
                        this.setIntValue(n2, n3);
                    } else if (this.type instanceof TypeDouble) {
                        double d = Double.parseDouble(string);
                        this.setDoubleValue(n2, d);
                    } else if (this.type instanceof TypeBool) {
                        boolean bl2 = Boolean.parseBoolean(string);
                        this.setBooleanValue(n2, bl2);
                    }
                    ++n2;
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
            if (!bl && n2 < this.size) {
                throw new PrismException("Too few values in file \"" + file + "\" (" + n2 + ", not " + this.size + ")");
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of file \"" + file + "\"");
        }
    }

    @Override
    public void clear() {
        this.valuesI = null;
        this.valuesD = null;
        this.valuesB = null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Object getValue(int n) {
        if (this.type instanceof TypeInt) {
            return this.valuesI[n];
        }
        if (this.type instanceof TypeDouble) {
            return this.valuesD[n];
        }
        if (this.type instanceof TypeBool) {
            return this.valuesB.get(n);
        }
        return null;
    }

    public boolean isNonZero(int n) {
        if (this.type instanceof TypeInt) {
            return this.valuesI[n] != 0;
        }
        if (this.type instanceof TypeDouble) {
            return this.valuesD[n] != 0.0;
        }
        if (this.type instanceof TypeBool) {
            return this.valuesB.get(n);
        }
        return false;
    }

    public int[] getIntArray() {
        return this.valuesI;
    }

    public double[] getDoubleArray() {
        return this.valuesD;
    }

    public BitSet getBitSet() {
        return this.valuesB;
    }

    public int getNNZ() {
        int n = 0;
        if (this.type instanceof TypeBool) {
            n = this.valuesB.cardinality();
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!this.isNonZero(i)) continue;
                ++n;
            }
        }
        return n;
    }

    public String getNNZString() {
        return "" + this.getNNZ();
    }

    public Object firstFromBitSet(BitSet bitSet) {
        return this.getValue(bitSet.nextSetBit(0));
    }

    public Object minOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n = Integer.MAX_VALUE;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.valuesI[n2] < n) {
                    n = this.valuesI[n2];
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return new Integer(n);
        }
        if (this.type instanceof TypeDouble) {
            double d = Double.POSITIVE_INFINITY;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (this.valuesD[n] < d) {
                    d = this.valuesD[n];
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return new Double(d);
        }
        throw new PrismException("Can't take min over a vector of type " + this.type);
    }

    public Object maxOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n = Integer.MIN_VALUE;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.valuesI[n2] > n) {
                    n = this.valuesI[n2];
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return new Integer(n);
        }
        if (this.type instanceof TypeDouble) {
            double d = Double.NEGATIVE_INFINITY;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (this.valuesD[n] > d) {
                    d = this.valuesD[n];
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return new Double(d);
        }
        throw new PrismException("Can't take max over a vector of type " + this.type);
    }

    public Object maxFiniteOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n = Integer.MIN_VALUE;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.valuesI[n2] > n) {
                    n = this.valuesI[n2];
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return new Integer(n);
        }
        if (this.type instanceof TypeDouble) {
            double d = Double.NEGATIVE_INFINITY;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                double d2 = this.valuesD[n];
                if (Double.isFinite(d2) && this.valuesD[n] > d) {
                    d = d2;
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return new Double(d);
        }
        throw new PrismException("Can't take max over a vector of type " + this.type);
    }

    public boolean forallOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeBool) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (!this.valuesB.get(n)) {
                    return false;
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return true;
        }
        throw new PrismException("Can't take for-all over a vector of type " + this.type);
    }

    public boolean existsOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeBool) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (this.valuesB.get(n)) {
                    return true;
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return false;
        }
        throw new PrismException("Can't take there-exists over a vector of type " + this.type);
    }

    public int countOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeBool) {
            int n = 0;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.valuesB.get(n2)) {
                    ++n;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return new Integer(n);
        }
        throw new PrismException("Can't take count over a vector of type " + this.type);
    }

    public Object sumOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n = 0;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                n += this.valuesI[n2];
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return new Integer(n);
        }
        if (this.type instanceof TypeDouble) {
            double d = 0.0;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                d += this.valuesD[n];
                n = bitSet.nextSetBit(n + 1);
            }
            return new Double(d);
        }
        throw new PrismException("Can't take sum over a vector of type " + this.type);
    }

    public double averageOverBitSet(BitSet bitSet) throws PrismException {
        if (this.type instanceof TypeInt) {
            int n = 0;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                n += this.valuesI[n2];
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return (double)n / (double)bitSet.cardinality();
        }
        if (this.type instanceof TypeDouble) {
            double d = 0.0;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                d += this.valuesD[n];
                n = bitSet.nextSetBit(n + 1);
            }
            return d / (double)bitSet.cardinality();
        }
        throw new PrismException("Can't take average over a vector of type " + this.type);
    }

    public void print(PrismLog prismLog) {
        this.doPrinting(prismLog, -1, null, true, false, true, true);
    }

    public void print(PrismLog prismLog, int n) {
        this.doPrinting(prismLog, n, null, true, false, true, true);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.doPrinting(prismLog, -1, null, bl, bl2, bl3, bl4);
    }

    public void printFiltered(PrismLog prismLog, BitSet bitSet) {
        this.doPrinting(prismLog, -1, bitSet, true, false, true, true);
    }

    public void printFiltered(PrismLog prismLog, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.doPrinting(prismLog, -1, bitSet, bl, bl2, bl3, bl4);
    }

    private void doPrinting(PrismLog prismLog, int n, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = 0;
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        if (bl2) {
            prismLog.println((String)(!bl ? "v = [" : "v = sparse(" + this.size + ",1);"));
        }
        if (bitSet == null) {
            int n3 = 0;
            while (n3 < this.size & n2 < n) {
                if (this.printLine(prismLog, n3, bl, bl2, bl3, bl4)) {
                    ++n2;
                }
                ++n3;
            }
        } else {
            int n4 = bitSet.nextSetBit(0);
            while (n4 >= 0 && n2 < n) {
                if (this.printLine(prismLog, n4, bl, bl2, bl3, bl4)) {
                    ++n2;
                }
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        if (bl && !bl2 && n2 == 0) {
            prismLog.println("(all zero)");
            return;
        }
        if (bl2 && !bl) {
            prismLog.println("];");
        }
    }

    private boolean printLine(PrismLog prismLog, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl || this.isNonZero(n)) {
            if (bl2) {
                if (bl) {
                    prismLog.println("v(" + (n + 1) + ")=" + this.getValue(n) + ";");
                } else {
                    prismLog.println(this.getValue(n));
                }
            } else {
                if (bl4) {
                    prismLog.print(n);
                }
                if (bl3 && this.statesList != null) {
                    if (bl4) {
                        prismLog.print(":");
                    }
                    prismLog.print(this.statesList.get(n).toString());
                }
                if (bl && this.type instanceof TypeBool) {
                    prismLog.println();
                } else {
                    if (bl4 || bl3) {
                        prismLog.print("=");
                    }
                    prismLog.println(this.getValue(n));
                }
            }
            return true;
        }
        return false;
    }

    public StateValues deepCopy() throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.type = this.type;
        stateValues.size = this.size;
        if (this.valuesI != null) {
            stateValues.valuesI = Utils.cloneIntArray(this.valuesI);
        }
        if (this.valuesD != null) {
            stateValues.valuesD = Utils.cloneDoubleArray(this.valuesD);
        }
        if (this.valuesB != null) {
            stateValues.valuesB = (BitSet)this.valuesB.clone();
        }
        stateValues.statesList = this.statesList;
        return stateValues;
    }

    public Type getType() {
        return this.type;
    }
}

