/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMDP;
import explicit.Distribution;
import explicit.MDP;
import explicit.MDPSimple;
import java.util.List;
import java.util.Map;
import prism.ModelType;
import prism.PrismUtils;

public class CTMDPSimple
extends MDPSimple
implements CTMDP {
    public CTMDPSimple() {
        this.initialise(0);
    }

    public CTMDPSimple(int n) {
        this.initialise(n);
    }

    public CTMDPSimple(CTMDPSimple cTMDPSimple) {
        super(cTMDPSimple);
    }

    public CTMDPSimple(CTMDPSimple cTMDPSimple, int[] nArray) {
        super(cTMDPSimple, nArray);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.CTMDP;
    }

    @Override
    public double getMaxExitRate() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numStates; ++i) {
            for (Distribution distribution : (List)this.trans.get(i)) {
                double d2 = distribution.sum();
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    @Override
    public boolean isLocallyUniform() {
        for (int i = 0; i < this.numStates; ++i) {
            int n = ((List)this.trans.get(i)).size();
            if (n < 2) continue;
            double d = ((Distribution)((List)this.trans.get(i)).get(0)).sum();
            for (int j = 1; j < n; ++j) {
                if (PrismUtils.doublesAreCloseAbs(((Distribution)((List)this.trans.get(i)).get(j)).sum(), d, 1.0E-12)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public MDP buildImplicitDiscretisedMDP(double d) {
        return null;
    }

    @Override
    public MDPSimple buildDiscretisedMDP(double d) {
        MDPSimple mDPSimple = new MDPSimple(this.numStates);
        for (int n : this.getInitialStates()) {
            mDPSimple.addInitialState(n);
        }
        for (int i = 0; i < this.numStates; ++i) {
            for (Distribution distribution : (List)this.trans.get(i)) {
                Distribution distribution2 = new Distribution();
                double d2 = distribution.sum();
                double d3 = Math.exp(-d2 * d);
                for (Map.Entry<Integer, Double> entry : distribution) {
                    distribution2.add(entry.getKey(), (1.0 - d3) * (entry.getValue() / d2));
                }
                distribution2.add(i, d3);
                mDPSimple.addChoice(i, distribution2);
            }
        }
        return mDPSimple;
    }
}

