/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrixRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GenMatrix<C extends RingElem<C>>
implements AlgebraElem<GenMatrix<C>, C> {
    private static final Logger logger = Logger.getLogger(GenMatrix.class);
    public final GenMatrixRing<C> ring;
    public final ArrayList<ArrayList<C>> matrix;
    private int hashValue = 0;

    public GenMatrix(GenMatrixRing<C> genMatrixRing) {
        this(genMatrixRing, ((GenMatrix)genMatrixRing.getZERO()).matrix);
    }

    public GenMatrix(GenMatrixRing<C> genMatrixRing, List<List<C>> list) {
        this.ring = genMatrixRing;
        this.matrix = new ArrayList(genMatrixRing.rows);
        for (List<C> list2 : list) {
            ArrayList<C> arrayList = new ArrayList<C>(list2);
            this.matrix.add(arrayList);
        }
        logger.info(this.ring.rows + " x " + this.ring.cols + " matrix constructed");
    }

    public GenMatrix(GenMatrixRing<C> genMatrixRing, ArrayList<ArrayList<C>> arrayList) {
        if (genMatrixRing == null || arrayList == null) {
            throw new IllegalArgumentException("Empty r or m not allowed, r = " + genMatrixRing + ", m = " + arrayList);
        }
        this.ring = genMatrixRing;
        this.matrix = new ArrayList<ArrayList<C>>(arrayList);
        logger.info(this.ring.rows + " x " + this.ring.cols + " matrix constructed");
    }

    public C get(int n, int n2) {
        return (C)((RingElem)this.matrix.get(n).get(n2));
    }

    public void setMutate(int n, int n2, C c) {
        ArrayList<C> arrayList = this.matrix.get(n);
        arrayList.set(n2, c);
        this.hashValue = 0;
    }

    public GenMatrix<C> set(int n, int n2, C c) {
        Element element = this.copy();
        ((GenMatrix)element).setMutate(n, n2, c);
        return element;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("[\n");
        for (List list : this.matrix) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            boolean bl2 = true;
            stringBuffer.append("[ ");
            for (RingElem ringElem : list) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ringElem.toString());
            }
            stringBuffer.append(" ]");
        }
        stringBuffer.append(" ] ");
        if (!PrettyPrint.isTrue()) {
            stringBuffer.append(":: " + this.ring.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("( ");
        for (List list : this.matrix) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            boolean bl2 = true;
            stringBuffer.append("( ");
            for (RingElem ringElem : list) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ringElem.toScript());
            }
            stringBuffer.append(" )");
        }
        stringBuffer.append(" ) ");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenMatrixRing)this.factory()).toScript();
    }

    @Override
    public GenMatrixRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenMatrix<C> copy() {
        ArrayList<ArrayList<C>> arrayList = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> arrayList2 : this.matrix) {
            ArrayList<C> arrayList3 = new ArrayList<C>(arrayList2);
            arrayList.add(arrayList3);
        }
        return new GenMatrix<C>(this.ring, arrayList);
    }

    @Override
    public boolean isZERO() {
        for (List list : this.matrix) {
            for (RingElem ringElem : list) {
                if (ringElem.isZERO()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isONE() {
        int n = 0;
        for (List list : this.matrix) {
            int n2 = 0;
            for (RingElem ringElem : list) {
                if (n == n2 ? !ringElem.isONE() : !ringElem.isZERO()) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GenMatrix)) {
            return false;
        }
        GenMatrix genMatrix = (GenMatrix)object;
        if (!this.ring.equals(genMatrix.ring)) {
            return false;
        }
        return this.matrix.equals(genMatrix.matrix);
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = 37 * this.matrix.hashCode() + this.ring.hashCode();
            if (this.hashValue == 0) {
                this.hashValue = 1;
            }
        }
        return this.hashValue;
    }

    @Override
    public int compareTo(GenMatrix<C> genMatrix) {
        if (!this.ring.equals(genMatrix.ring)) {
            return -1;
        }
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        int n = 0;
        for (ArrayList<C> arrayList2 : this.matrix) {
            ArrayList<C> arrayList3 = arrayList.get(n++);
            int n2 = 0;
            for (RingElem ringElem : arrayList2) {
                int n3 = ringElem.compareTo((Element)arrayList3.get(n2++));
                if (n3 == 0) continue;
                return n3;
            }
        }
        return 0;
    }

    @Override
    public boolean isUnit() {
        int n = 0;
        for (ArrayList<C> arrayList : this.matrix) {
            int n2 = 0;
            for (RingElem ringElem : arrayList) {
                if (n == n2 ? !ringElem.isUnit() : !ringElem.isZERO()) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    @Override
    public int signum() {
        return this.compareTo((GenMatrix<C>)this.ring.getZERO());
    }

    @Override
    public GenMatrix<C> sum(GenMatrix<C> genMatrix) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem : arrayList3) {
                RingElem ringElem2 = (RingElem)ringElem.sum((AbelianGroupElem)arrayList4.get(n2++));
                arrayList5.add(ringElem2);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    @Override
    public GenMatrix<C> subtract(GenMatrix<C> genMatrix) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem : arrayList3) {
                RingElem ringElem2 = (RingElem)ringElem.subtract((AbelianGroupElem)arrayList4.get(n2++));
                arrayList5.add(ringElem2);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    @Override
    public GenMatrix<C> negate() {
        ArrayList<ArrayList<C>> arrayList = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> arrayList2 : this.matrix) {
            ArrayList<RingElem> arrayList3 = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem ringElem : arrayList2) {
                RingElem ringElem2 = (RingElem)ringElem.negate();
                arrayList3.add(ringElem2);
            }
            arrayList.add(arrayList3);
        }
        return new GenMatrix<C>(this.ring, arrayList);
    }

    @Override
    public GenMatrix<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenMatrix<C> scalarMultiply(C c) {
        ArrayList<ArrayList<C>> arrayList = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> arrayList2 : this.matrix) {
            ArrayList<RingElem> arrayList3 = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem ringElem : arrayList2) {
                RingElem ringElem2 = (RingElem)ringElem.multiply(c);
                arrayList3.add(ringElem2);
            }
            arrayList.add(arrayList3);
        }
        return new GenMatrix<C>(this.ring, arrayList);
    }

    public GenMatrix<C> leftScalarMultiply(C ringElem) {
        ArrayList<ArrayList<C>> arrayList = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> arrayList2 : this.matrix) {
            ArrayList<RingElem> arrayList3 = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem ringElem2 : arrayList2) {
                RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
                arrayList3.add(ringElem3);
            }
            arrayList.add(arrayList3);
        }
        return new GenMatrix<C>(this.ring, arrayList);
    }

    @Override
    public GenMatrix<C> linearCombination(C c, GenMatrix<C> genMatrix, C c2) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem : arrayList3) {
                RingElem ringElem2 = (RingElem)ringElem.multiply(c);
                RingElem ringElem3 = (RingElem)((RingElem)arrayList4.get(n2++)).multiply(c2);
                RingElem ringElem4 = ringElem2.sum(ringElem3);
                arrayList5.add(ringElem4);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    @Override
    public GenMatrix<C> linearCombination(GenMatrix<C> genMatrix, C c) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem : arrayList3) {
                RingElem ringElem2 = (RingElem)((RingElem)arrayList4.get(n2++)).multiply(c);
                RingElem ringElem3 = ringElem.sum(ringElem2);
                arrayList5.add(ringElem3);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    @Override
    public GenMatrix<C> linearCombination(C monoidElem, GenMatrix<C> genMatrix) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem : arrayList3) {
                RingElem ringElem2 = (RingElem)monoidElem.multiply((MonoidElem)((MonoidElem)arrayList4.get(n2++)));
                RingElem ringElem3 = ringElem.sum(ringElem2);
                arrayList5.add(ringElem3);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    public GenMatrix<C> leftLinearCombination(C ringElem, C monoidElem, GenMatrix<C> genMatrix) {
        ArrayList<ArrayList<C>> arrayList = genMatrix.matrix;
        ArrayList<ArrayList<C>> arrayList2 = new ArrayList<ArrayList<C>>(this.ring.rows);
        int n = 0;
        for (ArrayList<C> arrayList3 : this.matrix) {
            ArrayList<C> arrayList4 = arrayList.get(n++);
            ArrayList<RingElem> arrayList5 = new ArrayList<RingElem>(this.ring.cols);
            int n2 = 0;
            for (RingElem ringElem2 : arrayList3) {
                RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
                RingElem ringElem4 = (RingElem)monoidElem.multiply((MonoidElem)((MonoidElem)arrayList4.get(n2++)));
                RingElem ringElem5 = ringElem3.sum(ringElem4);
                arrayList5.add(ringElem5);
            }
            arrayList2.add(arrayList5);
        }
        return new GenMatrix<C>(this.ring, arrayList2);
    }

    public GenMatrix<C> transpose(GenMatrixRing<C> genMatrixRing) {
        Element element = ((GenMatrix)genMatrixRing.getZERO()).copy();
        ArrayList<ArrayList<C>> arrayList = ((GenMatrix)element).matrix;
        int n = 0;
        for (ArrayList<C> arrayList2 : this.matrix) {
            int n2 = 0;
            for (RingElem ringElem : arrayList2) {
                arrayList.get(n2).set(n, ringElem);
                ++n2;
            }
            ++n;
        }
        return element;
    }

    @Override
    public GenMatrix<C> multiply(GenMatrix<C> genMatrix) {
        int n = this.ring.blocksize;
        int n2 = this.ring.blocksize;
        ArrayList<ArrayList<C>> arrayList = this.matrix;
        GenMatrixRing<C> genMatrixRing = genMatrix.ring.transpose();
        GenMatrix<C> genMatrix2 = genMatrix.transpose(genMatrixRing);
        ArrayList<ArrayList<C>> arrayList2 = genMatrix2.matrix;
        GenMatrixRing<C> genMatrixRing2 = this.ring.product(genMatrix.ring);
        Element element = ((GenMatrix)genMatrixRing2.getZERO()).copy();
        ArrayList<ArrayList<C>> arrayList3 = ((GenMatrix)element).matrix;
        for (int i = 0; i < arrayList.size(); i += n) {
            for (int j = 0; j < arrayList2.size(); j += n2) {
                for (int k = i; k < Math.min(i + n, arrayList.size()); ++k) {
                    ArrayList<C> arrayList4 = arrayList.get(k);
                    for (int i2 = j; i2 < Math.min(j + n2, arrayList2.size()); ++i2) {
                        ArrayList<C> arrayList5 = arrayList2.get(i2);
                        RingElem ringElem = (RingElem)this.ring.coFac.getZERO();
                        for (int i3 = 0; i3 < arrayList5.size(); ++i3) {
                            ringElem = (RingElem)ringElem.sum((AbelianGroupElem)((Object)((RingElem)arrayList4.get(i3)).multiply((MonoidElem)arrayList5.get(i3))));
                        }
                        arrayList3.get(k).set(i2, ringElem);
                    }
                }
            }
        }
        return new GenMatrix<C>(genMatrixRing2, arrayList3);
    }

    public GenMatrix<C> multiplySimple(GenMatrix<C> genMatrix) {
        ArrayList<ArrayList<C>> arrayList = this.matrix;
        ArrayList<ArrayList<C>> arrayList2 = genMatrix.matrix;
        GenMatrixRing<C> genMatrixRing = this.ring.product(genMatrix.ring);
        Element element = ((GenMatrix)genMatrixRing.getZERO()).copy();
        ArrayList<ArrayList<C>> arrayList3 = ((GenMatrix)element).matrix;
        for (int i = 0; i < genMatrixRing.rows; ++i) {
            ArrayList<C> arrayList4 = arrayList.get(i);
            for (int j = 0; j < genMatrixRing.cols; ++j) {
                RingElem ringElem = (RingElem)this.ring.coFac.getZERO();
                for (int k = 0; k < genMatrix.ring.rows; ++k) {
                    ringElem = (RingElem)ringElem.sum((AbelianGroupElem)((Object)((RingElem)arrayList4.get(k)).multiply((MonoidElem)arrayList2.get(k).get(j))));
                }
                arrayList3.get(i).set(j, ringElem);
            }
        }
        return new GenMatrix<C>(genMatrixRing, arrayList3);
    }

    @Override
    public GenMatrix<C> divide(GenMatrix<C> genMatrix) {
        throw new UnsupportedOperationException("divide not yet implemented");
    }

    @Override
    public GenMatrix<C> remainder(GenMatrix<C> genMatrix) {
        throw new UnsupportedOperationException("remainder not implemented");
    }

    public GenMatrix<C>[] quotientRemainder(GenMatrix<C> genMatrix) {
        throw new UnsupportedOperationException("quotientRemainder not implemented, input = " + genMatrix);
    }

    @Override
    public GenMatrix<C> inverse() {
        throw new UnsupportedOperationException("inverse not yet implemented");
    }

    @Override
    public GenMatrix<C> gcd(GenMatrix<C> genMatrix) {
        throw new UnsupportedOperationException("gcd not implemented");
    }

    public GenMatrix<C>[] egcd(GenMatrix<C> genMatrix) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

