/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Executor;
import edu.jas.util.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ExecutableServer
extends Thread {
    private static final Logger logger = Logger.getLogger(ExecutableServer.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final ChannelFactory cf;
    protected List<Executor> servers = null;
    public static final int DEFAULT_PORT = 7411;
    public static final String DONE = "Done";
    public static final String STOP = "Stop";
    private volatile boolean goon = true;
    private Thread mythread = null;

    public ExecutableServer() {
        this(7411);
    }

    public ExecutableServer(int n) {
        this(new ChannelFactory(n));
    }

    public ExecutableServer(ChannelFactory channelFactory) {
        this.cf = channelFactory;
        channelFactory.init();
        this.servers = new ArrayList<Executor>();
    }

    public static void main(String[] stringArray) throws InterruptedException {
        BasicConfigurator.configure();
        int n = 7411;
        if (stringArray.length < 1) {
            System.out.println("Usage: ExecutableServer <port>");
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ExecutableServer executableServer = new ExecutableServer(n);
        executableServer.init();
        executableServer.join();
    }

    public void init() {
        this.start();
        logger.info("ExecutableServer at " + this.cf);
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }

    @Override
    public void run() {
        SocketChannel socketChannel = null;
        Executor executor = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            if (this.debug) {
                logger.info("execute server " + this + " go on");
            }
            try {
                socketChannel = this.cf.getChannel();
                logger.debug("execute channel = " + socketChannel);
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    logger.debug("execute server " + this + " interrupted");
                    socketChannel.close();
                    continue;
                }
                executor = new Executor(socketChannel);
                if (this.goon) {
                    this.servers.add(executor);
                    executor.start();
                    logger.debug("server " + executor + " started");
                    continue;
                }
                executor = null;
                socketChannel.close();
            }
            catch (InterruptedException interruptedException) {
                this.goon = false;
                Thread.currentThread().interrupt();
                if (!this.debug) continue;
                interruptedException.printStackTrace();
            }
        }
        if (this.debug) {
            logger.info("execute server " + this + " terminated");
        }
    }

    public void terminate() {
        this.goon = false;
        logger.debug("terminating ExecutableServer");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.servers != null) {
            for (Executor executor : this.servers) {
                if (executor.channel != null) {
                    executor.channel.close();
                }
                try {
                    while (executor.isAlive()) {
                        executor.interrupt();
                        executor.join(100L);
                    }
                    logger.debug("server " + executor + " terminated");
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.servers = null;
        }
        logger.debug("Executors terminated");
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.debug("ExecuteServer terminated");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ExecutableServer(");
        stringBuffer.append(this.cf.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

