/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorHensel<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorAbstract<BigInteger> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorHensel.class);
    private final boolean debug = logger.isDebugEnabled();
    public final boolean quadratic;
    public final GreatestCommonDivisorAbstract<BigInteger> iufd;
    private final GreatestCommonDivisorAbstract<BigInteger> ufd;

    public GreatestCommonDivisorHensel() {
        this(true);
    }

    public GreatestCommonDivisorHensel(boolean bl) {
        this.quadratic = bl;
        this.iufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.ufd = this;
    }

    @Override
    public GenPolynomial<BigInteger> baseGcd(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2) {
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem;
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem2;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            abelianGroupElem2 = genPolynomial;
            abelianGroupElem = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            abelianGroupElem = genPolynomial;
            abelianGroupElem2 = genPolynomial2;
        }
        if (this.debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).abs();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
        BigInteger bigInteger = this.baseContent(abelianGroupElem2);
        BigInteger bigInteger2 = this.baseContent(abelianGroupElem);
        BigInteger bigInteger3 = this.gcd(bigInteger, bigInteger2);
        abelianGroupElem2 = this.divide(abelianGroupElem2, bigInteger);
        abelianGroupElem = this.divide(abelianGroupElem, bigInteger2);
        if (((GenPolynomial)abelianGroupElem2).isONE()) {
            return ((GenPolynomial)abelianGroupElem2).multiply((GenPolynomial<BigInteger>)((Object)bigInteger3));
        }
        if (((GenPolynomial)abelianGroupElem).isONE()) {
            return ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<BigInteger>)((Object)bigInteger3));
        }
        BigInteger bigInteger4 = (BigInteger)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient();
        BigInteger bigInteger5 = (BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient();
        BigInteger bigInteger6 = this.gcd(bigInteger4, bigInteger5);
        ExpVector expVector = ((GenPolynomial)abelianGroupElem2).degreeVector();
        ExpVector expVector2 = ((GenPolynomial)abelianGroupElem).degreeVector();
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        int n = 50;
        GenPolynomial<ModLong> genPolynomial3 = null;
        GenPolynomial<ModLong>[] genPolynomialArray = null;
        GenPolynomial<ModLong> genPolynomial4 = null;
        GenPolynomial<ModLong> genPolynomial5 = null;
        HenselApprox<ModLong> henselApprox = null;
        if (this.debug) {
            logger.debug("c = " + bigInteger3);
            logger.debug("cc = " + bigInteger6);
            logger.debug("primes = " + primeList);
        }
        int n2 = 0;
        for (java.math.BigInteger bigInteger7 : primeList) {
            GenPolynomial<ModLong> genPolynomial6;
            AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem3;
            GenPolynomial<ModLong> genPolynomial7;
            GenPolynomialRing<ModLong> genPolynomialRing2;
            GenPolynomial<ModLong> genPolynomial8;
            if (++n2 >= n) {
                logger.error("prime list exhausted, pn = " + n);
                return this.iufd.baseGcd(genPolynomial, genPolynomial2);
            }
            Iterable<ModLong> iterable = ModLongRing.MAX_LONG.compareTo(bigInteger7) > 0 ? new ModLongRing(bigInteger7, true) : new ModIntegerRing(bigInteger7, true);
            GcdRingElem gcdRingElem = (GcdRingElem)iterable.fromInteger(bigInteger6.getVal());
            if (gcdRingElem.isZERO() || (gcdRingElem = (GcdRingElem)iterable.fromInteger(((BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).getVal())).isZERO() || (gcdRingElem = (GcdRingElem)iterable.fromInteger(((BigInteger)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient()).getVal())).isZERO() || !(genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable), genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars()), abelianGroupElem)).degreeVector().equals(expVector2) || !(genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, abelianGroupElem2)).degreeVector().equals(expVector)) continue;
            if (this.debug) {
                logger.info("cofac = " + iterable.getIntegerModul());
            }
            if ((genPolynomial3 = genPolynomial8.gcd(genPolynomial7)).isConstant()) {
                logger.debug("cm, constant = " + genPolynomial3);
                return ((GenPolynomial)genPolynomialRing.getONE()).multiply(bigInteger3);
            }
            GenPolynomial<ModLong> genPolynomial9 = genPolynomial7.divide(genPolynomial3);
            genPolynomialArray = genPolynomial3.egcd(genPolynomial9);
            if (genPolynomialArray[0].isONE()) {
                abelianGroupElem3 = abelianGroupElem2;
                genPolynomial6 = genPolynomial9;
                genPolynomial4 = genPolynomialArray[1];
                genPolynomial5 = genPolynomialArray[2];
            } else {
                GenPolynomial<ModLong> genPolynomial10 = genPolynomial8.divide(genPolynomial3);
                genPolynomialArray = genPolynomial3.egcd(genPolynomial10);
                if (genPolynomialArray[0].isONE()) {
                    abelianGroupElem3 = abelianGroupElem;
                    genPolynomial6 = genPolynomial10;
                    genPolynomial4 = genPolynomialArray[1];
                    genPolynomial5 = genPolynomialArray[2];
                } else {
                    logger.info("both gcd != 1: Hensel not applicable");
                    return this.iufd.baseGcd(genPolynomial, genPolynomial2);
                }
            }
            BigInteger bigInteger8 = (BigInteger)((GenPolynomial)abelianGroupElem3).maxNorm();
            bigInteger8 = bigInteger8.multiply(((BigInteger)((GenPolynomial)abelianGroupElem3).leadingBaseCoefficient()).abs());
            bigInteger8 = bigInteger8.multiply(bigInteger8.fromInteger(2L));
            if (this.debug) {
                System.out.println("crq = " + abelianGroupElem3);
                System.out.println("cm  = " + genPolynomial3);
                System.out.println("cmf = " + genPolynomial6);
                System.out.println("sm  = " + genPolynomial4);
                System.out.println("tm  = " + genPolynomial5);
                System.out.println("cn  = " + bigInteger8);
            }
            try {
                henselApprox = this.quadratic ? HenselUtil.liftHenselQuadratic(abelianGroupElem3, bigInteger8, genPolynomial3, genPolynomial6, genPolynomial4, genPolynomial5) : HenselUtil.liftHensel(abelianGroupElem3, bigInteger8, genPolynomial3, genPolynomial6, genPolynomial4, genPolynomial5);
            }
            catch (NoLiftingException noLiftingException) {
                logger.info("giving up on Hensel gcd reverting to Subres gcd " + noLiftingException);
                return this.iufd.baseGcd(genPolynomial, genPolynomial2);
            }
            abelianGroupElem = henselApprox.A;
            if (this.debug) {
                System.out.println("q   = " + abelianGroupElem);
                System.out.println("qf  = " + henselApprox.B);
            }
            abelianGroupElem = this.basePrimitivePart(abelianGroupElem);
            if (PolyUtil.baseSparsePseudoRemainder(genPolynomial, abelianGroupElem = ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<BigInteger>)((Object)bigInteger3)).abs()).isZERO() && PolyUtil.baseSparsePseudoRemainder(genPolynomial2, abelianGroupElem).isZERO()) break;
            logger.info("final devision not successfull");
        }
        return abelianGroupElem;
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<BigInteger>> genPolynomial, GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2) {
        GenPolynomial genPolynomial3;
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem;
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem2;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            abelianGroupElem2 = genPolynomial;
            abelianGroupElem = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            abelianGroupElem = genPolynomial;
            abelianGroupElem2 = genPolynomial2;
        }
        if (this.debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).abs();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
        GenPolynomial<BigInteger> genPolynomial4 = this.ufd.recursiveContent((GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem2);
        GenPolynomial<BigInteger> genPolynomial5 = this.ufd.recursiveContent((GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem);
        GenPolynomial<BigInteger> genPolynomial6 = this.ufd.gcd(genPolynomial4, genPolynomial5);
        abelianGroupElem2 = PolyUtil.recursiveDivide(abelianGroupElem2, genPolynomial4);
        abelianGroupElem = PolyUtil.recursiveDivide(abelianGroupElem, genPolynomial5);
        genPolynomial4 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial6);
        genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial5, genPolynomial6);
        if (((GenPolynomial)abelianGroupElem2).isONE()) {
            return ((GenPolynomial)abelianGroupElem2).multiply(genPolynomial6);
        }
        if (((GenPolynomial)abelianGroupElem).isONE()) {
            return ((GenPolynomial)abelianGroupElem).multiply(genPolynomial6);
        }
        GenPolynomial genPolynomial7 = (GenPolynomial)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient();
        GenPolynomial<BigInteger> genPolynomial8 = this.ufd.gcd(genPolynomial7, genPolynomial3 = (GenPolynomial)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient());
        if (!genPolynomial8.isConstant()) {
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial9 = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem2, (GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem);
            genPolynomial9 = ((GenPolynomial)genPolynomial9.abs()).multiply(genPolynomial6);
            logger.info("non monic ldcf (" + genPolynomial8 + ") not implemented: " + genPolynomial9 + "= gcd(" + abelianGroupElem2 + "," + abelianGroupElem + ") * " + genPolynomial6);
            return genPolynomial9;
        }
        GenPolynomial genPolynomial10 = PolyUtil.switchVariables(abelianGroupElem);
        GenPolynomial genPolynomial11 = PolyUtil.switchVariables(abelianGroupElem2);
        GenPolynomialRing genPolynomialRing = genPolynomial10.ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        GenPolynomialRing<BigInteger> genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial12 = PolyUtil.distribute(genPolynomialRing3, genPolynomial10);
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial13 = PolyUtil.distribute(genPolynomialRing3, genPolynomial11);
        BigInteger bigInteger = (BigInteger)genPolynomial13.leadingBaseCoefficient();
        BigInteger bigInteger2 = (BigInteger)genPolynomial12.leadingBaseCoefficient();
        BigInteger bigInteger3 = this.gcd(bigInteger, bigInteger2);
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        Iterator<java.math.BigInteger> iterator = primeList.iterator();
        int n = 50;
        GenPolynomial<BigInteger> genPolynomial14 = null;
        for (int i = 0; i < 11; ++i) {
            List<GenPolynomial<ModLong>> list;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            GenPolynomial genPolynomial15;
            BigInteger bigInteger6;
            GenPolynomial genPolynomial16;
            RingElem<BigInteger> ringElem;
            AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem3;
            GenPolynomial<BigInteger> genPolynomial17;
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial18;
            GenPolynomial genPolynomial19;
            RingElem<BigInteger> ringElem2;
            GcdRingElem gcdRingElem;
            long l4;
            long l5;
            long l6;
            Serializable serializable;
            Iterable<Monomial<BigInteger>> iterable;
            java.math.BigInteger bigInteger7 = null;
            if (i == 0) {
                primeList = new PrimeList(PrimeList.Range.medium);
                iterator = primeList.iterator();
            }
            if (i == 4) {
                primeList = new PrimeList(PrimeList.Range.small);
                iterator = primeList.iterator();
                bigInteger7 = iterator.next();
                bigInteger7 = iterator.next();
                bigInteger7 = iterator.next();
                bigInteger7 = iterator.next();
            }
            if (i == 9) {
                primeList = new PrimeList(PrimeList.Range.large);
                iterator = primeList.iterator();
            }
            Object object = null;
            int n2 = 0;
            while (n2 < n && iterator.hasNext()) {
                bigInteger7 = iterator.next();
                logger.info("prime = " + bigInteger7);
                iterable = null;
                iterable = ModLongRing.MAX_LONG.compareTo(bigInteger7) > 0 ? new ModLongRing(bigInteger7, true) : new ModIntegerRing(bigInteger7, true);
                serializable = (GcdRingElem)iterable.fromInteger(bigInteger3.getVal());
                if (serializable.isZERO() || (serializable = (GcdRingElem)iterable.fromInteger(((BigInteger)((GenPolynomial)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).leadingBaseCoefficient()).getVal())).isZERO() || (serializable = (GcdRingElem)iterable.fromInteger(((BigInteger)((GenPolynomial)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient()).leadingBaseCoefficient()).getVal())).isZERO()) continue;
                object = iterable;
                break;
            }
            if (object == null) {
                iterable = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem, (GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem2);
                logger.info("no lucky prime, gave up on Hensel: " + iterable + "= gcd(" + abelianGroupElem2 + "," + abelianGroupElem + ")");
                return ((GenPolynomial)iterable.abs()).multiply(genPolynomial6);
            }
            iterable = new ArrayList(genPolynomial.ring.nvar);
            serializable = genPolynomialRing3;
            GenPolynomial<Object> genPolynomial20 = genPolynomial12;
            GenPolynomial genPolynomial21 = genPolynomial13;
            for (int j = genPolynomialRing3.nvar; j > 1; --j) {
                block38: {
                    GenPolynomial<BigInteger> genPolynomial22;
                    GenPolynomial<BigInteger> genPolynomial23;
                    l6 = genPolynomial20.degree(((GenPolynomialRing)serializable).nvar - 2);
                    l5 = genPolynomial21.degree(((GenPolynomialRing)serializable).nvar - 2);
                    serializable = ((GenPolynomialRing)serializable).contract(1);
                    l4 = 1L;
                    if (bigInteger7.longValue() > 1000L) {
                        l4 = 0L;
                    }
                    do {
                        if ((gcdRingElem = (GcdRingElem)object.fromInteger(l4++)).isZERO() && l4 != 1L) {
                            genPolynomial20 = null;
                            genPolynomial21 = null;
                            break block38;
                        }
                        ringElem2 = new BigInteger(l4 - 1L);
                        genPolynomial23 = PolyUtil.evaluateMain(serializable, genPolynomial20, ringElem2);
                        genPolynomial22 = PolyUtil.evaluateMain(serializable, genPolynomial21, ringElem2);
                    } while (l6 != genPolynomial23.degree(((GenPolynomialRing)serializable).nvar - 1) || l5 != genPolynomial22.degree(((GenPolynomialRing)serializable).nvar - 1));
                    iterable.add((BigInteger)ringElem2);
                    genPolynomial20 = genPolynomial23;
                    genPolynomial21 = genPolynomial22;
                }
                if (genPolynomial20 == null && genPolynomial21 == null) break;
            }
            if (genPolynomial20 == null && genPolynomial21 == null) continue;
            logger.info("evaluation points  = " + iterable);
            GenPolynomial<BigInteger> genPolynomial24 = this.ufd.baseGcd(genPolynomial20, genPolynomial21);
            if (genPolynomial24.isConstant()) {
                return ((GenPolynomial)genPolynomial.ring.getONE()).multiply(genPolynomial6);
            }
            logger.info("base gcd = " + genPolynomial24);
            if (i == 0) {
                genPolynomial19 = genPolynomial20;
                genPolynomial18 = genPolynomial21;
                genPolynomial14 = genPolynomial24;
                continue;
            }
            l6 = genPolynomial14.degree(0);
            l5 = genPolynomial24.degree(0);
            if (l5 < l6) {
                genPolynomial19 = genPolynomial20;
                genPolynomial18 = genPolynomial21;
                genPolynomial14 = genPolynomial24;
                continue;
            }
            if (l5 > l6) continue;
            l4 = ((GenPolynomial)abelianGroupElem2).degree(0);
            if (l6 == l4) {
                if (!PolyUtil.recursivePseudoRemainder(abelianGroupElem, abelianGroupElem2).isZERO()) continue;
                abelianGroupElem2 = ((GenPolynomial)((GenPolynomial)abelianGroupElem2).abs()).multiply(genPolynomial6);
                logger.info("exit with r | q : " + abelianGroupElem2);
                return abelianGroupElem2;
            }
            gcdRingElem = null;
            ringElem2 = PolyUtil.basePseudoDivide(genPolynomial21, genPolynomial24);
            GenPolynomial<BigInteger> genPolynomial25 = PolyUtil.basePseudoDivide(genPolynomial20, genPolynomial24);
            GenPolynomial<BigInteger> genPolynomial26 = this.ufd.baseGcd((GenPolynomial<BigInteger>)ringElem2, genPolynomial24);
            GenPolynomial<BigInteger> genPolynomial27 = this.ufd.baseGcd(genPolynomial25, genPolynomial24);
            if (genPolynomial26.isONE() && genPolynomial27.isONE()) {
                if (genPolynomial7.totalDegree() > genPolynomial3.totalDegree()) {
                    genPolynomial17 = genPolynomial12;
                    abelianGroupElem3 = abelianGroupElem;
                    ringElem = genPolynomial25;
                    genPolynomial16 = genPolynomial20;
                    bigInteger6 = (BigInteger)genPolynomial12.maxNorm();
                    gcdRingElem = bigInteger6.multiply(bigInteger3).multiply(new BigInteger(2L));
                    genPolynomial15 = genPolynomial3;
                    logger.debug("select deg: ui = qd, g = b");
                } else {
                    genPolynomial17 = genPolynomial13;
                    abelianGroupElem3 = abelianGroupElem2;
                    ringElem = ringElem2;
                    genPolynomial16 = genPolynomial21;
                    bigInteger6 = (BigInteger)genPolynomial13.maxNorm();
                    gcdRingElem = bigInteger6.multiply(bigInteger3).multiply(new BigInteger(2L));
                    genPolynomial15 = genPolynomial7;
                    logger.debug("select deg: ui = rd, g = a");
                }
            } else if (genPolynomial26.isONE()) {
                genPolynomial17 = genPolynomial13;
                abelianGroupElem3 = abelianGroupElem2;
                ringElem = ringElem2;
                genPolynomial16 = genPolynomial21;
                bigInteger6 = (BigInteger)genPolynomial13.maxNorm();
                gcdRingElem = bigInteger6.multiply(bigInteger3).multiply(new BigInteger(2L));
                genPolynomial15 = genPolynomial7;
                logger.debug("select: ui = rd, g = a");
            } else if (genPolynomial27.isONE()) {
                genPolynomial17 = genPolynomial12;
                abelianGroupElem3 = abelianGroupElem;
                ringElem = genPolynomial25;
                genPolynomial16 = genPolynomial20;
                bigInteger6 = (BigInteger)genPolynomial12.maxNorm();
                gcdRingElem = bigInteger6.multiply(bigInteger3).multiply(new BigInteger(2L));
                genPolynomial15 = genPolynomial3;
                logger.debug("select: ui = qd, g = b");
            } else {
                logger.info("both gcds != 1: method not applicable");
                break;
            }
            GenPolynomial<BigInteger> genPolynomial28 = genPolynomial8;
            GenPolynomial<BigInteger> genPolynomial29 = PolyUtil.basePseudoDivide(genPolynomial15, genPolynomial28);
            bigInteger6 = (BigInteger)((Object)PolyUtil.evaluateAll(genPolynomial15.ring.coFac, genPolynomial28, iterable));
            if (bigInteger6.isZERO() || (bigInteger5 = (BigInteger)((Object)PolyUtil.evaluateAll(genPolynomial15.ring.coFac, genPolynomial29, iterable))).isZERO() || (bigInteger4 = (BigInteger)((Object)PolyUtil.evaluateAll(genPolynomial15.ring.coFac, genPolynomial15, iterable))).isZERO()) continue;
            ringElem = ((GenPolynomial)ringElem).multiply(bigInteger6);
            GenPolynomial<BigInteger> genPolynomial30 = genPolynomial28.extendLower(genPolynomialRing3, 0, 0L);
            genPolynomial17 = genPolynomial17.multiply((BigInteger)((Object)genPolynomial30));
            logger.info("gcd(ldcf): " + genPolynomial28 + ", ldcf cofactor: " + genPolynomial29 + ", base cofactor: " + ringElem);
            long l7 = Power.logarithm(new BigInteger(bigInteger7), gcdRingElem);
            BigInteger bigInteger8 = Power.positivePower(object.getIntegerModul(), l7);
            Iterable<ModLong> iterable2 = ModLongRing.MAX_LONG.compareTo(bigInteger8.getVal()) > 0 ? new ModLongRing(bigInteger8.getVal(), true) : new ModIntegerRing(bigInteger8.getVal(), true);
            GenPolynomialRing<ModLong> genPolynomialRing4 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), (GenPolynomialRing)serializable);
            if (((GcdRingElem)iterable2.fromInteger(bigInteger6.getVal())).isZERO()) continue;
            GenPolynomial<ModLong> genPolynomial31 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial24);
            GenPolynomial<ModLong> genPolynomial32 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, ringElem);
            if (genPolynomial31.degree(0) != genPolynomial24.degree(0) || genPolynomial32.degree(0) != ((GenPolynomial)ringElem).degree(0) || genPolynomial31.isZERO() || genPolynomial32.isZERO()) continue;
            logger.info("univariate modulo p^k: " + genPolynomial31 + ", " + genPolynomial32);
            GenPolynomialRing<ModLong> genPolynomialRing5 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing3);
            GenPolynomial<ModLong> genPolynomial33 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial17);
            if (!genPolynomial17.leadingExpVector().equals(genPolynomial33.leadingExpVector())) {
                logger.info("ev(ui) = " + genPolynomial17.leadingExpVector() + ", ev(uq) = " + genPolynomial33.leadingExpVector());
                continue;
            }
            logger.info("multivariate modulo p^k: " + genPolynomial33);
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(genPolynomial31);
            arrayList.add(genPolynomial32);
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>(2);
            arrayList2.add((GenPolynomial<BigInteger>)genPolynomial28.ring.getONE());
            arrayList2.add((GenPolynomial<BigInteger>)genPolynomial28.ring.getONE());
            try {
                list = HenselMultUtil.liftHensel(genPolynomial17, genPolynomial33, arrayList, iterable, l7, arrayList2);
                logger.info("lift = " + list);
            }
            catch (NoLiftingException noLiftingException) {
                logger.info("NoLiftingException");
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                logger.info("ArithmeticException");
                continue;
            }
            catch (NotInvertibleException notInvertibleException) {
                logger.info("NotInvertibleException");
                continue;
            }
            GenPolynomial<BigInteger> genPolynomial34 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, list.get(0));
            genPolynomial34 = this.basePrimitivePart(genPolynomial34);
            GenPolynomial genPolynomial35 = PolyUtil.recursive(genPolynomialRing, genPolynomial34);
            GenPolynomial genPolynomial36 = PolyUtil.switchVariables(genPolynomial35);
            if (!genPolynomial36.ring.equals(genPolynomial.ring)) {
                System.out.println("Cs.ring = " + genPolynomial36.ring + ", P.ring = " + genPolynomial.ring);
            }
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial37 = this.ufd.recursivePrimitivePart(genPolynomial36);
            genPolynomial37 = this.ufd.baseRecursivePrimitivePart(genPolynomial37);
            genPolynomial37 = ((GenPolynomial)genPolynomial37.abs()).multiply(genPolynomial6);
            GenPolynomial genPolynomial38 = PolyUtil.recursivePseudoRemainder(genPolynomial, genPolynomial37);
            GenPolynomial genPolynomial39 = PolyUtil.recursivePseudoRemainder(genPolynomial2, genPolynomial37);
            if (genPolynomial38.isZERO() && genPolynomial39.isZERO()) {
                logger.info("gcd normal exit: " + genPolynomial37);
                return genPolynomial37;
            }
            logger.info("bad Q = " + genPolynomial37);
        }
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial40 = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem2, (GenPolynomial<GenPolynomial<BigInteger>>)abelianGroupElem);
        genPolynomial40 = ((GenPolynomial)genPolynomial40.abs()).multiply(genPolynomial6);
        logger.info("no lucky prime or evaluation points, gave up on Hensel: " + genPolynomial40 + "= gcd(" + abelianGroupElem2 + "," + abelianGroupElem + ")");
        return genPolynomial40;
    }

    GenPolynomial<BigInteger> invertPoly(ModularRingFactory<MOD> modularRingFactory, GenPolynomial<BigInteger> genPolynomial, List<BigInteger> list) {
        RingElem<BigInteger> ringElem2;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new RuntimeException("li not invertible: " + genPolynomial);
        }
        if (genPolynomial.isONE()) {
            return genPolynomial;
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing<MOD> genPolynomialRing2 = new GenPolynomialRing<MOD>(modularRingFactory, genPolynomialRing);
        GenPolynomial<MOD> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>(list.size());
        int n = 0;
        for (RingElem<BigInteger> ringElem2 : list) {
            GcdRingElem gcdRingElem = (GcdRingElem)modularRingFactory.fromInteger(ringElem2.getVal());
            GenPolynomial<Object> genPolynomial3 = genPolynomialRing2.univariate(n);
            genPolynomial3 = genPolynomial3.subtract((MOD)gcdRingElem);
            arrayList.add(genPolynomial3);
            ++n;
        }
        GenPolynomial<MOD> genPolynomial4 = genPolynomial2;
        ringElem2 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
        return ringElem2;
    }
}

