/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.AbstractPair;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderedMinPairlist<C extends RingElem<C>>
extends OrderedPairlist<C> {
    private static final Logger logger = Logger.getLogger(OrderedMinPairlist.class);

    public OrderedMinPairlist() {
    }

    public OrderedMinPairlist(GenPolynomialRing<C> genPolynomialRing) {
        this(0, genPolynomialRing);
    }

    public OrderedMinPairlist(int n, GenPolynomialRing<C> genPolynomialRing) {
        super(n, genPolynomialRing);
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedMinPairlist<C>(genPolynomialRing);
    }

    @Override
    public PairList<C> create(int n, GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedMinPairlist<C>(n, genPolynomialRing);
    }

    @Override
    public synchronized int put(GenPolynomial<C> genPolynomial) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        int n = this.P.size();
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        this.red.add(bitSet);
        this.P.add(genPolynomial);
        for (int i = 0; i < n; ++i) {
            GenPolynomial genPolynomial2 = (GenPolynomial)this.P.get(i);
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, expVector, expVector2)) {
                ((BitSet)this.red.get(i)).clear(n);
                continue;
            }
            ExpVector expVector3 = expVector.lcm(expVector2);
            Pair<C> pair = new Pair<C>(genPolynomial2, genPolynomial, i, n);
            boolean bl = true;
            if (this.useCriterion4) {
                bl = this.reduction.criterion4(pair.pi, pair.pj, expVector3);
            }
            if (bl) {
                bl = this.criterion3(i, n, expVector3);
            }
            if (!bl) {
                ((BitSet)this.red.get(i)).clear(n);
                continue;
            }
            LinkedList<Pair<C>> linkedList = (LinkedList<Pair<C>>)this.pairlist.get(expVector3);
            if (linkedList == null) {
                linkedList = new LinkedList<Pair<C>>();
            }
            linkedList.addFirst(pair);
            this.pairlist.put(expVector3, linkedList);
        }
        return this.P.size() - 1;
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator iterator = this.pairlist.entrySet().iterator();
        AbstractPair abstractPair = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ExpVector expVector = (ExpVector)entry.getKey();
            LinkedList linkedList = (LinkedList)entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info("g  = " + expVector);
            }
            abstractPair = null;
            while (!bl && linkedList.size() > 0) {
                abstractPair = (Pair)linkedList.removeFirst();
                int n = ((Pair)abstractPair).i;
                int n2 = ((Pair)abstractPair).j;
                if (!((BitSet)this.red.get(n2)).get(n)) {
                    System.out.println("c_y = " + expVector);
                    continue;
                }
                bl = true;
                if (this.useCriterion4) {
                    bl = this.reduction.criterion4(((Pair)abstractPair).pi, ((Pair)abstractPair).pj, expVector);
                }
                if (bl) {
                    bl = this.criterion3(n, n2, expVector);
                }
                if (!bl) {
                    // empty if block
                }
                ((BitSet)this.red.get(n2)).clear(n);
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
        if (!bl) {
            abstractPair = null;
        } else {
            abstractPair.maxIndex(this.P.size() - 1);
            ++this.remCount;
            if (logger.isDebugEnabled()) {
                logger.info("pair(" + ((Pair)abstractPair).j + "," + ((Pair)abstractPair).i + ")");
            }
        }
        return abstractPair;
    }

    @Override
    public boolean criterion3(int n, int n2, ExpVector expVector) {
        boolean bl = ((BitSet)this.red.get(n2)).get(n);
        if (!bl) {
            logger.warn("c3.s false for " + n2 + " " + n);
            return bl;
        }
        bl = true;
        for (int i = 0; i < this.P.size(); ++i) {
            boolean bl2;
            GenPolynomial genPolynomial = (GenPolynomial)this.P.get(i);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            boolean bl3 = bl2 = expVector.multipleOf(expVector2) && expVector.compareTo(expVector2) != 0;
            if (!bl2) continue;
            if (i < n) {
                boolean bl4 = bl = ((BitSet)this.red.get(n)).get(i) || ((BitSet)this.red.get(n2)).get(i);
            }
            if (n < i && i < n2) {
                boolean bl5 = bl = ((BitSet)this.red.get(i)).get(n) || ((BitSet)this.red.get(n2)).get(i);
            }
            if (n2 < i) {
                boolean bl6 = bl = ((BitSet)this.red.get(i)).get(n) || ((BitSet)this.red.get(i)).get(n2);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

