/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybridEC;
import edu.jas.gb.HybridReducerReceiverEC;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class HybridReducerServerEC<C extends RingElem<C>>
implements Runnable {
    public static final Logger logger = Logger.getLogger(HybridReducerServerEC.class);
    public final boolean debug = logger.isDebugEnabled();
    private final Terminator finner;
    private final ChannelFactory cf;
    private TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybridEC.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybridEC.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybridEC.ackTag;

    HybridReducerServerEC(int n, Terminator terminator, ChannelFactory channelFactory, DistHashTable<Integer, GenPolynomial<C>> distHashTable, PairList<C> pairList) {
        this.threadsPerNode = n;
        this.finner = terminator;
        this.cf = channelFactory;
        this.theList = distHashTable;
        this.pairlist = pairList;
    }

    @Override
    public void run() {
        HybridReducerReceiverEC<C> hybridReducerReceiverEC;
        AtomicInteger atomicInteger;
        SocketChannel socketChannel;
        block23: {
            logger.info("reducer server running with " + this.cf);
            socketChannel = null;
            try {
                socketChannel = this.cf.getChannel();
                this.pairChannel = new TaggedSocketChannel(socketChannel);
                this.pairChannel.init();
            }
            catch (InterruptedException interruptedException) {
                logger.debug("get pair channel interrupted");
                interruptedException.printStackTrace();
                return;
            }
            if (this.debug) {
                logger.info("pairChannel   = " + this.pairChannel);
            }
            this.finner.initIdle(this.threadsPerNode);
            atomicInteger = new AtomicInteger(0);
            hybridReducerReceiverEC = new HybridReducerReceiverEC<C>(this.finner, atomicInteger, this.pairChannel, this.theList, this.pairlist);
            hybridReducerReceiverEC.start();
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            while (bl) {
                logger.debug("receive request");
                Object object = null;
                try {
                    object = this.pairChannel.receive(this.pairTag);
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                    interruptedException.printStackTrace();
                }
                catch (IOException iOException) {
                    bl = false;
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                    classNotFoundException.printStackTrace();
                }
                if (object == null) {
                    bl = false;
                    break;
                }
                if (!(object instanceof GBTransportMessReq)) {
                    bl = false;
                    break;
                }
                logger.debug("find pair");
                while (!this.pairlist.hasNext()) {
                    if (!this.finner.hasJobs() && !this.pairlist.hasNext()) {
                        bl = false;
                        break;
                    }
                    try {
                        ++n2;
                        logger.info("waiting for reducers, remaining = " + this.finner);
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = false;
                        break;
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    bl = false;
                    break;
                }
                if (!this.pairlist.hasNext() && !this.finner.hasJobs()) {
                    logger.info("termination detection: no pairs and no jobs left");
                    bl = false;
                    break;
                }
                this.finner.notIdle();
                Pair<C> pair = this.pairlist.removeNext();
                if (this.debug) {
                    logger.info("active count = " + atomicInteger.get());
                    logger.info("send pair = " + pair);
                }
                GBTransportMess gBTransportMess = null;
                gBTransportMess = pair != null ? new GBTransportMessPairIndex(pair) : new GBTransportMess();
                try {
                    ++n;
                    this.pairChannel.send(this.pairTag, gBTransportMess);
                    int n3 = atomicInteger.getAndIncrement();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl = false;
                    break;
                }
            }
            logger.info("terminated, send " + n + " reduction pairs");
            logger.debug("send end");
            try {
                for (int i = 0; i < this.threadsPerNode; ++i) {
                    this.pairChannel.send(this.pairTag, new GBTransportMessEnd());
                }
                this.pairChannel.send(this.resultTag, new GBTransportMessEnd());
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block23;
                iOException.printStackTrace();
            }
        }
        hybridReducerReceiverEC.terminate();
        int n = atomicInteger.get();
        if (n > 0) {
            logger.info("remaining active tasks = " + n);
        }
        this.pairChannel.close();
        logger.debug("redServ pairChannel.close()");
        this.finner.release();
        socketChannel.close();
        logger.info("redServ channel.close()");
    }
}

