/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reducer;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseParallel<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseParallel.class);
    protected final int threads;
    protected final transient ThreadPool pool;

    public GroebnerBaseParallel() {
        this(2);
    }

    public GroebnerBaseParallel(int n) {
        this(n, new ThreadPool(n));
    }

    public GroebnerBaseParallel(int n, Reduction<C> reduction) {
        this(n, new ThreadPool(n), reduction);
    }

    public GroebnerBaseParallel(int n, PairList<C> pairList) {
        this(n, new ThreadPool(n), new ReductionPar(), pairList);
    }

    public GroebnerBaseParallel(int n, ThreadPool threadPool) {
        this(n, threadPool, new ReductionPar());
    }

    public GroebnerBaseParallel(int n, ThreadPool threadPool, Reduction<C> reduction) {
        this(n, threadPool, reduction, new OrderedPairlist());
    }

    public GroebnerBaseParallel(int n, Reduction<C> reduction, PairList<C> pairList) {
        this(n, new ThreadPool(n), reduction, pairList);
    }

    public GroebnerBaseParallel(int n, ThreadPool threadPool, Reduction<C> reduction, PairList<C> pairList) {
        super(reduction, pairList);
        if (!(reduction instanceof ReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = threadPool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.cancel();
        return n;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.info("start " + pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            Reducer<C> reducer = new Reducer<C>(terminator, list2, pairList);
            this.pool.addJob(reducer);
        }
        terminator.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug("#parallel list = " + list2.size());
        list2 = this.minimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducer[] miReducerArray = new MiReducer[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerArray[n] = new MiReducer(arrayList3, genPolynomial);
            this.pool.addJob(miReducerArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerArray.length; ++n) {
            genPolynomial = miReducerArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

