/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class GroebnerBaseAbstract<C extends RingElem<C>>
implements GroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Reduction<C> red;
    public final PairList<C> strategy;
    public final BasicLinAlg<GenPolynomial<C>> blas;

    public GroebnerBaseAbstract() {
        this(new ReductionSeq());
    }

    public GroebnerBaseAbstract(Reduction<C> reduction) {
        this(reduction, new OrderedPairlist());
    }

    public GroebnerBaseAbstract(PairList<C> pairList) {
        this(new ReductionSeq(), pairList);
    }

    public GroebnerBaseAbstract(Reduction<C> reduction, PairList<C> pairList) {
        if (reduction == null) {
            reduction = new ReductionSeq();
        }
        this.red = reduction;
        if (pairList == null) {
            pairList = new OrderedPairlist();
        }
        this.strategy = pairList;
        this.blas = new BasicLinAlg();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public List<GenPolynomial<C>> normalizeZerosOnes(List<GenPolynomial<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            if (genPolynomial.isUnit()) {
                arrayList.clear();
                arrayList.add((GenPolynomial<C>)genPolynomial.ring.getONE());
                return arrayList;
            }
            arrayList.add((GenPolynomial<C>)genPolynomial.abs());
        }
        return arrayList;
    }

    @Override
    public boolean isGB(List<GenPolynomial<C>> list) {
        return this.isGB(0, list);
    }

    @Override
    public boolean isGB(int n, List<GenPolynomial<C>> list) {
        return this.isGB(n, list, true);
    }

    public boolean isGB(List<GenPolynomial<C>> list, boolean bl) {
        return this.isGB(0, list, bl);
    }

    public boolean isGB(int n, List<GenPolynomial<C>> list, boolean bl) {
        if (bl) {
            return this.isGBsimple(n, list);
        }
        return this.isGBidem(n, list);
    }

    public boolean isGBsimple(int n, List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            ExpVector expVector = genPolynomial.leadingExpVector();
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<C> genPolynomial2;
                GenPolynomial<C> genPolynomial3;
                ExpVector expVector2;
                GenPolynomial<C> genPolynomial4 = list.get(j);
                ExpVector expVector3 = genPolynomial4.leadingExpVector();
                if (!this.red.moduleCriterion(n, expVector, expVector3) || !this.red.criterion4(expVector, expVector3, expVector2 = expVector.lcm(expVector3)) || !this.criterion3(i, j, expVector2, list) || (genPolynomial3 = this.red.SPolynomial(genPolynomial, genPolynomial4)).isZERO() || (genPolynomial2 = this.red.normalform(list, genPolynomial3)).isZERO()) continue;
                logger.info("no GB: pi = " + genPolynomial + ", pj = " + genPolynomial4);
                logger.info("s  = " + genPolynomial3 + ", h = " + genPolynomial2);
                return false;
            }
        }
        return true;
    }

    boolean criterion3(int n, int n2, ExpVector expVector, List<GenPolynomial<C>> list) {
        assert (n < n2);
        for (int i = 0; i < n; ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            if (!expVector.multipleOf(expVector2)) continue;
            return false;
        }
        return true;
    }

    public boolean isGBidem(int n, List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list);
        List<GenPolynomial<C>> list2 = this.GB(n, list);
        PolynomialList polynomialList2 = new PolynomialList(genPolynomialRing, list2);
        return polynomialList.compareTo(polynomialList2) == 0;
    }

    public int commonZeroTest(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return 1;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 0) {
            return -1;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (GenPolynomial<C> genPolynomial : list) {
            int[] nArray;
            if (genPolynomial.isZERO()) continue;
            if (genPolynomial.isConstant()) {
                return -1;
            }
            ExpVector expVector = genPolynomial.leadingExpVector();
            if (expVector == null || (nArray = expVector.dependencyOnVariables()) == null || nArray.length != 1) continue;
            hashSet.add(nArray[0]);
        }
        if (genPolynomialRing.nvar == hashSet.size()) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<GenPolynomial<C>> GB(List<GenPolynomial<C>> list) {
        return this.GB(0, list);
    }

    @Override
    public ExtendedGB<C> extGB(List<GenPolynomial<C>> list) {
        return this.extGB(0, list);
    }

    @Override
    public ExtendedGB<C> extGB(int n, List<GenPolynomial<C>> list) {
        throw new UnsupportedOperationException("extGB not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial genPolynomial;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenPolynomial<C>> iterable2 = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> iterable3 : list) {
            if (iterable3 == null || iterable3.isZERO()) continue;
            iterable2.add(iterable3);
        }
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        ArrayList arrayList = new ArrayList(iterable2.size());
        while (iterable2.size() > 0) {
            genPolynomial = (GenPolynomial)iterable2.remove(0);
            if (this.red.isTopReducible(iterable2, genPolynomial) || this.red.isTopReducible(arrayList, genPolynomial)) {
                if (!this.debug) continue;
                System.out.println("dropped " + genPolynomial);
                ArrayList<GenPolynomial<C>> n = new ArrayList<GenPolynomial<C>>(iterable2);
                n.addAll(arrayList);
                if ((genPolynomial = this.red.normalform(n, genPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
        }
        iterable2 = arrayList;
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        Collections.reverse(iterable2);
        int n = iterable2.size();
        if (this.debug) {
            System.out.println("#G " + n);
            for (GenPolynomial genPolynomial2 : iterable2) {
                System.out.println("aa = " + genPolynomial2.length() + ", lt = " + genPolynomial2.getMap().keySet());
            }
        }
        for (int i = 0; i < n; ++i) {
            genPolynomial = (GenPolynomial)iterable2.remove(0);
            if (this.debug) {
                System.out.println("doing " + genPolynomial.length() + ", lt = " + genPolynomial.leadingExpVector());
            }
            genPolynomial = this.red.normalform(iterable2, genPolynomial);
            iterable2.add(genPolynomial);
        }
        return iterable2;
    }

    public boolean isMinimalGB(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> iterable2 : list) {
            if (iterable2 != null && !iterable2.isZERO()) continue;
            if (this.debug) {
                logger.debug("zero polynomial " + iterable2);
            }
            return false;
        }
        ArrayList iterable3 = new ArrayList<GenPolynomial<C>>(list);
        ArrayList arrayList = new ArrayList(iterable3.size());
        while (iterable3.size() > 0) {
            GenPolynomial n = (GenPolynomial)iterable3.remove(0);
            if (this.red.isTopReducible(iterable3, n) || this.red.isTopReducible(arrayList, n)) {
                if (this.debug) {
                    logger.debug("top reducible polynomial " + n);
                }
                return false;
            }
            arrayList.add(n);
        }
        iterable3 = arrayList;
        if (iterable3.size() <= 1) {
            return true;
        }
        int n = iterable3.size();
        for (int i = 0; i < n; ++i) {
            GenPolynomial genPolynomial = (GenPolynomial)iterable3.remove(0);
            if (!this.red.isNormalform(iterable3, genPolynomial)) {
                if (this.debug) {
                    logger.debug("reducible polynomial " + genPolynomial);
                }
                return false;
            }
            iterable3.add(genPolynomial);
        }
        return true;
    }

    @Override
    public boolean isReductionMatrix(ExtendedGB<C> extendedGB) {
        if (extendedGB == null) {
            return true;
        }
        return this.isReductionMatrix(extendedGB.F, extendedGB.G, extendedGB.F2G, extendedGB.G2F);
    }

    @Override
    public boolean isReductionMatrix(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2, List<List<GenPolynomial<C>>> list3, List<List<GenPolynomial<C>>> list4) {
        boolean bl;
        int n = 0;
        for (List<GenPolynomial<C>> list5 : list4) {
            bl = this.red.isReductionNF(list5, list, list2.get(n), null);
            if (!bl) {
                logger.error("F isReductionMatrix s, k = " + list.size() + ", " + n);
                return false;
            }
            ++n;
        }
        n = 0;
        for (List<GenPolynomial<C>> list5 : list3) {
            bl = this.red.isReductionNF(list5, list2, list.get(n), null);
            if (!bl) {
                logger.error("G isReductionMatrix s, k = " + list2.size() + ", " + n);
                return false;
            }
            ++n;
        }
        return true;
    }

    public List<List<GenPolynomial<C>>> normalizeMatrix(int n, List<List<GenPolynomial<C>>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() == 0) {
            return list;
        }
        ArrayList<List<GenPolynomial<Object>>> arrayList = new ArrayList<List<GenPolynomial<Object>>>();
        ArrayList<List<GenPolynomial<C>>> arrayList2 = new ArrayList<List<GenPolynomial<C>>>();
        int n2 = list.get(list.size() - 1).size();
        for (List<GenPolynomial<C>> list3 : list) {
            ArrayList<GenPolynomial<C>> list22 = new ArrayList<GenPolynomial<C>>(list3);
            for (int i = list3.size(); i < n2; ++i) {
                list22.add(null);
            }
            arrayList.add(list22);
        }
        int n3 = n;
        for (int i = 0; i < arrayList.size(); ++i) {
            List list2 = (List)arrayList.get(i);
            if (this.debug) {
                logger.info("row = " + list2);
            }
            arrayList2.add(list2);
            if (i < n) continue;
            for (int j = i + 1; j < arrayList.size(); ++j) {
                GenPolynomial genPolynomial;
                List list3 = (List)arrayList.get(j);
                if (n3 >= list3.size() || (genPolynomial = (GenPolynomial)list3.get(n3)) == null || genPolynomial.isZERO()) continue;
                List<GenPolynomial> list4 = this.blas.scalarProduct(genPolynomial, list2);
                list4 = this.blas.vectorAdd(list4, list3);
                arrayList.set(j, list4);
            }
            ++n3;
        }
        arrayList.clear();
        for (List list5 : arrayList2) {
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList3.add(list5.get(i));
            }
            arrayList.add(arrayList3);
        }
        arrayList2 = arrayList;
        return arrayList2;
    }

    public ExtendedGB<C> minimalExtendedGB(int n, List<GenPolynomial<C>> list, List<List<GenPolynomial<C>>> list2) {
        List<GenPolynomial<Object>> list3;
        if (list == null) {
            return null;
        }
        if (list.size() <= 1) {
            return new ExtendedGB<C>(null, list, null, list2);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        ArrayList arrayList2 = new ArrayList(list.size());
        ArrayList<ArrayList<GenPolynomial<C>>> arrayList3 = new ArrayList<ArrayList<GenPolynomial<C>>>(list2.size());
        ArrayList arrayList4 = new ArrayList(list2.size());
        for (List<GenPolynomial<C>> object : list2) {
            list3 = new ArrayList<GenPolynomial<C>>(object);
            arrayList3.add((ArrayList<GenPolynomial<C>>)list3);
        }
        list3 = null;
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n2 = 0;
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial genPolynomial;
            GenPolynomial genPolynomial2 = (GenPolynomial)arrayList.remove(0);
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            ListIterator listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial = (GenPolynomial)listIterator.next();
                expVector = genPolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial = (GenPolynomial)listIterator.next();
                expVector = genPolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (!bl) {
                arrayList2.add(genPolynomial2);
                arrayList5.add(n2);
            } else {
                arrayList6.add(n2);
            }
            ++n2;
        }
        if (this.debug) {
            logger.debug("ix, #M, jx = " + arrayList5 + ", " + arrayList3.size() + ", " + arrayList6);
        }
        int n3 = -1;
        for (int i = 0; i < arrayList5.size(); ++i) {
            int n4 = (Integer)arrayList5.get(i);
            if (n4 >= n && n3 == -1) {
                n3 = arrayList4.size();
            }
            if (n4 < 0) continue;
            list3 = (List)arrayList3.get(n4);
            arrayList4.add(list3);
        }
        if (arrayList2.size() <= 1 || n3 == -1) {
            return new ExtendedGB(null, arrayList2, null, arrayList4);
        }
        return new ExtendedGB(null, arrayList2, null, arrayList4);
    }

    public List<Long> univariateDegrees(List<GenPolynomial<C>> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 0) {
            return arrayList;
        }
        TreeMap<Integer, Long> treeMap = new TreeMap<Integer, Long>();
        for (Comparable<GenPolynomial<C>> comparable : list) {
            Long l;
            int[] nArray;
            ExpVector expVector = comparable.leadingExpVector();
            if (expVector == null || (nArray = expVector.dependencyOnVariables()) == null || nArray.length != 1 || (l = (Long)treeMap.get(nArray[0])) != null) continue;
            treeMap.put(nArray[0], expVector.getVal(nArray[0]));
        }
        for (int i = 0; i < genPolynomialRing.nvar; ++i) {
            Comparable<GenPolynomial<C>> comparable;
            comparable = (Long)treeMap.get(i);
            arrayList.add((Long)comparable);
        }
        return arrayList;
    }

    public GenPolynomial<C> constructUnivariate(int n, List<GenPolynomial<C>> list) {
        AbelianGroupElem abelianGroupElem;
        GenPolynomial<Object> genPolynomial;
        Iterable<Monomial<Object>> iterable;
        GenPolynomial genPolynomial2;
        Serializable serializable22;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        List<Long> list2 = this.univariateDegrees(list);
        if (list2.size() <= n) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional " + list2);
        }
        int n2 = 0;
        Long l = list2.get(n);
        if (l == null) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional");
        }
        n2 = (int)l.longValue();
        long l2 = 1L;
        for (Serializable serializable22 : list2) {
            if (serializable22 == null) continue;
            l2 *= serializable22.longValue();
        }
        logger.info("univariate construction, deg = " + n2 + ", vsdim = " + l2);
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        serializable22 = genPolynomialRing.coFac;
        String string = genPolynomialRing.getVars()[genPolynomialRing.nvar - 1 - n];
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(serializable22, 1, new TermOrder(2), new String[]{string});
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(serializable22, n2, new TermOrder(2));
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, genPolynomialRing);
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> genPolynomial3 = genPolynomialRing4.getZERO();
        for (int i = 0; i < n2; ++i) {
            genPolynomial2 = genPolynomialRing4.univariate(n, i);
            iterable = genPolynomialRing3.univariate(genPolynomialRing3.nvar - 1 - i);
            genPolynomial2 = genPolynomial2.multiply(iterable);
            genPolynomial3 = genPolynomial3.sum(genPolynomial2);
        }
        if (this.debug) {
            logger.info("univariate construction, P = " + genPolynomial3);
            logger.info("univariate construction, deg_*(G) = " + list2);
        }
        int n3 = -1;
        do {
            genPolynomial = genPolynomialRing4.univariate(n, n2);
            GenPolynomial genPolynomial4 = genPolynomialRing3.univariate(genPolynomialRing3.nvar - 1 - n2);
            genPolynomial = genPolynomial.multiply((Object)genPolynomial4);
            genPolynomial3 = genPolynomial3.sum((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)genPolynomial);
            GenPolynomial genPolynomial5 = genPolynomialRing.univariate(n, n2);
            genPolynomial2 = this.red.normalform(list, genPolynomial5);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>>> genPolynomial6 = PolyUtil.toRecursive(genPolynomialRing4, genPolynomial2);
            abelianGroupElem = genPolynomial6.sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>>)genPolynomial3);
            iterable = new ArrayList(((GenPolynomial)abelianGroupElem).getMap().values());
            n3 = this.commonZeroTest((List<GenPolynomial<C>>)(iterable = this.red.irreducibleSet((List<GenPolynomial<C>>)iterable)));
            if (n3 == 0) continue;
            if ((long)(++n2) > l2) {
                logger.info("univariate construction, P = " + genPolynomial3);
                logger.info("univariate construction, nf(P) = " + genPolynomial2);
                logger.info("G = " + list);
                throw new ArithmeticException("univariate polynomial degree greater than vector space dimansion");
            }
            genPolynomialRing3 = genPolynomialRing3.extend(1);
            genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, genPolynomialRing);
            genPolynomial3 = PolyUtil.extendCoefficients(genPolynomialRing4, genPolynomial3, 0, 0L);
            GenPolynomial genPolynomial7 = PolyUtil.extendCoefficients(genPolynomialRing4, genPolynomial6, 0, 1L);
            genPolynomial3 = genPolynomial3.sum(genPolynomial7);
        } while (n3 != 0);
        genPolynomial = genPolynomialRing2.univariate(0, n2);
        for (GenPolynomial genPolynomial8 : iterable) {
            int[] nArray;
            abelianGroupElem = genPolynomial8.leadingExpVector();
            if (abelianGroupElem == null || (nArray = ((ExpVector)abelianGroupElem).dependencyOnVariables()) == null || nArray.length == 0) continue;
            int n4 = nArray[0];
            Object c = genPolynomial8.leadingBaseCoefficient();
            Object object = genPolynomial8.trailingBaseCoefficient();
            object = (RingElem)object.negate();
            if (!c.isONE()) {
                object = (RingElem)object.divide(c);
            }
            GenPolynomial<Object> genPolynomial9 = genPolynomialRing2.univariate(0, n2 - 1 - n4);
            genPolynomial9 = genPolynomial9.multiply(object);
            genPolynomial = genPolynomial.sum((Object)genPolynomial9);
        }
        if (logger.isInfoEnabled()) {
            logger.info("univariate construction, pol = " + genPolynomial);
        }
        return genPolynomial;
    }

    public void terminate() {
        logger.info("terminate not implemented");
    }

    public int cancel() {
        logger.info("cancel not implemented");
        return 0;
    }
}

