/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.Product;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ProductRing<C extends RingElem<C>>
implements RingFactory<Product<C>> {
    private static final Logger logger = Logger.getLogger(ProductRing.class);
    protected int nCopies;
    protected final RingFactory<C> ring;
    protected final List<RingFactory<C>> ringList;
    protected static final Random random = new Random();

    public ProductRing(RingFactory<C> ringFactory, int n) {
        this.ring = ringFactory;
        this.nCopies = n;
        this.ringList = null;
    }

    public ProductRing(List<RingFactory<C>> list) {
        this.ringList = list;
        this.ring = null;
        this.nCopies = 0;
    }

    public RingFactory<C> getFactory(int n) {
        if (this.nCopies != 0) {
            if (0 <= n && n < this.nCopies) {
                return this.ring;
            }
            logger.info("index: " + n);
            throw new IllegalArgumentException("index out of bound " + this);
        }
        return this.ringList.get(n);
    }

    public synchronized void addFactory(RingFactory<C> ringFactory) {
        if (this.nCopies != 0) {
            if (this.ring.equals(ringFactory)) {
                ++this.nCopies;
            }
            throw new IllegalArgumentException("wrong RingFactory: " + ringFactory);
        }
        this.ringList.add(ringFactory);
    }

    public boolean containsFactory(RingFactory<C> ringFactory) {
        if (this.nCopies != 0) {
            return this.ring.equals(ringFactory);
        }
        return this.ringList.contains(ringFactory);
    }

    @Override
    public boolean isFinite() {
        if (this.nCopies != 0) {
            return this.ring.isFinite();
        }
        for (RingFactory<C> ringFactory : this.ringList) {
            boolean bl = ringFactory.isFinite();
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public Product<C> copy(Product<C> product) {
        return new Product(product.ring, product.val, product.isunit);
    }

    @Override
    public Product<C> getZERO() {
        return new Product(this);
    }

    @Override
    public Product<C> getONE() {
        TreeMap treeMap = new TreeMap();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                treeMap.put(i, this.ring.getONE());
            }
        } else {
            int n = 0;
            for (RingFactory<C> ringFactory : this.ringList) {
                treeMap.put(n, ringFactory.getONE());
                ++n;
            }
        }
        return new Product(this, treeMap, 1);
    }

    @Override
    public List<Product<C>> generators() {
        ArrayList<Product<C>> arrayList = new ArrayList<Product<C>>();
        int n = this.nCopies;
        if (n == 0) {
            n = this.ringList.size();
        }
        for (int i = 0; i < n; ++i) {
            RingFactory<C> ringFactory = this.getFactory(i);
            List list = ringFactory.generators();
            for (RingElem ringElem : list) {
                TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
                treeMap.put(i, ringElem);
                Product product = new Product(this, treeMap);
                arrayList.add(product);
            }
        }
        return arrayList;
    }

    public Product<C> getAtomic(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IllegalArgumentException("index out of bounds " + n);
        }
        TreeMap treeMap = new TreeMap();
        if (this.nCopies != 0) {
            treeMap.put(n, this.ring.getONE());
        } else {
            RingFactory<C> ringFactory = this.ringList.get(n);
            treeMap.put(n, ringFactory.getONE());
        }
        return new Product(this, treeMap, 1);
    }

    public int length() {
        if (this.nCopies != 0) {
            return this.nCopies;
        }
        return this.ringList.size();
    }

    @Override
    public boolean isCommutative() {
        if (this.nCopies != 0) {
            return this.ring.isCommutative();
        }
        for (RingFactory<C> ringFactory : this.ringList) {
            if (ringFactory.isCommutative()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAssociative() {
        if (this.nCopies != 0) {
            return this.ring.isAssociative();
        }
        for (RingFactory<C> ringFactory : this.ringList) {
            if (ringFactory.isAssociative()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.nCopies != 0) {
            if (this.nCopies == 1) {
                return this.ring.isField();
            }
        } else if (this.ringList.size() == 1) {
            return this.ringList.get(0).isField();
        }
        return false;
    }

    public boolean onlyFields() {
        if (this.nCopies != 0) {
            return this.ring.isField();
        }
        for (RingFactory<C> ringFactory : this.ringList) {
            if (ringFactory.isField()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BigInteger characteristic() {
        if (this.nCopies != 0) {
            return this.ring.characteristic();
        }
        BigInteger bigInteger = null;
        for (RingFactory<C> ringFactory : this.ringList) {
            if (bigInteger == null) {
                bigInteger = ringFactory.characteristic();
                continue;
            }
            BigInteger bigInteger2 = ringFactory.characteristic();
            if (bigInteger.compareTo(bigInteger2) <= 0) continue;
            bigInteger = bigInteger2;
        }
        return bigInteger;
    }

    @Override
    public Product<C> fromInteger(BigInteger bigInteger) {
        TreeMap treeMap = new TreeMap();
        if (this.nCopies != 0) {
            RingElem ringElem = (RingElem)this.ring.fromInteger(bigInteger);
            for (int i = 0; i < this.nCopies; ++i) {
                treeMap.put(i, ringElem);
            }
        } else {
            int n = 0;
            for (RingFactory<C> ringFactory : this.ringList) {
                treeMap.put(n, ringFactory.fromInteger(bigInteger));
                ++n;
            }
        }
        return new Product(this, treeMap);
    }

    @Override
    public Product<C> fromInteger(long l) {
        return this.fromInteger(new BigInteger("" + l));
    }

    public String toString() {
        if (this.nCopies != 0) {
            String string = this.ring.toString();
            if (string.matches("[0-9].*")) {
                string = this.ring.getClass().getSimpleName();
            }
            return "ProductRing[ " + string + "^" + this.nCopies + " ]";
        }
        StringBuffer stringBuffer = new StringBuffer("ProductRing[ ");
        int n = 0;
        for (RingFactory<C> ringFactory : this.ringList) {
            String string;
            if (n != 0) {
                stringBuffer.append(", ");
            }
            if ((string = ringFactory.toString()).matches("[0-9].*")) {
                string = ringFactory.getClass().getSimpleName();
            }
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("RR( [ ");
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            RingFactory<C> ringFactory = this.getFactory(i);
            String string = null;
            try {
                string = ((RingElem)((Object)ringFactory)).toScriptFactory();
            }
            catch (Exception exception) {
                string = ringFactory.toScript();
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(" ] )");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ProductRing)) {
            return false;
        }
        ProductRing productRing = (ProductRing)object;
        if (this.nCopies != 0) {
            if (this.nCopies != productRing.nCopies || !this.ring.equals(productRing.ring)) {
                return false;
            }
        } else {
            if (this.ringList.size() != productRing.ringList.size()) {
                return false;
            }
            int n = 0;
            for (RingFactory<C> ringFactory : this.ringList) {
                if (!ringFactory.equals(productRing.ringList.get(n))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.nCopies != 0) {
            n = this.ring.hashCode();
            n = 37 * n + this.nCopies;
        } else {
            for (RingFactory<C> ringFactory : this.ringList) {
                n = 37 * n + ringFactory.hashCode();
            }
        }
        return n;
    }

    @Override
    public Product<C> random(int n) {
        return this.random(n, 0.5f);
    }

    public Product<C> random(int n, float f) {
        return this.random(n, f, random);
    }

    @Override
    public Product<C> random(int n, Random random) {
        return this.random(n, 0.5f, ProductRing.random);
    }

    public Product<C> random(int n, float f, Random random) {
        TreeMap<Integer, RingElem> treeMap = new TreeMap<Integer, RingElem>();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                RingElem ringElem;
                float f2 = random.nextFloat();
                if (!(f2 < f) || (ringElem = (RingElem)this.ring.random(n, random)).isZERO()) continue;
                treeMap.put(i, ringElem);
            }
        } else {
            int n2 = 0;
            for (RingFactory<C> ringFactory : this.ringList) {
                RingElem ringElem;
                float f3 = random.nextFloat();
                if (f3 < f && !(ringElem = (RingElem)ringFactory.random(n, random)).isZERO()) {
                    treeMap.put(n2, ringElem);
                }
                ++n2;
            }
        }
        return new Product(this, treeMap);
    }

    @Override
    public Product<C> parse(String string) {
        StringReader stringReader = new StringReader(string);
        return this.parse(stringReader);
    }

    @Override
    public Product<C> parse(Reader reader) {
        TreeMap treeMap = new TreeMap();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                treeMap.put(i, this.ring.parse(reader));
            }
        } else {
            int n = 0;
            for (RingFactory<C> ringFactory : this.ringList) {
                treeMap.put(n, ringFactory.parse(reader));
                ++n;
            }
        }
        return new Product(this, treeMap);
    }
}

