/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableLocalResidueRing;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SolvableLocalResidue<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableLocalResidue<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocalResidue.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableLocalResidueRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;

    public SolvableLocalResidue(SolvableLocalResidueRing<C> solvableLocalResidueRing) {
        this(solvableLocalResidueRing, (GenSolvablePolynomial<C>)solvableLocalResidueRing.ring.getZERO());
    }

    public SolvableLocalResidue(SolvableLocalResidueRing<C> solvableLocalResidueRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        this(solvableLocalResidueRing, genSolvablePolynomial, (GenSolvablePolynomial<C>)solvableLocalResidueRing.ring.getONE(), false);
    }

    public SolvableLocalResidue(SolvableLocalResidueRing<C> solvableLocalResidueRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        this(solvableLocalResidueRing, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    protected SolvableLocalResidue(SolvableLocalResidueRing<C> solvableLocalResidueRing, GenSolvablePolynomial<C> object, GenSolvablePolynomial<C> object2, boolean bl) {
        if (object2 == null || ((GenPolynomial)object2).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = solvableLocalResidueRing;
        if (((GenPolynomial)object2).signum() < 0) {
            object = (GenSolvablePolynomial)((GenPolynomial)object).negate();
            object2 = (GenSolvablePolynomial)((GenPolynomial)object2).negate();
        }
        if (bl) {
            this.num = object;
            this.den = object2;
            return;
        }
        GenSolvablePolynomial genSolvablePolynomial = this.ring.ideal.normalform(object2);
        if (genSolvablePolynomial.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal, d = " + object2);
        }
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.ideal.normalform(object);
        if (genSolvablePolynomial2.isZERO()) {
            this.num = genSolvablePolynomial2;
            this.den = this.ring.ring.getONE();
            return;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)((GenPolynomial)object2).leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            object = ((GenSolvablePolynomial)object).multiply(gcdRingElem);
            object2 = ((GenSolvablePolynomial)object2).multiply(gcdRingElem);
        }
        if (((GenPolynomial)object).compareTo(object2) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)object).negate()).compareTo(object2) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isZERO()) {
            this.num = object;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isONE()) {
            this.num = object;
            this.den = object2;
            return;
        }
        Object[] objectArray = PolyGBUtil.syzGcdCofactors(solvableLocalResidueRing.ring, object, object2);
        if (!objectArray[0].isONE()) {
            logger.info("constructor: gcd = " + Arrays.toString(objectArray));
            object = objectArray[1];
            object2 = objectArray[2];
        }
        Object[] objectArray2 = this.ring.engine.leftSimplifier(object, object2);
        logger.info("simp: " + Arrays.toString(objectArray2) + ", " + object + ", " + object2);
        this.num = objectArray2[0];
        this.den = objectArray2[1];
    }

    @Override
    public SolvableLocalResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableLocalResidue<C> copy() {
        return new SolvableLocalResidue<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String string = "{ " + this.num.toString(this.ring.ring.getVars());
            if (!this.den.isONE()) {
                string = string + " | " + this.den.toString(this.ring.ring.getVars());
            }
            return string + " }";
        }
        return "SolvableLocalResidue[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableLocalResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableLocalResidue<C> solvableLocalResidue) {
        if (solvableLocalResidue == null || solvableLocalResidue.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -solvableLocalResidue.signum();
        }
        return this.subtract(solvableLocalResidue).signum();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SolvableLocalResidue)) {
            return false;
        }
        SolvableLocalResidue solvableLocalResidue = null;
        try {
            solvableLocalResidue = (SolvableLocalResidue)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableLocalResidue == null) {
            return false;
        }
        if (this.num.equals(solvableLocalResidue.num) && this.den.equals(solvableLocalResidue.den)) {
            return true;
        }
        return this.compareTo(solvableLocalResidue) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public SolvableLocalResidue<C> abs() {
        return new SolvableLocalResidue<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableLocalResidue<C> sum(SolvableLocalResidue<C> solvableLocalResidue) {
        if (solvableLocalResidue == null || solvableLocalResidue.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableLocalResidue;
        }
        if (this.den.isONE() && solvableLocalResidue.den.isONE()) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableLocalResidue.num);
            return new SolvableLocalResidue<C>(this.ring, genSolvablePolynomial, this.den, false);
        }
        if (this.den.compareTo(solvableLocalResidue.den) == 0) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableLocalResidue.num);
            return new SolvableLocalResidue<C>(this.ring, genSolvablePolynomial, this.den, false);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.den, solvableLocalResidue.den);
        if (this.debug) {
            logger.info("oc[0] den =sum= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.den + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableLocalResidue.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomialArray[1].multiply(solvableLocalResidue.num);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial2.sum(genSolvablePolynomial3);
        return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial4, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocalResidue<C> negate() {
        return new SolvableLocalResidue<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableLocalResidue<C> subtract(SolvableLocalResidue<C> solvableLocalResidue) {
        return this.sum((SolvableLocalResidue<C>)solvableLocalResidue.negate());
    }

    @Override
    public SolvableLocalResidue<C> divide(SolvableLocalResidue<C> solvableLocalResidue) {
        return this.multiply((C)solvableLocalResidue.inverse());
    }

    @Override
    public SolvableLocalResidue<C> inverse() {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return new SolvableLocalResidue<C>(this.ring, this.den, this.num, false);
    }

    @Override
    public SolvableLocalResidue<C> remainder(SolvableLocalResidue<C> solvableLocalResidue) {
        if (solvableLocalResidue.isZERO()) {
            throw new ArithmeticException("element not invertible " + solvableLocalResidue);
        }
        return this.ring.getZERO();
    }

    @Override
    public SolvableLocalResidue<C> multiply(SolvableLocalResidue<C> solvableLocalResidue) {
        if (solvableLocalResidue == null || solvableLocalResidue.isZERO()) {
            return solvableLocalResidue;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (solvableLocalResidue.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return solvableLocalResidue;
        }
        if (this.den.isONE() && solvableLocalResidue.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = this.num.multiply(solvableLocalResidue.num);
            return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, this.den, false);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.num, solvableLocalResidue.den);
        if (this.debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.num + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableLocalResidue.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[1].multiply(solvableLocalResidue.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.den);
        return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    @Override
    public SolvableLocalResidue<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (genSolvablePolynomial.isONE()) {
            return this;
        }
        SolvableLocalResidue<C> solvableLocalResidue = new SolvableLocalResidue<C>(this.ring, genSolvablePolynomial);
        return this.multiply((C)solvableLocalResidue);
    }

    @Override
    public SolvableLocalResidue<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (c.isONE()) {
            return this;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply((RingElem)c);
        return this.multiply((C)genPolynomial);
    }

    @Override
    public SolvableLocalResidue<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply(expVector);
        return this.multiply((C)genPolynomial);
    }

    public SolvableLocalResidue<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public SolvableLocalResidue<C> gcd(SolvableLocalResidue<C> solvableLocalResidue) {
        if (solvableLocalResidue == null || solvableLocalResidue.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableLocalResidue;
        }
        return this.ring.getONE();
    }

    public SolvableLocalResidue<C>[] egcd(SolvableLocalResidue<C> solvableLocalResidue) {
        SolvableLocalResidue[] solvableLocalResidueArray = new SolvableLocalResidue[]{null, null, null};
        if (solvableLocalResidue == null || solvableLocalResidue.isZERO()) {
            solvableLocalResidueArray[0] = this;
            return solvableLocalResidueArray;
        }
        if (this.isZERO()) {
            solvableLocalResidueArray[0] = solvableLocalResidue;
            return solvableLocalResidueArray;
        }
        GenPolynomial genPolynomial = this.ring.ring.fromInteger(2L);
        solvableLocalResidueArray[0] = this.ring.getONE();
        solvableLocalResidueArray[1] = this.multiply((C)genPolynomial).inverse();
        solvableLocalResidueArray[2] = solvableLocalResidue.multiply(genPolynomial).inverse();
        return solvableLocalResidueArray;
    }
}

