/*
 * Decompiled with CFR 0.152.
 */
package common;

import prism.PrismException;

public class SafeCast {
    public static int toInt(double d) throws PrismException {
        try {
            return SafeCast.toIntExact(d);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismException(arithmeticException.getMessage());
        }
    }

    public static int toIntExact(double d) {
        if (!Double.isFinite(d)) {
            throw new ArithmeticException(d + " is non-finite, cannot be represented by int");
        }
        if ((double)((int)d) != d) {
            throw new ArithmeticException(d + " cannot be losslessly converted to int");
        }
        return (int)d;
    }

    public static long toLongExact(double d) {
        if (!Double.isFinite(d)) {
            throw new ArithmeticException(d + " is non-finite, cannot be represented by long");
        }
        if ((double)((long)d) != d) {
            throw new ArithmeticException(d + " cannot be losslessly converted to long");
        }
        return (long)d;
    }
}

