/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.IterableBitSet;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface IntSet
extends Iterable<Integer> {
    public PrimitiveIterator.OfInt iterator();

    public PrimitiveIterator.OfInt reversedIterator();

    public int cardinality();

    public boolean contains(int var1);

    default public boolean get(int n) {
        return this.contains(n);
    }

    default public boolean contains(IntSet intSet) {
        return intSet.stream().allMatch(this::contains);
    }

    default public boolean contains(BitSet bitSet) {
        return this.contains(IntSet.asIntSet(bitSet));
    }

    default public IntStream stream() {
        return StreamSupport.intStream(() -> Spliterators.spliterator(this.iterator(), (long)this.cardinality(), 1), 65, false);
    }

    default public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        PrimitiveIterator.OfInt ofInt = this.iterator();
        while (ofInt.hasNext()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            bl = false;
            stringBuffer.append(ofInt.nextInt());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static IntSet asIntSet(BitSet bitSet) {
        return new IntSetFromBitSet(bitSet);
    }

    public static IntSet asIntSet(int n) {
        return new SingletonIntSet(n);
    }

    public static class SingletonIntSet
    implements IntSet {
        private int singleMember;

        public SingletonIntSet(int n) {
            this.singleMember = n;
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public int nextInt() {
                    this.done = true;
                    return singleMember;
                }
            };
        }

        @Override
        public PrimitiveIterator.OfInt reversedIterator() {
            return this.iterator();
        }

        @Override
        public int cardinality() {
            return 1;
        }

        @Override
        public boolean contains(int n) {
            return n == this.singleMember;
        }

        public String toString() {
            return "{" + this.singleMember + "}";
        }
    }

    public static class IntSetFromBitSet
    implements IntSet {
        private BitSet bs;
        int cardinality = -1;

        public IntSetFromBitSet(BitSet bitSet) {
            this.bs = bitSet;
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return IterableBitSet.getSetBits(this.bs).iterator();
        }

        @Override
        public PrimitiveIterator.OfInt reversedIterator() {
            return IterableBitSet.getSetBitsReversed(this.bs).iterator();
        }

        @Override
        public IntStream stream() {
            return this.bs.stream();
        }

        @Override
        public int cardinality() {
            if (this.cardinality == -1) {
                this.cardinality = this.bs.cardinality();
            }
            return this.cardinality;
        }

        @Override
        public boolean contains(int n) {
            return this.bs.get(n);
        }

        public String toString() {
            return this.asString();
        }
    }
}

