/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceType;
import automata.DA;
import automata.DASimplifyAcceptance;
import automata.HOAF2DA;
import automata.LTL2RabinLibrary;
import automata.LTL2WDBA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.transformations.ToStateAcceptance;
import jltl2ba.APSet;
import jltl2ba.LTLFragments;
import jltl2ba.SimpleLTL;
import jltl2dstar.LTL2Rabin;
import parser.Values;
import parser.ast.Expression;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNG;
import prism.PrismNotSupportedException;

public class LTL2DA
extends PrismComponent {
    public LTL2DA(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public DA<BitSet, AcceptanceRabin> convertLTLFormulaToDRA(Expression expression, Values values) throws PrismException {
        return this.convertLTLFormulaToDA(expression, values, AcceptanceType.RABIN);
    }

    public DA<BitSet, ? extends AcceptanceOmega> convertLTLFormulaToDA(Expression expression, Values values, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        DA<BitSet, ? extends AcceptanceOmega> dA = null;
        boolean bl = this.useExternal();
        boolean bl2 = Expression.containsTemporalTimeBounds(expression);
        if (bl2) {
            bl = false;
        }
        if (!bl) {
            try {
                dA = LTL2RabinLibrary.getDAforLTL(expression, values, acceptanceTypeArray);
                if (dA != null) {
                    this.getLog().println("Taking " + dA.getAutomataType() + " from library...");
                }
            }
            catch (Exception exception) {
                if (bl2) {
                    throw exception;
                }
                this.getLog().println("Warning: Exception during attempt to construct DRA using the LTL2RabinLibrary:");
                this.getLog().println(" " + exception.getMessage());
            }
        }
        if (dA == null) {
            if (!bl2) {
                if (bl) {
                    dA = this.convertLTLFormulaToDAWithExternalTool(expression, values, acceptanceTypeArray);
                } else {
                    SimpleLTL simpleLTL = expression.convertForJltl2ba();
                    boolean bl3 = false;
                    if (bl3) {
                        LTLFragments lTLFragments = LTLFragments.analyse(simpleLTL);
                        this.mainLog.println(lTLFragments);
                        if (lTLFragments.isSyntacticGuarantee() && AcceptanceType.contains((AcceptanceType[])acceptanceTypeArray, (AcceptanceType)AcceptanceType.REACH)) {
                            this.mainLog.println("Generating DFA for co-safety property...");
                            LTL2WDBA lTL2WDBA = new LTL2WDBA(this);
                            dA = lTL2WDBA.cosafeltl2dfa(simpleLTL);
                        } else if (bl3 && lTLFragments.isSyntacticObligation() && AcceptanceType.contains((AcceptanceType[])acceptanceTypeArray, (AcceptanceType)AcceptanceType.BUCHI)) {
                            this.mainLog.println("Generating DBA for obligation property...");
                            LTL2WDBA lTL2WDBA = new LTL2WDBA(this);
                            dA = lTL2WDBA.obligation2wdba(simpleLTL);
                        }
                    }
                    if (dA == null) {
                        dA = LTL2Rabin.ltl2da(simpleLTL, acceptanceTypeArray);
                    }
                }
            } else {
                throw new PrismNotSupportedException("Could not convert LTL formula to deterministic automaton, formula had time-bounds");
            }
        }
        if (dA == null) {
            throw new PrismNotSupportedException("Could not convert LTL formula to deterministic automaton");
        }
        if (!this.getSettings().getBoolean("prism.noDaSimplify")) {
            dA = DASimplifyAcceptance.simplifyAcceptance(this, dA, acceptanceTypeArray);
        }
        return dA;
    }

    public DA<BitSet, ? extends AcceptanceOmega> convertLTLFormulaToDAWithExternalTool(Expression expression, Values values, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        String string;
        String string2 = this.getSettings().getString("prism.ltl2daTool");
        SimpleLTL simpleLTL = expression.convertForJltl2ba();
        SimpleLTL simpleLTL2 = simpleLTL.clone();
        simpleLTL2.renameAP("L", "p");
        DA<BitSet, ? extends AcceptanceOmega> dA = null;
        try {
            int n;
            String string3;
            string = this.getSettings().getString("prism.ltl2daSyntax");
            if (string == null || string.isEmpty()) {
                throw new PrismException("No LTL syntax option provided");
            }
            switch (string) {
                case "LBT": {
                    string3 = simpleLTL2.toStringLBT();
                    break;
                }
                case "Spin": {
                    string3 = simpleLTL2.toStringSpin();
                    break;
                }
                case "Spot": {
                    string3 = simpleLTL2.toStringSpot();
                    break;
                }
                case "Rabinizer": {
                    simpleLTL2 = simpleLTL2.toBasicOperators();
                    string3 = simpleLTL2.toStringSpot();
                    break;
                }
                default: {
                    throw new PrismException("Unknown LTL syntax option \"" + string + "\"");
                }
            }
            Object object2 = File.createTempFile("prism-ltl-external-", ".ltl", null);
            File file = File.createTempFile("prism-ltl-external-", ".hoa", null);
            File file2 = File.createTempFile("prism-ltl-external-", ".output", null);
            FileWriter fileWriter = new FileWriter((File)object2);
            fileWriter.write(string3);
            fileWriter.close();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.getLog().print("Calling external LTL->DA tool: ");
            for (String object3 : arrayList) {
                this.getLog().print(" " + object3);
            }
            this.getLog().println();
            this.getLog().print("LTL formula (in " + string + " syntax):  ");
            this.getLog().println(string3);
            this.getLog().println();
            arrayList.add(((File)object2).getAbsolutePath());
            arrayList.add(file.getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectOutput(file2);
            processBuilder.redirectErrorStream(true);
            PrismNG.setupChildProcessEnvironment(processBuilder);
            Process process = processBuilder.start();
            process.getInputStream().close();
            while (true) {
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException object6) {
                    continue;
                }
                break;
            }
            if (n != 0) {
                throw new PrismException("Call to external LTL->DA tool failed, return value = " + n + ".\nTo investigate, please consult the following files:\n LTL formula:                     " + ((File)object2).getAbsolutePath() + "\n Automaton output:                " + file.getAbsolutePath() + "\n Tool output (stdout and stderr): " + file2.getAbsolutePath() + "\n");
            }
            file2.delete();
            try {
                Object object;
                Object i;
                Object transitionBasedAcceptanceException;
                try {
                    transitionBasedAcceptanceException = new HOAF2DA();
                    i = new FileInputStream(file);
                    HOAFParser.parseHOA((InputStream)i, (HOAConsumer)transitionBasedAcceptanceException);
                    dA = ((HOAF2DA)transitionBasedAcceptanceException).getDA();
                }
                catch (HOAF2DA.TransitionBasedAcceptanceException parseException) {
                    this.getLog().println("Automaton with transition-based acceptance, automatically converting to state-based acceptance...");
                    i = new HOAF2DA();
                    object = new HOAIntermediateStoreAndManipulate((HOAConsumer)i, new StoredAutomatonManipulator[]{new ToStateAcceptance()});
                    FileInputStream fileInputStream = new FileInputStream(file);
                    HOAFParser.parseHOA((InputStream)fileInputStream, (HOAConsumer)object);
                    dA = ((HOAF2DA)i).getDA();
                }
                if (dA == null) {
                    throw new PrismException("Could not construct DA");
                }
                this.checkAPs(simpleLTL2, dA.getAPList());
                transitionBasedAcceptanceException = dA.getAPList();
                for (int j = 0; j < transitionBasedAcceptanceException.size(); ++j) {
                    if (!((String)transitionBasedAcceptanceException.get(j)).startsWith("p")) continue;
                    object = "L" + ((String)transitionBasedAcceptanceException.get(j)).substring("p".length());
                    transitionBasedAcceptanceException.set(j, object);
                }
            }
            catch (ParseException prismException) {
                throw new PrismException("Parse error: " + prismException.getMessage() + ".\nTo investigate, please consult the following files:\n LTL formula:        " + ((File)object2).getAbsolutePath() + "\n Automaton output: " + file.getAbsolutePath() + "\n");
            }
            catch (PrismException prismException) {
                throw new PrismException(prismException.getMessage() + ".\nTo investigate, please consult the following files:\n LTL formula: " + ((File)object2).getAbsolutePath() + "\n Automaton output: " + file.getAbsolutePath() + "\n");
            }
            file.delete();
            ((File)object2).delete();
        }
        catch (IOException iOException) {
            throw new PrismException(iOException.getMessage());
        }
        if (!this.getSettings().getBoolean("prism.noDaSimplify")) {
            dA = DASimplifyAcceptance.simplifyAcceptance(this, dA, acceptanceTypeArray);
        }
        if (AcceptanceType.contains((AcceptanceType[])acceptanceTypeArray, (AcceptanceType)(string = dA.getAcceptance()).getType())) {
            return dA;
        }
        if (AcceptanceType.contains((AcceptanceType[])acceptanceTypeArray, (AcceptanceType)AcceptanceType.GENERIC)) {
            DA.switchAcceptance(dA, (AcceptanceOmega)string.toAcceptanceGeneric());
            return dA;
        }
        throw new PrismException("The external LTL->DA tool returned an automaton with " + string.getType() + " acceptance, which is not yet supported for model checking this model / property");
    }

    private boolean useExternal() {
        String string = this.getSettings().getString("prism.ltl2daTool");
        return string != null && !string.isEmpty();
    }

    private void checkAPs(SimpleLTL simpleLTL, List<String> list) throws PrismException {
        APSet aPSet = simpleLTL.getAPs();
        for (String string : list) {
            if (aPSet.hasAP(string)) continue;
            throw new PrismException("Generated automaton has extra atomic proposition \"" + string + "\"");
        }
    }

    public static void main(String[] stringArray) {
        try {
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(stringArray[0]);
            Expression expression = Expression.createFromJltl2ba(simpleLTL);
            LTL2DA lTL2DA = new LTL2DA(new PrismComponent());
            DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression, null, AcceptanceType.RABIN, AcceptanceType.REACH);
            PrintStream printStream = stringArray.length < 2 || "-".equals(stringArray[1]) ? System.out : new PrintStream(stringArray[1]);
            String string = stringArray.length < 3 ? "hoa" : stringArray[2];
            dA.print(printStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.print("Error: " + exception);
        }
    }
}

