/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import userinterface.util.MultipleProperty;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class PropertyTableModel
extends AbstractTableModel
implements Observer {
    private ArrayList<PropertyOwner> owners;
    private ArrayList<String> groupNames = new ArrayList();
    private ArrayList<Integer> groupStarts = new ArrayList();
    private ArrayList<Integer> groupSizes = new ArrayList();
    private int currentGroup;
    private DefaultComboBoxModel comboModel;
    private JTable theTable = null;

    public PropertyTableModel() {
        this.owners = new ArrayList();
        this.comboModel = new DefaultComboBoxModel();
    }

    public void setJTable(JTable jTable) {
        this.theTable = jTable;
    }

    public void setOwners(ArrayList<PropertyOwner> arrayList) {
        this.owners = arrayList;
        Collections.sort(arrayList);
        Iterator<PropertyOwner> iterator = arrayList.iterator();
        PropertyOwner propertyOwner = null;
        int n = 0;
        Object object = "";
        this.groupNames = new ArrayList();
        this.groupStarts = new ArrayList();
        this.groupSizes = new ArrayList();
        int n2 = 0;
        Object object2 = "";
        while (iterator.hasNext()) {
            PropertyOwner propertyOwner2 = iterator.next();
            for (int i = 0; i < propertyOwner2.getNumProperties(); ++i) {
                propertyOwner2.getProperty(i).addObserver(this);
                propertyOwner2.getProperty(i).setOwningModel(this);
            }
            if (propertyOwner == null) {
                ++n;
                if (!propertyOwner2.getDescriptor().equals("")) {
                    object2 = (String)object2 + "'" + propertyOwner2.getDescriptor() + "'";
                }
                object = propertyOwner2.getClassDescriptor();
                this.groupStarts.add(new Integer(0));
            } else if (propertyOwner2.getUniquePropertyID() == propertyOwner.getUniquePropertyID()) {
                ++n;
                if (!propertyOwner2.getClassDescriptor().endsWith("s")) {
                    object = propertyOwner2.getClassDescriptor() + "s";
                }
                if (!propertyOwner2.getDescriptor().equals("")) {
                    object2 = (String)object2 + ", '" + propertyOwner2.getDescriptor() + "'";
                }
            } else {
                object = (String)object + " " + (String)object2;
                object2 = "";
                this.groupNames.add((String)object);
                this.groupSizes.add(new Integer(n));
                n = 0;
                ++n;
                object2 = (String)object2 + propertyOwner2.getDescriptor();
                if (!propertyOwner2.getDescriptor().equals("")) {
                    object = propertyOwner2.getClassDescriptor() + " '" + propertyOwner2.getDescriptor() + "'";
                }
                this.groupStarts.add(new Integer(n2));
            }
            propertyOwner = propertyOwner2;
            ++n2;
        }
        if (arrayList.size() != 0) {
            object = (String)object + " " + (String)object2;
            this.groupNames.add((String)object);
            this.groupSizes.add(new Integer(n));
        }
        if (this.currentGroup > arrayList.size() - 1) {
            this.currentGroup = 0;
        }
        this.comboModel = new DefaultComboBoxModel<Object>(this.groupNames.toArray());
        this.fireTableDataChanged();
    }

    public String getGroupName(int n) {
        return this.groupNames.get(n);
    }

    public int getNumGroupNames() {
        return this.groupNames.size();
    }

    @Override
    public int getRowCount() {
        if (this.groupNames.size() == 0) {
            return 0;
        }
        PropertyOwner propertyOwner = this.owners.get(this.groupStarts.get(this.currentGroup));
        return propertyOwner.getNumProperties();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Property";
        }
        return "Value";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            PropertyOwner propertyOwner = this.owners.get(this.groupStarts.get(this.currentGroup));
            return propertyOwner.getProperty(n).getName();
        }
        if (this.getCurrentGroupSize() == 1) {
            PropertyOwner propertyOwner = this.getOwner(this.getCurrentGroupStart());
            return propertyOwner.getProperty(n);
        }
        ArrayList<SingleProperty> arrayList = new ArrayList<SingleProperty>();
        for (int i = this.getCurrentGroupStart(); i < this.getCurrentGroupStart() + this.getCurrentGroupSize(); ++i) {
            PropertyOwner propertyOwner = this.getOwner(i);
            arrayList.add(propertyOwner.getProperty(n));
        }
        MultipleProperty multipleProperty = new MultipleProperty(arrayList);
        return multipleProperty;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        return this.getSelectedProperty(n2).isEnabled();
    }

    public SingleProperty getSelectedProperty(int n) {
        if (n < 0) {
            return null;
        }
        PropertyOwner propertyOwner = this.getOwner(this.getCurrentGroupStart());
        return propertyOwner.getProperty(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            if (n2 == 1) {
                if (this.getCurrentGroupSize() == 1) {
                    PropertyOwner propertyOwner = this.getOwner(this.getCurrentGroupStart());
                    propertyOwner.getProperty(n).setProperty(object);
                } else {
                    for (int i = this.getCurrentGroupStart(); i < this.getCurrentGroupStart() + this.getCurrentGroupSize(); ++i) {
                        PropertyOwner propertyOwner = this.getOwner(i);
                        propertyOwner.getProperty(n).setProperty(object);
                    }
                }
            }
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public int getCurrentGroup() {
        return this.currentGroup;
    }

    protected int getCurrentGroupSize() {
        return this.groupSizes.get(this.currentGroup);
    }

    protected int getCurrentGroupStart() {
        return this.groupStarts.get(this.currentGroup);
    }

    protected String getCurrentGroupName() {
        return this.groupNames.get(this.currentGroup);
    }

    protected PropertyOwner getOwner(int n) {
        return this.owners.get(n);
    }

    public int getNumGroups() {
        return this.groupNames.size();
    }

    public void setCurrentGroup(int n) {
        this.currentGroup = n;
        this.fireTableDataChanged();
    }

    public static void printArray(ArrayList<?> arrayList) {
        System.out.print("(");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print(arrayList.get(i) + " ");
        }
    }

    public DefaultComboBoxModel getComboModel() {
        return this.comboModel;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.fireTableDataChanged();
        this.repaintTable();
    }

    public void repaintTable() {
        if (this.theTable != null) {
            this.theTable.repaint();
        }
    }
}

