/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;
import parser.ast.Module;
import parser.ast.ModulesFile;
import prism.ModelInfo;
import simulator.PathFullInfo;
import userinterface.simulator.GUISimLabelList;
import userinterface.simulator.GUISimulator;
import userinterface.simulator.SimulationView;
import userinterface.util.GUIGroupedTableModel;

public class GUISimulatorPathTableModel
extends AbstractTableModel
implements GUIGroupedTableModel,
Observer {
    private static final long serialVersionUID = 1L;
    private GUISimulator simulator;
    private SimulationView view;
    private boolean pathActive;
    private ModulesFile parsedModel;
    private ModelInfo modelInfo;
    private PathFullInfo path;
    private SimulationView.RewardStructureValue rewardStructureValue;
    private SimulationView.VariableValue variableValue;
    private SimulationView.TimeValue timeValue;
    private SimulationView.ActionValue actionValue;

    public GUISimulatorPathTableModel(GUISimulator gUISimulator, SimulationView simulationView) {
        this.simulator = gUISimulator;
        this.view = simulationView;
        this.view.addObserver(this);
        SimulationView simulationView2 = simulationView;
        Objects.requireNonNull(simulationView2);
        this.rewardStructureValue = new SimulationView.RewardStructureValue(simulationView2, null, null);
        SimulationView simulationView3 = simulationView;
        Objects.requireNonNull(simulationView3);
        this.variableValue = new SimulationView.VariableValue(simulationView3, null, null);
    }

    public void setPathActive(boolean bl) {
        this.pathActive = bl;
    }

    public void setPath(PathFullInfo pathFullInfo) {
        this.path = pathFullInfo;
    }

    public void setParsedModel(ModulesFile modulesFile) {
        this.parsedModel = modulesFile;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    public boolean canShowTime() {
        return this.parsedModel.getModelType().continuousTime();
    }

    @Override
    public int getGroupCount() {
        int n;
        if (!this.pathActive) {
            return 0;
        }
        int n2 = 0;
        if (this.view.showActions() || this.view.showSteps()) {
            ++n2;
        }
        if (this.canShowTime() && (this.view.showTime() || this.view.showCumulativeTime())) {
            ++n2;
        }
        ArrayList<SimulationView.Variable> arrayList = this.view.getVisibleVariables();
        HashSet<String> hashSet = new HashSet<String>();
        for (SimulationView.Variable object : arrayList) {
            hashSet.add(object.getName());
        }
        for (n = 0; n < this.parsedModel.getNumGlobals(); ++n) {
            if (!hashSet.contains(this.parsedModel.getGlobal(n).getName())) continue;
            ++n2;
            break;
        }
        block2: for (n = 0; n < this.parsedModel.getNumModules(); ++n) {
            Module module = this.parsedModel.getModule(n);
            for (int i = 0; i < module.getNumDeclarations(); ++i) {
                if (!hashSet.contains(module.getDeclaration(i).getName())) continue;
                ++n2;
                continue block2;
            }
        }
        if (this.view.getVisibleRewardColumns().size() > 0) {
            ++n2;
        }
        return n2;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.view) {
            this.fireTableStructureChanged();
            this.simulator.sortOutColumnSizes();
        }
    }

    @Override
    public String getGroupName(int n) {
        if (!this.pathActive) {
            return "";
        }
        int n2 = 0;
        if (this.view.showActions() || this.view.showSteps()) {
            if (n2 == n) {
                return "Step";
            }
            ++n2;
        }
        if (this.canShowTime() && (this.view.showTime() || this.view.showCumulativeTime())) {
            if (n2 == n) {
                return "Time";
            }
            ++n2;
        }
        if (this.view.getVisibleVariables().size() > 0) {
            int n3;
            ArrayList<SimulationView.Variable> arrayList = this.view.getVisibleVariables();
            HashSet<String> hashSet = new HashSet<String>();
            for (SimulationView.Variable object : arrayList) {
                hashSet.add(object.getName());
            }
            for (n3 = 0; n3 < this.parsedModel.getNumGlobals(); ++n3) {
                if (!hashSet.contains(this.parsedModel.getGlobal(n3).getName())) continue;
                if (n2 == n) {
                    return "Globals";
                }
                ++n2;
                break;
            }
            block2: for (n3 = 0; n3 < this.parsedModel.getNumModules(); ++n3) {
                Module module = this.parsedModel.getModule(n3);
                for (int i = 0; i < module.getNumDeclarations(); ++i) {
                    if (!hashSet.contains(module.getDeclaration(i).getName())) continue;
                    if (n2 == n) {
                        return this.parsedModel.getModuleName(n3);
                    }
                    ++n2;
                    continue block2;
                }
            }
        }
        if (this.view.getVisibleRewardColumns().size() > 0) {
            if (n2 == n) {
                return "Rewards";
            }
            ++n2;
        }
        return "Undefined Group";
    }

    @Override
    public String getGroupToolTip(int n) {
        int n2;
        ArrayList<SimulationView.Variable> arrayList = this.view.getVisibleVariables();
        HashSet<String> hashSet = new HashSet<String>();
        for (SimulationView.Variable variable : arrayList) {
            hashSet.add(variable.getName());
        }
        int n3 = 0;
        if (this.view.showActions() || this.view.showSteps()) {
            if (n3 == n) {
                return null;
            }
            ++n3;
        }
        if (this.canShowTime() && (this.view.showTime() || this.view.showCumulativeTime())) {
            if (n3 == n) {
                return null;
            }
            ++n3;
        }
        for (n2 = 0; n2 < this.parsedModel.getNumGlobals(); ++n2) {
            if (!hashSet.contains(this.parsedModel.getGlobal(n2).getName())) continue;
            if (n3 == n) {
                return "Global variables";
            }
            ++n3;
            break;
        }
        block2: for (n2 = 0; n2 < this.parsedModel.getNumModules(); ++n2) {
            Module module = this.parsedModel.getModule(n2);
            for (int i = 0; i < module.getNumDeclarations(); ++i) {
                if (!hashSet.contains(module.getDeclaration(i).getName())) continue;
                if (n3 == n) {
                    return "Variables of module \"" + this.parsedModel.getModuleName(n2) + "\"";
                }
                ++n3;
                continue block2;
            }
        }
        if (this.view.getVisibleRewardColumns().size() > 0) {
            if (n3 == n) {
                return "State, transition and cumulative rewards";
            }
            ++n3;
        }
        return null;
    }

    @Override
    public int getLastColumnOfGroup(int n) {
        int n2 = 0;
        int n3 = n2 + (this.view.showActions() ? 1 : 0) + (this.view.showSteps() ? 1 : 0);
        int n4 = n3 + (this.canShowTime() && this.view.showCumulativeTime() ? 1 : 0) + (this.canShowTime() && this.view.showTime() ? 1 : 0);
        int n5 = n4 + this.view.getVisibleVariables().size();
        int n6 = 0;
        if (this.view.showActions() || this.view.showSteps()) {
            if (n6 == n) {
                if (this.view.showActions() && this.view.showSteps()) {
                    return n2 + 1;
                }
                return n2;
            }
            ++n6;
        }
        if (this.canShowTime() && (this.view.showCumulativeTime() || this.view.showTime())) {
            if (n6 == n) {
                if (this.view.showCumulativeTime() && this.view.showTime()) {
                    return n3 + 1;
                }
                return n3;
            }
            ++n6;
        }
        if (this.view.getVisibleVariables().size() > 0) {
            int n7;
            int n8 = 0;
            ArrayList<SimulationView.Variable> arrayList = this.view.getVisibleVariables();
            HashSet<String> hashSet = new HashSet<String>();
            for (SimulationView.Variable variable : arrayList) {
                hashSet.add(variable.getName());
            }
            boolean bl = false;
            for (n7 = 0; n7 < this.parsedModel.getNumGlobals(); ++n7) {
                boolean bl2 = hashSet.contains(this.parsedModel.getGlobal(n7).getName());
                if (!bl && bl2) {
                    bl = true;
                }
                if (!bl2) continue;
                ++n8;
            }
            if (bl && n6 == n) {
                return n4 + n8 - 1;
            }
            if (bl) {
                ++n6;
            }
            for (n7 = 0; n7 < this.parsedModel.getNumModules(); ++n7) {
                Module module = this.parsedModel.getModule(n7);
                boolean bl3 = false;
                for (int i = 0; i < module.getNumDeclarations(); ++i) {
                    boolean bl4 = hashSet.contains(module.getDeclaration(i).getName());
                    if (!bl3 && bl4) {
                        bl3 = true;
                    }
                    if (!bl4) continue;
                    ++n8;
                }
                if (bl3 && n6 == n) {
                    return n4 + n8 - 1;
                }
                if (!bl3) continue;
                ++n6;
            }
        }
        if (this.view.getVisibleRewardColumns().size() > 0) {
            if (n6 == n) {
                return n5 + this.view.getVisibleRewardColumns().size() - 1;
            }
            ++n6;
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (!this.pathActive) {
            return 0;
        }
        int n = 0;
        n += this.view.showActions() ? 1 : 0;
        n += this.view.showSteps() ? 1 : 0;
        n += (this.canShowTime() && this.view.showCumulativeTime() ? 1 : 0) + (this.canShowTime() && this.view.showTime() ? 1 : 0);
        n += this.view.getVisibleVariables().size();
        return n += this.view.getVisibleRewardColumns().size();
    }

    @Override
    public int getRowCount() {
        return this.pathActive ? (int)this.path.size() + 1 : 0;
    }

    public boolean shouldColourRow(int n) {
        int n2 = this.simulator.getStateLabelList().getSelectedIndex();
        if (n2 != -1) {
            GUISimLabelList.SimLabel simLabel = (GUISimLabelList.SimLabel)this.simulator.getStateLabelList().getModel().getElementAt(n2);
            if (n == this.getRowCount() - 1 ? simLabel.getResult() == 1 : simLabel.getResult(n) == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        if (this.pathActive) {
            int n2 = 0;
            int n3 = n2 + (this.view.showActions() ? 1 : 0);
            int n4 = n3 + (this.view.showSteps() ? 1 : 0);
            int n5 = n4 + (this.canShowTime() && this.view.showCumulativeTime() ? 1 : 0);
            int n6 = n5 + (this.canShowTime() && this.view.showTime() ? 1 : 0);
            int n7 = n6 + this.view.getVisibleVariables().size();
            if (n2 <= n && n < n3) {
                return this.modelInfo.getActionStringDescription();
            }
            if (n3 <= n && n < n4) {
                return "#";
            }
            if (n4 <= n && n < n5) {
                return "Time (+)";
            }
            if (n5 <= n && n < n6) {
                return "Time";
            }
            if (n6 <= n && n < n7) {
                return this.view.getVisibleVariables().get(n - n6).toString();
            }
            if (n7 <= n) {
                return this.view.getVisibleRewardColumns().get(n - n7).getColumnName();
            }
        }
        return "Undefined Column";
    }

    @Override
    public String getColumnToolTip(int n) {
        if (this.pathActive) {
            int n2 = 0;
            int n3 = n2 + (this.view.showActions() ? 1 : 0);
            int n4 = n3 + (this.view.showSteps() ? 1 : 0);
            int n5 = n4 + (this.canShowTime() && this.view.showCumulativeTime() ? 1 : 0);
            int n6 = n5 + (this.canShowTime() && this.view.showTime() ? 1 : 0);
            int n7 = n6 + this.view.getVisibleVariables().size();
            if (n2 <= n && n < n3) {
                return "Module name or [action] label";
            }
            if (n3 <= n && n < n4) {
                return "Index of state in path";
            }
            if (n4 <= n && n < n5) {
                return "Cumulative time";
            }
            if (n5 <= n && n < n6) {
                return "Time spent in state";
            }
            if (n6 <= n && n < n7) {
                return "Values of variable \"" + this.view.getVisibleVariables().get(n - n6).toString() + "\"";
            }
            if (n7 <= n) {
                SimulationView.RewardStructureColumn rewardStructureColumn = this.view.getVisibleRewardColumns().get(n - n7);
                String string = rewardStructureColumn.getRewardStructure().getColumnName();
                if (rewardStructureColumn.isStateReward()) {
                    return "State reward of reward structure " + string;
                }
                if (rewardStructureColumn.isTransitionReward()) {
                    return "Transition reward of reward structure " + string;
                }
                if (rewardStructureColumn.isCumulativeReward()) {
                    return "Cumulative reward of reward structure " + string;
                }
            }
        }
        return "Undefined Column";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.pathActive) {
            int n3 = 0;
            int n4 = n3 + (this.view.showActions() ? 1 : 0);
            int n5 = n4 + (this.view.showSteps() ? 1 : 0);
            int n6 = n5 + (this.canShowTime() && this.view.showCumulativeTime() ? 1 : 0);
            int n7 = n6 + (this.canShowTime() && this.view.showTime() ? 1 : 0);
            int n8 = n7 + this.view.getVisibleVariables().size();
            if (n3 <= n2 && n2 < n4) {
                SimulationView simulationView = this.view;
                Objects.requireNonNull(simulationView);
                this.actionValue = new SimulationView.ActionValue(simulationView, n == 0 ? "" : this.path.getActionString(n - 1));
                this.actionValue.setActionValueUnknown(false);
                return this.actionValue;
            }
            if (n4 <= n2 && n2 < n5) {
                return "" + n;
            }
            if (n5 <= n2 && n2 < n6) {
                SimulationView simulationView = this.view;
                Objects.requireNonNull(simulationView);
                this.timeValue = new SimulationView.TimeValue(simulationView, this.path.getCumulativeTime(n), true);
                this.timeValue.setTimeValueUnknown((long)n > this.path.size());
                return this.timeValue;
            }
            if (n6 <= n2 && n2 < n7) {
                SimulationView simulationView = this.view;
                Objects.requireNonNull(simulationView);
                this.timeValue = new SimulationView.TimeValue(simulationView, this.path.getTime(n), false);
                this.timeValue.setTimeValueUnknown((long)n >= this.path.size());
                return this.timeValue;
            }
            if (n7 <= n2 && n2 < n8) {
                SimulationView.Variable variable = this.view.getVisibleVariables().get(n2 - n7);
                Object object = this.path.getState((int)n).varValues[variable.getIndex()];
                this.variableValue.setVariable(variable);
                this.variableValue.setValue(object);
                this.variableValue.setChanged(n == 0 || !this.path.getState((int)(n - 1)).varValues[variable.getIndex()].equals(object));
                return this.variableValue;
            }
            if (n8 <= n2) {
                SimulationView.RewardStructureColumn rewardStructureColumn = this.view.getVisibleRewardColumns().get(n2 - n8);
                this.rewardStructureValue.setRewardStructureColumn(rewardStructureColumn);
                this.rewardStructureValue.setRewardValueUnknown(false);
                if (rewardStructureColumn.isStateReward()) {
                    double d = this.path.getStateReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                    this.rewardStructureValue.setChanged(n == 0 || d != this.path.getStateReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                    this.rewardStructureValue.setRewardValue(new Double(d));
                    this.rewardStructureValue.setRewardValueUnknown((long)n > this.path.size());
                } else if (rewardStructureColumn.isTransitionReward()) {
                    double d = this.path.getTransitionReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                    this.rewardStructureValue.setChanged(n == 0 || d != this.path.getTransitionReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                    this.rewardStructureValue.setRewardValue(new Double(d));
                    this.rewardStructureValue.setRewardValueUnknown((long)n >= this.path.size());
                } else {
                    double d = this.path.getCumulativeReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                    this.rewardStructureValue.setChanged(n == 0 || d != this.path.getCumulativeReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                    this.rewardStructureValue.setRewardValue(new Double(d));
                    this.rewardStructureValue.setRewardValueUnknown((long)n > this.path.size());
                }
                return this.rewardStructureValue;
            }
        }
        return "Undefined value";
    }

    public void restartPathTable() {
        this.view.refreshToDefaultView(this.pathActive, this.parsedModel);
    }

    public void updatePathTable() {
        this.fireTableDataChanged();
    }

    public boolean isPathLooping() {
        return this.path.isLooping();
    }

    public int getLoopStart() {
        return (int)this.path.loopStart();
    }

    public int getLoopEnd() {
        return (int)this.path.loopEnd();
    }

    public SimulationView getView() {
        return this.view;
    }

    public void setView(SimulationView simulationView) {
        this.view.deleteObserver(this);
        this.view = simulationView;
        this.view.addObserver(this);
    }
}

