/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jfree.data.xy.XYDataItem;
import parser.Values;
import parser.type.TypeInterval;
import prism.DefinedConstant;
import prism.Interval;
import prism.PrismException;
import prism.ResultListener;
import prism.ResultsCollection;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.graph.Graph;
import userinterface.graph.GraphResultListener;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIGraphHandler;
import userinterface.properties.GraphConstantHeader;
import userinterface.properties.GraphConstantLine;
import userinterface.properties.GraphConstantPickerList;

public class GUIGraphPicker
extends JDialog {
    private GUIPrism gui;
    private GUIPlugin plugin;
    private GUIExperiment experiment;
    private GUIGraphHandler graphHandler;
    private ResultsCollection resultsCollection;
    private GraphConstantPickerList pickerList;
    private String ranger;
    private DefinedConstant rangingConstant;
    private Values otherValues;
    private Vector<DefinedConstant> multiSeries;
    private Graph graphModel;
    private boolean graphCancelled;
    private static final int MAX_NUM_SERIES_BEFORE_QUERY = 11;
    private ButtonGroup buttonGroup1;
    private JPanel constantTablePanel;
    private JComboBox existingGraphCombo;
    private JRadioButton existingGraphRadio;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JTabbedPane jTabbedPane1;
    private JButton lineCancelButton;
    private JButton lineOkayButton;
    private JLabel middleLabel;
    private JRadioButton newGraphRadio;
    private JComboBox selectAxisConstantCombo;
    private JTextField seriesNameField;
    private JLabel seriesNameLabel;
    private JLabel topComboLabel;

    public GUIGraphPicker(GUIPrism gUIPrism, GUIPlugin gUIPlugin, GUIExperiment gUIExperiment, GUIGraphHandler gUIGraphHandler, boolean bl) {
        block17: {
            Object object;
            Cloneable cloneable;
            int n;
            ArrayList<Values> arrayList;
            Vector<Object> vector;
            block18: {
                Object object2;
                Values values;
                super((Frame)gUIPrism, true);
                this.setTitle("New Graph Series");
                this.gui = gUIPrism;
                this.plugin = gUIPlugin;
                this.experiment = gUIExperiment;
                this.graphHandler = gUIGraphHandler;
                this.resultsCollection = gUIExperiment.getResults();
                this.graphCancelled = true;
                this.multiSeries = new Vector();
                this.initComponents();
                this.setResizable(false);
                this.init();
                this.setLocationRelativeTo(this.getParent());
                this.getRootPane().setDefaultButton(this.lineOkayButton);
                this.setVisible(true);
                if (this.graphCancelled) break block17;
                vector = new Vector<Object>();
                arrayList = new ArrayList<Values>();
                arrayList.add(this.otherValues);
                for (n = 0; n < this.multiSeries.size(); ++n) {
                    cloneable = (ArrayList)arrayList.clone();
                    arrayList.clear();
                    for (int i = 0; i < this.multiSeries.get(n).getNumSteps(); ++i) {
                        object = (ArrayList)((ArrayList)cloneable).clone();
                        for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                            values = new Values();
                            object2 = (Values)((ArrayList)object).get(j);
                            values.addValues((Values)object2);
                            values.addValue(this.multiSeries.get(n).getName(), this.multiSeries.get(n).getValue(i));
                            arrayList.add(values);
                        }
                    }
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    String string;
                    cloneable = (Values)arrayList.get(n);
                    String string2 = string = arrayList.size() > 1 ? ((Values)cloneable).toString() : this.seriesNameField.getText();
                    if (gUIExperiment.getPropertyType() instanceof TypeInterval) {
                        object = this.graphModel.addSeries(string + " (min)");
                        ((Graph.SeriesKey)object).next = this.graphModel.addSeries(string + " (max)");
                        vector.add(object);
                        continue;
                    }
                    vector.add(this.graphModel.addSeries(string));
                }
                if (!bl || this.resultsCollection.getCurrentIteration() <= 0) break block18;
                for (n = 0; n < arrayList.size(); ++n) {
                    cloneable = (Values)arrayList.get(n);
                    Graph.SeriesKey seriesKey = (Graph.SeriesKey)vector.get(n);
                    for (int i = 0; i < this.rangingConstant.getNumSteps(); ++i) {
                        Object object3 = this.rangingConstant.getValue(i);
                        values = new Values();
                        values.addValues((Values)cloneable);
                        values.addValue(this.ranger, object3);
                        try {
                            object2 = this.resultsCollection.getResult(values);
                            double d = 0.0;
                            double d2 = 0.0;
                            boolean bl2 = true;
                            if (object3 instanceof Double) {
                                d = (Double)object3;
                            } else if (object3 instanceof Integer) {
                                d = ((Integer)object3).intValue();
                            } else {
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            if (object2 instanceof Double) {
                                d2 = (Double)object2;
                                this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d2));
                                continue;
                            }
                            if (object2 instanceof Integer) {
                                d2 = ((Integer)object2).intValue();
                                this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d2));
                                continue;
                            }
                            if (!(object2 instanceof Interval)) continue;
                            Interval interval = (Interval)object2;
                            if (interval.lower instanceof Double) {
                                d2 = (Double)interval.lower;
                                this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d2));
                                d2 = (Double)interval.upper;
                                this.graphModel.addPointToSeries(seriesKey.next, new XYDataItem(d, d2));
                                continue;
                            }
                            if (!(object2 instanceof Integer)) continue;
                            d2 = ((Integer)interval.lower).intValue();
                            this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d2));
                            d2 = ((Integer)interval.upper).intValue();
                            this.graphModel.addPointToSeries(seriesKey.next, new XYDataItem(d, d2));
                            continue;
                        }
                        catch (PrismException prismException) {
                            // empty catch block
                        }
                    }
                }
                break block17;
            }
            if (bl || this.resultsCollection.getCurrentIteration() != 0) break block17;
            for (n = 0; n < arrayList.size(); ++n) {
                cloneable = (Values)arrayList.get(n);
                Graph.SeriesKey seriesKey = (Graph.SeriesKey)vector.get(n);
                object = new GraphResultListener(this.graphModel, seriesKey, this.ranger, (Values)cloneable);
                this.resultsCollection.addResultListener((ResultListener)object);
            }
        }
    }

    private void init() {
        int n;
        GraphConstantHeader graphConstantHeader = new GraphConstantHeader();
        this.constantTablePanel.add((Component)graphConstantHeader, "North");
        JScrollPane jScrollPane = new JScrollPane();
        this.constantTablePanel.add((Component)jScrollPane, "Center");
        this.pickerList = new GraphConstantPickerList();
        jScrollPane.setViewportView(this.pickerList);
        for (n = 0; n < this.resultsCollection.getRangingConstants().size(); ++n) {
            DefinedConstant definedConstant = this.resultsCollection.getRangingConstants().get(n);
            this.pickerList.addConstant(new GraphConstantLine(definedConstant, this));
            this.selectAxisConstantCombo.addItem(definedConstant.getName());
        }
        if (this.selectAxisConstantCombo.getItemCount() > 0) {
            if (this.resultsCollection.getNumPropertyRangingConstants() > 0) {
                this.selectAxisConstantCombo.setSelectedIndex(this.resultsCollection.getNumModelRangingConstants());
            } else {
                this.selectAxisConstantCombo.setSelectedIndex(0);
            }
        }
        this.pickerList.disableLine(0);
        if (this.resultsCollection.getRangingConstants().size() == 1) {
            this.selectAxisConstantCombo.setEnabled(false);
            this.pickerList.setEnabled(false);
            graphConstantHeader.setEnabled(false);
            this.middleLabel.setEnabled(false);
            this.topComboLabel.setEnabled(false);
        }
        this.newGraphRadio.setSelected(true);
        for (n = 0; n < this.graphHandler.getNumModels(); ++n) {
            this.existingGraphCombo.addItem(this.graphHandler.getGraphName(n));
        }
        if (this.existingGraphCombo.getItemCount() > 0) {
            this.existingGraphCombo.setSelectedIndex(this.existingGraphCombo.getItemCount() - 1);
        } else {
            this.existingGraphCombo.setEnabled(false);
            this.existingGraphRadio.setEnabled(false);
        }
        this.resetAutoSeriesName();
        this.doEnables();
        this.pack();
    }

    public void doEnables() {
        this.existingGraphCombo.setEnabled(this.existingGraphRadio.isSelected());
    }

    public void resetAutoSeriesName() {
        if (this.selectAxisConstantCombo.getSelectedItem() == null) {
            return;
        }
        this.ranger = this.selectAxisConstantCombo.getSelectedItem().toString();
        this.otherValues = new Values();
        this.multiSeries = new Vector();
        for (int i = 0; i < this.pickerList.getNumConstants(); ++i) {
            DefinedConstant definedConstant = this.pickerList.getConstantLine(i).getDC();
            if (definedConstant.getName().equals(this.ranger)) continue;
            Object object = this.pickerList.getConstantLine(i).getSelectedValue();
            if (object instanceof String) {
                this.seriesNameLabel.setEnabled(false);
                this.seriesNameField.setText("");
                this.seriesNameField.setEnabled(false);
                return;
            }
            this.otherValues.addValue(definedConstant.getName(), object);
        }
        if (this.otherValues.getNumValues() != 0) {
            this.seriesNameField.setText(this.otherValues.toString());
        } else {
            this.seriesNameField.setText("New Series");
        }
        this.seriesNameLabel.setEnabled(true);
        this.seriesNameField.setEnabled(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.topComboLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.selectAxisConstantCombo = new JComboBox();
        this.jPanel7 = new JPanel();
        this.middleLabel = new JLabel();
        this.constantTablePanel = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jLabel3 = new JLabel();
        this.newGraphRadio = new JRadioButton();
        this.existingGraphRadio = new JRadioButton();
        this.jPanel11 = new JPanel();
        this.existingGraphCombo = new JComboBox();
        this.jPanel12 = new JPanel();
        this.seriesNameLabel = new JLabel();
        this.seriesNameField = new JTextField();
        this.jPanel4 = new JPanel();
        this.lineOkayButton = new JButton();
        this.lineCancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIGraphPicker.this.closeDialog(windowEvent);
            }
        });
        this.jTabbedPane1.setTabPlacement(2);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("Line Graph"));
        this.jPanel1.setFocusable(false);
        this.jPanel1.setEnabled(false);
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.topComboLabel.setText("Select x axis constant:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.topComboLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jPanel6, gridBagConstraints);
        this.selectAxisConstantCombo.setPreferredSize(new Dimension(100, 24));
        this.selectAxisConstantCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIGraphPicker.this.selectAxisConstantComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.selectAxisConstantCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.middleLabel.setText("Define other constants:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.middleLabel, gridBagConstraints);
        this.constantTablePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.constantTablePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jPanel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel3.add((Component)this.jPanel10, gridBagConstraints);
        this.jLabel3.setText("Add Series to:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.newGraphRadio.setText("New Graph");
        this.buttonGroup1.add(this.newGraphRadio);
        this.newGraphRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIGraphPicker.this.newGraphRadioActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.newGraphRadio, gridBagConstraints);
        this.existingGraphRadio.setText("Existing Graph");
        this.buttonGroup1.add(this.existingGraphRadio);
        this.existingGraphRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIGraphPicker.this.existingGraphRadioActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.existingGraphRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jPanel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.existingGraphCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.jPanel3.add((Component)this.jPanel12, gridBagConstraints);
        this.seriesNameLabel.setText("Series name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.seriesNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.seriesNameField, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel4.setLayout(new FlowLayout(2));
        this.lineOkayButton.setText("Okay");
        this.lineOkayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIGraphPicker.this.lineOkayButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.lineOkayButton);
        this.lineCancelButton.setText("Cancel");
        this.lineCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIGraphPicker.this.lineCancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.lineCancelButton);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel2.setBorder(new TitledBorder("Bar Graph"));
        this.jPanel2.setEnabled(false);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    public boolean isGraphCancelled() {
        return this.graphCancelled;
    }

    private void lineCancelButtonActionPerformed(ActionEvent actionEvent) {
        this.graphCancelled = true;
        this.setVisible(false);
    }

    private void lineOkayButtonActionPerformed(ActionEvent actionEvent) {
        int n = 1;
        this.ranger = this.selectAxisConstantCombo.getSelectedItem().toString();
        this.otherValues = new Values();
        this.multiSeries = new Vector();
        for (int i = 0; i < this.pickerList.getNumConstants(); ++i) {
            DefinedConstant definedConstant = this.pickerList.getConstantLine(i).getDC();
            if (definedConstant.getName().equals(this.ranger)) {
                this.rangingConstant = definedConstant;
                continue;
            }
            Object object = this.pickerList.getConstantLine(i).getSelectedValue();
            if (object instanceof String) {
                this.multiSeries.add(this.pickerList.getConstantLine(i).getDC());
                n *= definedConstant.getNumSteps();
                continue;
            }
            this.otherValues.addValue(definedConstant.getName(), object);
        }
        if (this.rangingConstant == null) {
            return;
        }
        if (n > 11) {
            String[] stringArray = new String[]{"Yes", "No"};
            int n2 = -1;
            n2 = this.plugin.optionPane("Warning: This will plot " + n + " series.\nAre you sure you want to continue?", "Question", 0, 3, stringArray, stringArray[0]);
            if (n2 != 0) {
                return;
            }
        }
        if (this.newGraphRadio.isSelected()) {
            this.graphModel = new Graph();
            this.graphHandler.addGraph(this.graphModel);
            this.graphModel.getYAxisSettings().setHeading(this.resultsCollection.getResultName());
            this.graphModel.getXAxisSettings().setHeading(this.ranger);
        } else {
            this.graphModel = this.graphHandler.getModel(this.existingGraphCombo.getSelectedItem().toString());
            if (!this.ranger.equals(this.graphModel.getXAxisSettings().getHeading()) && !GUIGraphPicker.roughExists(this.ranger, this.graphModel.getXAxisSettings().getHeading())) {
                this.graphModel.getXAxisSettings().setHeading(this.graphModel.getXAxisSettings().getHeading() + ", " + this.ranger);
            }
        }
        this.graphCancelled = false;
        this.setVisible(false);
    }

    private void existingGraphRadioActionPerformed(ActionEvent actionEvent) {
        this.doEnables();
    }

    private void newGraphRadioActionPerformed(ActionEvent actionEvent) {
        this.doEnables();
    }

    private void selectAxisConstantComboActionPerformed(ActionEvent actionEvent) {
        this.pickerList.disableLine(this.selectAxisConstantCombo.getSelectedIndex());
        this.resetAutoSeriesName();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static int factorial(int n) {
        if (n < 0) {
            return 1;
        }
        if (n == 0) {
            return 1;
        }
        return n * GUIGraphPicker.factorial(n - 1);
    }

    public static boolean roughExists(String string, String string2) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return false;
        }
        if (n != 0 && string2.charAt(n - 1) != ' ') {
            return false;
        }
        return string2.length() == n + 1 || string2.charAt(n + 1) == ',';
    }
}

