/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import parser.ast.PropertiesFile;
import userinterface.GUIComputationThread;
import userinterface.GUIPlugin;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ExportBuiltModelThread
extends GUIComputationThread {
    private int exportEntity;
    private int exportType;
    private File exportFile;
    private PropertiesFile propertiesFile;

    public ExportBuiltModelThread(GUIMultiModelHandler gUIMultiModelHandler, int n, int n2, File file) {
        this(gUIMultiModelHandler.getGUIPlugin(), n, n2, file);
    }

    public ExportBuiltModelThread(GUIPlugin gUIPlugin, int n, int n2, File file) {
        super(gUIPlugin);
        this.exportEntity = n;
        this.exportType = n2;
        this.exportFile = file;
    }

    public void setPropertiesFile(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportBuiltModelThread.this.plug.startProgress();
                    ExportBuiltModelThread.this.plug.setTaskBarText("Exporting...");
                    ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ExportBuiltModelThread.this.plug));
                }
            });
            try {
                switch (this.exportEntity) {
                    case 4: {
                        this.prism.exportStatesToFile(this.exportType, this.exportFile);
                        break;
                    }
                    case 1: {
                        this.prism.exportTransToFile(true, this.exportType, this.exportFile);
                        break;
                    }
                    case 2: {
                        this.prism.exportStateRewardsToFile(this.exportType, this.exportFile);
                        break;
                    }
                    case 3: {
                        this.prism.exportTransRewardsToFile(true, this.exportType, this.exportFile);
                        break;
                    }
                    case 5: {
                        this.prism.exportLabelsToFile(this.propertiesFile, this.exportType, this.exportFile);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExportBuiltModelThread.this.plug.stopProgress();
                        ExportBuiltModelThread.this.plug.setTaskBarText("Exporting... error.");
                        ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ExportBuiltModelThread.this.plug));
                        ExportBuiltModelThread.this.error("Could not export to file \"" + ExportBuiltModelThread.this.exportFile + "\"");
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                this.error(throwable);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExportBuiltModelThread.this.plug.stopProgress();
                        ExportBuiltModelThread.this.plug.setTaskBarText("Exporting... error.");
                        ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ExportBuiltModelThread.this.plug));
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportBuiltModelThread.this.plug.stopProgress();
                    ExportBuiltModelThread.this.plug.setTaskBarText("Exporting... done.");
                    ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ExportBuiltModelThread.this.plug));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

