/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.type.Type;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ResultsCollection;
import prism.RewardGenerator;
import prism.UndefinedConstants;
import simulator.Path;
import simulator.PathFull;
import simulator.PathFullInfo;
import simulator.PathFullPrefix;
import simulator.PathOnTheFly;
import simulator.RandomNumberGenerator;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;
import strat.Strategy;
import userinterface.graph.Graph;

public class SimulatorEngine
extends PrismComponent {
    private ModelGenerator modelGen = null;
    private RewardGenerator rewardGen;
    private ModelType modelType = null;
    private VarList varList = null;
    private int numVars = 0;
    private Values mfConstants = null;
    private List<State> reachableStates;
    private Strategy strategy;
    protected List<Expression> labels = null;
    private List<Expression> properties = null;
    private List<Sampler> propertySamplers = null;
    protected Path path = null;
    protected boolean onTheFly = true;
    protected State currentState = null;
    protected State transitionListState = null;
    protected double[] tmpStateRewards = null;
    protected double[] tmpTransitionRewards = null;
    private RandomNumberGenerator rng = new RandomNumberGenerator();

    public SimulatorEngine(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public void loadModel(ModelGenerator modelGenerator, RewardGenerator rewardGenerator) throws PrismException {
        if (rewardGenerator == null) {
            rewardGenerator = new RewardGenerator(){};
        }
        this.modelGen = modelGenerator;
        this.rewardGen = rewardGenerator;
        this.modelType = modelGenerator.getModelType();
        this.mfConstants = modelGenerator.getConstantValues();
        this.varList = modelGenerator.createVarList();
        this.numVars = this.varList.getNumVars();
        this.initialise();
    }

    public void loadModel(ModelGenerator modelGenerator) throws PrismException {
        this.loadModel(modelGenerator, null);
    }

    private void initialise() throws PrismException {
        this.currentState = new State(this.numVars);
        this.tmpStateRewards = new double[this.rewardGen.getNumRewardStructs()];
        this.tmpTransitionRewards = new double[this.rewardGen.getNumRewardStructs()];
        this.strategy = null;
        this.labels = new ArrayList<Expression>();
        this.properties = new ArrayList<Expression>();
        this.propertySamplers = new ArrayList<Sampler>();
    }

    public ModelGenerator getModel() {
        return this.modelGen;
    }

    public RewardGenerator getRewardGenerator() {
        return this.rewardGen;
    }

    public void createNewPath() throws PrismException {
        this.initialise();
        this.path = new PathFull(this.modelGen, this.rewardGen);
        this.onTheFly = false;
    }

    public void createNewOnTheFlyPath() throws PrismException {
        this.initialise();
        this.path = new PathOnTheFly(this.modelGen, this.rewardGen);
        this.onTheFly = true;
    }

    public void initialisePath(State state) throws PrismException {
        if (state != null) {
            this.currentState.copy(state);
        } else if (this.modelGen.hasSingleInitialState()) {
            this.currentState.copy(this.modelGen.getInitialState());
        } else {
            throw new PrismNotSupportedException("Random choice of multiple initial states not yet supported");
        }
        this.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.initialise(this.currentState, this.tmpStateRewards);
        this.computeTransitionsForState(this.currentState);
        this.resetSamplers();
        this.updateSamplers();
        this.initialiseStrategy();
    }

    public void manualTransition(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        if (this.modelType.continuousTime()) {
            double d = this.modelGen.getProbabilitySum();
            this.executeTimedTransition(n2, n3, this.rng.randomExpDouble(d), n);
        } else {
            this.executeTransition(n2, n3, n);
        }
    }

    public void manualTransition(int n, double d) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        this.executeTimedTransition(n2, n3, d, n);
    }

    public boolean automaticTransition() throws PrismException {
        if (this.modelGen.getNumChoices() == 0) {
            return false;
        }
        switch (this.modelType) {
            case DTMC: {
                double d = this.rng.randomUnifDouble();
                Ref ref = new Ref();
                this.getChoiceIndexByProbabilitySum(d, ref);
                this.executeTransition(ref.i, ref.offset, -1);
                break;
            }
            case MDP: {
                int n = this.rng.randomUnifInt(this.modelGen.getNumChoices());
                double d = this.rng.randomUnifDouble();
                int n2 = this.getTransitionIndexByProbabilitySum(n, d);
                this.executeTransition(n, n2, -1);
                break;
            }
            case CTMC: {
                double d = this.modelGen.getProbabilitySum();
                double d2 = this.rng.randomUnifDouble(d);
                Ref ref = new Ref();
                this.getChoiceIndexByProbabilitySum(d2, ref);
                this.executeTimedTransition(ref.i, ref.offset, this.rng.randomExpDouble(d), -1);
                break;
            }
            default: {
                throw new PrismNotSupportedException(this.modelType + " not supported");
            }
        }
        return true;
    }

    private void getChoiceIndexByProbabilitySum(double d, Ref ref) throws PrismException {
        int n = this.modelGen.getNumChoices();
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        for (n2 = 0; d >= d3 && n2 < n; d3 += d2, ++n2) {
            d2 = this.modelGen.getChoiceProbabilitySum(n2);
        }
        ref.i = n2 - 1;
        ref.offset = this.getTransitionIndexByProbabilitySum(n2 - 1, d - (d3 - d2));
    }

    private int getTransitionIndexByProbabilitySum(int n, double d) throws PrismException {
        int n2 = this.modelGen.getNumTransitions(n);
        if (n2 > 1) {
            double d2 = 0.0;
            int n3 = 0;
            for (n3 = 0; d >= d2 && n3 < n2; d2 += this.modelGen.getTransitionProbability(n, n3), ++n3) {
            }
            return n3 - 1;
        }
        return 0;
    }

    public int automaticTransitions(int n, boolean bl) throws PrismException {
        int n2;
        for (n2 = 0; !(n2 >= n || bl && this.path.isLooping() || !this.automaticTransition()); ++n2) {
        }
        return n2;
    }

    public int automaticTransitions(double d, boolean bl) throws PrismException {
        if (!this.modelType.continuousTime()) {
            return this.automaticTransitions((int)Math.ceil(d), false);
        }
        int n = 0;
        double d2 = this.path.getTotalTime() + d;
        while (this.path.getTotalTime() < d2 && this.automaticTransition()) {
            ++n;
        }
        return n;
    }

    public void backtrackTo(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("Cannot backtrack to a negative step index");
        }
        if ((long)n > this.path.size()) {
            throw new PrismException("There is no step " + n + " to backtrack to");
        }
        ((PathFull)this.path).backtrack(n);
        this.currentState.copy(this.path.getCurrentState());
        this.computeTransitionsForState(this.currentState);
        this.recomputeSamplers();
    }

    public void backtrackTo(double d) throws PrismException {
        int n;
        if (d < 0.0) {
            throw new PrismException("Cannot backtrack to a negative time point");
        }
        if (d > this.path.getTotalTime()) {
            throw new PrismException("There is no time point " + d + " to backtrack to");
        }
        PathFull pathFull = (PathFull)this.path;
        long l = this.path.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismException("PathFull cannot deal with paths over length 2147483647");
        }
        int n2 = (int)l;
        for (n = 0; n <= n2 && pathFull.getCumulativeTime(n) < d; ++n) {
        }
        this.backtrackTo(n);
    }

    public void removePrecedingStates(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("Cannot remove states before a negative step index");
        }
        if ((long)n > this.path.size()) {
            throw new PrismException("There is no step " + n + " in the path");
        }
        ((PathFull)this.path).removePrecedingStates(n);
        this.recomputeSamplers();
    }

    public void computeTransitionsForStep(int n) throws PrismException {
        this.computeTransitionsForState(((PathFull)this.path).getState(n));
    }

    public void computeTransitionsForCurrentState() throws PrismException {
        this.computeTransitionsForState(this.path.getCurrentState());
    }

    private void computeTransitionsForState(State state) throws PrismException {
        this.modelGen.exploreState(state);
        this.transitionListState = state;
    }

    public void loadReachableStates(List<State> list) {
        this.reachableStates = list;
    }

    public void loadStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void loadPath(PathFullInfo pathFullInfo) throws PrismException {
        long l = pathFullInfo.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismException("PathFull cannot deal with paths over length 2147483647");
        }
        int n = (int)l;
        this.createNewPath();
        State state = pathFullInfo.getState(0);
        this.initialisePath(state);
        for (int i = 0; i < n; ++i) {
            State state2 = pathFullInfo.getState(i + 1);
            int n2 = this.modelGen.getNumChoices();
            boolean bl = false;
            block1: for (int j = 0; j < n2; ++j) {
                int n3 = this.modelGen.getNumTransitions(j);
                for (int k = 0; k < n3; ++k) {
                    if (!this.modelGen.computeTransitionTarget(j, k).equals(state2)) continue;
                    bl = true;
                    if (this.modelType.continuousTime() && pathFullInfo.hasTimeInfo()) {
                        this.manualTransition(j, pathFullInfo.getTime(i));
                        continue block1;
                    }
                    this.manualTransition(j);
                    continue block1;
                }
            }
            if (!bl) {
                throw new PrismException("Path loading failed at step " + (i + 1));
            }
            state = state2;
        }
    }

    public int addLabel(Expression expression) throws PrismLangException {
        return this.addLabel(expression, null);
    }

    public int addLabel(Expression expression, PropertiesFile propertiesFile) throws PrismLangException {
        Expression expression2 = expression.deepCopy();
        expression2 = (Expression)expression2.replaceConstants(this.mfConstants);
        if (propertiesFile != null) {
            expression2 = (Expression)expression2.replaceConstants(propertiesFile.getConstantValues());
        }
        expression2 = (Expression)expression2.simplify();
        this.labels.add(expression2);
        return this.labels.size() - 1;
    }

    public int addProperty(Expression expression) throws PrismException {
        return this.addProperty(expression, null);
    }

    public int addProperty(Expression expression, PropertiesFile propertiesFile) throws PrismException {
        Expression expression2 = expression.deepCopy();
        LabelList labelList = propertiesFile == null ? null : propertiesFile.getCombinedLabelList();
        expression2 = (Expression)expression2.expandPropRefsAndLabels(propertiesFile, labelList);
        expression2 = (Expression)expression2.replaceConstants(this.mfConstants);
        if (propertiesFile != null) {
            expression2 = (Expression)expression2.replaceConstants(propertiesFile.getConstantValues());
        }
        expression2 = (Expression)expression2.simplify();
        Sampler sampler = Sampler.createSampler(expression2, this.modelGen, this.rewardGen);
        this.properties.add(expression2);
        this.propertySamplers.add(sampler);
        return this.properties.size() - 1;
    }

    public boolean queryLabel(int n) throws PrismLangException {
        return this.labels.get(n).evaluateBoolean(this.path.getCurrentState());
    }

    public boolean queryLabel(int n, int n2) throws PrismLangException {
        return this.labels.get(n).evaluateBoolean(((PathFull)this.path).getState(n2));
    }

    public boolean queryIsInitial() throws PrismException {
        return this.path.getCurrentState().equals(this.modelGen.getInitialState());
    }

    public boolean queryIsInitial(int n) throws PrismException {
        return ((PathFull)this.path).getState(n).equals(this.modelGen.getInitialState());
    }

    public boolean queryIsDeadlock() throws PrismException {
        return this.modelGen.isDeadlock();
    }

    public boolean queryIsDeadlock(int n) throws PrismException {
        return (long)n == this.path.size() ? this.modelGen.getNumChoices() == 0 : false;
    }

    public Object queryProperty(int n) {
        if (n < 0 || n >= this.propertySamplers.size()) {
            this.mainLog.printWarning("Can't query property " + n + ".");
            return null;
        }
        Sampler sampler = this.propertySamplers.get(n);
        return sampler.isCurrentValueKnown() ? sampler.getCurrentValue() : null;
    }

    private void calculateStateRewards(State state, double[] dArray) throws PrismException {
        int n = this.rewardGen.getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.rewardGen.getStateReward(i, state);
        }
    }

    private void calculateTransitionRewards(State state, Object object, double[] dArray) throws PrismException {
        int n = this.rewardGen.getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.rewardGen.getStateActionReward(i, state, object);
        }
    }

    private void executeTransition(int n, int n2, int n3) throws PrismException {
        if (!this.onTheFly && n3 == -1) {
            n3 = this.modelGen.getTotalIndexOfTransition(n, n2);
        }
        double d = this.modelGen.getTransitionProbability(n, n2);
        Object object = this.modelGen.getChoiceAction(n);
        String string = this.modelGen.getChoiceActionString(n);
        this.calculateTransitionRewards(this.path.getCurrentState(), object, this.tmpTransitionRewards);
        this.currentState.copy(this.modelGen.computeTransitionTarget(n, n2));
        this.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.addStep(n3, object, string, d, this.tmpTransitionRewards, this.currentState, this.tmpStateRewards, this.modelGen);
        this.computeTransitionsForState(this.currentState);
        this.updateSamplers();
        this.updateStrategy();
    }

    private void executeTimedTransition(int n, int n2, double d, int n3) throws PrismException {
        if (!this.onTheFly && n3 == -1) {
            n3 = this.modelGen.getTotalIndexOfTransition(n, n2);
        }
        double d2 = this.modelGen.getTransitionProbability(n, n2);
        Object object = this.modelGen.getChoiceAction(n);
        String string = this.modelGen.getChoiceActionString(n);
        this.calculateTransitionRewards(this.path.getCurrentState(), object, this.tmpTransitionRewards);
        this.currentState.copy(this.modelGen.computeTransitionTarget(n, n2));
        this.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.addStep(d, n3, object, string, d2, this.tmpTransitionRewards, this.currentState, this.tmpStateRewards, this.modelGen);
        this.computeTransitionsForState(this.currentState);
        this.updateSamplers();
        this.updateStrategy();
    }

    private void resetSamplers() throws PrismLangException {
        for (Sampler sampler : this.propertySamplers) {
            sampler.reset();
        }
    }

    private void updateSamplers() throws PrismException {
        for (Sampler sampler : this.propertySamplers) {
            sampler.update(this.path, this.modelGen);
        }
    }

    private void recomputeSamplers() throws PrismException {
        this.resetSamplers();
        long l = this.path.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismLangException("PathFull cannot deal with paths over length 2147483647");
        }
        int n = (int)l;
        PathFullPrefix pathFullPrefix = new PathFullPrefix((PathFull)this.path, 0);
        for (int i = 0; i <= n; ++i) {
            pathFullPrefix.setPrefixLength(i);
            for (Sampler sampler : this.propertySamplers) {
                sampler.update(pathFullPrefix, null);
            }
        }
    }

    private void initialiseStrategy() {
        if (this.strategy != null) {
            State state = this.getCurrentState();
            int n = this.reachableStates.indexOf(state);
            this.strategy.initialise(n);
        }
    }

    private void updateStrategy() {
        if (this.strategy != null) {
            State state = this.getCurrentState();
            int n = this.reachableStates.indexOf(state);
            Object object = this.path.getPreviousAction();
            this.strategy.update(object, n);
        }
    }

    public int getNumVariables() {
        return this.numVars;
    }

    public String getVariableName(int n) {
        return n < this.numVars && n >= 0 ? this.varList.getName(n) : null;
    }

    public Type getVariableType(int n) {
        return n < this.numVars && n >= 0 ? this.varList.getType(n) : null;
    }

    public int getIndexOfVar(String string) throws PrismException {
        return this.varList.getIndex(string);
    }

    public State getTransitionListState() {
        return this.transitionListState == null ? this.path.getCurrentState() : this.transitionListState;
    }

    public int getNumChoices() throws PrismException {
        return this.modelGen.getNumChoices();
    }

    public int getNumTransitions() throws PrismException {
        return this.modelGen.getNumTransitions();
    }

    public int getNumTransitions(int n) throws PrismException {
        return this.modelGen.getNumTransitions(n);
    }

    public int getChoiceIndexOfTransition(int n) throws PrismException {
        return this.modelGen.getChoiceIndexOfTransition(n);
    }

    public Object getTransitionAction(int n, int n2) throws PrismException {
        return this.modelGen.getTransitionAction(n, n2);
    }

    public Object getTransitionAction(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.modelGen.getTransitionAction(n2, n3);
    }

    public String getTransitionActionString(int n, int n2) throws PrismException {
        return this.modelGen.getTransitionActionString(n, n2);
    }

    public String getTransitionActionString(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.getTransitionActionString(n2, n3);
    }

    public double getTransitionProbability(int n, int n2) throws PrismException {
        return this.modelGen.getTransitionProbability(n, n2);
    }

    public double getTransitionProbability(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.getTransitionProbability(n2, n3);
    }

    public String getTransitionUpdateString(int n, int n2) throws PrismException {
        return this.modelGen.getTransitionUpdateString(n, n2);
    }

    public String getTransitionUpdateString(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.getTransitionUpdateString(n2, n3);
    }

    public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        return this.modelGen.getTransitionUpdateStringFull(n, n2);
    }

    public String getTransitionUpdateStringFull(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.getTransitionUpdateStringFull(n2, n3);
    }

    public State computeTransitionTarget(int n, int n2) throws PrismException {
        return this.modelGen.computeTransitionTarget(n, n2);
    }

    public State computeTransitionTarget(int n) throws PrismException {
        int n2 = this.modelGen.getChoiceIndexOfTransition(n);
        int n3 = this.modelGen.getChoiceOffsetOfTransition(n);
        return this.computeTransitionTarget(n2, n3);
    }

    public Path getPath() {
        return this.path;
    }

    public long getPathSize() {
        return this.path.size();
    }

    public State getCurrentState() {
        return this.path.getCurrentState();
    }

    public State getPreviousState() {
        return this.path.getPreviousState();
    }

    public double getTotalTimeForPath() {
        return this.path.getTotalTime();
    }

    public double getTotalCumulativeRewardForPath(int n) {
        return this.path.getTotalCumulativeReward(n);
    }

    public PathFull getPathFull() {
        return (PathFull)this.path;
    }

    public Object getVariableValueOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getState((int)n).varValues[n2];
    }

    public State getStateOfPathStep(int n) {
        return ((PathFull)this.path).getState(n);
    }

    public double getStateRewardOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getStateReward(n, n2);
    }

    public double getCumulativeTimeUpToPathStep(int n) {
        return ((PathFull)this.path).getCumulativeTime(n);
    }

    public double getCumulativeRewardUpToPathStep(int n, int n2) {
        return ((PathFull)this.path).getCumulativeReward(n, n2);
    }

    public double getTimeSpentInPathStep(int n) {
        return ((PathFull)this.path).getTime(n);
    }

    public int getChoiceOfPathStep(int n) {
        return ((PathFull)this.path).getChoice(n);
    }

    public Object getActionOfPathStep(int n) {
        return ((PathFull)this.path).getAction(n);
    }

    public String getActionStringOfPathStep(int n) {
        return ((PathFull)this.path).getActionString(n);
    }

    public double getTransitionRewardOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getTransitionReward(n, n2);
    }

    public boolean isPathLooping() {
        return this.path.isLooping();
    }

    public long loopStart() {
        return this.path.loopStart();
    }

    public long loopEnd() {
        return this.path.loopEnd();
    }

    public void exportPath(File file) throws PrismException {
        this.exportPath(file, false);
    }

    public void exportPath(File file, boolean bl) throws PrismException {
        this.exportPath(file, false, bl, " ", null);
    }

    public void exportPath(File file, boolean bl, String string, ArrayList<Integer> arrayList) throws PrismException {
        this.exportPath(file, bl, false, string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPath(File file, boolean bl, boolean bl2, String string, ArrayList<Integer> arrayList) throws PrismException {
        PrismLog prismLog = null;
        try {
            if (this.path == null) {
                throw new PrismException("There is no path to export");
            }
            if (file != null) {
                prismLog = new PrismFileLog(file.getPath());
                if (!prismLog.ready()) {
                    throw new PrismException("Could not open file \"" + file + "\" for output");
                }
                this.mainLog.println("\nExporting path to file \"" + file + "\"...");
            } else {
                prismLog = this.mainLog;
                prismLog.println();
            }
            ((PathFull)this.path).exportToLog(prismLog, bl, bl2, string, arrayList);
            if (file != null) {
                prismLog.close();
            }
        }
        finally {
            if (file != null && prismLog != null) {
                prismLog.close();
            }
        }
    }

    public void plotPath(Graph graph) throws PrismException {
        ((PathFull)this.path).plotOnGraph(graph);
    }

    public boolean isPropertyOKForSimulation(Expression expression) {
        return this.isPropertyOKForSimulationString(expression) == null;
    }

    public void checkPropertyForSimulation(Expression expression) throws PrismException {
        String string = this.isPropertyOKForSimulationString(expression);
        if (string != null) {
            throw new PrismNotSupportedException(string);
        }
    }

    private String isPropertyOKForSimulationString(Expression expression) {
        Expression expression2;
        if (!(expression instanceof ExpressionProb) && !(expression instanceof ExpressionReward)) {
            if (expression instanceof ExpressionFilter && (((ExpressionFilter)expression).getOperand() instanceof ExpressionProb || ((ExpressionFilter)expression).getOperand() instanceof ExpressionReward)) {
                return "Simulator cannot handle P or R properties with filters";
            }
            return "Simulator can only handle P or R properties";
        }
        try {
            if (expression.computeProbNesting() > 1) {
                return "Simulator cannot handle nested P, R or S operators";
            }
        }
        catch (PrismException prismException) {
            return "Simulator cannot handle this property: " + prismException.getMessage();
        }
        if (expression instanceof ExpressionReward && (expression2 = ((ExpressionReward)expression).getExpression()) instanceof ExpressionTemporal && ((ExpressionTemporal)expression2).getOperator() == 11 && ((ExpressionTemporal)expression2).getUpperBound() == null) {
            return "Simulator cannot handle cumulative reward properties without time bounds";
        }
        return null;
    }

    public Object modelCheckSingleProperty(PropertiesFile propertiesFile, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(expression);
        Object[] objectArray = this.modelCheckMultipleProperties(propertiesFile, arrayList, state, l, simulationMethod);
        if (objectArray[0] instanceof PrismException) {
            throw (PrismException)objectArray[0];
        }
        return objectArray[0];
    }

    public Object[] modelCheckMultipleProperties(PropertiesFile propertiesFile, List<Expression> list, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        Object object;
        int n;
        this.createNewOnTheFlyPath();
        simulationMethod.computeMissingParameterBeforeSim();
        this.mainLog.println("\nSimulation method: " + simulationMethod.getName() + " (" + simulationMethod.getFullName() + ")");
        this.mainLog.println("Simulation method parameters: " + simulationMethod.getParametersString());
        this.mainLog.println("Simulation parameters: max path length=" + l);
        Object[] objectArray = new Object[list.size()];
        int[] nArray = new int[list.size()];
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            try {
                this.checkPropertyForSimulation(list.get(n));
                nArray[n] = this.addProperty(list.get(n), propertiesFile);
                ++n2;
                object = simulationMethod.clone();
                this.propertySamplers.get(nArray[n]).setSimulationMethod((SimulationMethod)object);
                try {
                    ((SimulationMethod)object).setExpression(this.properties.get(nArray[n]));
                    continue;
                }
                catch (PrismException prismException) {
                    this.properties.remove(nArray[n]);
                    this.propertySamplers.remove(nArray[n]);
                    throw prismException;
                }
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
                nArray[n] = -1;
            }
        }
        if (n2 > 0) {
            this.doSampling(state, l);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (nArray[n] == -1) continue;
            object = this.propertySamplers.get(nArray[n]);
            SimulationMethod simulationMethod2 = ((Sampler)object).getSimulationMethod();
            simulationMethod2.computeMissingParameterAfterSim();
            try {
                objectArray[n] = simulationMethod2.getResult((Sampler)object);
                continue;
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
            }
        }
        Object object2 = "";
        if (objectArray.length > 0 && ((ModelType)((Object)(object = this.modelGen.getModelType()))).nondeterministic() && ((ModelType)((Object)object)).removeNondeterminism() != object) {
            object2 = (String)object2 + " (with nondeterminism in " + ((Enum)object).name() + " being resolved uniformly)";
        }
        if (objectArray.length == 1) {
            this.mainLog.print("\nSimulation method parameters: ");
            this.mainLog.println(nArray[0] == -1 ? "no simulation" : this.propertySamplers.get(nArray[0]).getSimulationMethod().getParametersString());
            this.mainLog.print("\nSimulation result details: ");
            this.mainLog.println(nArray[0] == -1 ? "no simulation" : this.propertySamplers.get(nArray[0]).getSimulationMethodResultExplanation());
            if (!(objectArray[0] instanceof PrismException)) {
                this.mainLog.println("\nResult: " + objectArray[0] + (String)object2);
            }
        } else {
            int n3;
            this.mainLog.println("\nSimulation method parameters:");
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.mainLog.print(list.get(n3) + " : ");
                this.mainLog.println(nArray[n3] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n3]).getSimulationMethod().getParametersString());
            }
            this.mainLog.println("\nSimulation result details:");
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.mainLog.print(list.get(n3) + " : ");
                this.mainLog.println(nArray[n3] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n3]).getSimulationMethodResultExplanation());
            }
            this.mainLog.println("\nResults:");
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.mainLog.println(list.get(n3) + " : " + objectArray[n3] + (String)object2);
            }
        }
        return objectArray;
    }

    public void modelCheckExperiment(PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        Object object;
        int n;
        this.createNewOnTheFlyPath();
        simulationMethod.computeMissingParameterBeforeSim();
        this.mainLog.println("\nSimulation method: " + simulationMethod.getName() + " (" + simulationMethod.getFullName() + ")");
        this.mainLog.println("Simulation method parameters: " + simulationMethod.getParametersString());
        this.mainLog.println("Simulation parameters: max path length=" + l);
        int n2 = undefinedConstants.getNumPropertyIterations();
        Values values = new Values();
        Object[] objectArray = new Object[n2];
        Values[] valuesArray = new Values[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            valuesArray[n] = values = undefinedConstants.getPFConstantValues();
            propertiesFile.setSomeUndefinedConstants(values, false);
            try {
                this.checkPropertyForSimulation(expression);
                nArray[n] = this.addProperty(expression, propertiesFile);
                ++n3;
                object = simulationMethod.clone();
                this.propertySamplers.get(nArray[n]).setSimulationMethod((SimulationMethod)object);
                try {
                    ((SimulationMethod)object).setExpression(this.properties.get(nArray[n]));
                }
                catch (PrismException prismException) {
                    this.properties.remove(nArray[n]);
                    this.propertySamplers.remove(nArray[n]);
                    throw prismException;
                }
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
                nArray[n] = -1;
            }
            undefinedConstants.iterateProperty();
        }
        if (n3 > 0) {
            this.doSampling(state, l);
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != -1) {
                object = this.propertySamplers.get(nArray[n]);
                SimulationMethod simulationMethod2 = ((Sampler)object).getSimulationMethod();
                simulationMethod2.computeMissingParameterAfterSim();
                try {
                    objectArray[n] = simulationMethod2.getResult((Sampler)object);
                }
                catch (PrismException prismException) {
                    objectArray[n] = prismException;
                }
            }
            resultsCollection.setResult(undefinedConstants.getMFConstantValues(), valuesArray[n], objectArray[n]);
        }
        this.mainLog.println("\nSimulation method parameters:");
        for (n = 0; n < objectArray.length; ++n) {
            this.mainLog.print(valuesArray[n] + " : ");
            this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethod().getParametersString());
        }
        this.mainLog.println("\nSimulation result details:");
        for (n = 0; n < objectArray.length; ++n) {
            this.mainLog.print(valuesArray[n] + " : ");
            this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethodResultExplanation());
        }
        this.mainLog.println("\nResults:");
        this.mainLog.print(resultsCollection.toStringPartial(undefinedConstants.getMFConstantValues(), true, " ", " : ", false));
    }

    private void doSampling(State state, long l) throws PrismException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        double d = 0.0;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        long l4 = System.currentTimeMillis();
        this.mainLog.print("\nSampling progress: [");
        this.mainLog.flush();
        int n3 = 0;
        while (!bl6) {
            long l5;
            bl3 = true;
            for (Sampler sampler : this.propertySamplers) {
                if (sampler.getSimulationMethod().shouldStopNow(n3, sampler)) continue;
                bl3 = false;
            }
            if (bl3) break;
            n2 = 100;
            for (Sampler sampler : this.propertySamplers) {
                n2 = Math.min(n2, sampler.getSimulationMethod().getProgress(n3, sampler));
            }
            if (n2 > n) {
                n = n2;
                this.mainLog.print(" " + n + "%");
                this.mainLog.flush();
            }
            ++n3;
            this.initialisePath(state);
            bl4 = false;
            bl5 = false;
            for (l5 = 0L; !bl4 && l5 < l || bl5; ++l5) {
                bl4 = true;
                bl5 = false;
                for (Sampler sampler : this.propertySamplers) {
                    if (sampler.isCurrentValueKnown()) continue;
                    bl4 = false;
                    if (!sampler.needsBoundedNumSteps()) continue;
                    bl5 = true;
                }
                if ((bl4 || l5 >= l) && !bl5) break;
                this.automaticTransition();
            }
            d = (d * (double)(n3 - 1) + (double)l5) / (double)n3;
            l2 = n3 == 1 ? l5 : Math.min(l2, l5);
            long l6 = l3 = n3 == 1 ? l5 : Math.max(l3, l5);
            if (!bl4) {
                bl = true;
                break;
            }
            for (Sampler sampler : this.propertySamplers) {
                sampler.updateStats();
            }
        }
        if (!bl) {
            if (!bl6) {
                this.mainLog.print(" 100% ]");
            }
            this.mainLog.println();
            long l7 = System.currentTimeMillis();
            double d2 = (double)(l7 - l4) / 1000.0;
            this.mainLog.print("\nSampling complete: ");
            this.mainLog.print(n3 + " iterations in " + d2 + " seconds (average " + PrismUtils.formatDouble(2, d2 / (double)n3) + ")\n");
            this.mainLog.print("Path length statistics: average " + PrismUtils.formatDouble(2, d) + ", min " + l2 + ", max " + l3 + "\n");
        } else {
            this.mainLog.print(" ...\n\nSampling terminated early after " + n3 + " iterations.\n");
        }
        if (bl2) {
            this.mainLog.printWarning("Deadlocks were found during simulation: self-loops were added.");
        }
        if (bl6) {
            this.mainLog.printWarning("Simulation was terminated before completion.");
        }
        if (bl) {
            throw new PrismException("One or more of the properties being sampled could not be checked on a sample. Consider increasing the maximum path length");
        }
    }

    public void stopSampling() {
    }

    public class Ref {
        public int i;
        public int offset;
    }
}

