/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.MinMax;
import java.io.Serializable;
import parser.ast.RelOp;
import prism.ModelType;
import prism.PrismLangException;

public class OpRelOpBound {
    protected String op;
    protected RelOp relOp;
    protected boolean numeric;
    protected double bound;

    public OpRelOpBound(String string, RelOp relOp, Double d) {
        this.op = string;
        this.relOp = relOp;
        boolean bl = this.numeric = d == null;
        if (d != null) {
            this.bound = d;
        }
    }

    public boolean isProbabilistic() {
        return "P".equals(this.op);
    }

    public boolean isReward() {
        return "R".equals(this.op);
    }

    public RelOp getRelOp() {
        return this.relOp;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public double getBound() {
        return this.bound;
    }

    public boolean isQualitative() {
        return !this.isNumeric() && this.op.equals("P") && (this.bound == 0.0 || this.bound == 1.0);
    }

    public boolean isTriviallyTrue() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.GEQ) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.LEQ) {
                return true;
            }
        }
        return false;
    }

    public boolean isTriviallyFalse() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.LT) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.GT) {
                return true;
            }
        }
        return false;
    }

    public MinMax getMinMax(ModelType modelType) throws PrismLangException {
        return this.getMinMax(modelType, true);
    }

    public MinMax getMinMax(ModelType modelType, boolean bl) throws PrismLangException {
        MinMax minMax = MinMax.blank();
        if (modelType.nondeterministic()) {
            if (modelType != ModelType.MDP && modelType != ModelType.CTMDP) {
                throw new PrismLangException("Don't know how to model check " + this.getTypeOfOperator() + " properties for " + modelType + "s");
            }
            if (this.isNumeric()) {
                if (this.relOp == RelOp.EQ) {
                    throw new PrismLangException("Can't use \"" + this.op + "=?\" for nondeterministic models; use e.g. \"" + this.op + "min=?\" or \"" + this.op + "max=?\"");
                }
                minMax = this.relOp.isMin() ? MinMax.min() : MinMax.max();
            } else {
                minMax = bl ? (this.relOp.isLowerBound() ? MinMax.min() : MinMax.max()) : (this.relOp.isLowerBound() ? MinMax.max() : MinMax.min());
            }
        }
        return minMax;
    }

    public String getTypeOfOperator() {
        Object object = "";
        object = (String)object + this.op + this.relOp;
        object = (String)object + (this.isNumeric() ? "?" : "p");
        return object;
    }

    public String relOpBoundString() {
        return this.relOp.toString() + this.bound;
    }

    public String toString() {
        return this.op + this.relOp.toString() + (Serializable)(this.isNumeric() ? "?" : Double.valueOf(this.bound));
    }
}

