/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.ExpressionProb;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.visitor.ASTTraverse;
import prism.PrismLangException;

public class ComputeProbNesting
extends ASTTraverse {
    PropertiesFile propertiesFile = null;
    private int currentNesting;
    private int maxNesting;

    public ComputeProbNesting() {
        this(null);
    }

    public ComputeProbNesting(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
        this.currentNesting = 0;
        this.maxNesting = 0;
    }

    public int getMaxNesting() {
        return this.maxNesting;
    }

    @Override
    public void visitPre(ExpressionProb expressionProb) throws PrismLangException {
        ++this.currentNesting;
        this.maxNesting = Math.max(this.maxNesting, this.currentNesting);
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        --this.currentNesting;
    }

    @Override
    public void visitPre(ExpressionReward expressionReward) throws PrismLangException {
        ++this.currentNesting;
        this.maxNesting = Math.max(this.maxNesting, this.currentNesting);
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        --this.currentNesting;
    }

    @Override
    public void visitPre(ExpressionSS expressionSS) throws PrismLangException {
        ++this.currentNesting;
        this.maxNesting = Math.max(this.maxNesting, this.currentNesting);
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        --this.currentNesting;
    }

    @Override
    public void visitPost(ExpressionProp expressionProp) throws PrismLangException {
        if (this.propertiesFile != null) {
            Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
            if (property != null) {
                property.accept(this);
            } else {
                throw new PrismLangException("Unknown property reference " + expressionProp, expressionProp);
            }
        }
    }
}

