/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import prism.PrismLangException;

public enum RelOp {
    GT(">"){

        @Override
        public boolean isLowerBound() {
            return true;
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return bl ? LT : LEQ;
        }
    }
    ,
    GEQ(">="){

        @Override
        public boolean isLowerBound() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return bl ? LEQ : LT;
        }
    }
    ,
    MIN("min="){

        @Override
        public boolean isMin() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return MAX;
        }
    }
    ,
    LT("<"){

        @Override
        public boolean isUpperBound() {
            return true;
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return bl ? GT : GEQ;
        }
    }
    ,
    LEQ("<="){

        @Override
        public boolean isUpperBound() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return bl ? GEQ : GT;
        }
    }
    ,
    MAX("max="){

        @Override
        public boolean isMax() {
            return true;
        }

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            return MIN;
        }
    }
    ,
    EQ("="){

        @Override
        public RelOp negate(boolean bl) throws PrismLangException {
            throw new PrismLangException("Cannot negate " + this);
        }
    };

    private final String symbol;

    private RelOp(String string2) {
        this.symbol = string2;
    }

    public String toString() {
        return this.symbol;
    }

    public boolean isLowerBound() {
        return false;
    }

    public boolean isUpperBound() {
        return false;
    }

    public boolean isStrict() {
        return false;
    }

    public boolean isMin() {
        return false;
    }

    public boolean isMax() {
        return false;
    }

    public RelOp negate() throws PrismLangException {
        return this.negate(false);
    }

    public abstract RelOp negate(boolean var1) throws PrismLangException;

    public static RelOp parseSymbol(String string) {
        for (RelOp relOp : RelOp.values()) {
            if (!relOp.toString().equals(string)) continue;
            return relOp;
        }
        return null;
    }
}

