/*
 * Decompiled with CFR 0.152.
 */
package param;

import common.IterableBitSet;
import common.IterableStateSet;
import explicit.MDPModelChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import param.BigRational;
import param.BoxRegion;
import param.ConstraintChecker;
import param.Function;
import param.FunctionFactory;
import param.Lumper;
import param.MutablePMC;
import param.NullLumper;
import param.ParamMode;
import param.ParamModel;
import param.ParamRewardStruct;
import param.Point;
import param.Region;
import param.RegionFactory;
import param.RegionIntersection;
import param.RegionValues;
import param.RegionValuesIntersections;
import param.RegionsTODO;
import param.Scheduler;
import param.StateEliminator;
import param.StateValues;
import param.StrongLumper;
import param.WeakLumper;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

final class ValueComputer
extends PrismComponent {
    private ParamMode mode;
    private ParamModel model;
    private RegionFactory regionFactory;
    private FunctionFactory functionFactory;
    private ConstraintChecker constraintChecker;
    private BigRational precision;
    private HashMap<SchedulerCacheKey, ArrayList<Scheduler>> schedCache;
    private HashMap<ResultCacheKey, ResultCacheEntry> resultCache;
    private StateEliminator.EliminationOrder eliminationOrder;
    private Lumper.BisimType bisimType;

    ValueComputer(PrismComponent prismComponent, ParamMode paramMode, ParamModel paramModel, RegionFactory regionFactory, BigRational bigRational, StateEliminator.EliminationOrder eliminationOrder, Lumper.BisimType bisimType) {
        super(prismComponent);
        this.mode = paramMode;
        this.model = paramModel;
        this.regionFactory = regionFactory;
        this.functionFactory = regionFactory.getFunctionFactory();
        this.constraintChecker = regionFactory.getConstraintChecker();
        this.precision = bigRational;
        this.schedCache = new HashMap();
        this.resultCache = new HashMap();
        this.eliminationOrder = eliminationOrder;
        this.bisimType = bisimType;
    }

    RegionValues computeUnbounded(RegionValues regionValues, RegionValues regionValues2, boolean bl, ParamRewardStruct paramRewardStruct) throws PrismException {
        RegionValues regionValues3 = new RegionValues(this.regionFactory);
        RegionValuesIntersections regionValuesIntersections = new RegionValuesIntersections(regionValues, regionValues2);
        for (RegionIntersection regionIntersection : regionValuesIntersections) {
            Region region = regionIntersection.getRegion();
            StateValues stateValues = regionIntersection.getStateValues1();
            StateValues stateValues2 = regionIntersection.getStateValues2();
            RegionValues regionValues4 = this.computeUnbounded(region, stateValues, stateValues2, bl, paramRewardStruct);
            regionValues3.addAll(regionValues4);
        }
        return regionValues3;
    }

    private RegionValues computeUnbounded(Region region, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct) throws PrismException {
        if (paramRewardStruct != null) {
            MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
            mDPModelChecker.setSilentPrecomputations(true);
            BitSet bitSet = mDPModelChecker.prob1(this.model, stateValues.toBitSet(), stateValues2.toBitSet(), !bl, null);
            bitSet.flip(0, this.model.getNumStates());
            PrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.model.getNumStates()).iterator();
            while (ofInt.hasNext()) {
                int n = (Integer)ofInt.next();
                stateValues.setStateValue(n, false);
            }
        }
        switch (this.model.getModelType()) {
            case CTMC: 
            case DTMC: {
                return this.computeUnboundedMC(region, stateValues, stateValues2, paramRewardStruct);
            }
            case MDP: {
                if (this.model.getMaxNumChoices() == 1) {
                    return this.computeUnboundedMC(region, stateValues, stateValues2, paramRewardStruct);
                }
                return this.computeUnboundedMDP(region, stateValues, stateValues2, bl, paramRewardStruct);
            }
        }
        throw new PrismNotSupportedException("Parametric unbounded reachability computation not supported for " + this.model.getModelType());
    }

    private RegionValues computeUnboundedMC(Region region, StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct) throws PrismException {
        Scheduler scheduler = new Scheduler(this.model);
        MutablePMC mutablePMC = this.buildAlterablePMCForReach(this.model, stateValues, stateValues2, scheduler, paramRewardStruct);
        if (paramRewardStruct != null && this.mode == ParamMode.EXACT) {
            paramRewardStruct.checkForNonNormalRewards();
        }
        StateValues stateValues3 = this.computeValues(mutablePMC, this.model.getFirstInitialState());
        return this.regionFactory.completeCover(stateValues3);
    }

    private RegionValues computeUnboundedMDP(Region region, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct) throws PrismException {
        BigRational bigRational = region.volume().multiply(this.precision);
        BigRational bigRational2 = region.volume().subtract(bigRational);
        RegionValues regionValues = new RegionValues(this.regionFactory);
        RegionsTODO regionsTODO = new RegionsTODO();
        regionsTODO.add(region);
        BigRational bigRational3 = BigRational.ZERO;
        Scheduler scheduler = new Scheduler(this.model);
        this.precomputeScheduler(this.model, scheduler, stateValues, stateValues2, paramRewardStruct, bl);
        while (bigRational3.compareTo(bigRational2) == -1) {
            Function[] functionArray;
            StateValues stateValues3;
            Region region2 = regionsTODO.poll();
            Point point = ((BoxRegion)region2).getMidPoint();
            Scheduler scheduler2 = this.computeOptConcreteReachScheduler(point, this.model, stateValues, stateValues2, bl, paramRewardStruct, scheduler);
            if (scheduler2 == null) {
                if (region2.volume().compareTo(bigRational) <= 0) {
                    bigRational2 = bigRational2.subtract(region2.volume());
                    continue;
                }
                regionsTODO.addAll(region2.split());
                continue;
            }
            ResultCacheEntry resultCacheEntry = this.lookupValues(PropType.REACH, stateValues, stateValues2, paramRewardStruct, scheduler2, bl);
            if (resultCacheEntry == null) {
                MutablePMC mutablePMC = this.buildAlterablePMCForReach(this.model, stateValues, stateValues2, scheduler2, paramRewardStruct);
                stateValues3 = this.computeValues(mutablePMC, this.model.getFirstInitialState());
                functionArray = this.computeCompare(stateValues, stateValues2, paramRewardStruct, scheduler2, bl, stateValues3);
                this.storeValues(PropType.REACH, stateValues, stateValues2, paramRewardStruct, scheduler2, bl, stateValues3, functionArray);
            } else {
                stateValues3 = resultCacheEntry.getValues();
                functionArray = resultCacheEntry.getCompare();
            }
            boolean bl2 = true;
            Function function = null;
            Function[] functionArray2 = functionArray;
            int n = functionArray2.length;
            for (int i = 0; i < n; ++i) {
                Function function2;
                function = function2 = functionArray2[i];
                if (this.constraintChecker.check(region2, function2, false)) continue;
                bl2 = false;
            }
            if (bl2) {
                bigRational3 = bigRational3.add(region2.volume());
                regionValues.add(region2, stateValues3);
                continue;
            }
            regionsTODO.addAll(region2.split(function));
        }
        return regionValues;
    }

    private Function[] computeCompare(StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct, Scheduler scheduler, boolean bl, StateValues stateValues3) {
        HashSet<Function> hashSet = new HashSet<Function>();
        for (int i = 0; i < this.model.getNumStates(); ++i) {
            if (!stateValues.getStateValueAsBoolean(i) || stateValues2.getStateValueAsBoolean(i)) continue;
            Function function = stateValues3.getStateValueAsFunction(i);
            for (int j = this.model.stateBegin(i); j < this.model.stateEnd(i); ++j) {
                Function function2 = paramRewardStruct == null ? this.functionFactory.getZero() : paramRewardStruct.getReward(j);
                for (int k = this.model.choiceBegin(j); k < this.model.choiceEnd(j); ++k) {
                    int n = this.model.succState(k);
                    Function function3 = this.model.succProb(k).multiply(stateValues3.getStateValueAsFunction(n));
                    function2 = function2.add(function3);
                }
                function2 = bl ? function2.subtract(function) : function.subtract(function2);
                hashSet.add(function2);
            }
        }
        return hashSet.toArray(new Function[0]);
    }

    private void storeValues(PropType propType, StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct, Scheduler scheduler, boolean bl, StateValues stateValues3, Function[] functionArray) {
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, paramRewardStruct, scheduler, bl);
        ResultCacheEntry resultCacheEntry = new ResultCacheEntry(stateValues3, functionArray);
        this.resultCache.put(resultCacheKey, resultCacheEntry);
    }

    private ResultCacheEntry lookupValues(PropType propType, StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct, Scheduler scheduler, boolean bl) {
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, paramRewardStruct, scheduler, bl);
        ResultCacheEntry resultCacheEntry = this.resultCache.get(resultCacheKey);
        return resultCacheEntry;
    }

    Scheduler computeOptConcreteReachScheduler(Point point, ParamModel paramModel, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct, Scheduler scheduler) throws PrismException {
        ParamModel paramModel2 = paramModel.instantiate(point, true);
        if (paramModel2 == null) {
            return null;
        }
        ParamRewardStruct paramRewardStruct2 = null;
        if (paramRewardStruct != null && (paramRewardStruct2 = paramRewardStruct.instantiate(point)).hasNegativeRewards()) {
            if (this.mode == ParamMode.EXACT) {
                throw new PrismNotSupportedException(this.mode.Engine() + " currently does not support negative rewards in reachability reward computations");
            }
            return null;
        }
        Scheduler scheduler2 = this.lookupScheduler(point, paramModel2, PropType.REACH, stateValues, stateValues2, bl, paramRewardStruct2);
        if (scheduler2 != null) {
            return scheduler2;
        }
        scheduler2 = scheduler.clone();
        boolean bl2 = true;
        while (bl2) {
            int n;
            MutablePMC mutablePMC = this.buildAlterablePMCForReach(paramModel2, stateValues, stateValues2, scheduler2, paramRewardStruct);
            StateValues stateValues3 = this.computeValues(mutablePMC, paramModel2.getFirstInitialState());
            BigRational[] bigRationalArray = new BigRational[stateValues3.getNumStates()];
            for (n = 0; n < paramModel2.getNumStates(); ++n) {
                bigRationalArray[n] = stateValues3.getStateValueAsFunction(n).asBigRational();
            }
            bl2 = false;
            for (n = 0; n < paramModel2.getNumStates(); ++n) {
                if (!stateValues.getStateValueAsBoolean(n) || stateValues2.getStateValueAsBoolean(n)) continue;
                BigRational bigRational = bigRationalArray[n];
                for (int i = paramModel2.stateBegin(n); i < paramModel2.stateEnd(n); ++i) {
                    BigRational bigRational2 = BigRational.ZERO;
                    for (int j = paramModel2.choiceBegin(i); j < paramModel2.choiceEnd(i); ++j) {
                        int n2 = paramModel2.succState(j);
                        BigRational bigRational3 = paramModel2.succProb(j).asBigRational();
                        BigRational bigRational4 = bigRationalArray[n2];
                        BigRational bigRational5 = bigRational3.multiply(bigRational4);
                        bigRational2 = bigRational2.add(bigRational5);
                    }
                    if (paramRewardStruct != null) {
                        bigRational2 = bigRational2.add(paramRewardStruct.getReward(i).asBigRational());
                    }
                    if (bigRational.compareTo(bigRational2) != (bl ? 1 : -1)) continue;
                    scheduler2.setChoice(n, i);
                    bigRational = bigRational2;
                    bl2 = true;
                }
            }
        }
        this.storeScheduler(PropType.REACH, stateValues, stateValues2, bl, paramRewardStruct, scheduler2);
        return scheduler2;
    }

    private void storeScheduler(PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct, Scheduler scheduler) {
        SchedulerCacheKey schedulerCacheKey = new SchedulerCacheKey(propType, stateValues, stateValues2, bl, paramRewardStruct, null);
        ArrayList<Scheduler> arrayList = this.schedCache.get(schedulerCacheKey);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.schedCache.put(schedulerCacheKey, arrayList);
        }
        arrayList.add(scheduler);
    }

    private Scheduler lookupScheduler(Point point, ParamModel paramModel, PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct) {
        SchedulerCacheKey schedulerCacheKey = new SchedulerCacheKey(propType, stateValues, stateValues2, bl, paramRewardStruct, null);
        ArrayList<Scheduler> arrayList = this.schedCache.get(schedulerCacheKey);
        if (arrayList == null) {
            return null;
        }
        for (Scheduler scheduler : arrayList) {
            if (!this.checkScheduler(point, propType, stateValues, stateValues2, bl, paramRewardStruct, scheduler)) continue;
            return scheduler;
        }
        return null;
    }

    private boolean checkScheduler(Point point, PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct, Scheduler scheduler) {
        Function[] functionArray;
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, paramRewardStruct, scheduler, bl);
        ResultCacheEntry resultCacheEntry = this.resultCache.get(resultCacheKey);
        for (Function function : functionArray = resultCacheEntry.getCompare()) {
            if (function.evaluate(point, false).signum() != -1) continue;
            return false;
        }
        return true;
    }

    private void precomputeScheduler(ParamModel paramModel, Scheduler scheduler, StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct, boolean bl) throws PrismException {
        if (paramRewardStruct == null) {
            if (bl) {
                this.precomputePmin(paramModel, scheduler, stateValues, stateValues2);
            }
        } else if (bl) {
            this.precomputeRminProperScheduler(paramModel, scheduler, stateValues, stateValues2);
        }
    }

    private void precomputeRminProperScheduler(ParamModel paramModel, Scheduler scheduler, StateValues stateValues, StateValues stateValues2) throws PrismException {
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.setSilentPrecomputations(true);
        int[] nArray = new int[paramModel.getNumStates()];
        BitSet bitSet = stateValues.toBitSet();
        mDPModelChecker.prob1(paramModel, bitSet, stateValues2.toBitSet(), false, nArray);
        PrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            assert (nArray[n] >= 0);
            scheduler.setChoice(n, paramModel.stateBegin(n) + nArray[n]);
        }
    }

    private void precomputePmin(ParamModel paramModel, Scheduler scheduler, StateValues stateValues, StateValues stateValues2) {
        int n;
        BitSet bitSet = new BitSet(paramModel.getNumStates());
        for (n = 0; n < paramModel.getNumStates(); ++n) {
            bitSet.set(n, stateValues2.getStateValueAsBoolean(n));
        }
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < paramModel.getNumStates(); ++i) {
                if (!stateValues.getStateValueAsBoolean(i) || bitSet.get(i)) continue;
                boolean bl = true;
                for (int j = paramModel.stateBegin(i); j < paramModel.stateEnd(i); ++j) {
                    boolean bl2 = false;
                    for (int k = paramModel.choiceBegin(j); k < paramModel.choiceEnd(j); ++k) {
                        if (!bitSet.get(paramModel.succState(k))) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    scheduler.setChoice(i, j);
                    bl = false;
                }
                if (!bl) continue;
                bitSet.set(i, true);
                n = 1;
            }
        }
    }

    private MutablePMC buildAlterablePMCForReach(ParamModel paramModel, StateValues stateValues, StateValues stateValues2, Scheduler scheduler, ParamRewardStruct paramRewardStruct) {
        MutablePMC mutablePMC = new MutablePMC(this.functionFactory, paramModel.getNumStates(), paramRewardStruct != null, false);
        for (int i = 0; i < paramModel.getNumStates(); ++i) {
            int n;
            boolean bl = stateValues2.getStateValueAsBoolean(i);
            boolean bl2 = bl || !stateValues.getStateValueAsBoolean(i);
            int n2 = scheduler.getChoice(i);
            mutablePMC.setTargetState(i, bl);
            mutablePMC.setInitState(i, paramModel.isInitialState(i));
            if (bl2) {
                mutablePMC.addTransition(i, i, this.functionFactory.getOne());
                if (null == paramRewardStruct) continue;
                if (bl) {
                    mutablePMC.setReward(i, this.functionFactory.getZero());
                    continue;
                }
                mutablePMC.setReward(i, this.functionFactory.getInf());
                continue;
            }
            if (paramRewardStruct != null) {
                mutablePMC.setReward(i, paramRewardStruct.getReward(n2));
            }
            Function function = this.functionFactory.getZero();
            for (n = paramModel.choiceBegin(n2); n < paramModel.choiceEnd(n2); ++n) {
                function = function.add(paramModel.succProb(n));
            }
            for (n = paramModel.choiceBegin(n2); n < paramModel.choiceEnd(n2); ++n) {
                mutablePMC.addTransition(i, paramModel.succState(n), paramModel.succProb(n).divide(function));
            }
        }
        return mutablePMC;
    }

    private MutablePMC buildAlterablePMCForSteady(ParamModel paramModel, StateValues stateValues, Scheduler scheduler, ParamRewardStruct paramRewardStruct) {
        MutablePMC mutablePMC = new MutablePMC(this.functionFactory, paramModel.getNumStates(), true, true);
        for (int i = 0; i < paramModel.getNumStates(); ++i) {
            int n = scheduler.getChoice(i);
            mutablePMC.setTargetState(i, false);
            mutablePMC.setInitState(i, paramModel.isInitialState(i));
            Function function = paramModel.sumLeaving(n);
            if (paramRewardStruct != null) {
                mutablePMC.setReward(i, paramRewardStruct.getReward(n));
            } else {
                mutablePMC.setReward(i, stateValues.getStateValueAsBoolean(i) ? this.functionFactory.getOne().divide(function) : this.functionFactory.getZero());
            }
            for (int j = paramModel.choiceBegin(n); j < paramModel.choiceEnd(n); ++j) {
                mutablePMC.addTransition(i, paramModel.succState(j), paramModel.succProb(j));
            }
            mutablePMC.setTime(i, this.functionFactory.getOne().divide(function));
        }
        return mutablePMC;
    }

    private StateValues computeValues(MutablePMC mutablePMC, int n) {
        Lumper lumper;
        switch (this.bisimType) {
            case NULL: {
                lumper = new NullLumper(mutablePMC);
                break;
            }
            case STRONG: {
                lumper = new StrongLumper(mutablePMC);
                break;
            }
            case WEAK: {
                if (mutablePMC.isUseRewards()) {
                    lumper = new StrongLumper(mutablePMC);
                    break;
                }
                lumper = new WeakLumper(mutablePMC);
                break;
            }
            default: {
                throw new RuntimeException("invalid bisimulation method");
            }
        }
        if (lumper instanceof WeakLumper && mutablePMC.isUseTime()) {
            lumper = new StrongLumper(mutablePMC);
        }
        MutablePMC mutablePMC2 = lumper.getQuotient();
        StateEliminator stateEliminator = new StateEliminator(mutablePMC2, this.eliminationOrder);
        stateEliminator.eliminate();
        int[] nArray = lumper.getOriginalToOptimised();
        StateValues stateValues = new StateValues(mutablePMC.getNumStates(), n);
        for (int i = 0; i < nArray.length; ++i) {
            stateValues.setStateValue(i, stateEliminator.getResult(nArray[i]));
        }
        return stateValues;
    }

    private RegionValues computeSteadyState(Region region, StateValues stateValues, boolean bl, ParamRewardStruct paramRewardStruct) {
        StateValues stateValues2;
        RegionValues regionValues = new RegionValues(this.regionFactory);
        Scheduler scheduler = new Scheduler(this.model);
        ResultCacheEntry resultCacheEntry = this.lookupValues(PropType.STEADY, stateValues, null, paramRewardStruct, scheduler, bl);
        if (resultCacheEntry == null) {
            MutablePMC mutablePMC = this.buildAlterablePMCForSteady(this.model, stateValues, scheduler, paramRewardStruct);
            stateValues2 = this.computeValues(mutablePMC, this.model.getFirstInitialState());
            this.storeValues(PropType.STEADY, stateValues, null, paramRewardStruct, scheduler, bl, stateValues2, null);
        } else {
            stateValues2 = resultCacheEntry.getValues();
        }
        regionValues.add(region, stateValues2);
        return regionValues;
    }

    public RegionValues computeSteadyState(RegionValues regionValues, boolean bl, ParamRewardStruct paramRewardStruct) {
        RegionValues regionValues2 = new RegionValues(this.regionFactory);
        for (Map.Entry<Region, StateValues> entry : regionValues) {
            Region region = entry.getKey();
            StateValues stateValues = entry.getValue();
            RegionValues regionValues3 = this.computeSteadyState(region, stateValues, bl, paramRewardStruct);
            regionValues2.addAll(regionValues3);
        }
        return regionValues2;
    }

    class ResultCacheEntry {
        private final StateValues values;
        private final Function[] compare;

        ResultCacheEntry(StateValues stateValues, Function[] functionArray) {
            this.values = stateValues;
            this.compare = functionArray;
        }

        StateValues getValues() {
            return this.values;
        }

        Function[] getCompare() {
            return this.compare;
        }
    }

    class ResultCacheKey {
        private final PropType propType;
        private final BitSet b1;
        private final BitSet b2;
        private final ParamRewardStruct rew;
        private final Scheduler sched;
        private final boolean min;

        ResultCacheKey(PropType propType, StateValues stateValues, StateValues stateValues2, ParamRewardStruct paramRewardStruct, Scheduler scheduler, boolean bl) {
            this.propType = propType;
            this.b1 = stateValues.toBitSet();
            this.b2 = stateValues2 == null ? null : stateValues2.toBitSet();
            this.rew = paramRewardStruct;
            this.sched = scheduler;
            this.min = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ResultCacheKey)) {
                return false;
            }
            ResultCacheKey resultCacheKey = (ResultCacheKey)object;
            if (!this.propType.equals((Object)resultCacheKey.propType)) {
                return false;
            }
            if (!this.b1.equals(resultCacheKey.b1)) {
                return false;
            }
            if (this.b2 == null != (resultCacheKey.b2 == null)) {
                return false;
            }
            if (this.b2 != null && !this.b2.equals(resultCacheKey.b2)) {
                return false;
            }
            if (this.rew == null != (resultCacheKey.rew == null)) {
                return false;
            }
            if (this.rew != null && !this.rew.equals(resultCacheKey.rew)) {
                return false;
            }
            if (!this.sched.equals(resultCacheKey.sched)) {
                return false;
            }
            return this.min == resultCacheKey.min;
        }

        public int hashCode() {
            int n = 0;
            switch (this.propType) {
                case REACH: {
                    n = 13;
                    break;
                }
                case STEADY: {
                    n = 17;
                }
            }
            n = this.b1.hashCode() + (n << 6) + (n << 16) - n;
            if (this.b2 != null) {
                n = this.b2.hashCode() + (n << 6) + (n << 16) - n;
            }
            n = (this.rew == null ? 0 : this.rew.hashCode()) + (n << 6) + (n << 16) - n;
            n = this.sched.hashCode() + (n << 6) + (n << 16) - n;
            n = (this.min ? 13 : 17) + (n << 6) + (n << 16) - n;
            return n;
        }
    }

    class SchedulerCacheKey {
        private final PropType propType;
        private final BitSet b1;
        private final BitSet b2;
        private final boolean min;
        private final ParamRewardStruct rew;

        SchedulerCacheKey(PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, ParamRewardStruct paramRewardStruct, Region region) {
            this.propType = propType;
            this.b1 = stateValues.toBitSet();
            this.b2 = stateValues2 == null ? null : stateValues2.toBitSet();
            this.min = bl;
            this.rew = paramRewardStruct;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SchedulerCacheKey)) {
                return false;
            }
            SchedulerCacheKey schedulerCacheKey = (SchedulerCacheKey)object;
            if (!this.propType.equals((Object)schedulerCacheKey.propType)) {
                return false;
            }
            if (!this.b1.equals(schedulerCacheKey.b1)) {
                return false;
            }
            if (this.b2 == null != (schedulerCacheKey.b2 == null)) {
                return false;
            }
            if (this.b2 != null && !this.b2.equals(schedulerCacheKey.b2)) {
                return false;
            }
            if (this.rew == null != (schedulerCacheKey.rew == null)) {
                return false;
            }
            if (this.rew != null && !this.rew.equals(schedulerCacheKey.rew)) {
                return false;
            }
            return this.min == schedulerCacheKey.min;
        }

        public int hashCode() {
            int n = 0;
            switch (this.propType) {
                case REACH: {
                    n = 13;
                    break;
                }
                case STEADY: {
                    n = 17;
                }
            }
            n = (this.b1 == null ? 0 : this.b1.hashCode()) + (n << 6) + (n << 16) - n;
            if (this.b2 != null) {
                n = (this.b2 == null ? 0 : this.b2.hashCode()) + (n << 6) + (n << 16) - n;
            }
            n = (this.min ? 13 : 17) + (n << 6) + (n << 16) - n;
            n = (this.rew == null ? 0 : this.rew.hashCode()) + (n << 6) + (n << 16) - n;
            return n;
        }
    }

    private static enum PropType {
        REACH,
        STEADY;

    }
}

