/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.Function;
import param.FunctionFactory;
import param.ModelBuilder;
import param.ParamMode;
import param.Point;
import param.RegionValues;
import parser.Values;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;

public class ParamResult {
    private ParamMode mode;
    private RegionValues regionValues;
    private ModelBuilder modelBuilder;
    private FunctionFactory factory;

    public ParamResult(ParamMode paramMode, RegionValues regionValues, ModelBuilder modelBuilder, FunctionFactory functionFactory) {
        this.mode = paramMode;
        this.regionValues = regionValues;
        this.modelBuilder = modelBuilder;
        this.factory = functionFactory;
    }

    public RegionValues getRegionValues() {
        return this.regionValues;
    }

    public String toString() {
        return this.regionValues.toString();
    }

    public Object getSimpleResult(Type type) throws PrismException {
        if (this.regionValues.getNumRegions() != 1) {
            throw new PrismException("Unexpected result from " + this.mode + " model checker");
        }
        if (type.equals(TypeBool.getInstance())) {
            boolean bl = this.regionValues.getResult(0).getInitStateValueAsBoolean();
            return bl;
        }
        Function function = this.regionValues.getResult(0).getInitStateValueAsFunction();
        BigRational bigRational = function.evaluate(new Point(new BigRational[]{new BigRational(0L)}));
        return bigRational;
    }

    public boolean test(Type type, String string, Values values) throws PrismException {
        Expression expression = null;
        try {
            expression = Prism.parseSingleExpressionString(string);
            ConstantList constantList = new ConstantList(values);
            for (String string2 : this.modelBuilder.getParameterNames()) {
                constantList.addConstant(new ExpressionIdent(string2), null, TypeDouble.getInstance());
            }
            expression.findAllConstants(constantList);
            expression.typeCheck();
            expression = (Expression)expression.evaluatePartially(values, null);
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("Invalid RESULT specification \"" + string + "\" for property: " + prismLangException.getMessage());
        }
        return this.test(type, expression, string);
    }

    private boolean test(Type type, Expression expression, String string) throws PrismException {
        if (this.regionValues.getNumRegions() != 1) {
            throw new PrismNotSupportedException("Testing " + this.mode + " results with multiple regions not supported");
        }
        if (type.equals(TypeBool.getInstance())) {
            boolean bl;
            boolean bl2 = this.regionValues.getResult(0).getInitStateValueAsBoolean();
            if (bl2 != (bl = expression.evaluateExact().toBoolean())) {
                throw new PrismException("Wrong result (expected " + string + ", got " + bl2 + ")");
            }
        } else {
            Function function;
            try {
                function = this.modelBuilder.expr2function(this.factory, expression);
            }
            catch (PrismException prismException) {
                throw new PrismException("Invalid (or unsupported) RESULT specification \"" + string + "\" for " + this.mode + " property");
            }
            Function function2 = this.regionValues.getResult(0).getInitStateValueAsFunction();
            if (!function2.equals(function)) {
                throw new PrismException("Wrong result (expected " + string + " = " + function + ", got " + function2 + ")");
            }
        }
        return true;
    }
}

