/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Model;
import explicit.Product;
import explicit.rewards.StateRewards;
import java.util.ArrayList;

public class StateRewardsSimple
extends StateRewards {
    protected ArrayList<Double> stateRewards;

    public StateRewardsSimple() {
        this.stateRewards = new ArrayList();
    }

    public StateRewardsSimple(StateRewardsSimple stateRewardsSimple) {
        if (stateRewardsSimple.stateRewards == null) {
            this.stateRewards = null;
        } else {
            int n = stateRewardsSimple.stateRewards.size();
            this.stateRewards = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.stateRewards.add(stateRewardsSimple.stateRewards.get(i));
            }
        }
    }

    public void setStateReward(int n, double d) {
        if (d == 0.0 && n >= this.stateRewards.size()) {
            return;
        }
        int n2 = n - this.stateRewards.size() + 1;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.stateRewards.add(0.0);
            }
        }
        this.stateRewards.set(n, d);
    }

    @Override
    public double getStateReward(int n) {
        try {
            return this.stateRewards.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0.0;
        }
    }

    @Override
    public StateRewards liftFromModel(Product<? extends Model> product) {
        Model model = product.getProductModel();
        int n = model.getNumStates();
        StateRewardsSimple stateRewardsSimple = new StateRewardsSimple();
        for (int i = 0; i < n; ++i) {
            stateRewardsSimple.setStateReward(i, this.getStateReward(product.getModelState(i)));
        }
        return stateRewardsSimple;
    }

    @Override
    public StateRewardsSimple deepCopy() {
        return new StateRewardsSimple(this);
    }
}

