/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Model;
import explicit.Product;
import explicit.rewards.StateRewards;

public class StateRewardsArray
extends StateRewards {
    protected double[] stateRewards = null;

    public StateRewardsArray(int n) {
        this.stateRewards = new double[n];
        for (int i = 0; i < n; ++i) {
            this.stateRewards[i] = 0.0;
        }
    }

    public StateRewardsArray(StateRewardsArray stateRewardsArray) {
        int n = stateRewardsArray.stateRewards.length;
        this.stateRewards = new double[n];
        for (int i = 0; i < n; ++i) {
            this.stateRewards[i] = stateRewardsArray.stateRewards[i];
        }
    }

    public void setStateReward(int n, double d) {
        this.stateRewards[n] = d;
    }

    public void addToStateReward(int n, double d) {
        int n2 = n;
        this.stateRewards[n2] = this.stateRewards[n2] + d;
    }

    @Override
    public double getStateReward(int n) {
        return this.stateRewards[n];
    }

    @Override
    public StateRewards liftFromModel(Product<? extends Model> product) {
        Model model = product.getProductModel();
        int n = model.getNumStates();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        for (int i = 0; i < n; ++i) {
            stateRewardsArray.setStateReward(i, this.stateRewards[product.getModelState(i)]);
        }
        return stateRewardsArray;
    }

    @Override
    public StateRewardsArray deepCopy() {
        return new StateRewardsArray(this);
    }
}

