/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Bisimulation;
import explicit.CTMCModelChecker;
import explicit.CTMDPModelChecker;
import explicit.DTMCModelChecker;
import explicit.LTLModelChecker;
import explicit.MDPModelChecker;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.ProbModelChecker;
import explicit.STPGModelChecker;
import explicit.StateValues;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTTraverseModify;
import parser.visitor.ReplaceLabels;
import prism.Filter;
import prism.Interval;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.Result;
import prism.RewardGenerator;

public class StateModelChecker
extends PrismComponent {
    protected int verbosity = 0;
    protected boolean exportTarget = false;
    protected String exportTargetFilename = null;
    protected boolean exportProductTrans = false;
    protected String exportProductTransFilename = null;
    protected boolean exportProductStates = false;
    protected String exportProductStatesFilename = null;
    protected boolean exportProductVector = false;
    protected String exportProductVectorFilename = null;
    protected boolean storeVector = false;
    protected boolean genStrat = false;
    protected boolean restrictStratToReach = true;
    protected boolean doBisim = false;
    protected boolean doTopologicalValueIteration = false;
    protected boolean doPmaxQuotient = false;
    protected boolean doIntervalIteration = false;
    protected ModulesFile modulesFile = null;
    protected ModelInfo modelInfo = null;
    protected RewardGenerator rewardGen = null;
    protected PropertiesFile propertiesFile = null;
    protected Values constantValues;
    protected Filter currentFilter;
    protected Result result;

    public StateModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (prismComponent == null || prismComponent.getSettings() == null) {
            this.setSettings(null);
        }
        if (this.settings != null) {
            this.verbosity = this.settings.getBoolean("prism.verbose") ? 10 : 1;
            this.setDoIntervalIteration(this.settings.getBoolean("prism.intervalIter"));
            this.setDoTopologicalValueIteration(this.settings.getBoolean("prism.topologicalVI"));
            this.setDoPmaxQuotient(this.settings.getBoolean("prism.pmaxQuotient"));
        }
    }

    public static StateModelChecker createModelChecker(ModelType modelType) throws PrismException {
        return StateModelChecker.createModelChecker(modelType, null);
    }

    public static StateModelChecker createModelChecker(ModelType modelType, PrismComponent prismComponent) throws PrismException {
        ProbModelChecker probModelChecker = null;
        switch (modelType) {
            case DTMC: {
                probModelChecker = new DTMCModelChecker(prismComponent);
                break;
            }
            case MDP: {
                probModelChecker = new MDPModelChecker(prismComponent);
                break;
            }
            case CTMC: {
                probModelChecker = new CTMCModelChecker(prismComponent);
                break;
            }
            case CTMDP: {
                probModelChecker = new CTMDPModelChecker(prismComponent);
                break;
            }
            case STPG: {
                probModelChecker = new STPGModelChecker(prismComponent);
                break;
            }
            default: {
                throw new PrismException("Cannot create model checker for model type " + modelType);
            }
        }
        return probModelChecker;
    }

    public void inheritSettings(StateModelChecker stateModelChecker) {
        this.setModelCheckingInfo(stateModelChecker.modelInfo, stateModelChecker.propertiesFile, stateModelChecker.rewardGen);
        this.setLog(stateModelChecker.getLog());
        this.setVerbosity(stateModelChecker.getVerbosity());
        this.setExportTarget(stateModelChecker.getExportTarget());
        this.setExportTargetFilename(stateModelChecker.getExportTargetFilename());
        this.setExportProductTrans(stateModelChecker.getExportProductTrans());
        this.setExportProductTransFilename(stateModelChecker.getExportProductTransFilename());
        this.setExportProductStates(stateModelChecker.getExportProductStates());
        this.setExportProductStatesFilename(stateModelChecker.getExportProductStatesFilename());
        this.setExportProductVector(stateModelChecker.getExportProductVector());
        this.setExportProductVectorFilename(stateModelChecker.getExportProductVectorFilename());
        this.setStoreVector(stateModelChecker.getStoreVector());
        this.setGenStrat(stateModelChecker.getGenStrat());
        this.setRestrictStratToReach(stateModelChecker.getRestrictStratToReach());
        this.setDoBisim(stateModelChecker.getDoBisim());
        this.setDoIntervalIteration(stateModelChecker.getDoIntervalIteration());
        this.setDoPmaxQuotient(stateModelChecker.getDoPmaxQuotient());
    }

    public void printSettings() {
        this.mainLog.print("verbosity = " + this.verbosity + " ");
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public void setExportTarget(boolean bl) {
        this.exportTarget = bl;
    }

    public void setExportTargetFilename(String string) {
        this.exportTargetFilename = string;
    }

    public void setExportProductTrans(boolean bl) {
        this.exportProductTrans = bl;
    }

    public void setExportProductTransFilename(String string) {
        this.exportProductTransFilename = string;
    }

    public void setExportProductStates(boolean bl) {
        this.exportProductStates = bl;
    }

    public void setExportProductStatesFilename(String string) {
        this.exportProductStatesFilename = string;
    }

    public void setExportProductVector(boolean bl) {
        this.exportProductVector = bl;
    }

    public void setExportProductVectorFilename(String string) {
        this.exportProductVectorFilename = string;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setGenStrat(boolean bl) {
        this.genStrat = bl;
    }

    public void setRestrictStratToReach(boolean bl) {
        this.restrictStratToReach = bl;
    }

    public void setDoBisim(boolean bl) {
        this.doBisim = bl;
    }

    public void setDoTopologicalValueIteration(boolean bl) {
        this.doTopologicalValueIteration = bl;
    }

    public void setDoPmaxQuotient(boolean bl) {
        this.doPmaxQuotient = bl;
    }

    public void setDoIntervalIteration(boolean bl) {
        this.doIntervalIteration = bl;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public boolean getExportTarget() {
        return this.exportTarget;
    }

    public String getExportTargetFilename() {
        return this.exportTargetFilename;
    }

    public boolean getExportProductTrans() {
        return this.exportProductTrans;
    }

    public String getExportProductTransFilename() {
        return this.exportProductTransFilename;
    }

    public boolean getExportProductStates() {
        return this.exportProductStates;
    }

    public String getExportProductStatesFilename() {
        return this.exportProductStatesFilename;
    }

    public boolean getExportProductVector() {
        return this.exportProductVector;
    }

    public String getExportProductVectorFilename() {
        return this.exportProductVectorFilename;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean getGenStrat() {
        return this.genStrat;
    }

    public boolean getRestrictStratToReach() {
        return this.restrictStratToReach;
    }

    public boolean getDoBisim() {
        return this.doBisim;
    }

    public boolean getDoTopologicalValueIteration() {
        return this.doTopologicalValueIteration;
    }

    public boolean getDoPmaxQuotient() {
        return this.doPmaxQuotient;
    }

    public boolean getDoIntervalIteration() {
        return this.doIntervalIteration;
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    public LabelList getLabelList() {
        if (this.propertiesFile != null) {
            return this.propertiesFile.getCombinedLabelList();
        }
        if (this.modulesFile != null) {
            return this.modulesFile.getLabelList();
        }
        return null;
    }

    public Set<String> getDefinedLabelNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        LabelList labelList = this.getLabelList();
        if (labelList != null) {
            treeSet.addAll(labelList.getLabelNames());
        }
        if (this.modelInfo != null) {
            treeSet.addAll(this.modelInfo.getLabelNames());
        }
        return treeSet;
    }

    public void setModelCheckingInfo(ModelInfo modelInfo, PropertiesFile propertiesFile, RewardGenerator rewardGenerator) {
        this.modelInfo = modelInfo;
        if (modelInfo instanceof ModulesFile) {
            this.modulesFile = (ModulesFile)modelInfo;
        }
        this.propertiesFile = propertiesFile;
        this.rewardGen = rewardGenerator;
        this.constantValues = new Values();
        if (modelInfo != null) {
            this.constantValues.addValues(modelInfo.getConstantValues());
        }
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
    }

    public Result check(Model model, Expression expression) throws PrismException {
        Object object;
        long l = 0L;
        this.result = new Result();
        this.currentFilter = null;
        if (this.storeVector) {
            object = new ExpressionFilter("store", expression);
            ((ExpressionFilter)object).setInvisible(true);
            ((ASTElement)object).typeCheck();
            expression = object;
        }
        expression = ExpressionFilter.addDefaultFilterIfNeeded(expression, model.getNumInitialStates() == 1);
        if (this.doBisim) {
            this.mainLog.println("\nPerforming bisimulation minimisation...");
            object = new ArrayList();
            ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
            Expression expression2 = this.checkMaximalPropositionalFormulas(model, expression.deepCopy(), (List<String>)object, arrayList);
            Bisimulation bisimulation = new Bisimulation(this);
            model = bisimulation.minimise(model, (List<String>)object, arrayList);
            this.mainLog.println("Modified property: " + expression2);
            expression = expression2;
        }
        l = System.currentTimeMillis();
        StateValues stateValues = this.checkExpression(model, expression, null);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model checking: " + (double)l / 1000.0 + " seconds.");
        Object object2 = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object2 = (String)object2 + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object2 = (String)object2 + ": " + this.result.getResultString();
        this.mainLog.print("\n" + (String)object2 + "\n");
        return this.result;
    }

    public StateValues checkExpression(Model model, Expression expression, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        if (expression instanceof ExpressionITE) {
            stateValues = this.checkExpressionITE(model, (ExpressionITE)expression, bitSet);
        } else if (expression instanceof ExpressionBinaryOp) {
            stateValues = this.checkExpressionBinaryOp(model, (ExpressionBinaryOp)expression, bitSet);
        } else if (expression instanceof ExpressionUnaryOp) {
            stateValues = this.checkExpressionUnaryOp(model, (ExpressionUnaryOp)expression, bitSet);
        } else if (expression instanceof ExpressionFunc) {
            stateValues = this.checkExpressionFunc(model, (ExpressionFunc)expression, bitSet);
        } else {
            if (expression instanceof ExpressionIdent) {
                throw new PrismException("Unknown identifier \"" + ((ExpressionIdent)expression).getName() + "\"");
            }
            if (expression instanceof ExpressionLiteral) {
                stateValues = this.checkExpressionLiteral(model, (ExpressionLiteral)expression);
            } else if (expression instanceof ExpressionConstant) {
                stateValues = this.checkExpressionConstant(model, (ExpressionConstant)expression);
            } else {
                if (expression instanceof ExpressionFormula) {
                    if (((ExpressionFormula)expression).getDefinition() != null) {
                        return this.checkExpression(model, ((ExpressionFormula)expression).getDefinition(), bitSet);
                    }
                    throw new PrismException("Unexpanded formula \"" + ((ExpressionFormula)expression).getName() + "\"");
                }
                if (expression instanceof ExpressionVar) {
                    stateValues = this.checkExpressionVar(model, (ExpressionVar)expression, bitSet);
                } else if (expression instanceof ExpressionLabel) {
                    stateValues = this.checkExpressionLabel(model, (ExpressionLabel)expression, bitSet);
                } else if (expression instanceof ExpressionProp) {
                    stateValues = this.checkExpressionProp(model, (ExpressionProp)expression, bitSet);
                } else if (expression instanceof ExpressionFilter) {
                    stateValues = this.checkExpressionFilter(model, (ExpressionFilter)expression, bitSet);
                } else {
                    throw new PrismNotSupportedException("Couldn't check " + expression.getClass());
                }
            }
        }
        return stateValues;
    }

    protected StateValues checkExpressionITE(Model model, ExpressionITE expressionITE, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        try {
            stateValues = this.checkExpression(model, expressionITE.getOperand1(), bitSet);
            stateValues2 = this.checkExpression(model, expressionITE.getOperand2(), bitSet);
            stateValues3 = this.checkExpression(model, expressionITE.getOperand3(), bitSet);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        stateValues3.applyITE(stateValues, stateValues2);
        stateValues.clear();
        stateValues2.clear();
        return stateValues3;
    }

    protected StateValues checkExpressionBinaryOp(Model model, ExpressionBinaryOp expressionBinaryOp, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionBinaryOp.getOperator();
        try {
            stateValues = this.checkExpression(model, expressionBinaryOp.getOperand1(), bitSet);
            stateValues2 = this.checkExpression(model, expressionBinaryOp.getOperand2(), bitSet);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        stateValues.applyBinaryOp(n, stateValues2);
        stateValues2.clear();
        return stateValues;
    }

    protected StateValues checkExpressionUnaryOp(Model model, ExpressionUnaryOp expressionUnaryOp, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        int n = expressionUnaryOp.getOperator();
        stateValues = this.checkExpression(model, expressionUnaryOp.getOperand(), bitSet);
        if (n == 3) {
            return stateValues;
        }
        stateValues.applyUnaryOp(n);
        return stateValues;
    }

    protected StateValues checkExpressionFunc(Model model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: {
                return this.checkExpressionFuncNary(model, expressionFunc, bitSet);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.checkExpressionFuncUnary(model, expressionFunc, bitSet);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.checkExpressionFuncBinary(model, expressionFunc, bitSet);
            }
            case 8: {
                throw new PrismNotSupportedException("Multi-objective model checking is not supported for " + model.getModelType() + "s with the explicit engine");
            }
        }
        throw new PrismException("Unrecognised function \"" + expressionFunc.getName() + "\"");
    }

    protected StateValues checkExpressionFuncUnary(Model model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
        try {
            stateValues.applyFunctionUnary(n);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (prismException instanceof PrismLangException) {
                ((PrismLangException)prismException).setASTElement(expressionFunc);
            }
            throw prismException;
        }
        return stateValues;
    }

    protected StateValues checkExpressionFuncBinary(Model model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionFunc.getNameCode();
        try {
            stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
            stateValues2 = this.checkExpression(model, expressionFunc.getOperand(1), bitSet);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        try {
            stateValues.applyFunctionBinary(n, stateValues2);
            stateValues2.clear();
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            if (prismException instanceof PrismLangException) {
                ((PrismLangException)prismException).setASTElement(expressionFunc);
            }
            throw prismException;
        }
        return stateValues;
    }

    protected StateValues checkExpressionFuncNary(Model model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
        int n2 = expressionFunc.getNumOperands();
        for (int i = 1; i < n2; ++i) {
            try {
                stateValues2 = this.checkExpression(model, expressionFunc.getOperand(i), bitSet);
            }
            catch (PrismException prismException) {
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                throw prismException;
            }
            try {
                stateValues.applyFunctionBinary(n, stateValues2);
                stateValues2.clear();
                continue;
            }
            catch (PrismException prismException) {
                if (stateValues != null) {
                    stateValues.clear();
                }
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                if (prismException instanceof PrismLangException) {
                    ((PrismLangException)prismException).setASTElement(expressionFunc);
                }
                throw prismException;
            }
        }
        return stateValues;
    }

    protected StateValues checkExpressionLiteral(Model model, ExpressionLiteral expressionLiteral) throws PrismException {
        return new StateValues(expressionLiteral.getType(), expressionLiteral.evaluate(), model);
    }

    protected StateValues checkExpressionConstant(Model model, ExpressionConstant expressionConstant) throws PrismException {
        return new StateValues(expressionConstant.getType(), expressionConstant.evaluate(this.constantValues), model);
    }

    protected StateValues checkExpressionVar(Model model, ExpressionVar expressionVar, BitSet bitSet) throws PrismException {
        StateValues stateValues;
        block4: {
            List<State> list;
            int n;
            block5: {
                block3: {
                    n = model.getNumStates();
                    stateValues = new StateValues(expressionVar.getType(), model);
                    list = model.getStatesList();
                    if (!(expressionVar.getType() instanceof TypeBool)) break block3;
                    for (int i = 0; i < n; ++i) {
                        stateValues.setBooleanValue(i, expressionVar.evaluateBoolean(list.get(i)));
                    }
                    break block4;
                }
                if (!(expressionVar.getType() instanceof TypeInt)) break block5;
                for (int i = 0; i < n; ++i) {
                    stateValues.setIntValue(i, expressionVar.evaluateInt(list.get(i)));
                }
                break block4;
            }
            if (!(expressionVar.getType() instanceof TypeDouble)) break block4;
            for (int i = 0; i < n; ++i) {
                stateValues.setDoubleValue(i, expressionVar.evaluateDouble(list.get(i)));
            }
        }
        return stateValues;
    }

    protected StateValues checkExpressionLabel(Model model, ExpressionLabel expressionLabel, BitSet bitSet) throws PrismException {
        int n;
        if (expressionLabel.isDeadlockLabel()) {
            int n2 = model.getNumStates();
            BitSet bitSet2 = new BitSet(n2);
            for (int i = 0; i < n2; ++i) {
                bitSet2.set(i, model.isDeadlockState(i));
            }
            return StateValues.createFromBitSet(bitSet2, model);
        }
        if (expressionLabel.isInitLabel()) {
            int n3 = model.getNumStates();
            BitSet bitSet3 = new BitSet(n3);
            for (int i = 0; i < n3; ++i) {
                bitSet3.set(i, model.isInitialState(i));
            }
            return StateValues.createFromBitSet(bitSet3, model);
        }
        BitSet bitSet4 = model.getLabelStates(expressionLabel.getName());
        if (bitSet4 != null) {
            return StateValues.createFromBitSet((BitSet)bitSet4.clone(), model);
        }
        LabelList labelList = this.getLabelList();
        if (labelList != null && (n = labelList.getLabelIndex(expressionLabel.getName())) != -1) {
            return this.checkExpression(model, labelList.getLabel(n), bitSet);
        }
        throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\"");
    }

    protected StateValues checkExpressionProp(Model model, ExpressionProp expressionProp, BitSet bitSet) throws PrismException {
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            this.mainLog.println("\nModel checking : " + property);
            return this.checkExpression(model, property.getExpression(), bitSet);
        }
        throw new PrismException("Unknown property reference " + expressionProp);
    }

    protected StateValues checkExpressionFilter(Model model, ExpressionFilter expressionFilter, BitSet bitSet) throws PrismException {
        ExpressionFilter.FilterOperator filterOperator;
        boolean bl;
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        String string = (bl = Expression.isTrue(expression)) ? "all states" : "states satisfying filter";
        BitSet bitSet2 = this.checkExpression(model, expression, null).getBitSet();
        if (bitSet2.isEmpty()) {
            throw new PrismException("Filter satisfies no states");
        }
        boolean bl2 = expression instanceof ExpressionLabel && ((ExpressionLabel)expression).isInitLabel();
        boolean bl3 = bl2 & model.getNumInitialStates() == 1;
        if (!bl2 && !expressionFilter.isInvisible()) {
            this.mainLog.println("\nStates satisfying filter " + expression + ": " + bitSet2.cardinality());
        }
        if ((filterOperator = expressionFilter.getOperatorType()) == ExpressionFilter.FilterOperator.FIRST) {
            bitSet2.clear(bitSet2.nextSetBit(0) + 1, bitSet2.length());
        }
        if (filterOperator == ExpressionFilter.FilterOperator.STATE) {
            if (bitSet2.cardinality() != 1) {
                Object object = "Filter should be satisfied in exactly 1 state";
                object = (String)object + " (but \"" + expression + "\" is true in " + bitSet2.cardinality() + " states)";
                throw new PrismException((String)object);
            }
            this.currentFilter = new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0));
        } else {
            this.currentFilter = filterOperator == ExpressionFilter.FilterOperator.FORALL && bl2 && bl3 ? new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0)) : (filterOperator == ExpressionFilter.FilterOperator.FIRST && bl2 && bl3 ? new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0)) : null);
        }
        StateValues stateValues = this.checkExpression(model, expressionFilter.getOperand(), bitSet2);
        StateValues stateValues2 = null;
        BitSet bitSet3 = null;
        BitSet bitSet4 = null;
        boolean bl4 = false;
        Object object = null;
        Object object2 = null;
        switch (filterOperator) {
            case PRINT: 
            case PRINTALL: {
                if (expressionFilter.getType() instanceof TypeBool) {
                    this.mainLog.print("\nSatisfying states");
                    this.mainLog.println((String)(bl ? ":" : " that are also in filter " + expression + ":"));
                    stateValues.printFiltered(this.mainLog, bitSet2);
                } else if (filterOperator == ExpressionFilter.FilterOperator.PRINT) {
                    this.mainLog.println("\nResults (non-zero only) for filter " + expression + ":");
                    stateValues.printFiltered(this.mainLog, bitSet2);
                } else {
                    this.mainLog.println("\nResults (including zeros) for filter " + expression + ":");
                    stateValues.printFiltered(this.mainLog, bitSet2, false, false, true, true);
                }
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case STORE: {
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case MIN: {
                object2 = stateValues.minOverBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Minimum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + object2);
                bitSet3 = stateValues.getBitSetFromCloseValue(object2, 1.0E-5, false);
                bitSet3.and(bitSet2);
                break;
            }
            case MAX: {
                object2 = stateValues.maxOverBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Maximum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + object2);
                bitSet3 = stateValues.getBitSetFromCloseValue(object2, 1.0E-5, false);
                bitSet3.and(bitSet2);
                break;
            }
            case ARGMIN: {
                object2 = stateValues.minOverBitSet(bitSet2);
                this.mainLog.print("\nMinimum value over " + string + ": " + object2);
                bitSet3 = stateValues.getBitSetFromCloseValue(object2, 1.0E-5, false);
                bitSet3.and(bitSet2);
                stateValues2 = StateValues.createFromBitSet(bitSet3, model);
                this.mainLog.println("\nNumber of states with minimum value: " + bitSet3.cardinality());
                bitSet3 = null;
                break;
            }
            case ARGMAX: {
                object2 = stateValues.maxOverBitSet(bitSet2);
                this.mainLog.print("\nMaximum value over " + string + ": " + object2);
                bitSet3 = stateValues.getBitSetFromCloseValue(object2, 1.0E-5, false);
                bitSet3.and(bitSet2);
                stateValues2 = StateValues.createFromBitSet(bitSet3, model);
                this.mainLog.println("\nNumber of states with maximum value: " + bitSet3.cardinality());
                bitSet3 = null;
                break;
            }
            case COUNT: {
                int n = stateValues.countOverBitSet(bitSet2);
                object2 = new Integer(n);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = bl ? "Count of satisfying states" : "Count of satisfying states also in filter";
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            case SUM: {
                object2 = stateValues.sumOverBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Sum over " + string;
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            case AVG: {
                object2 = stateValues.averageOverBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Average over " + string;
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            case FIRST: {
                object2 = stateValues.firstFromBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Value in ";
                object = bl2 ? (String)object + (bl3 ? "the initial state" : "first initial state") : (String)object + (bl ? "the first state" : "first state satisfying filter");
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            case RANGE: {
                object2 = new Interval(stateValues.minOverBitSet(bitSet2), stateValues.maxOverBitSet(bitSet2));
                stateValues2 = stateValues;
                stateValues = null;
                object = "Range of values over ";
                object = (String)object + (bl2 ? "initial states" : string);
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            case FORALL: {
                bitSet4 = stateValues.getBitSet();
                bl4 = stateValues.forallOverBitSet(bitSet2);
                object2 = new Boolean(bl4);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Property " + (bl4 ? "" : "not ") + "satisfied in ";
                this.mainLog.print("\nProperty satisfied in " + stateValues.countOverBitSet(bitSet2));
                if (bl2) {
                    object = bl3 ? (String)object + "the initial state" : (String)object + "all initial states";
                    this.mainLog.println(" of " + model.getNumInitialStates() + " initial states.");
                    break;
                }
                if (bl) {
                    object = (String)object + "all states";
                    this.mainLog.println(" of all " + model.getNumStates() + " states.");
                    break;
                }
                object = (String)object + "all filter states";
                this.mainLog.println(" of " + bitSet2.cardinality() + " filter states.");
                break;
            }
            case EXISTS: {
                bitSet4 = stateValues.getBitSet();
                bl4 = stateValues.existsOverBitSet(bitSet2);
                object2 = new Boolean(bl4);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Property satisfied in ";
                object = bl ? (String)object + (bl4 ? "at least one state" : "no states") : (String)object + (bl4 ? "at least one filter state" : "no filter states");
                this.mainLog.println("\n" + (String)object);
                break;
            }
            case STATE: {
                object2 = stateValues.firstFromBitSet(bitSet2);
                stateValues2 = new StateValues(expressionFilter.getType(), object2, model);
                object = "Value in ";
                object = bl2 ? (String)object + "the initial state" : (String)object + "the filter state";
                this.mainLog.println("\n" + (String)object + ": " + object2);
                break;
            }
            default: {
                throw new PrismException("Unrecognised filter type \"" + expressionFilter.getOperatorName() + "\"");
            }
        }
        if (bitSet3 != null) {
            boolean bl5;
            StateValues stateValues3 = StateValues.createFromBitSet(bitSet3, model);
            this.mainLog.print("\nThere are " + bitSet3.cardinality() + " states with ");
            this.mainLog.print((expressionFilter.getType() instanceof TypeDouble ? "(approximately) " : "") + "this value");
            boolean bl6 = bl5 = this.verbosity > 0;
            if (!bl5 && bitSet3.cardinality() > 10) {
                this.mainLog.print(".\nThe first 10 states are displayed below. To view them all, enable verbose mode or use a print filter.\n");
                stateValues3.print(this.mainLog, 10);
            } else {
                this.mainLog.print(":\n");
                stateValues3.print(this.mainLog);
            }
        }
        this.result.setResult(object2);
        if (expressionFilter.getExplanationEnabled() && object != null) {
            this.result.setExplanation(((String)object).toLowerCase());
        } else {
            this.result.setExplanation(null);
        }
        if (filterOperator == ExpressionFilter.FilterOperator.STORE) {
            this.result.setVector(stateValues2);
        }
        if (stateValues != null && !Expression.isFilter(expressionFilter.getOperand(), ExpressionFilter.FilterOperator.STORE)) {
            stateValues.clear();
        }
        return stateValues2;
    }

    public Expression handleMaximalStateFormulas(ModelExplicit modelExplicit, Expression expression) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        Expression expression2 = lTLModelChecker.checkMaximalStateFormulas(this, modelExplicit, expression.deepCopy(), vector);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "L" + i;
            String string2 = modelExplicit.addUniqueLabel("phi", vector.get(i), this.getDefinedLabelNames());
            hashMap.put(string, string2);
        }
        return (Expression)expression2.accept(new ReplaceLabels(hashMap));
    }

    public Expression checkMaximalPropositionalFormulas(Model model, Expression expression, List<String> list, List<BitSet> list2) throws PrismException {
        Expression expression2 = (Expression)expression.accept(new CheckMaximalPropositionalFormulas(this, model, list, list2));
        return expression2;
    }

    public static Map<String, BitSet> loadLabelsFile(String string) throws PrismException {
        HashMap<String, BitSet> hashMap;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
        try {
            int n;
            int n2;
            int n3;
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                bufferedReader.close();
                throw new PrismException("Empty labels file");
            }
            String[] stringArray = string2.split(" ");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string2 = stringArray[n3];
                n2 = string2.indexOf(61);
                if (n2 < 0) {
                    bufferedReader.close();
                    throw new PrismException("Corrupt labels file (line 1)");
                }
                n = Integer.parseInt(string2.substring(0, n2));
                while (arrayList.size() <= n) {
                    arrayList.add("?");
                }
                arrayList.set(n, string2.substring(n2 + 2, string2.length() - 1));
            }
            BitSet[] bitSetArray = new BitSet[arrayList.size()];
            for (n3 = 0; n3 < bitSetArray.length; ++n3) {
                bitSetArray[n3] = new BitSet();
            }
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(":");
                    n3 = Integer.parseInt(stringArray[0].trim());
                    stringArray = stringArray[1].trim().split(" ");
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (stringArray[n2].length() == 0) continue;
                        n = Integer.parseInt(stringArray[n2]);
                        bitSetArray[n].set(n3);
                    }
                }
                string2 = bufferedReader.readLine();
            }
            HashMap<String, BitSet> hashMap2 = new HashMap<String, BitSet>();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                if (((String)arrayList.get(n3)).equals("?")) continue;
                hashMap2.put((String)arrayList.get(n3), bitSetArray[n3]);
            }
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new PrismException("Error reading labels file \"" + string + "\"");
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Error in labels file");
            }
        }
        bufferedReader.close();
        return hashMap;
    }

    public void exportLabels(Model model, List<String> list, int n, PrismLog prismLog) throws PrismException {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        for (String string : list) {
            StateValues stateValues = this.checkExpression(model, new ExpressionLabel(string), null);
            arrayList.add(stateValues.getBitSet());
        }
        this.exportLabels(model, arrayList, list, n, prismLog);
    }

    public void exportLabels(Model model, List<BitSet> list, List<String> list2, int n, PrismLog prismLog) {
        int n2;
        String string = "l";
        int n3 = model.getNumStates();
        int n4 = list.size();
        if (n == 4) {
            prismLog.println("#DECLARATION");
        }
        block15: for (n2 = 0; n2 < n4; ++n2) {
            switch (n) {
                case 1: {
                    prismLog.print((n2 > 0 ? " " : "") + n2 + "=\"" + list2.get(n2) + "\"");
                    continue block15;
                }
                case 2: {
                    prismLog.println(string + "_" + list2.get(n2) + "=sparse(" + n3 + ",1);");
                    continue block15;
                }
                case 4: {
                    prismLog.print((n2 > 0 ? " " : "") + list2.get(n2));
                }
            }
        }
        prismLog.println();
        if (n == 4) {
            prismLog.println("#END");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl = true;
            block17: for (int i = 0; i < n4; ++i) {
                if (!list.get(i).get(n2)) continue;
                if (bl) {
                    switch (n) {
                        case 1: {
                            prismLog.print(n2 + ":");
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 4: {
                            prismLog.print(n2 + 1);
                        }
                    }
                    bl = false;
                }
                switch (n) {
                    case 1: {
                        prismLog.print(" " + i);
                        continue block17;
                    }
                    case 2: {
                        prismLog.println(string + "_" + list2.get(i) + "(" + (n2 + 1) + ")=1;");
                        continue block17;
                    }
                    case 4: {
                        prismLog.print(" " + list2.get(i));
                    }
                }
            }
            if (bl || n == 2) continue;
            prismLog.println();
        }
    }

    class CheckMaximalPropositionalFormulas
    extends ASTTraverseModify {
        private StateModelChecker mc;
        private Model model;
        private List<String> propNames;
        private List<BitSet> propBSs;

        public CheckMaximalPropositionalFormulas(StateModelChecker stateModelChecker2, Model model, List<String> list, List<BitSet> list2) {
            this.mc = stateModelChecker2;
            this.model = model;
            this.propNames = list;
            this.propBSs = list2;
        }

        @Override
        public Object visit(ExpressionITE expressionITE) throws PrismLangException {
            return expressionITE.getType() instanceof TypeBool && expressionITE.isProposition() ? this.replaceWithLabel(expressionITE) : super.visit(expressionITE);
        }

        @Override
        public Object visit(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
            return expressionBinaryOp.getType() instanceof TypeBool && expressionBinaryOp.isProposition() ? this.replaceWithLabel(expressionBinaryOp) : super.visit(expressionBinaryOp);
        }

        @Override
        public Object visit(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
            return expressionUnaryOp.getType() instanceof TypeBool && expressionUnaryOp.isProposition() ? this.replaceWithLabel(expressionUnaryOp) : super.visit(expressionUnaryOp);
        }

        @Override
        public Object visit(ExpressionFunc expressionFunc) throws PrismLangException {
            return expressionFunc.getType() instanceof TypeBool && expressionFunc.isProposition() ? this.replaceWithLabel(expressionFunc) : super.visit(expressionFunc);
        }

        @Override
        public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
            return expressionIdent.getType() instanceof TypeBool && expressionIdent.isProposition() ? this.replaceWithLabel(expressionIdent) : super.visit(expressionIdent);
        }

        @Override
        public Object visit(ExpressionLiteral expressionLiteral) throws PrismLangException {
            return expressionLiteral.getType() instanceof TypeBool && expressionLiteral.isProposition() ? this.replaceWithLabel(expressionLiteral) : super.visit(expressionLiteral);
        }

        @Override
        public Object visit(ExpressionConstant expressionConstant) throws PrismLangException {
            return expressionConstant.getType() instanceof TypeBool && expressionConstant.isProposition() ? this.replaceWithLabel(expressionConstant) : super.visit(expressionConstant);
        }

        @Override
        public Object visit(ExpressionFormula expressionFormula) throws PrismLangException {
            return expressionFormula.getType() instanceof TypeBool && expressionFormula.isProposition() ? this.replaceWithLabel(expressionFormula) : super.visit(expressionFormula);
        }

        @Override
        public Object visit(ExpressionVar expressionVar) throws PrismLangException {
            return expressionVar.getType() instanceof TypeBool && expressionVar.isProposition() ? this.replaceWithLabel(expressionVar) : super.visit(expressionVar);
        }

        @Override
        public Object visit(ExpressionLabel expressionLabel) throws PrismLangException {
            return expressionLabel.getType() instanceof TypeBool && expressionLabel.isProposition() ? this.replaceWithLabel(expressionLabel) : super.visit(expressionLabel);
        }

        @Override
        public Object visit(ExpressionProp expressionProp) throws PrismLangException {
            Property property = StateModelChecker.this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
            if (property != null) {
                return expressionProp.accept(this);
            }
            throw new PrismLangException("Unknown property reference " + expressionProp, expressionProp);
        }

        @Override
        public Object visit(ExpressionFilter expressionFilter) throws PrismLangException {
            return expressionFilter.getType() instanceof TypeBool && expressionFilter.isProposition() ? this.replaceWithLabel(expressionFilter) : super.visit(expressionFilter);
        }

        private Object replaceWithLabel(Expression expression) throws PrismLangException {
            StateValues stateValues;
            try {
                stateValues = this.mc.checkExpression(this.model, expression, null);
            }
            catch (PrismException prismException) {
                throw new PrismLangException(prismException.getMessage());
            }
            BitSet bitSet = stateValues.getBitSet();
            if (bitSet.isEmpty()) {
                return Expression.False();
            }
            if (bitSet.cardinality() == this.model.getNumStates()) {
                return Expression.True();
            }
            int n = this.propBSs.indexOf(bitSet);
            if (n != -1) {
                stateValues.clear();
                return new ExpressionLabel("L" + n);
            }
            String string = "L" + this.propBSs.size();
            this.propNames.add(string);
            this.propBSs.add(bitSet);
            return new ExpressionLabel(string);
        }
    }
}

