/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.ProbModelChecker;
import explicit.STPG;
import explicit.STPGAbstrSimple;
import explicit.StateModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.STPGRewards;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import parser.ast.Expression;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class STPGModelChecker
extends ProbModelChecker {
    public STPGModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismNotSupportedException("LTL model checking not yet supported for stochastic games");
    }

    public ModelCheckerResult computeNextProbs(STPG sTPG, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = sTPG.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        sTPG.mvMultMinMax(dArray, bl, bl2, dArray2, null, false, null);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachProbs(STPG sTPG, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        return this.computeReachProbs(sTPG, null, bitSet, bl, bl2, null, null);
    }

    public ModelCheckerResult computeUntilProbs(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) throws PrismException {
        return this.computeReachProbs(sTPG, bitSet, bitSet2, bl, bl2, null, null);
    }

    public ModelCheckerResult computeReachProbs(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        if (!(this.solnMethod != ProbModelChecker.SolnMethod.VALUE_ITERATION || this.valIterDir != ProbModelChecker.ValIterDir.ABOVE || this.precomp && this.prob0)) {
            throw new PrismException("Precomputation (Prob0) must be enabled for value iteration from above");
        }
        boolean bl3 = this.exportAdv;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting probabilistic reachability...");
        }
        sTPG.checkForDeadlocks(bitSet2);
        int n = sTPG.getNumStates();
        if (dArray != null && bitSet3 != null && !bitSet3.isEmpty()) {
            BitSet bitSet4 = (BitSet)bitSet2.clone();
            PrimitiveIterator.OfInt ofInt = new IterableBitSet(bitSet3).iterator();
            while (ofInt.hasNext()) {
                int n2 = (Integer)ofInt.next();
                if (dArray[n2] != 1.0) continue;
                bitSet4.set(n2);
            }
            bitSet2 = bitSet4;
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet5 = this.precomp && this.prob0 ? this.prob0(sTPG, bitSet, bitSet2, bl, bl2) : new BitSet();
        l2 = System.currentTimeMillis() - l2;
        long l3 = System.currentTimeMillis();
        BitSet bitSet6 = this.precomp && this.prob1 && !bl3 ? this.prob1(sTPG, bitSet, bitSet2, bl, bl2) : (BitSet)bitSet2.clone();
        l3 = System.currentTimeMillis() - l3;
        int n3 = bitSet6.cardinality();
        int n4 = bitSet5.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n - (n3 + n4)));
        }
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachProbsValIter(sTPG, bitSet5, bitSet6, bl, bl2, dArray, bitSet3);
                break;
            }
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachProbsGaussSeidel(sTPG, bitSet5, bitSet6, bl, bl2, dArray, bitSet3);
                break;
            }
            default: {
                throw new PrismException("Unknown STPG solution method " + this.solnMethod);
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l3) / 1000.0;
        return modelCheckerResult;
    }

    public BitSet prob0(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting Prob0 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(sTPG.getNumStates());
            bitSet3.set(0, sTPG.getNumStates());
            return bitSet3;
        }
        int n = sTPG.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl3) {
            ++n2;
            sTPG.prob0step(bitSet6, bitSet4, bl, bl2, bitSet5);
            bl3 = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Prob0 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet4;
    }

    public BitSet prob1(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting Prob1 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            return new BitSet(sTPG.getNumStates());
        }
        int n = sTPG.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet3.set(0, n);
        while (!bl3) {
            boolean bl4 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl4) {
                ++n2;
                sTPG.prob1step(bitSet6, bitSet3, bitSet4, bl, bl2, bitSet5);
                bl4 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Prob1 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet3;
    }

    protected ModelCheckerResult computeReachProbsValIter(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        boolean bl3 = this.exportAdv;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray2 = new double[n3];
        double[] dArray3 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                    dArray2[n2] = dArray3[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                    dArray2[n2] = dArray3[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
                dArray2[n2] = dArray3[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (bl3) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = -1;
            }
        }
        boolean bl4 = false;
        for (n = 0; !bl4 && n < this.maxIters; ++n) {
            sTPG.mvMultMinMax(dArray2, bl, bl2, dArray3, bitSet4, false, (int[])(bl3 ? nArray : null));
            bl4 = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl4 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        if (bl3) {
            PrismFileLog prismFileLog = new PrismFileLog(this.exportAdvFilename);
            for (n2 = 0; n2 < n3; ++n2) {
                prismFileLog.println(n2 + " " + (nArray[n2] != -1 ? sTPG.getAction(n2, nArray[n2]) : "-"));
            }
            ((PrismLog)prismFileLog).println();
            ((PrismLog)prismFileLog).close();
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(STPG sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray2 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n < this.maxIters; ++n) {
            double d3 = sTPG.mvMultGSMinMax(dArray2, bl, bl2, bitSet4, false, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            bl3 = d3 < this.termCritParam;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public List<Integer> probReachStrategy(STPG sTPG, int n, BitSet bitSet, boolean bl, boolean bl2, double[] dArray) throws PrismException {
        double d = sTPG.mvMultMinMaxSingle(n, dArray, bl, bl2);
        return sTPG.mvMultMinMaxSingleChoices(n, dArray, bl, bl2, d);
    }

    public ModelCheckerResult computeBoundedReachProbs(STPG sTPG, BitSet bitSet, int n, boolean bl, boolean bl2) throws PrismException {
        return this.computeBoundedReachProbs(sTPG, null, bitSet, n, bl, bl2, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(STPG sTPG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2) throws PrismException {
        return this.computeBoundedReachProbs(sTPG, bitSet, bitSet2, n, bl, bl2, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(STPG sTPG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        double[] dArray3;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting bounded probabilistic reachability...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray3 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray3[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray3[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray3, sTPG.getInitialStates(), bl2);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            sTPG.mvMultMinMax(dArray4, bl, bl2, dArray3, bitSet2, true, null);
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray3, sTPG.getInitialStates(), bl2);
            }
            double[] dArray6 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray6;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Bounded probabilistic reachability (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(STPG sTPG, STPGRewards sTPGRewards, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        return this.computeReachRewards(sTPG, sTPGRewards, bitSet, bl, bl2, null, null);
    }

    public ModelCheckerResult computeReachRewards(STPG sTPG, STPGRewards sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        sTPG.checkForDeadlocks(bitSet);
        int n = sTPG.getNumStates();
        if (dArray != null && bitSet2 != null && !bitSet2.isEmpty()) {
            BitSet bitSet3 = (BitSet)bitSet.clone();
            PrimitiveIterator.OfInt ofInt = new IterableBitSet(bitSet2).iterator();
            while (ofInt.hasNext()) {
                int n2 = (Integer)ofInt.next();
                if (dArray[n2] != 1.0) continue;
                bitSet3.set(n2);
            }
            bitSet = bitSet3;
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet4 = this.prob1(sTPG, null, bitSet, !bl, !bl2);
        bitSet4.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        int n3 = bitSet.cardinality();
        int n4 = bitSet4.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n - (n3 + n4)));
        }
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(sTPG, sTPGRewards, bitSet, bitSet4, bl, bl2, dArray, bitSet2);
                break;
            }
            default: {
                throw new PrismException("Unknown STPG solution method " + this.solnMethod);
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsValIter(STPG sTPG, STPGRewards sTPGRewards, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double[] dArray2;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray3 = new double[n3];
        double[] dArray4 = dArray2 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]));
                    dArray3[n2] = dArray2[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]);
                    dArray3[n2] = dArray2[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : 0.0);
                dArray3[n2] = dArray2[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n < this.maxIters; ++n) {
            sTPG.mvMultRewMinMax(dArray3, sTPGRewards, bl, bl2, dArray2, bitSet4, false, null);
            bl3 = PrismUtils.doublesAreClose(dArray3, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray5 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = true;
        try {
            STPGModelChecker sTPGModelChecker = new STPGModelChecker(null);
            STPGAbstrSimple sTPGAbstrSimple = new STPGAbstrSimple();
            sTPGAbstrSimple.buildFromPrismExplicit(stringArray[0]);
            sTPGAbstrSimple.addInitialState(0);
            Map<String, BitSet> map = StateModelChecker.loadLabelsFile(stringArray[1]);
            BitSet bitSet = map.get(stringArray[2]);
            if (bitSet == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 3; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-minmin")) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-maxmin")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-minmax")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (!stringArray[i].equals("-maxmax")) continue;
                bl = false;
                bl2 = false;
            }
            ModelCheckerResult modelCheckerResult = sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, bitSet, bl, bl2);
            System.out.println(modelCheckerResult.soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

