/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedMessage;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TaggedSocketChannel
extends Thread {
    private static final Logger logger = Logger.getLogger(TaggedSocketChannel.class);
    private static final boolean debug = logger.isDebugEnabled();
    private volatile boolean isRunning = false;
    private static final String DONE = "TaggedSocketChannel Done";
    private final AtomicInteger blockedCount;
    protected final SocketChannel sc;
    protected final Map<Integer, BlockingQueue> queues;

    public TaggedSocketChannel(SocketChannel socketChannel) {
        this.sc = socketChannel;
        this.blockedCount = new AtomicInteger(0);
        this.queues = new HashMap<Integer, BlockingQueue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map<Integer, BlockingQueue> map = this.queues;
        synchronized (map) {
            if (!this.isRunning) {
                this.start();
                this.isRunning = true;
            }
        }
        logger.info("TaggedSocketChannel at " + this.sc);
    }

    public SocketChannel getSocket() {
        return this.sc;
    }

    public void send(Integer n, Object object) throws IOException {
        if (n == null) {
            throw new IllegalArgumentException("tag null not allowed");
        }
        if (object instanceof Exception) {
            throw new IllegalArgumentException("message " + object + " not allowed");
        }
        TaggedMessage taggedMessage = new TaggedMessage(n, object);
        this.sc.send(taggedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receive(Integer n) throws InterruptedException, IOException, ClassNotFoundException {
        Map<Integer, BlockingQueue<Object>> map;
        BlockingQueue blockingQueue = null;
        int n2 = 0;
        do {
            map = this.queues;
            synchronized (map) {
                blockingQueue = this.queues.get(n);
                if (blockingQueue == null) {
                    if (!this.isRunning) {
                        throw new IOException("receiver not running for " + this);
                    }
                    try {
                        logger.debug("receive wait, tag = " + n);
                        n2 = this.blockedCount.incrementAndGet();
                        this.queues.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.info("receive wait exception, tag = " + n + ", blockedCount = " + n2);
                        throw interruptedException;
                    }
                    finally {
                        n2 = this.blockedCount.decrementAndGet();
                    }
                }
            }
        } while (blockingQueue == null);
        map = null;
        try {
            n2 = this.blockedCount.incrementAndGet();
            map = blockingQueue.take();
        }
        finally {
            n2 = this.blockedCount.decrementAndGet();
        }
        if (map instanceof IOException) {
            throw (IOException)((Object)map);
        }
        if (map instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)((Object)map);
        }
        if (map instanceof Exception) {
            throw new IOException(map.toString());
        }
        return map;
    }

    public void close() {
        this.terminate();
    }

    @Override
    public String toString() {
        return "socketChannel(" + this.sc + ", tags = " + this.queues.keySet() + ")";
    }

    public int tagSize() {
        return this.queues.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int messages() {
        int n = 0;
        Map<Integer, BlockingQueue> map = this.queues;
        synchronized (map) {
            for (BlockingQueue blockingQueue : this.queues.values()) {
                n += blockingQueue.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        Map<Integer, BlockingQueue> map;
        Object object;
        if (this.sc == null) {
            this.isRunning = false;
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Serializable serializable;
                object = null;
                try {
                    logger.debug("waiting for tagged object");
                    object = this.sc.receive();
                    if (this.isInterrupted()) {
                        this.isRunning = false;
                    }
                }
                catch (IOException iOException) {
                    object = iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = classNotFoundException;
                }
                catch (Exception exception) {
                    object = exception;
                }
                logger.debug("object recieved");
                if (object instanceof TaggedMessage) {
                    map = (TaggedMessage)object;
                    serializable = null;
                    Map<Integer, BlockingQueue> map2 = this.queues;
                    synchronized (map2) {
                        serializable = this.queues.get(((TaggedMessage)((Object)map)).tag);
                        if (serializable == null) {
                            serializable = new LinkedBlockingQueue<Object>();
                            this.queues.put(((TaggedMessage)((Object)map)).tag, (BlockingQueue)((Object)serializable));
                            this.queues.notifyAll();
                        }
                    }
                    serializable.put(((TaggedMessage)((Object)map)).msg);
                    continue;
                }
                if (object instanceof Exception) {
                    if (debug) {
                        logger.debug("exception " + object);
                    }
                    map = this.queues;
                    synchronized (map) {
                        this.isRunning = false;
                        for (BlockingQueue blockingQueue : this.queues.values()) {
                            int n2 = this.blockedCount.get();
                            for (n = 0; n <= n2; ++n) {
                                blockingQueue.put(object);
                            }
                            if (n2 <= 0) continue;
                            logger.debug("put exception to queue, blockedCount = " + n2);
                        }
                        this.queues.notifyAll();
                        continue;
                    }
                }
                if (debug) {
                    logger.debug("no tagged message and no exception " + object);
                }
                map = this.queues;
                synchronized (map) {
                    this.isRunning = false;
                    serializable = object.equals(DONE) ? new Exception("DONE message") : new IllegalArgumentException("no tagged message and no exception '" + object + "'");
                    for (BlockingQueue blockingQueue : this.queues.values()) {
                        n = this.blockedCount.get();
                        for (int i = 0; i <= n; ++i) {
                            blockingQueue.put(serializable);
                        }
                        if (n <= 0) continue;
                        logger.debug("put '" + ((Throwable)serializable).toString() + "' to queue, blockedCount = " + n);
                    }
                    this.queues.notifyAll();
                }
                if (!object.equals(DONE)) continue;
                logger.info("run terminating by request");
                try {
                    this.sc.send(DONE);
                }
                catch (IOException iOException) {
                    logger.warn("send other done failed " + iOException);
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                if (debug) {
                    logger.debug("exception " + interruptedException);
                }
                map = this.queues;
                synchronized (map) {
                    this.isRunning = false;
                    for (BlockingQueue blockingQueue : this.queues.values()) {
                        try {
                            int n3 = this.blockedCount.get();
                            for (n = 0; n <= n3; ++n) {
                                blockingQueue.put(interruptedException);
                            }
                            if (n3 <= 0) continue;
                            logger.debug("put interrupted to queue, blockCount = " + n3);
                        }
                        catch (InterruptedException interruptedException2) {}
                    }
                    this.queues.notifyAll();
                }
            }
        }
        if (this.isInterrupted()) {
            object = new InterruptedException("terminating via interrupt");
            map = this.queues;
            synchronized (map) {
                for (BlockingQueue blockingQueue : this.queues.values()) {
                    try {
                        int n4 = this.blockedCount.get();
                        for (n = 0; n <= n4; ++n) {
                            blockingQueue.put(object);
                        }
                        if (n4 <= 0) continue;
                        logger.debug("put terminating via interrupt to queue, blockCount = " + n4);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.queues.notifyAll();
            }
        }
        logger.info("run terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.isRunning = false;
        this.interrupt();
        if (this.sc != null) {
            try {
                this.sc.send(DONE);
            }
            catch (IOException iOException) {
                logger.warn("send done failed " + iOException);
            }
            logger.debug(this.sc + " not yet closed");
        }
        this.interrupt();
        Map<Integer, BlockingQueue> map = this.queues;
        synchronized (map) {
            this.isRunning = false;
            for (Map.Entry<Integer, BlockingQueue> entry : this.queues.entrySet()) {
                BlockingQueue blockingQueue = entry.getValue();
                if (blockingQueue.size() != 0) {
                    logger.info("queue for tag " + entry.getKey() + " not empty " + blockingQueue);
                }
                int n = 0;
                try {
                    n = this.blockedCount.get();
                    for (int i = 0; i <= n; ++i) {
                        blockingQueue.put(new IOException("queue terminate"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= 0) continue;
                logger.debug("put IO-end to queue for tag " + entry.getKey() + ", blockCount = " + n);
            }
            this.queues.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("terminated");
    }
}

