/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.DHTListener;
import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistHashTable<K, V>
extends AbstractMap<K, V> {
    private static final Logger logger = Logger.getLogger(DistHashTable.class);
    private static boolean debug = logger.isDebugEnabled();
    protected final SortedMap<K, V> theList;
    protected final ChannelFactory cf;
    protected SocketChannel channel = null;
    protected DHTListener<K, V> listener = null;

    public DistHashTable(String string) {
        this(string, 9009);
    }

    public DistHashTable(String string, int n) {
        this(new ChannelFactory(n + 1), string, n);
    }

    public DistHashTable(ChannelFactory channelFactory, String string, int n) {
        this.cf = channelFactory;
        channelFactory.init();
        try {
            this.channel = channelFactory.getChannel(string, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        if (debug) {
            logger.debug("dl channel = " + this.channel);
        }
        this.theList = new TreeMap();
        this.listener = new DHTListener<K, V>(this.channel, this.theList);
    }

    public DistHashTable(SocketChannel socketChannel) {
        this.cf = null;
        this.channel = socketChannel;
        this.theList = new TreeMap();
        this.listener = new DHTListener<K, V>(this.channel, this.theList);
    }

    @Override
    public int hashCode() {
        return this.theList.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.theList.equals(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.theList.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.theList.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return new ArrayList<V>(this.theList.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> getValueList() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return new ArrayList<V>(this.theList.values());
        }
    }

    public SortedMap<K, V> getList() {
        return this.theList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<K> iterator() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.keySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<V> valueIterator() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.values().iterator();
        }
    }

    public void putWait(K k, V v) {
        this.put(k, v);
        while (!v.equals(this.getWait(k))) {
        }
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException("null keys or values not allowed");
        }
        try {
            DHTTransport<K, V> dHTTransport = DHTTransport.create(k, v);
            this.channel.send(dHTTransport);
        }
        catch (IOException iOException) {
            logger.info("send, exception " + iOException);
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            logger.info("send, exception " + exception);
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getWait(K k) {
        V v = null;
        try {
            SortedMap<K, V> sortedMap = this.theList;
            synchronized (sortedMap) {
                v = this.get(k);
                while (v == null) {
                    this.theList.wait(100L);
                    v = this.theList.get(k);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            interruptedException.printStackTrace();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.theList;
        synchronized (object) {
            this.theList.clear();
        }
        try {
            object = new DHTTransportClear();
            this.channel.send(object);
        }
        catch (IOException iOException) {
            logger.info("send, exception " + iOException);
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            logger.info("send, exception " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.listener == null) {
            return;
        }
        if (this.listener.isDone()) {
            return;
        }
        if (debug) {
            logger.debug("initialize " + this.listener);
        }
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            this.listener.start();
        }
    }

    public void terminate() {
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.listener == null) {
            return;
        }
        if (debug) {
            logger.debug("terminate " + this.listener);
        }
        this.listener.setDone();
        try {
            while (this.listener.isAlive()) {
                this.listener.interrupt();
                this.listener.join(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.listener = null;
    }
}

