/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.SquarefreeAbstract;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeRingChar0<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeRingChar0.class);
    protected final RingFactory<C> coFac;

    public SquarefreeRingChar0(RingFactory<C> ringFactory) {
        super(GCDFactory.getProxy(ringFactory));
        if (ringFactory.isField()) {
            throw new IllegalArgumentException("fac is a field: use SquarefreeFieldChar0");
        }
        if (ringFactory.characteristic().signum() != 0) {
            throw new IllegalArgumentException("characterisic(fac) must be zero");
        }
        this.coFac = ringFactory;
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> genPolynomial2 = this.engine.basePrimitivePart(genPolynomial);
        if (genPolynomial2.isConstant()) {
            return genPolynomial2;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        genPolynomial3 = this.engine.basePrimitivePart(genPolynomial3);
        GenPolynomial<C> genPolynomial4 = this.engine.baseGcd(genPolynomial2, genPolynomial3);
        genPolynomial4 = this.engine.basePrimitivePart(genPolynomial4);
        GenPolynomial<C> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial4);
        genPolynomial5 = this.engine.basePrimitivePart(genPolynomial5);
        return genPolynomial5;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> genPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2;
        GenPolynomial<C> genPolynomial3;
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isConstant()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        if (!gcdRingElem.isONE()) {
            genPolynomial3 = this.engine.baseContent(genPolynomial);
            genPolynomial = genPolynomial.divide(genPolynomial3);
            genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial3);
            treeMap.put(genPolynomial2, 1L);
        }
        genPolynomial3 = genPolynomial;
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = null;
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (genPolynomial3.isConstant() || genPolynomial3.isZERO()) break;
                genPolynomial2 = PolyUtil.baseDeriviative(genPolynomial3);
                genPolynomial4 = this.engine.baseGcd(genPolynomial3, genPolynomial2);
                genPolynomial4 = this.engine.basePrimitivePart(genPolynomial4);
                genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial4);
                l = 0L;
                bl = false;
            }
            if (genPolynomial5.isConstant()) break;
            ++l;
            GenPolynomial genPolynomial6 = this.engine.baseGcd(genPolynomial4, genPolynomial5);
            genPolynomial6 = this.engine.basePrimitivePart(genPolynomial6);
            GenPolynomial genPolynomial7 = PolyUtil.basePseudoDivide(genPolynomial5, genPolynomial6);
            genPolynomial5 = genPolynomial6;
            genPolynomial4 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial5);
            if (genPolynomial7.degree(0) <= 0L) continue;
            if (gcdRingElem.isONE() && !((GcdRingElem)genPolynomial7.leadingBaseCoefficient()).isONE()) {
                genPolynomial7 = this.engine.basePrimitivePart(genPolynomial7);
                logger.info("z,pp = " + genPolynomial7);
            }
            treeMap.put(genPolynomial7, l);
        }
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = genPolynomial;
        GenPolynomial<C> genPolynomial3 = this.engine.recursiveContent(genPolynomial);
        if (!(genPolynomial3 = this.engine.basePrimitivePart(genPolynomial3)).isONE()) {
            genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2.leadingExpVector().getVal(0) < 1L) {
            return genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = PolyUtil.recursiveDeriviative(genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial4);
        genPolynomial5 = this.engine.baseRecursivePrimitivePart(genPolynomial5);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial6 = PolyUtil.recursivePseudoDivide(genPolynomial2, genPolynomial5);
        genPolynomial6 = this.engine.baseRecursivePrimitivePart(genPolynomial6);
        return genPolynomial6.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        GenPolynomial genPolynomial2;
        GenPolynomial genPolynomial3;
        Object object;
        GenPolynomial<C> genPolynomial4;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        C c = this.engine.baseRecursiveContent(genPolynomial);
        if (!c.isONE()) {
            genPolynomial4 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(c);
            object = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial4);
            treeMap.put((GenPolynomial<GenPolynomial<C>>)object, 1L);
            genPolynomial = PolyUtil.baseRecursiveDivide(genPolynomial, c);
        }
        genPolynomial4 = this.engine.recursiveContent(genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info("Pc = " + genPolynomial4);
        }
        if (!(genPolynomial4 = this.engine.basePrimitivePart(genPolynomial4)).isONE()) {
            genPolynomial = PolyUtil.coefficientPseudoDivide(genPolynomial, genPolynomial4);
        }
        object = this.squarefreeFactors((C)genPolynomial4);
        if (logger.isInfoEnabled()) {
            logger.info("rsf = " + object);
        }
        for (Map.Entry entry : object.entrySet()) {
            genPolynomial3 = (GenPolynomial)entry.getKey();
            if (genPolynomial3.isONE()) continue;
            genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial3);
            Long l = (Long)entry.getValue();
            treeMap.put(genPolynomial2, l);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = genPolynomial;
        genPolynomial3 = null;
        genPolynomial2 = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                Map.Entry entry;
                if (genPolynomial5.isConstant() || genPolynomial5.isZERO()) break;
                entry = PolyUtil.recursiveDeriviative(genPolynomial5);
                genPolynomial3 = this.engine.recursiveUnivariateGcd(genPolynomial5, entry);
                genPolynomial3 = this.engine.baseRecursivePrimitivePart(genPolynomial3);
                genPolynomial2 = PolyUtil.recursivePseudoDivide(genPolynomial5, genPolynomial3);
                l = 0L;
                bl = false;
            }
            if (genPolynomial2.isConstant()) break;
            ++l;
            GenPolynomial genPolynomial6 = this.engine.recursiveUnivariateGcd(genPolynomial3, genPolynomial2);
            genPolynomial6 = this.engine.baseRecursivePrimitivePart(genPolynomial6);
            GenPolynomial genPolynomial7 = PolyUtil.recursivePseudoDivide(genPolynomial2, genPolynomial6);
            genPolynomial2 = genPolynomial6;
            genPolynomial3 = PolyUtil.recursivePseudoDivide(genPolynomial3, genPolynomial2);
            if (genPolynomial7.isONE() || genPolynomial7.isZERO()) continue;
            genPolynomial7 = this.engine.baseRecursivePrimitivePart(genPolynomial7);
            treeMap.put(genPolynomial7, l);
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreePart(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial3 = this.engine.recursiveContent(genPolynomial2);
        genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        GenPolynomial genPolynomial4 = this.squarefreePart(genPolynomial3);
        GenPolynomial genPolynomial5 = this.recursiveUnivariateSquarefreePart(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial5.multiply(genPolynomial4);
        GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
        return genPolynomial7;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreeFactors(genPolynomial);
        }
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        SortedMap sortedMap = this.recursiveUnivariateSquarefreeFactors(genPolynomial2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            Long l = entry.getValue();
            GenPolynomial genPolynomial3 = entry.getKey();
            GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C c) {
        throw new UnsupportedOperationException("method not implemented");
    }
}

