/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.StringUtil;
import edu.jas.poly.ExpVector;
import edu.jas.poly.Word;
import edu.jas.structure.MonoidFactory;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class WordFactory
implements MonoidFactory<Word> {
    final String alphabet;
    public final Word ONE;
    public static final String transRef = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public final String[] translation;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(WordFactory.class);
    private static final WordComparator horder = new WordComparator(){

        @Override
        public int compare(Word word, Word word2) {
            return word.gradInvlexCompareTo(word2);
        }
    };
    private static final WordComparator lorder = new WordComparator(){

        @Override
        public int compare(Word word, Word word2) {
            return -word.gradInvlexCompareTo(word2);
        }
    };

    public WordFactory() {
        this("");
    }

    public WordFactory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string not allowed");
        }
        this.alphabet = WordFactory.cleanSpace(string);
        this.translation = null;
        this.ONE = new Word(this, "", false);
    }

    public WordFactory(String[] stringArray) {
        String[] stringArray2 = WordFactory.cleanAll(stringArray);
        if (WordFactory.isSingleLetters(stringArray2)) {
            this.alphabet = WordFactory.concat(stringArray2);
            this.translation = null;
        } else {
            this.alphabet = transRef.substring(0, stringArray2.length);
            this.translation = stringArray2;
            logger.info("alphabet = " + this.alphabet + ", translation = " + Arrays.toString(this.translation));
        }
        this.ONE = new Word(this, "", false);
    }

    @Override
    public boolean isFinite() {
        return this.alphabet.length() == 0;
    }

    @Override
    public boolean isCommutative() {
        return this.alphabet.length() == 0;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public Word getONE() {
        return this.ONE;
    }

    @Override
    public Word copy(Word word) {
        return new Word(this, word.getVal(), false);
    }

    public int length() {
        return this.alphabet.length();
    }

    String getVal() {
        return this.alphabet;
    }

    String[] getTrans() {
        return this.translation;
    }

    public char getVal(int n) {
        return this.alphabet.charAt(n);
    }

    public String[] getVars() {
        String[] stringArray = new String[this.alphabet.length()];
        if (this.translation == null) {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                stringArray[i] = String.valueOf(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                stringArray[i] = this.translation[i];
            }
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\"");
        if (this.translation == null) {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.translation[i]);
            }
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WordFactory)) {
            return false;
        }
        WordFactory wordFactory = (WordFactory)object;
        return this.alphabet.equals(wordFactory.alphabet);
    }

    public int hashCode() {
        return this.alphabet.hashCode();
    }

    @Override
    public List<Word> generators() {
        int n = this.alphabet.length();
        ArrayList<Word> arrayList = new ArrayList<Word>(n);
        for (int i = 0; i < n; ++i) {
            Word word = new Word(this, String.valueOf(this.alphabet.charAt(i)), false);
            arrayList.add(word);
        }
        return arrayList;
    }

    @Override
    public Word fromInteger(long l) {
        throw new UnsupportedOperationException("not implemented for WordFactory");
    }

    @Override
    public Word fromInteger(BigInteger bigInteger) {
        throw new UnsupportedOperationException("not implemented for WordFactory");
    }

    public Word valueOf(ExpVector expVector) {
        Word word = this.ONE;
        List<Word> list = this.generators();
        int n = this.alphabet.length();
        int n2 = expVector.length();
        if (n2 > n) {
            throw new IllegalArgumentException("alphabet to short for exponent " + expVector + ", alpahbet = " + this.alphabet);
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)expVector.getVal(n2 - i - 1);
            Word word2 = list.get(i);
            Word word3 = this.ONE;
            for (int j = 0; j < n3; ++j) {
                word3 = word3.multiply(word2);
            }
            word = word.multiply(word3);
        }
        return word;
    }

    public int indexOf(char c) {
        return this.alphabet.indexOf(c);
    }

    @Override
    public Word random(int n) {
        return this.random(n, random);
    }

    @Override
    public Word random(int n, Random random) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.alphabet.length();
        for (int i = 0; i < n; ++i) {
            int n3 = Math.abs(random.nextInt() % n2);
            stringBuffer.append(this.alphabet.charAt(n3));
        }
        return new Word(this, stringBuffer.toString(), false);
    }

    @Override
    public Word parse(String string) {
        String string2;
        String string3 = WordFactory.clean(string);
        if (!string3.matches(string2 = this.translation == null ? "[" + this.alphabet + " ]*" : "[" + WordFactory.concat(this.translation) + " ]*")) {
            throw new IllegalArgumentException("word '" + string3 + "' contains letters not from: " + this.alphabet + " or from " + WordFactory.concat(this.translation));
        }
        return new Word(this, string3, true);
    }

    @Override
    public Word parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    public WordComparator getDescendComparator() {
        return horder;
    }

    public WordComparator getAscendComparator() {
        return lorder;
    }

    public static String cleanSpace(String string) {
        String string2 = string.trim();
        string2 = string2.replaceAll("\\*", "");
        string2 = string2.replaceAll("\\s", "");
        string2 = string2.replaceAll("\\(", "");
        string2 = string2.replaceAll("\\)", "");
        string2 = string2.replaceAll("\\\"", "");
        return string2;
    }

    public static String clean(String string) {
        String string2 = string.trim();
        string2 = string2.replaceAll("\\*", " ");
        string2 = string2.replaceAll("\\(", "");
        string2 = string2.replaceAll("\\)", "");
        string2 = string2.replaceAll("\\\"", "");
        return string2;
    }

    public static String[] cleanAll(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = WordFactory.cleanSpace(stringArray[i]);
            if (stringArray2[i].length() != 0) continue;
            logger.error("empty v[i]: '" + stringArray[i] + "'");
        }
        return stringArray2;
    }

    public static String concat(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null) {
            return stringBuffer.toString();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String[] trimAll(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
            if (stringArray2[i].length() != 0) continue;
            logger.error("empty v[i]: '" + stringArray[i] + "'");
        }
        return stringArray2;
    }

    public static int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSingleLetters(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 1) continue;
            return false;
        }
        return true;
    }

    public String translate(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = WordFactory.indexOf(this.translation, string);
            if (n < 0) {
                System.out.println("t = " + Arrays.toString(this.translation));
                System.out.println("v = " + Arrays.toString(stringArray));
                logger.error("v[i] not found in t: " + string);
                throw new IllegalArgumentException("v[i] not found in t: " + string);
            }
            stringBuffer.append(transRef.charAt(n));
        }
        return stringBuffer.toString();
    }

    public String transVar(char c) {
        int n = this.alphabet.indexOf(c);
        return this.translation[n];
    }

    public static abstract class WordComparator
    implements Comparator<Word>,
    Serializable {
        @Override
        public abstract int compare(Word var1, Word var2);
    }
}

