/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.LocalRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Local<C extends RingElem<C>>
implements RingElem<Local<C>>,
QuotPair<C> {
    private static final Logger logger = Logger.getLogger(Local.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final LocalRing<C> ring;
    protected final C num;
    protected final C den;
    protected int isunit = -1;

    public Local(LocalRing<C> localRing) {
        this(localRing, (RingElem)localRing.ring.getZERO());
    }

    public Local(LocalRing<C> localRing, C c) {
        this((LocalRing<RingElem>)localRing, (RingElem)c, (RingElem)localRing.ring.getONE(), true);
    }

    public Local(LocalRing<C> localRing, C c, C c2) {
        this(localRing, c, c2, false);
    }

    protected Local(LocalRing<C> localRing, C object, C object2, boolean bl) {
        if (object2 == null || object2.isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = localRing;
        if (object2.signum() < 0) {
            object = (RingElem)object.negate();
            object2 = (RingElem)object2.negate();
        }
        if (bl) {
            this.num = object;
            this.den = object2;
            return;
        }
        RingElem ringElem = (RingElem)object2.remainder(this.ring.ideal);
        if (ringElem == null || ringElem.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal");
        }
        if (object instanceof GcdRingElem && object2 instanceof GcdRingElem) {
            GcdRingElem gcdRingElem = (GcdRingElem)object;
            GcdRingElem gcdRingElem2 = (GcdRingElem)object2;
            GcdRingElem gcdRingElem3 = gcdRingElem.gcd(gcdRingElem2);
            if (this.debug) {
                logger.info("gcd = " + gcdRingElem3);
            }
            if (gcdRingElem3.isONE()) {
                this.num = object;
                this.den = object2;
            } else {
                this.num = object.divide((GcdRingElem)gcdRingElem3);
                this.den = object2.divide((GcdRingElem)gcdRingElem3);
            }
        } else {
            logger.warn("gcd = ????");
            this.num = object;
            this.den = object2;
        }
    }

    @Override
    public LocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public C numerator() {
        return this.num;
    }

    @Override
    public C denominator() {
        return this.den;
    }

    @Override
    public boolean isConstant() {
        throw new UnsupportedOperationException("isConstant not implemented");
    }

    @Override
    public Local<C> copy() {
        return new Local<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        RingElem ringElem = (RingElem)this.num.remainder(this.ring.ideal);
        boolean bl = ringElem != null && !ringElem.isZERO();
        this.isunit = bl ? 1 : 0;
        return bl;
    }

    public String toString() {
        return "Local[ " + this.num.toString() + " / " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Local( " + this.num.toScript() + " , " + this.den.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((LocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Local<C> local) {
        if (local == null || local.isZERO()) {
            return this.signum();
        }
        RingElem ringElem = (RingElem)this.num.multiply(local.den);
        RingElem ringElem2 = (RingElem)this.den.multiply(local.num);
        RingElem ringElem3 = ringElem.subtract(ringElem2);
        return ringElem3.signum();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Local)) {
            return false;
        }
        Local local = (Local)object;
        return 0 == this.compareTo(local);
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public Local<C> abs() {
        return new Local<RingElem>((LocalRing<RingElem>)this.ring, (RingElem)this.num.abs(), (RingElem)this.den, true);
    }

    @Override
    public Local<C> sum(Local<C> local) {
        if (local == null || local.isZERO()) {
            return this;
        }
        RingElem ringElem = (RingElem)this.num.multiply(local.den);
        ringElem = (RingElem)ringElem.sum((AbelianGroupElem)this.den.multiply(local.num));
        RingElem ringElem2 = (RingElem)this.den.multiply(local.den);
        return new Local<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    @Override
    public Local<C> negate() {
        return new Local<RingElem>((LocalRing<RingElem>)this.ring, (RingElem)this.num.negate(), (RingElem)this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Local<C> subtract(Local<C> local) {
        if (local == null || local.isZERO()) {
            return this;
        }
        RingElem ringElem = (RingElem)this.num.multiply(local.den);
        ringElem = (RingElem)ringElem.subtract((AbelianGroupElem)this.den.multiply(local.num));
        RingElem ringElem2 = (RingElem)this.den.multiply(local.den);
        return new Local<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    @Override
    public Local<C> divide(Local<C> local) {
        return this.multiply((Local<C>)local.inverse());
    }

    @Override
    public Local<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new Local<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public Local<C> remainder(Local<C> local) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        if (local.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + local);
    }

    public Local<C>[] quotientRemainder(Local<C> local) {
        return new Local[]{this.divide(local), this.remainder(local)};
    }

    @Override
    public Local<C> multiply(Local<C> local) {
        if (local == null || local.isZERO()) {
            return local;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (local.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return local;
        }
        RingElem ringElem = (RingElem)this.num.multiply(local.num);
        RingElem ringElem2 = (RingElem)this.den.multiply(local.den);
        return new Local<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    @Override
    public Local<C> gcd(Local<C> local) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public Local<C>[] egcd(Local<C> local) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

