/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptStatus;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public final class GenWordPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenWordPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final WordFactory alphabet;
    public final GenWordPolynomial<C> ZERO;
    public final GenWordPolynomial<C> ONE;
    public final Word wone;
    static final Random random = new Random();
    private int isField = -1;
    private static final Logger logger = Logger.getLogger(GenWordPolynomialRing.class);
    final boolean checkPreempt = PreemptStatus.isAllowed();

    public GenWordPolynomialRing(RingFactory<C> ringFactory, WordFactory wordFactory) {
        this.coFac = ringFactory;
        this.alphabet = wordFactory;
        this.ZERO = new GenWordPolynomial(this);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        this.wone = wordFactory.getONE();
        this.ONE = new GenWordPolynomial<RingElem>(this, ringElem, this.wone);
    }

    public GenWordPolynomialRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, new WordFactory(stringArray));
    }

    public GenWordPolynomialRing(RingFactory<C> ringFactory, String string) {
        this(ringFactory, new WordFactory(string));
    }

    public GenWordPolynomialRing(RingFactory<C> ringFactory, GenWordPolynomialRing genWordPolynomialRing) {
        this(ringFactory, genWordPolynomialRing.alphabet);
    }

    public GenWordPolynomialRing(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing.coFac, new WordFactory(genPolynomialRing.vars));
    }

    public GenWordPolynomialRing<C> copy() {
        return new GenWordPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WordPolyRing(");
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toString().trim());
        }
        stringBuffer.append(",");
        stringBuffer.append(this.alphabet.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("WordPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("WordPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",");
        stringBuffer.append(this.alphabet.toScript());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenWordPolynomialRing)) {
            return false;
        }
        GenWordPolynomialRing genWordPolynomialRing = (GenWordPolynomialRing)object;
        if (!this.coFac.equals(genWordPolynomialRing.coFac)) {
            return false;
        }
        return this.alphabet.equals(genWordPolynomialRing.alphabet);
    }

    public int hashCode() {
        int n = this.coFac.hashCode() << 11;
        return n += this.alphabet.hashCode();
    }

    public String[] getVars() {
        return this.alphabet.getVars();
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public GenWordPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenWordPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative() && this.alphabet.isFinite();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isFinite() {
        return this.alphabet.isFinite() && this.coFac.isFinite();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.alphabet.isFinite()) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenWordPolynomial<C> valueOf(C c) {
        return new GenWordPolynomial<C>(this, c);
    }

    public GenWordPolynomial<C> valueOf(Word word) {
        return this.valueOf((RingElem)this.coFac.getONE(), word);
    }

    public GenWordPolynomial<C> valueOf(ExpVector expVector) {
        return this.valueOf((RingElem)this.coFac.getONE(), expVector);
    }

    public GenWordPolynomial<C> valueOf(C c, Word word) {
        return new GenWordPolynomial<C>(this, c, word);
    }

    public GenWordPolynomial<C> valueOf(C c, ExpVector expVector) {
        return new GenWordPolynomial<C>(this, c, this.alphabet.valueOf(expVector));
    }

    public GenWordPolynomial<C> valueOf(GenPolynomial<C> genPolynomial) {
        if (genPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (genPolynomial.isONE()) {
            return this.getONE();
        }
        Element element = ((GenWordPolynomial)this.getZERO()).copy();
        for (Map.Entry entry : genPolynomial.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector = entry.getKey();
            Word word = this.alphabet.valueOf(expVector);
            ((GenWordPolynomial)element).doPutToMap(word, ringElem);
        }
        return element;
    }

    public List<GenWordPolynomial<C>> valueOf(List<GenPolynomial<C>> list) {
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list.size());
        if (list.isEmpty()) {
            return arrayList;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            GenWordPolynomial<C> genWordPolynomial = this.valueOf(genPolynomial);
            arrayList.add(genWordPolynomial);
        }
        return arrayList;
    }

    @Override
    public GenWordPolynomial<C> fromInteger(long l) {
        return new GenWordPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(l), this.wone);
    }

    @Override
    public GenWordPolynomial<C> fromInteger(BigInteger bigInteger) {
        return new GenWordPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(bigInteger), this.wone);
    }

    @Override
    public GenWordPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenWordPolynomial<C> random(int n, Random random) {
        return this.random(5, n, 3, random);
    }

    public GenWordPolynomial<C> random(int n, int n2, int n3) {
        return this.random(n, n2, n3, random);
    }

    public GenWordPolynomial<C> random(int n, int n2, int n3, Random random) {
        GenWordPolynomial<RingElem> genWordPolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            int n4 = Math.abs(random.nextInt() % n3);
            Word word = this.alphabet.random(n4, random);
            RingElem ringElem = (RingElem)this.coFac.random(n, random);
            genWordPolynomial = genWordPolynomial.sum(ringElem, word);
        }
        return genWordPolynomial;
    }

    @Override
    public GenWordPolynomial<C> copy(GenWordPolynomial<C> genWordPolynomial) {
        return new GenWordPolynomial(this, genWordPolynomial.val);
    }

    @Override
    public GenWordPolynomial<C> parse(String string) {
        String string2 = string;
        if (!string.contains("|")) {
            string2 = string2.replace("{", "").replace("}", "");
        }
        return this.parse(new StringReader(string2));
    }

    @Override
    public GenWordPolynomial<C> parse(Reader reader) {
        if (this.alphabet.length() <= 2) {
            GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.coFac, this.alphabet.getVars());
            GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(genPolynomialRing, reader);
            GenPolynomial genPolynomial = null;
            try {
                genPolynomial = genPolynomialTokenizer.nextPolynomial();
            }
            catch (IOException iOException) {
                logger.error(iOException.toString() + " parse " + this);
            }
            GenWordPolynomial<C> genWordPolynomial = this.valueOf(genPolynomial);
            return genWordPolynomial;
        }
        logger.error("parse not implemented");
        throw new UnsupportedOperationException("not implemented");
    }

    public GenWordPolynomial<C> univariate(int n) {
        GenWordPolynomial<RingElem> genWordPolynomial = this.getZERO();
        List<Word> list = this.alphabet.generators();
        if (0 <= n && n < list.size()) {
            RingElem ringElem = (RingElem)this.coFac.getONE();
            Word word = list.get(n);
            genWordPolynomial = genWordPolynomial.sum(ringElem, word);
        }
        return genWordPolynomial;
    }

    public GenWordPolynomial<C> commute(int n, int n2) {
        AbelianGroupElem abelianGroupElem = this.getZERO();
        List<Word> list = this.alphabet.generators();
        if (0 <= n && n < list.size() && 0 <= n2 && n2 < list.size()) {
            RingElem ringElem = (RingElem)this.coFac.getONE();
            Word word = list.get(n);
            Word word2 = list.get(n2);
            abelianGroupElem = abelianGroupElem.sum(ringElem, word2.multiply(word));
            abelianGroupElem = abelianGroupElem.subtract(ringElem, word.multiply(word2));
            if (n > n2) {
                abelianGroupElem = abelianGroupElem.negate();
            }
        }
        return abelianGroupElem;
    }

    public List<GenWordPolynomial<C>> commute(int n) {
        int n2 = this.alphabet.length();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            if (n == i) continue;
            arrayList.add(this.commute(n, i));
        }
        return arrayList;
    }

    public List<GenWordPolynomial<C>> commute() {
        int n = this.alphabet.length();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n * (n - 1));
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(this.commute(i));
        }
        return arrayList;
    }

    public List<GenWordPolynomial<C>> univariateList() {
        int n = this.alphabet.length();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(n);
        for (int i = 0; i < n; ++i) {
            GenWordPolynomial<C> genWordPolynomial = this.univariate(i);
            arrayList.add(genWordPolynomial);
        }
        return arrayList;
    }

    public List<GenWordPolynomial<C>> getGenerators() {
        List<GenWordPolynomial<C>> list = this.univariateList();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list.size() + 1);
        arrayList.add((GenWordPolynomial<C>)this.getONE());
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public List<GenWordPolynomial<C>> generators() {
        List list = this.coFac.generators();
        List<GenWordPolynomial<C>> list2 = this.univariateList();
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list2.size() + list.size());
        for (RingElem ringElem : list) {
            arrayList.add(((GenWordPolynomial)this.getONE()).multiply(ringElem));
        }
        arrayList.addAll(list2);
        return arrayList;
    }
}

