/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.gbmod.ModSolvableGroebnerBaseSeq;
import edu.jas.gbmod.SolvResPart;
import edu.jas.gbmod.SolvResPolPart;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.gbufd.SGBFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SolvableSyzygySeq<C extends GcdRingElem<C>>
extends SolvableSyzygyAbstract<C> {
    private static final Logger logger = Logger.getLogger(SolvableSyzygySeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    private static boolean assertEnabled = false;
    protected SolvableGroebnerBase<C> sbb;
    protected ModSolvableGroebnerBase<C> msbb;

    public SolvableSyzygySeq(RingFactory<C> ringFactory) {
        this.sbb = SGBFactory.getImplementation(ringFactory);
        this.msbb = new ModSolvableGroebnerBaseSeq<C>(ringFactory);
    }

    @Override
    public List<SolvResPart<C>> resolution(ModuleList<C> moduleList) {
        ArrayList<SolvResPart<C>> arrayList = new ArrayList<SolvResPart<C>>();
        ModuleList<C> moduleList2 = moduleList;
        while (true) {
            ModuleList<C> moduleList3 = this.msbb.leftGB(moduleList2);
            ModuleList<C> moduleList4 = this.leftZeroRelations(moduleList3);
            arrayList.add(new SolvResPart<C>(moduleList2, moduleList3, moduleList4));
            if (moduleList4 == null || moduleList4.list == null || moduleList4.list.size() == 0) break;
            moduleList2 = moduleList4;
        }
        return arrayList;
    }

    @Override
    public List resolution(PolynomialList<C> polynomialList) {
        List<GenSolvablePolynomial<C>> list = this.sbb.leftGB(polynomialList.castToSolvableList());
        List<List<GenSolvablePolynomial<C>>> list2 = this.leftZeroRelations(list);
        PolynomialList<C> polynomialList2 = new PolynomialList<C>((GenSolvablePolynomialRing)polynomialList.ring, list);
        ModuleList<C> moduleList = new ModuleList<C>((GenSolvablePolynomialRing)polynomialList.ring, list2);
        List<SolvResPart<C>> list3 = this.resolution(moduleList);
        list3.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(polynomialList, polynomialList2, moduleList)));
        return list3;
    }

    @Override
    public List<SolvResPart<C>> resolutionArbitrary(ModuleList<C> moduleList) {
        ArrayList<SolvResPart<C>> arrayList = new ArrayList<SolvResPart<C>>();
        ModuleList<C> moduleList2 = moduleList;
        ModuleList moduleList3 = null;
        while (true) {
            ModuleList<C> moduleList4 = this.leftZeroRelationsArbitrary(moduleList2);
            arrayList.add(new SolvResPart<C>(moduleList2, moduleList3, moduleList4));
            if (moduleList4 == null || moduleList4.list == null || moduleList4.list.size() == 0) break;
            moduleList2 = moduleList4;
        }
        return arrayList;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> polynomialList) {
        PolynomialList polynomialList2 = null;
        List<List<GenSolvablePolynomial<C>>> list = this.leftZeroRelationsArbitrary(polynomialList.castToSolvableList());
        ModuleList<C> moduleList = new ModuleList<C>((GenSolvablePolynomialRing)polynomialList.ring, list);
        List<SolvResPart<C>> list2 = this.resolutionArbitrary(moduleList);
        list2.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(polynomialList, polynomialList2, moduleList)));
        return list2;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(int n, List<GenSolvablePolynomial<C>> list) {
        List list2;
        List list3;
        Iterator iterator;
        if (list == null) {
            return null;
        }
        if (list.size() <= 1) {
            return this.leftZeroRelations(n, list);
        }
        int n2 = list.size();
        SolvableExtendedGB<C> solvableExtendedGB = this.sbb.extLeftGB(n, list);
        if (debug) {
            logger.info("exgb = " + solvableExtendedGB);
        }
        if (assertEnabled) {
            logger.info("check1 exgb start");
            if (!this.sbb.isLeftReductionMatrix(solvableExtendedGB)) {
                logger.error("is reduction matrix ? false");
            }
            logger.info("check1 exgb end");
        }
        List list4 = solvableExtendedGB.G;
        List list5 = solvableExtendedGB.G2F;
        List list6 = solvableExtendedGB.F2G;
        List list7 = this.leftZeroRelations(n, list4);
        GenSolvablePolynomialRing genSolvablePolynomialRing = list4.get((int)0).ring;
        ModuleList moduleList = new ModuleList(genSolvablePolynomialRing, list7);
        if (debug) {
            logger.info("syz = " + moduleList);
        }
        if (assertEnabled) {
            logger.info("check2 left syz start");
            if (!this.isLeftZeroRelation(list7, list4)) {
                logger.error("is syzygy ? false");
            }
            logger.info("check2 left syz end");
        }
        ArrayList arrayList2 = new ArrayList(list7.size());
        for (List object : list7) {
            Iterator iterator2 = object.iterator();
            iterator = list5.iterator();
            list3 = new ArrayList<GenPolynomial>(n2);
            for (int moduleList2 = 0; moduleList2 < n2; ++moduleList2) {
                list3.add(genSolvablePolynomialRing.getZERO());
            }
            while (iterator2.hasNext() && iterator.hasNext()) {
                GenSolvablePolynomial genSolvablePolynomial = iterator2.next();
                List list8 = (List)iterator.next();
                if (genSolvablePolynomial == null || list8 == null) continue;
                list2 = this.blas.scalarProduct(genSolvablePolynomial, PolynomialList.castToList(list8));
                list3 = PolynomialList.castToSolvableList(this.blas.vectorAdd(PolynomialList.castToList(list3), list2));
            }
            if (iterator2.hasNext() || iterator.hasNext()) {
                logger.error("leftZeroRelationsArbitrary wrong sizes");
            }
            arrayList2.add(list3);
        }
        if (assertEnabled) {
            logger.info("check3 left syz start");
            if (!this.isLeftZeroRelation(arrayList2, list)) {
                logger.error("is partial syz sf ? false");
            }
            logger.info("check3 left syz end");
        }
        ArrayList arrayList3 = new ArrayList(n2);
        for (List list9 : list6) {
            iterator = list9.iterator();
            list3 = list5.iterator();
            List list10 = new ArrayList<GenPolynomial>(n2);
            for (int i = 0; i < n2; ++i) {
                list10.add(genSolvablePolynomialRing.getZERO());
            }
            while (iterator.hasNext() && list3.hasNext()) {
                GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)iterator.next();
                list2 = (List)list3.next();
                if (genSolvablePolynomial == null || list2 == null) continue;
                List list11 = this.blas.scalarProduct(genSolvablePolynomial, PolynomialList.castToList(list2));
                list10 = PolynomialList.castToSolvableList(this.blas.vectorAdd(PolynomialList.castToList(list10), list11));
            }
            if (iterator.hasNext() || list3.hasNext()) {
                logger.error("zeroRelationsArbitrary wrong sizes");
            }
            arrayList3.add(list10);
        }
        int n3 = arrayList2.size();
        ArrayList arrayList = new ArrayList(n2);
        int n4 = 0;
        list3 = arrayList3.iterator();
        while (list3.hasNext()) {
            List list12 = (List)list3.next();
            ArrayList<GenSolvablePolynomial> arrayList4 = new ArrayList<GenSolvablePolynomial>(list12.size());
            int n5 = 0;
            for (GenSolvablePolynomial genSolvablePolynomial : list12) {
                GenSolvablePolynomial genSolvablePolynomial2 = null;
                if (n4 == n5) {
                    genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomialRing.getONE().subtract(genSolvablePolynomial);
                } else if (genSolvablePolynomial != null) {
                    genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.negate();
                }
                arrayList4.add(genSolvablePolynomial2);
                ++n5;
            }
            arrayList.add(arrayList4);
            if (!this.blas.isZero(PolynomialList.castToList(arrayList4))) {
                arrayList2.add(arrayList4);
            }
            ++n4;
        }
        list3 = new ModuleList(genSolvablePolynomialRing, arrayList);
        if (debug) {
            logger.debug("syz M2L = " + list3);
        }
        if (debug) {
            ModuleList moduleList2 = new ModuleList(genSolvablePolynomialRing, arrayList2);
            logger.debug("syz sf = " + moduleList2);
            logger.debug("#syz " + n3 + ", " + arrayList2.size());
        }
        if (assertEnabled) {
            logger.info("check4 left syz start");
            if (!this.isLeftZeroRelation(arrayList2, list)) {
                logger.error("is syz sf ? false");
            }
            logger.info("check4 left syz end");
        }
        return arrayList2;
    }

    @Override
    public GenSolvablePolynomial<C>[] leftOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        Serializable serializable;
        List list;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial.equals(genSolvablePolynomial2)) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial.isConstant()) {
            if (genSolvablePolynomialRing.coFac.isCommutative()) {
                genSolvablePolynomialArray[0] = genSolvablePolynomial2;
                genSolvablePolynomialArray[1] = genSolvablePolynomial;
                return genSolvablePolynomialArray;
            }
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getONE();
            GcdRingElem gcdRingElem = (GcdRingElem)((GcdRingElem)genSolvablePolynomial.leadingBaseCoefficient()).inverse();
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.multiply(gcdRingElem);
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isConstant()) {
            if (genSolvablePolynomialRing.coFac.isCommutative()) {
                genSolvablePolynomialArray[0] = genSolvablePolynomial2;
                genSolvablePolynomialArray[1] = genSolvablePolynomial;
                return genSolvablePolynomialArray;
            }
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            GcdRingElem gcdRingElem = (GcdRingElem)((GcdRingElem)genSolvablePolynomial2.leadingBaseCoefficient()).inverse();
            genSolvablePolynomialArray[1] = genSolvablePolynomial.multiply(gcdRingElem);
            return genSolvablePolynomialArray;
        }
        logger.info("computing left Ore condition: " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        List list2 = this.leftZeroRelationsArbitrary(arrayList);
        if (list2.size() < 0) {
            list = new ModuleList(genSolvablePolynomialRing, list2);
            serializable = this.msbb.leftGB(list);
            list2 = serializable.castToSolvableList();
        }
        list = null;
        serializable = null;
        for (List list3 : list2) {
            if (list3.get(0).isZERO()) continue;
            if (list == null) {
                list = list3;
            }
            if (serializable == null) {
                serializable = (GenSolvablePolynomial)list.get(0);
                continue;
            }
            if (((GenPolynomial)serializable).compareTo(list3.get(0)) <= 0) continue;
            list = list3;
            serializable = list.get(0);
        }
        genSolvablePolynomialArray[0] = serializable;
        genSolvablePolynomialArray[1] = (GenSolvablePolynomial)((GenSolvablePolynomial)list.get(1)).negate();
        return genSolvablePolynomialArray;
    }

    @Override
    public GenSolvablePolynomial<C>[] rightOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial.equals(genSolvablePolynomial2)) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial.isConstant()) {
            if (genSolvablePolynomialRing.coFac.isCommutative()) {
                genSolvablePolynomialArray[0] = genSolvablePolynomial2;
                genSolvablePolynomialArray[1] = genSolvablePolynomial;
                return genSolvablePolynomialArray;
            }
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getONE();
            GcdRingElem gcdRingElem = (GcdRingElem)((GcdRingElem)genSolvablePolynomial.leadingBaseCoefficient()).inverse();
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.multiply(gcdRingElem);
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isConstant()) {
            if (genSolvablePolynomialRing.coFac.isCommutative()) {
                genSolvablePolynomialArray[0] = genSolvablePolynomial2;
                genSolvablePolynomialArray[1] = genSolvablePolynomial;
                return genSolvablePolynomialArray;
            }
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            GcdRingElem gcdRingElem = (GcdRingElem)((GcdRingElem)genSolvablePolynomial2.leadingBaseCoefficient()).inverse();
            genSolvablePolynomialArray[1] = genSolvablePolynomial.multiply(gcdRingElem);
            return genSolvablePolynomialArray;
        }
        logger.info("computing right Ore condition: " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        List list = this.rightZeroRelationsArbitrary(arrayList);
        List list2 = null;
        GenSolvablePolynomial genSolvablePolynomial3 = null;
        for (List list3 : list) {
            if (list3.get(0).isZERO()) continue;
            if (list2 == null) {
                list2 = list3;
            }
            if (genSolvablePolynomial3 == null) {
                genSolvablePolynomial3 = list2.get(0);
                continue;
            }
            if (genSolvablePolynomial3.compareTo(list3.get(0)) <= 0) continue;
            list2 = list3;
            genSolvablePolynomial3 = list2.get(0);
        }
        genSolvablePolynomialArray[0] = (GenSolvablePolynomial)list2.get(0);
        genSolvablePolynomialArray[1] = (GenSolvablePolynomial)((GenSolvablePolynomial)list2.get(1)).negate();
        return genSolvablePolynomialArray;
    }

    @Override
    public GenSolvablePolynomial<C>[] leftSimplifier(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        int n;
        GcdRingElem gcdRingElem;
        List list3;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        Object[] objectArray = null;
        if (genSolvablePolynomial.isConstant() || genSolvablePolynomial2.isConstant()) {
            objectArray = new GenSolvablePolynomial[]{genSolvablePolynomial, genSolvablePolynomial2};
            return objectArray;
        }
        if (genSolvablePolynomial.totalDegree() > 3L || genSolvablePolynomial2.totalDegree() > 3L) {
            logger.warn("skipping GB computation: degs = " + genSolvablePolynomial.totalDegree() + ", " + genSolvablePolynomial2.totalDegree());
            objectArray = new GenSolvablePolynomial[]{genSolvablePolynomial, genSolvablePolynomial2};
            return objectArray;
        }
        objectArray = this.rightOreCond(genSolvablePolynomial, genSolvablePolynomial2);
        logger.info("oc = " + Arrays.toString(objectArray));
        ArrayList arrayList = new ArrayList(objectArray.length);
        arrayList.add((GenSolvablePolynomial)((GenPolynomial)objectArray[1]).negate());
        arrayList.add(objectArray[0]);
        List list2 = this.leftZeroRelationsArbitrary(arrayList);
        ArrayList arrayList2 = new ArrayList(list2.size());
        ArrayList arrayList3 = new ArrayList(list2.size());
        for (List list3 : list2) {
            if (list3.get(0).isZERO()) continue;
            arrayList2.add(list3.get(0));
            arrayList3.add(list3.get(1));
        }
        logger.info("G1(den): " + arrayList2 + ", G2(num): " + arrayList3);
        SolvableExtendedGB<C> solvableExtendedGB = this.sbb.extLeftGB(arrayList2);
        logger.info("exgb.F: " + solvableExtendedGB.F + ", exgb.G: " + solvableExtendedGB.G);
        list3 = solvableExtendedGB.G;
        int n2 = 0;
        GenSolvablePolynomial<GcdRingElem> genSolvablePolynomial3 = null;
        for (int i = 0; i < list3.size(); ++i) {
            if (genSolvablePolynomial3 == null) {
                genSolvablePolynomial3 = list3.get(i);
                n2 = i;
                continue;
            }
            if (genSolvablePolynomial3.compareTo(list3.get(i)) <= 0) continue;
            genSolvablePolynomial3 = list3.get(i);
            n2 = i;
        }
        GenSolvablePolynomial<GcdRingElem> genSolvablePolynomial4 = (GenSolvablePolynomial<GcdRingElem>)this.blas.scalarProduct(PolynomialList.castToList(solvableExtendedGB.G2F.get(n2)), PolynomialList.castToList(arrayList3));
        logger.info("min(den): " + genSolvablePolynomial3 + ", min(num): " + genSolvablePolynomial4 + ", m = " + n2 + ", " + solvableExtendedGB.G2F.get(n2));
        GenSolvablePolynomial<GcdRingElem> genSolvablePolynomial5 = genSolvablePolynomial4;
        GenSolvablePolynomial<GcdRingElem> genSolvablePolynomial6 = genSolvablePolynomial3;
        if (genSolvablePolynomial6.signum() < 0) {
            genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial5.negate();
            genSolvablePolynomial6 = (GenSolvablePolynomial<GcdRingElem>)genSolvablePolynomial6.negate();
        }
        if (!(gcdRingElem = (GcdRingElem)genSolvablePolynomial6.leadingBaseCoefficient()).isONE() && gcdRingElem.isUnit()) {
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            genSolvablePolynomial5 = genSolvablePolynomial5.multiplyLeft(gcdRingElem);
            genSolvablePolynomial6 = genSolvablePolynomial6.multiplyLeft(gcdRingElem);
        }
        if (debug && (n = this.compare(genSolvablePolynomial, genSolvablePolynomial2, genSolvablePolynomial5, genSolvablePolynomial6)) != 0) {
            objectArray[0] = genSolvablePolynomial;
            objectArray[1] = genSolvablePolynomial2;
            throw new RuntimeException("simp wrong, giving up: t = " + n);
        }
        objectArray[0] = genSolvablePolynomial5;
        objectArray[1] = genSolvablePolynomial6;
        return objectArray;
    }

    static {
        if (!$assertionsDisabled) {
            assertEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

