/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybridEC;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class HybridReducerClientEC<C extends RingElem<C>>
implements Runnable {
    private static final Logger logger = Logger.getLogger(HybridReducerClientEC.class);
    public final boolean debug = logger.isDebugEnabled();
    private final TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    public final Integer pairTag = GroebnerBaseDistributedHybridEC.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybridEC.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybridEC.ackTag;

    HybridReducerClientEC(TaggedSocketChannel taggedSocketChannel, DistHashTable<Integer, GenPolynomial<C>> distHashTable) {
        this.pairChannel = taggedSocketChannel;
        this.theList = distHashTable;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (this.debug) {
            logger.info("pairChannel   = " + this.pairChannel + " reducer client running");
        }
        Pair pair = null;
        GenPolynomial<C> genPolynomial = null;
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (bl) {
            GBTransportMessReq gBTransportMessReq = new GBTransportMessReq();
            logger.debug("send request");
            try {
                this.pairChannel.send(this.pairTag, gBTransportMessReq);
            }
            catch (IOException iOException) {
                bl = false;
                if (logger.isDebugEnabled()) {
                    iOException.printStackTrace();
                }
                logger.info("receive pair, IOexception ");
                break;
            }
            logger.debug("receive pair, goon = " + bl);
            bl2 = true;
            Object object = null;
            try {
                object = this.pairChannel.receive(this.pairTag);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (this.debug) {
                logger.info("received pair = " + object);
            }
            genPolynomial = null;
            if (object == null) continue;
            if (object instanceof GBTransportMessEnd) {
                bl = false;
                continue;
            }
            if (object instanceof GBTransportMessPair || object instanceof GBTransportMessPairIndex) {
                GBTransportMess gBTransportMess;
                GenPolynomial<C> genPolynomial2 = null;
                GenPolynomial<C> genPolynomial3 = null;
                GenPolynomial<C> genPolynomial4 = null;
                if (object instanceof GBTransportMessPair) {
                    gBTransportMess = (GBTransportMessPair)object;
                    pair = gBTransportMess.pair;
                    if (pair != null) {
                        genPolynomial4 = pair.pi;
                        genPolynomial3 = pair.pj;
                    }
                }
                if (object instanceof GBTransportMessPairIndex) {
                    gBTransportMess = (GBTransportMessPairIndex)object;
                    Integer n2 = ((GBTransportMessPairIndex)gBTransportMess).i;
                    Integer n3 = ((GBTransportMessPairIndex)gBTransportMess).j;
                    Integer n4 = ((GBTransportMessPairIndex)gBTransportMess).s;
                    genPolynomial4 = this.theList.getWait(n2);
                    genPolynomial3 = this.theList.getWait(n3);
                    genPolynomial2 = this.theList.getWait(n4);
                }
                if (genPolynomial4 != null && genPolynomial3 != null) {
                    GenPolynomial genPolynomial5 = this.red.SPolynomial(genPolynomial4, genPolynomial3);
                    if (!genPolynomial5.isZERO()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ht(S) = " + genPolynomial5.leadingExpVector());
                        }
                        genPolynomial = this.red.normalform(this.theList, genPolynomial5);
                        ++n;
                        if (!genPolynomial.isZERO()) {
                            genPolynomial = genPolynomial.monic();
                            if (logger.isInfoEnabled()) {
                                logger.info("ht(H) = " + genPolynomial.leadingExpVector());
                            }
                        }
                    }
                } else {
                    logger.info("pi = " + genPolynomial4 + ", pj = " + genPolynomial3 + ", ps = " + genPolynomial2);
                }
            }
            if (object instanceof GBTransportMess) {
                logger.debug("null pair results in null H poly");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("#distributed list = " + this.theList.size());
                logger.debug("send H polynomial = " + genPolynomial);
            }
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessPoly(genPolynomial));
                bl2 = false;
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
            }
            try {
                object = this.pairChannel.receive(this.ackTag);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (!(object instanceof GBTransportMess)) {
                logger.error("invalid acknowledgement " + object);
            }
            logger.info("received acknowledgment ");
        }
        logger.info("terminated, " + n + " reductions, " + this.theList.size() + " polynomials");
        if (bl2) {
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessEnd());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.debug("terminated, send done");
        }
    }
}

