/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithComplexAlgebraicRoots;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithRealRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.PrimaryComponent;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gbufd.GBFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class IdealTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(IdealTest.class);
    TermOrder to;
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> M;
    List<GenPolynomial<BigRational>> G;
    PolynomialList<BigRational> F;
    GroebnerBase<BigRational> bb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)IdealTest.suite());
    }

    public IdealTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(IdealTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        this.bb = GBFactory.getImplementation(bigRational);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testIdealSum() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!ideal.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!ideal.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        this.L = this.bb.GB(this.L);
        IdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        ideal = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.GB(this.L);
        IdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        Ideal<BigRational> ideal2 = ideal;
        Ideal<BigRational> ideal3 = ideal2.sum(ideal);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"equals( K, I )", (boolean)ideal3.equals(ideal));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        IdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isGB(this.L));
        ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        ideal3 = ideal2.sum(ideal);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"K contains(I)", (boolean)ideal3.contains(ideal));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)ideal3.contains(ideal2));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        IdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isGB(this.L));
        ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        ideal = ideal3;
        ideal3 = ideal2.sum(ideal);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"K contains(I)", (boolean)ideal3.contains(ideal));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)ideal3.contains(ideal2));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        IdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isGB(this.L));
        ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        ideal = ideal3;
        ideal3 = ideal2.sum(ideal);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"equals( K, I )", (boolean)ideal3.equals(ideal));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)ideal3.contains(ideal));
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
    }

    public void testIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!ideal.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        Ideal<BigRational> ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( J )", (!ideal2.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        Ideal<BigRational> ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        Ideal<BigRational> ideal4 = ideal.intersect(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)ideal.contains(ideal4));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)ideal2.contains(ideal4));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)ideal4.contains(ideal3));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        ideal4 = ideal.intersect(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)ideal.contains(ideal4));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)ideal2.contains(ideal4));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)ideal4.contains(ideal3));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        ideal4 = ideal.intersect(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)ideal.contains(ideal4));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)ideal2.contains(ideal4));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)ideal4.contains(ideal3));
    }

    public void testIdealQuotient() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        Ideal<BigRational> ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        Ideal<BigRational> ideal4 = ideal3.quotient(ideal2.getList().get(0));
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)ideal4.equals(ideal));
        ideal4 = ideal3.quotient(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)ideal4.equals(ideal));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        ideal2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        ideal4 = ideal3.quotient(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)ideal4.equals(ideal));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal3 = ideal.product(ideal2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)ideal.contains(ideal3));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)ideal2.contains(ideal3));
        ideal4 = ideal3.quotient(ideal2);
        IdealTest.assertTrue((String)"not isZERO( H )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)ideal4.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)ideal4.equals(ideal));
    }

    public void testIdealInfiniteQuotient() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        Ideal<BigRational> ideal2 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal2 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal2 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        this.G = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.GB(this.G);
        Ideal<BigRational> ideal3 = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        ideal2 = ideal.infiniteQuotient(ideal3);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.GB(this.G);
        ideal3 = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        ideal2 = ideal.infiniteQuotient(ideal3);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
    }

    public void testIdealInfiniteQuotientRabi() {
        this.a = this.fac.random(this.kl - 1, this.ll - 1, this.el - 1, this.q / 2.0f);
        this.b = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        Ideal<BigRational> ideal2 = ideal.infiniteQuotientRab(this.a);
        Ideal<BigRational> ideal3 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)ideal2.equals(ideal3));
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal2 = ideal.infiniteQuotientRab(this.a);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        ideal3 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)ideal2.equals(ideal3));
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal2 = ideal.infiniteQuotientRab(this.a);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        ideal3 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)ideal2.equals(ideal3));
        this.G = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.GB(this.G);
        Ideal<BigRational> ideal4 = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal4.isGB());
        ideal2 = ideal.infiniteQuotientRab(ideal4);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        ideal3 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)ideal2.equals(ideal3));
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.GB(this.G);
        ideal4 = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal4.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal4.isGB());
        ideal2 = ideal.infiniteQuotientRab(ideal4);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)ideal2.equals(ideal));
        ideal3 = ideal.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)ideal2.equals(ideal3));
    }

    public void testIdealRadicalMember() {
        this.a = this.fac.random(this.kl - 1, this.ll, this.el - 1, this.q);
        this.b = this.fac.random(this.kl - 1, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        if (!ideal.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b)", (boolean)ideal.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b)", (boolean)ideal.isRadicalMember(this.b));
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.b.multiply((BigRational)((Object)this.b)));
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        if (!ideal.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b*b)", (boolean)ideal.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b*b)", (boolean)ideal.isRadicalMember(this.b));
        }
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        if (!ideal.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b*b)", (boolean)ideal.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b*b)", (boolean)ideal.isRadicalMember(this.b));
        }
    }

    public void testIdealCommonZeros() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            ideal = new Ideal<BigRational>(this.fac, this.L, true);
            IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)0);
        this.L.remove(0);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)ideal.commonZeroTest(), (int)1);
    }

    public void testIdealDimension() {
        Dimension dimension;
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)ideal.dimension().d);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)ideal.dimension().d);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)-1, (int)ideal.dimension().d);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            ideal = new Ideal<BigRational>(this.fac, this.L, true);
            dimension = ideal.dimension();
            IdealTest.assertTrue((String)"dimension( I )", (dimension.d >= 1 ? 1 : 0) != 0);
        }
        this.L = this.fac.univariateList();
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        dimension = ideal.dimension();
        IdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dimension.d);
        while (this.L.size() > 0) {
            this.L.remove(0);
            ideal = new Ideal<BigRational>(this.fac, this.L, true);
            dimension = ideal.dimension();
            IdealTest.assertEquals((String)"dimension( I )", (int)(this.rl - this.L.size()), (int)dimension.d);
        }
        this.L = this.fac.univariateList();
        ideal = new Ideal<BigRational>(this.fac, this.L, true);
        ideal = ideal.product(ideal);
        dimension = ideal.dimension();
        IdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dimension.d);
        this.L = ideal.getList();
        while (this.L.size() > 0) {
            this.L.remove(0);
            ideal = new Ideal<BigRational>(this.fac, this.L, true);
            dimension = ideal.dimension();
            IdealTest.assertTrue((String)"dimension( I )", (dimension.d > 0 ? 1 : 0) != 0);
        }
    }

    public void testIdealTopt() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        Ideal<BigRational> ideal2 = ideal.copy();
        ideal2.doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        if (ideal.isONE()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        ideal = new Ideal<BigRational>(this.fac, this.L);
        Ideal<BigRational> ideal3 = ideal.copy();
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal3.doToptimize();
        ideal3.doGB();
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        ideal2 = ideal.copy();
        ideal2.doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
        if (ideal.isONE()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal3 = ideal.copy();
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ideal3.doToptimize();
        ideal3.doGB();
        IdealTest.assertTrue((String)"not isZERO( K )", (!ideal3.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)ideal3.isGB());
        ideal2 = ideal.copy();
        ideal2.doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!ideal2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
    }

    public void testElimIdeal() {
        int n;
        String[] stringArray = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.univariate(2, 3L);
        this.b = this.fac.univariate(1, 2L);
        this.c = this.fac.univariate(0, 1L);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n <= stringArray.length; ++n) {
            KsubSet ksubSet = new KsubSet(arrayList, n);
            for (List list : ksubSet) {
                String[] stringArray2 = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray2[i] = (String)list.get(i);
                }
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.fac.coFac, stringArray2.length, this.fac.tord, stringArray2);
                Ideal<BigRational> ideal2 = ideal.eliminate(genPolynomialRing);
                IdealTest.assertTrue((String)"isGB( J )", (boolean)ideal2.isGB());
                IdealTest.assertTrue((String)"size( J ) <=  |ev|", (ideal2.getList().size() <= list.size() ? 1 : 0) != 0);
            }
        }
    }

    public void testUnivPoly() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 + 34/55 x^2 + 1/9 x + 99 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^3 - x y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        for (int i = 0; i < this.rl; ++i) {
            GenPolynomial<BigRational> genPolynomial = ideal.constructUnivariate(this.rl - 1 - i);
            Element element = this.fac.parse(genPolynomial.toString());
            IdealTest.assertTrue((String)"I.contains(U) ", (boolean)ideal.contains((GenPolynomial<BigRational>)element));
        }
        List<GenPolynomial<BigRational>> list = ideal.constructUnivariate();
        for (GenPolynomial genPolynomial : list) {
            Element element = this.fac.parse(genPolynomial.toString());
            IdealTest.assertTrue((String)"I.contains(U) ", (boolean)ideal.contains((GenPolynomial<BigRational>)element));
        }
    }

    public void testComplexRoot() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^2 - 9 )");
        this.c = this.fac.parse("( z - 7 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        BigRational bigRational2 = new BigRational(1L, 1000000L);
        bigRational2 = bigRational2.multiply(bigRational2);
        bigRational2 = bigRational2.multiply(bigRational2).multiply(bigRational2);
        BigDecimal bigDecimal = new BigDecimal(bigRational2.getRational());
        bigDecimal = bigDecimal.abs();
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal2, this.fac);
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal2);
        GenPolynomialRing<BigDecimal> genPolynomialRing2 = new GenPolynomialRing<BigDecimal>(complexRing, genPolynomialRing);
        List<List<Complex<BigDecimal>>> list = PolyUtilApp.complexRootTuples(ideal, bigRational2);
        for (GenPolynomial<BigRational> genPolynomial : ideal.getList()) {
            GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
            GenPolynomial<Complex<BigDecimal>> genPolynomial3 = PolyUtil.toComplex(genPolynomialRing2, genPolynomial2);
            for (List<Complex<BigDecimal>> list2 : list) {
                Complex<BigDecimal> complex = PolyUtil.evaluateAll(complexRing, genPolynomialRing2, genPolynomial3, list2);
                if (((BigDecimal)((Complex)complex.norm()).getRe()).compareTo(bigDecimal) <= 0) continue;
                IdealTest.fail((String)("ev > eps : " + complex + " > " + bigDecimal));
            }
        }
    }

    public void testRealRoot() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        BigRational bigRational2 = new BigRational(1L, 1000000L);
        bigRational2 = bigRational2.multiply(bigRational2);
        bigRational2 = bigRational2.multiply(bigRational2);
        BigDecimal bigDecimal = new BigDecimal(bigRational2.getRational());
        bigDecimal = bigDecimal.abs();
        bigRational2 = bigRational2.multiply(new BigRational(1L, 100L));
        List<List<BigDecimal>> list = PolyUtilApp.realRootTuples(ideal, bigRational2);
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal2, this.fac);
        for (GenPolynomial<BigRational> genPolynomial : ideal.getList()) {
            GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
            for (List<BigDecimal> list2 : list) {
                BigDecimal bigDecimal3 = PolyUtil.evaluateAll(bigDecimal2, genPolynomialRing, genPolynomial2, list2);
                if (bigDecimal3.abs().compareTo(bigDecimal) <= 0) continue;
                IdealTest.fail((String)("ev > e : " + bigDecimal3 + " > " + bigDecimal + ", eps = " + new BigDecimal(bigRational2)));
            }
        }
    }

    public void testZeroDimDecomp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimDecomposition();
        boolean bl = ideal.isZeroDimDecomposition(list);
        IdealTest.assertTrue((String)"is decomposition ", (boolean)bl);
    }

    public void testIdealRealRoot() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimDecomposition();
        IdealTest.assertTrue((String)"is decomposition ", (boolean)ideal.isZeroDimDecomposition(list));
        BigRational bigRational2 = new BigRational(1L, 1000000L);
        bigRational2 = bigRational2.multiply(bigRational2);
        bigRational2 = bigRational2.multiply(bigRational2);
        BigDecimal bigDecimal = new BigDecimal(bigRational2.getRational());
        bigDecimal = bigDecimal.abs();
        bigRational2 = bigRational2.multiply(new BigRational(1L, 10L));
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        List<IdealWithRealRoots<BigRational>> list2 = PolyUtilApp.realRoots(list, bigRational2);
        for (IdealWithRealRoots<BigRational> idealWithRealRoots : list2) {
            List list3 = idealWithRealRoots.ideal.getList();
            ArrayList<GenPolynomial<BigDecimal>> arrayList = new ArrayList<GenPolynomial<BigDecimal>>(list3.size());
            GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal2, idealWithRealRoots.ideal.list.ring);
            for (GenPolynomial genPolynomial : list3) {
                GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
                arrayList.add(genPolynomial2);
            }
            boolean bl = PolyUtilApp.isRealRoots(arrayList, idealWithRealRoots.rroots, bigDecimal);
            IdealTest.assertTrue((String)"isRealRoots ", (boolean)bl);
        }
    }

    public void testIdealComplexRoot() {
        BigRational bigRational = new BigRational(1L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 + 3 )");
        this.b = this.fac.parse("( y^2 - x )");
        this.c = this.fac.parse("( z^2 - x y )");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimRootDecomposition();
        IdealTest.assertTrue((String)"is decomposition ", (boolean)ideal.isZeroDimDecomposition(list));
        BigRational bigRational2 = new BigRational(1L, 1000000L);
        bigRational2 = bigRational2.multiply(bigRational2).multiply(bigRational2);
        BigDecimal bigDecimal = new BigDecimal(bigRational2.getRational());
        bigDecimal = bigDecimal.abs();
        List list2 = PolyUtilApp.complexAlgebraicRoots(list);
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal);
        int n = 0;
        int n2 = 0;
        for (IdealWithComplexAlgebraicRoots idealWithComplexAlgebraicRoots : list2) {
            List list3 = idealWithComplexAlgebraicRoots.ideal.getList();
            ArrayList<GenPolynomial<Complex<BigDecimal>>> arrayList = new ArrayList<GenPolynomial<Complex<BigDecimal>>>(list3.size());
            n2 += idealWithComplexAlgebraicRoots.can.size();
            GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal, idealWithComplexAlgebraicRoots.ideal.list.ring);
            GenPolynomialRing<BigDecimal> genPolynomialRing2 = new GenPolynomialRing<BigDecimal>(complexRing, genPolynomialRing);
            int n3 = 1;
            for (GenPolynomial genPolynomial : list3) {
                long l = genPolynomial.leadingExpVector().totalDeg();
                n3 = (int)((long)n3 * l);
                GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
                GenPolynomial<Complex<BigDecimal>> genPolynomial3 = PolyUtil.toComplex(genPolynomialRing2, genPolynomial2);
                arrayList.add(genPolynomial3);
            }
            n += n3;
            List<List<Complex<BigDecimal>>> list4 = idealWithComplexAlgebraicRoots.decimalApproximation();
        }
        logger.info("#roots = " + n2 + ", #vr-dim = " + n);
        IdealTest.assertTrue((String)("#roots(" + n2 + ") == degree(" + n + "): "), (n2 == n ? 1 : 0) != 0);
    }

    public void testNormalPosition() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^3 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        int[] nArray = ideal.normalPositionIndex2Vars();
        if (nArray == null) {
            nArray = ideal.normalPositionIndexUnivars();
        }
        if (nArray == null) {
            return;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        IdealWithUniv<BigRational> idealWithUniv = ideal.normalPositionFor(n, n2, null);
        boolean bl = idealWithUniv.ideal.isNormalPositionFor(n + 1, n2 + 1);
        IdealTest.assertTrue((String)"is normal position ", (boolean)bl);
        nArray = idealWithUniv.ideal.normalPositionIndex2Vars();
        if (nArray == null) {
            nArray = idealWithUniv.ideal.normalPositionIndexUnivars();
        }
        if (nArray == null) {
            return;
        }
        n = nArray[0];
        n2 = nArray[1];
        IdealTest.assertTrue((String)("i == 0: " + n), (n == 0 ? 1 : 0) != 0);
        IdealTest.assertTrue((String)("j == 2: " + n2), (n2 == 2 ? 1 : 0) != 0);
    }

    public void testRootDecomposition() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 7 )");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x * y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimRootDecomposition();
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)ideal.isZeroDimDecomposition(list));
    }

    public void testPrimeDecomposition() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )^2 ");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimPrimeDecomposition();
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)ideal.isZeroDimDecomposition(list));
    }

    public void testPrimaryDecomposition() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )^2 ");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.zeroDimPrimaryDecomposition();
        IdealTest.assertTrue((String)"is intersection ", (boolean)ideal.isPrimaryDecomposition(list));
    }

    public void testRootDecompositionReal() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )");
        this.b = this.fac.parse("( y^2 - 7 )");
        this.c = this.fac.parse("( z^3 - x * y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List<IdealWithRealAlgebraicRoots<BigRational>> list = PolyUtilApp.realAlgebraicRoots(ideal);
        ArrayList arrayList = new ArrayList();
        for (IdealWithRealAlgebraicRoots<BigRational> idealWithRealAlgebraicRoots : list) {
            arrayList.add(idealWithRealAlgebraicRoots);
        }
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)ideal.isZeroDimDecomposition(arrayList));
        for (IdealWithRealAlgebraicRoots<BigRational> idealWithRealAlgebraicRoots : list) {
            List<List<BigDecimal>> list2 = idealWithRealAlgebraicRoots.decimalApproximation();
        }
    }

    public void testExtCont() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( y + x y^2 ) ");
        this.b = this.fac.parse("( x z + x^2 y ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        IdealWithUniv idealWithUniv = ideal.extension("x");
        IdealWithUniv<BigRational> idealWithUniv2 = ideal.permContraction(idealWithUniv);
        IdealTest.assertTrue((String)"I subseteq Con(Ext(I)) ", (boolean)idealWithUniv2.ideal.contains(ideal));
    }

    public void testPrimeDecomp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( z^2 - x ) ");
        this.b = this.fac.parse("( y^2 - x ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.primeDecomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)ideal.isDecomposition(list));
        ArrayList arrayList = new ArrayList(list.size());
        for (IdealWithUniv idealWithUniv : list) {
            arrayList.add(idealWithUniv.ideal);
        }
        Ideal<BigRational> ideal2 = ideal.intersect(arrayList);
        IdealTest.assertTrue((String)"I == Ii ", (boolean)ideal.equals(ideal2));
    }

    public void testRadicalDecomp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 + 2 x y z + z^4 ) ");
        this.b = this.fac.parse("( y z - z^2 ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.radicalDecomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)ideal.isDecomposition(list));
        ArrayList arrayList = new ArrayList(list.size());
        for (IdealWithUniv idealWithUniv : list) {
            arrayList.add(idealWithUniv.ideal);
        }
        Ideal<BigRational> ideal2 = ideal.intersect(arrayList);
        IdealTest.assertTrue((String)"Ii.contains(I) ", (boolean)ideal2.contains(ideal));
    }

    public void testIrredDecomp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 + 2 x y z + z^4 ) ");
        this.b = this.fac.parse("( y z - z^2 ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.decomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)ideal.isDecomposition(list));
        ArrayList arrayList = new ArrayList(list.size());
        for (IdealWithUniv idealWithUniv : list) {
            arrayList.add(idealWithUniv.ideal);
        }
        Ideal<BigRational> ideal2 = ideal.intersect(arrayList);
        IdealTest.assertTrue((String)"Ii.contains(I) ", (boolean)ideal2.contains(ideal));
    }

    public void testPrimaryDecomp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        IdealTest.assertTrue((String)"vars.length == 3 ", (stringArray.length == 3 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x z^2 - 1 )^2 ");
        this.b = this.fac.parse("( y^2 - x ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L);
        ideal.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!ideal.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        List list = ideal.primaryDecomposition();
        ArrayList arrayList = new ArrayList(list.size());
        for (PrimaryComponent<BigRational> primaryComponent : list) {
            arrayList.add(primaryComponent.primary);
        }
        IdealTest.assertTrue((String)"I eq cup G_i ", (boolean)ideal.isPrimaryDecomposition(list));
    }

    public void testAnnihilator() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.a.isConstant());
        this.b = this.fac.univariate(1);
        this.c = this.fac.univariate(this.rl - 1);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)ideal.isGB());
        Ideal<BigRational> ideal2 = ideal.annihilator(this.c);
        ideal2.doGB();
        IdealTest.assertTrue((String)"isAnnihilator(c,J)", (boolean)ideal.isAnnihilator(this.c, ideal2));
        this.d = this.fac.univariate(this.rl - 2);
        this.M = new ArrayList<GenPolynomial<BigRational>>();
        this.M.add(this.c);
        this.M.add(this.d);
        Ideal<BigRational> ideal3 = new Ideal<BigRational>(this.fac, this.M);
        ideal2 = ideal.annihilator(ideal3);
        ideal2.doGB();
        IdealTest.assertTrue((String)"isAnnihilator(M,J)", (boolean)ideal.isAnnihilator(ideal3, ideal2));
    }
}

