/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.IterableDouble;
import common.iterable.IterableInt;
import common.iterable.IterableLong;
import common.iterable.SingletonIterator;
import java.util.Iterator;

public abstract class SingletonIterable<T>
implements Iterable<T> {

    public static class OfDouble
    extends SingletonIterable<Double>
    implements IterableDouble {
        final double element;

        public OfDouble(double d) {
            this.element = d;
        }

        @Override
        public SingletonIterator.OfDouble iterator() {
            return new SingletonIterator.OfDouble(this.element);
        }
    }

    public static class OfLong
    extends SingletonIterable<Long>
    implements IterableLong {
        final long element;

        public OfLong(long l) {
            this.element = l;
        }

        @Override
        public SingletonIterator.OfLong iterator() {
            return new SingletonIterator.OfLong(this.element);
        }
    }

    public static class OfInt
    extends SingletonIterable<Integer>
    implements IterableInt {
        final int element;

        public OfInt(int n) {
            this.element = n;
        }

        @Override
        public SingletonIterator.OfInt iterator() {
            return new SingletonIterator.OfInt(this.element);
        }
    }

    public static class Of<T>
    extends SingletonIterable<T> {
        final T element;

        public Of(T t) {
            this.element = t;
        }

        @Override
        public Iterator<T> iterator() {
            return new SingletonIterator.Of<T>(this.element);
        }
    }
}

