/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.IterableDouble;
import common.iterable.IterableInt;
import common.iterable.IterableLong;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class FilteringIterator<T>
implements Iterator<T> {
    protected final Iterator<T> iterator;
    protected boolean hasNext;

    public static <T> Iterator<T> nonNull(Iterable<T> iterable) {
        return FilteringIterator.nonNull(iterable.iterator());
    }

    public static <T> Iterator<T> nonNull(Iterator<T> iterator) {
        if (iterator instanceof PrimitiveIterator) {
            return iterator;
        }
        return new Of<Object>(iterator, Objects::nonNull);
    }

    public FilteringIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public FilteringIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    protected void requireNext() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
    }

    public static <T> Iterator<T> dedupe(Iterator<T> iterator) {
        HashSet hashSet = new HashSet();
        return new Of<Object>(iterator, hashSet::add);
    }

    public static OfInt dedupe(PrimitiveIterator.OfInt ofInt) {
        HashSet hashSet = new HashSet();
        return new OfInt(ofInt, hashSet::add);
    }

    public static OfLong dedupe(PrimitiveIterator.OfLong ofLong) {
        HashSet hashSet = new HashSet();
        return new OfLong(ofLong, hashSet::add);
    }

    public static OfDouble dedupe(PrimitiveIterator.OfDouble ofDouble) {
        HashSet hashSet = new HashSet();
        return new OfDouble(ofDouble, hashSet::add);
    }

    public static class OfDouble
    extends FilteringIterator<Double>
    implements PrimitiveIterator.OfDouble {
        protected final DoublePredicate predicate;
        private double next;

        public OfDouble(IterableDouble iterableDouble, DoublePredicate doublePredicate) {
            this(iterableDouble.iterator(), doublePredicate);
        }

        public OfDouble(PrimitiveIterator.OfDouble ofDouble, DoublePredicate doublePredicate) {
            super(ofDouble);
            this.predicate = doublePredicate;
            this.seekNext();
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            double d = this.next;
            this.seekNext();
            return d;
        }

        private void seekNext() {
            while (this.iterator.hasNext()) {
                this.next = ((PrimitiveIterator.OfDouble)this.iterator).nextDouble();
                if (!this.predicate.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }

    public static class OfLong
    extends FilteringIterator<Long>
    implements PrimitiveIterator.OfLong {
        protected final LongPredicate predicate;
        private long next;

        public OfLong(IterableLong iterableLong, LongPredicate longPredicate) {
            this(iterableLong.iterator(), longPredicate);
        }

        public OfLong(PrimitiveIterator.OfLong ofLong, LongPredicate longPredicate) {
            super(ofLong);
            this.predicate = longPredicate;
            this.seekNext();
        }

        @Override
        public long nextLong() {
            this.requireNext();
            long l = this.next;
            this.seekNext();
            return l;
        }

        private void seekNext() {
            while (this.iterator.hasNext()) {
                this.next = ((PrimitiveIterator.OfLong)this.iterator).nextLong();
                if (!this.predicate.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }

    public static class OfInt
    extends FilteringIterator<Integer>
    implements PrimitiveIterator.OfInt {
        protected final IntPredicate predicate;
        private int next;

        public OfInt(IterableInt iterableInt, IntPredicate intPredicate) {
            this(iterableInt.iterator(), intPredicate);
        }

        public OfInt(PrimitiveIterator.OfInt ofInt, IntPredicate intPredicate) {
            super(ofInt);
            this.predicate = intPredicate;
            this.seekNext();
        }

        @Override
        public int nextInt() {
            this.requireNext();
            int n = this.next;
            this.seekNext();
            return n;
        }

        private void seekNext() {
            while (this.iterator.hasNext()) {
                this.next = ((PrimitiveIterator.OfInt)this.iterator).nextInt();
                if (!this.predicate.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }

    public static class Of<T>
    extends FilteringIterator<T> {
        protected final Predicate<? super T> predicate;
        private T next;

        public Of(Iterable<T> iterable, Predicate<? super T> predicate) {
            this(iterable.iterator(), predicate);
        }

        public Of(Iterator<T> iterator, Predicate<? super T> predicate) {
            super(iterator);
            this.predicate = predicate;
            this.seekNext();
        }

        @Override
        public T next() {
            this.requireNext();
            T t = this.next;
            this.seekNext();
            return t;
        }

        private void seekNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.predicate.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
            this.next = null;
        }
    }
}

