/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import parser.ast.PropertiesFile;
import prism.PrismException;
import prism.Result;
import userinterface.GUIComputationThread;
import userinterface.GUIPrism;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.properties.GUIProperty;
import userinterface.util.GUIComputationEvent;

public class ModelCheckThread
extends GUIComputationThread {
    private GUIMultiProperties parent;
    private PropertiesFile propertiesFile;
    private ArrayList<GUIProperty> guiProps;

    public ModelCheckThread(GUIMultiProperties gUIMultiProperties, PropertiesFile propertiesFile, ArrayList<GUIProperty> arrayList) {
        super(gUIMultiProperties);
        this.parent = gUIMultiProperties;
        this.propertiesFile = propertiesFile;
        this.guiProps = arrayList;
    }

    @Override
    public void run() {
        int n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelCheckThread.this.parent.startProgress();
                ModelCheckThread.this.parent.setTaskBarText("Verifying properties...");
                ModelCheckThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, ModelCheckThread.this.parent));
            }
        });
        Result result = null;
        for (int i = 0; i < this.guiProps.size(); ++i) {
            GUIProperty gUIProperty = this.guiProps.get(i);
            gUIProperty.setStatus(1);
            this.parent.repaintList();
        }
        IconThread iconThread = new IconThread(null);
        for (int i = n = this.propertiesFile.getNumProperties() - this.guiProps.size(); i < this.propertiesFile.getNumProperties(); ++i) {
            GUIProperty gUIProperty = this.guiProps.get(i - n);
            iconThread = new IconThread(gUIProperty);
            iconThread.start();
            try {
                result = this.prism.modelCheck(this.propertiesFile, this.propertiesFile.getPropertyObject(i));
            }
            catch (Exception exception) {
                result = new Result(exception);
                this.error(exception);
            }
            catch (StackOverflowError stackOverflowError) {
                result = new Result(new PrismException("Stack overflow"));
                this.error(stackOverflowError);
            }
            iconThread.interrupt();
            try {
                iconThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            gUIProperty.setResult(result);
            gUIProperty.setMethodString("Verification");
            gUIProperty.setNumberOfWarnings(this.prism.getMainLog().getNumberOfWarnings());
            this.parent.repaintList();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelCheckThread.this.parent.stopProgress();
                ModelCheckThread.this.parent.setTaskBarText("Verifying properties... done.");
                ModelCheckThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, ModelCheckThread.this.parent));
                ModelCheckThread.this.parent.notifyEventListeners(new GUIPropertiesEvent(6));
            }
        });
    }

    class IconThread
    extends Thread {
        GUIProperty gp;
        ImageIcon[] images;
        boolean canContinue = false;

        public IconThread(GUIProperty gUIProperty) {
            this.gp = gUIProperty;
            this.images = new ImageIcon[8];
            this.images[0] = GUIPrism.getIconFromImage("smallClockAnim1.png");
            this.images[1] = GUIPrism.getIconFromImage("smallClockAnim2.png");
            this.images[2] = GUIPrism.getIconFromImage("smallClockAnim3.png");
            this.images[3] = GUIPrism.getIconFromImage("smallClockAnim4.png");
            this.images[4] = GUIPrism.getIconFromImage("smallClockAnim5.png");
            this.images[5] = GUIPrism.getIconFromImage("smallClockAnim6.png");
            this.images[6] = GUIPrism.getIconFromImage("smallClockAnim7.png");
            this.images[7] = GUIPrism.getIconFromImage("smallClockAnim8.png");
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (!IconThread.interrupted() && this.gp != null) {
                    ++n;
                    this.gp.setDoingImage(this.images[n %= 8]);
                    ModelCheckThread.this.parent.repaintList();
                    IconThread.sleep(150L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.canContinue = true;
        }
    }
}

