/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.pepaModel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.Style;

public class GUIPepaModelEditor
extends GUIModelEditor
implements DocumentListener {
    private JEditorPane editor = new JEditorPane();
    private UndoManager undoManager;
    private PlainDocument d;
    private GUIMultiModelHandler handler;
    static final Style PLAIN_S = new Style(Color.black, 0);

    public GUIPepaModelEditor(GUIMultiModelHandler gUIMultiModelHandler) {
        PepaEditorKit pepaEditorKit = new PepaEditorKit();
        this.editor.setEditorKitForContentType("text/pepa", pepaEditorKit);
        this.editor.setContentType("text/pepa");
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(200);
        this.handler = gUIMultiModelHandler;
        this.d = (PlainDocument)this.editor.getDocument();
        this.editor.getDocument().addDocumentListener(this);
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.editor);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.handler != null) {
            this.handler.hasModified(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.handler != null) {
            this.handler.hasModified(true);
        }
    }

    @Override
    public String getParseText() {
        return this.editor.getText();
    }

    @Override
    public void newModel() {
        this.editor.setText("");
    }

    public void read(Reader reader, Object object) throws IOException {
        this.editor.read(reader, object);
        this.d = (PlainDocument)this.editor.getDocument();
        this.d.addDocumentListener(this);
    }

    public void write(Writer writer) throws IOException {
        this.editor.write(writer);
    }

    @Override
    public void undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    @Override
    public void redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    @Override
    public void copy() {
        this.editor.copy();
    }

    @Override
    public void cut() {
        this.editor.cut();
    }

    @Override
    public void paste() {
        this.editor.paste();
    }

    @Override
    public void delete() {
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public void setEditorFont(Font font) {
        this.editor.setFont(font);
    }

    public void setEditorBackground(Color color) {
        this.editor.setBackground(color);
    }

    class PepaView
    extends PlainView {
        private Matcher match;
        private Pattern pattern;

        public PepaView(Element element) {
            super(element);
            this.pattern = Pattern.compile("%.*");
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Object object;
            int n5 = this.findStartOfLine(n3, this.getDocument());
            int n6 = this.findEndOfLine(n4, this.getDocument());
            if (graphics instanceof Graphics2D) {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            try {
                graphics.setColor(Color.green);
                object = this.getDocument();
                Segment segment = this.getLineBuffer();
                String string = object.getText(n5, n6 - n5);
                Style[] styleArray = this.highlight(string, n3 - n5, n4 - n3);
                boolean bl = false;
                boolean bl2 = false;
                Object var14_15 = null;
                String string2 = GUIPepaModelEditor.this.handler.getPepaEditorFontFast().getName();
                int n7 = GUIPepaModelEditor.this.handler.getPepaEditorFontFast().getSize();
                for (int i = 0; i < styleArray.length; ++i) {
                    Style style = styleArray[i];
                    graphics.setColor(style.c);
                    graphics.setFont(new Font(string2, style.style, n7));
                    Segment segment2 = this.getLineBuffer();
                    object.getText(n3 + i, 1, segment2);
                    n = Utilities.drawTabbedText(segment2, n, n2, graphics, (TabExpander)this, n3 + i);
                }
                graphics.setColor(Color.black);
                graphics.setFont(new Font(string2, 0, n7));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n;
        }

        @Override
        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Object object;
            int n5 = this.findStartOfLine(n3, this.getDocument());
            int n6 = this.findEndOfLine(n4, this.getDocument());
            if (graphics instanceof Graphics2D) {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            try {
                graphics.setColor(Color.green);
                object = this.getDocument();
                Segment segment = this.getLineBuffer();
                String string = object.getText(n5, n6 - n5);
                Style[] styleArray = this.highlight(string, n3 - n5, n4 - n3);
                boolean bl = false;
                boolean bl2 = false;
                Object var14_15 = null;
                String string2 = GUIPepaModelEditor.this.handler.getPepaEditorFontFast().getName();
                int n7 = GUIPepaModelEditor.this.handler.getPepaEditorFontFast().getSize();
                for (int i = 0; i < styleArray.length; ++i) {
                    Style style = styleArray[i];
                    graphics.setColor(style.c);
                    graphics.setFont(new Font(string2, style.style, n7));
                    Segment segment2 = this.getLineBuffer();
                    object.getText(n3 + i, 1, segment2);
                    n = Utilities.drawTabbedText(segment2, n, n2, graphics, (TabExpander)this, n3 + i);
                }
                graphics.setColor(Color.black);
                graphics.setFont(new Font(string2, 0, n7));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n;
        }

        private synchronized Style[] highlight(String string, int n, int n2) {
            int n3;
            Style[] styleArray = new Style[string.length()];
            for (n3 = 0; n3 < styleArray.length; ++n3) {
                styleArray[n3] = PLAIN_S;
            }
            this.match = this.pattern.matcher(string);
            n3 = 0;
            int n4 = 0;
            boolean bl = this.match.find();
            while (bl) {
                n3 = this.match.start();
                n4 = this.match.end();
                for (int i = n3; i < n4; ++i) {
                    styleArray[i] = GUIPepaModelEditor.this.handler.getPepaEditorCommentFast();
                }
                bl = this.match.find();
            }
            Style[] styleArray2 = new Style[n2];
            for (int i = 0; i < styleArray2.length; ++i) {
                styleArray2[i] = styleArray[i + n];
            }
            return styleArray2;
        }

        private synchronized int findStartOfLine(int n, Document document) {
            int n2 = n;
            String string = "";
            try {
                string = document.getText(n2, 1);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            if (string.equals("\n") || --n2 < -1) {
                --n2;
            }
            while (!string.equals("\n") && n2 >= -1) {
                try {
                    string = document.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    return 0;
                }
                --n2;
            }
            return n2 += 2;
        }

        private synchronized int findEndOfLine(int n, Document document) {
            int n2 = n;
            String string = "";
            try {
                string = document.getText(n2, 1);
            }
            catch (BadLocationException badLocationException) {
                return document.getLength();
            }
            ++n2;
            while (!string.equals("\n") && n2 <= document.getLength()) {
                try {
                    string = document.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    return document.getLength() - 1;
                }
                ++n2;
            }
            return --n2;
        }
    }

    class PepaContext
    extends StyleContext
    implements ViewFactory {
        public static final String COMMENT_D = "Single Line Comment";

        @Override
        public View create(Element element) {
            return new PepaView(element);
        }
    }

    class PepaEditorKit
    extends DefaultEditorKit {
        private PepaContext preferences;

        public PepaContext getStylePreferences() {
            if (this.preferences == null) {
                this.preferences = new PepaContext();
            }
            return this.preferences;
        }

        public void setStylePreferences(PepaContext pepaContext) {
            this.preferences = pepaContext;
        }

        @Override
        public String getContentType() {
            return "text/pepa";
        }

        @Override
        public Document createDefaultDocument() {
            return new PlainDocument();
        }

        @Override
        public final ViewFactory getViewFactory() {
            return this.getStylePreferences();
        }
    }
}

