/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import parser.Values;
import parser.type.Type;
import prism.PrismException;
import prism.UndefinedConstants;
import userinterface.GUIPrism;

public class GUIConstantsPicker
extends JDialog {
    public static final int NO_VALUES = 0;
    public static final int VALUES_DONE = 1;
    public static final int CANCELLED = 2;
    private boolean cancelled = true;
    private JTable propTable;
    private DefineConstantTable propTableModel;
    private JTable modelTable;
    private DefineConstantTable modelTableModel;
    private boolean areModel;
    private boolean areProp;
    private Action okAction;
    private Action cancelAction;
    private JButton okayButton;
    private UndefinedConstants undef;
    private GUIPrism gui;
    JPanel topPanel;

    public GUIConstantsPicker(GUIPrism gUIPrism, UndefinedConstants undefinedConstants, boolean bl, boolean bl2, Values values, Values values2) {
        super(gUIPrism, "Define Constants", true);
        this.areModel = bl;
        this.areProp = bl2;
        this.undef = undefinedConstants;
        this.gui = gUIPrism;
        this.propTableModel = new DefineConstantTable();
        this.modelTableModel = new DefineConstantTable();
        this.propTable = new JTable();
        this.modelTable = new JTable();
        this.propTable.setModel(this.propTableModel);
        this.modelTable.setModel(this.modelTableModel);
        this.propTable.setSelectionMode(1);
        this.modelTable.setSelectionMode(1);
        this.propTable.setCellSelectionEnabled(true);
        this.modelTable.setCellSelectionEnabled(true);
        this.propTable.setRowHeight(this.getFontMetrics(this.propTable.getFont()).getHeight() + 4);
        this.modelTable.setRowHeight(this.getFontMetrics(this.modelTable.getFont()).getHeight() + 4);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.initTables(bl, bl2);
        this.initValues(undefinedConstants, values, values2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel = new JLabel();
        this.topPanel = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.okayButton = new JButton();
        JButton jButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIConstantsPicker.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        jLabel.setText("Please define the following constants:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.topPanel, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel6.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIConstantsPicker.this.okayButtonActionPerformed(actionEvent);
            }
        });
        jPanel6.add(this.okayButton);
        jButton.setText("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIConstantsPicker.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel6.add(jButton);
        this.getContentPane().add((Component)jPanel6, "South");
        this.pack();
    }

    private void initTables(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("Model Constants"));
            jPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.modelTable);
            jPanel.add(jScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("Property Constants"));
            jPanel2.setLayout(new BorderLayout());
            JScrollPane jScrollPane2 = new JScrollPane();
            jScrollPane2.setViewportView(this.propTable);
            jPanel2.add(jScrollPane2);
            this.topPanel.add(jPanel);
            this.topPanel.add(jPanel2);
        } else if (bl) {
            this.topPanel.setBorder(new TitledBorder("Model Constants"));
            this.topPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.modelTable);
            this.topPanel.add(jScrollPane);
        } else if (bl2) {
            this.topPanel.setBorder(new TitledBorder("Property Constants"));
            this.topPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.propTable);
            this.topPanel.add(jScrollPane);
        }
        this.topPanel.setPreferredSize(new Dimension(500, 200));
    }

    private void initValues(UndefinedConstants undefinedConstants, Values values, Values values2) {
        Object object;
        Constant constant;
        int n;
        for (n = 0; n < undefinedConstants.getMFNumUndefined(); ++n) {
            constant = new Constant(undefinedConstants.getMFUndefinedName(n), undefinedConstants.getMFUndefinedType(n), "");
            if (values != null) {
                try {
                    constant.value = object = values.getValueOf(constant.name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.modelTableModel.addConstant(constant);
        }
        for (n = 0; n < undefinedConstants.getPFNumUndefined(); ++n) {
            constant = new Constant(undefinedConstants.getPFUndefinedName(n), undefinedConstants.getPFUndefinedType(n), "");
            if (values2 != null) {
                try {
                    constant.value = object = values2.getValueOf(constant.name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.propTableModel.addConstant(constant);
        }
    }

    public static int defineConstantsWithDialog(GUIPrism gUIPrism, UndefinedConstants undefinedConstants, Values values, Values values2) {
        boolean bl;
        boolean bl2 = undefinedConstants.getMFNumUndefined() > 0;
        boolean bl3 = bl = undefinedConstants.getPFNumUndefined() > 0;
        if (bl2 || bl) {
            return new GUIConstantsPicker(gUIPrism, undefinedConstants, bl2, bl, values, values2).defineValues();
        }
        return 0;
    }

    public int defineValues() {
        this.show();
        if (this.cancelled) {
            return 2;
        }
        return 1;
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        if (this.areProp && this.propTable.getCellEditor() != null) {
            this.propTable.getCellEditor().stopCellEditing();
        }
        if (this.areModel && this.modelTable.getCellEditor() != null) {
            this.modelTable.getCellEditor().stopCellEditing();
        }
        try {
            Constant constant;
            int n;
            int n2 = this.modelTableModel.getNumConstants();
            for (n = 0; n < n2; ++n) {
                constant = this.modelTableModel.getConstant(n);
                this.undef.defineConstant(constant.name, "" + constant.value);
            }
            n2 = this.propTableModel.getNumConstants();
            for (n = 0; n < n2; ++n) {
                constant = this.propTableModel.getConstant(n);
                this.undef.defineConstant(constant.name, "" + constant.value);
            }
            this.undef.checkAllDefined();
            this.undef.initialiseIterators();
            this.cancelled = false;
            this.dispose();
        }
        catch (PrismException prismException) {
            this.gui.errorDialog(prismException.getMessage());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    class Constant {
        String name;
        Type type;
        Object value;

        public Constant(String string, Type type, Object object) {
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public String toString() {
            return this.name + "=" + this.value.toString();
        }
    }

    class DefineConstantTable
    extends AbstractTableModel {
        ArrayList constants = new ArrayList();

        public void addConstant(Constant constant) {
            this.constants.add(constant);
            this.fireTableRowsInserted(this.constants.size() - 1, this.constants.size() - 1);
        }

        public int getNumConstants() {
            return this.constants.size();
        }

        public Constant getConstant(int n) {
            return (Constant)this.constants.get(n);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.constants.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Constant constant = (Constant)this.constants.get(n);
            switch (n2) {
                case 0: {
                    return constant.name;
                }
                case 1: {
                    return constant.type.getTypeString();
                }
                case 2: {
                    return constant.value.toString();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                Constant constant = (Constant)this.constants.get(n);
                String string = (String)object;
                constant.value = string;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public String toString() {
            Object object = "";
            for (int i = 0; i < this.constants.size(); ++i) {
                Constant constant = (Constant)this.constants.get(i);
                object = (String)object + constant.toString();
                if (i == this.constants.size() - 1) continue;
                object = (String)object + ",";
            }
            return object;
        }
    }
}

