/*
 * Decompiled with CFR 0.152.
 */
package sparse;

import dv.DoubleVector;
import dv.IntegerVector;
import java.io.FileNotFoundException;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import odd.ODDUtils;
import prism.NativeIntArray;
import prism.OpsAndBoundsList;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import sparse.NDSparseMatrix;

public class PrismSparse {
    private static PrismLog mainLog;
    private static PrismLog techLog;

    public static void initialise(PrismLog prismLog, PrismLog prismLog2) {
        PrismSparse.setCUDDManager();
        PrismSparse.setMainLog(prismLog);
        PrismSparse.setTechLog(prismLog2);
    }

    public static void closeDown() {
        PrismSparse.PS_FreeGlobalRefs();
    }

    private static native void PS_FreeGlobalRefs();

    private static void checkNumStates(ODDNode oDDNode) throws PrismNotSupportedException {
        ODDUtils.checkInt(oDDNode, "Currently, the sparse engine cannot handle models");
    }

    private static native void PS_SetCUDDManager(long var0);

    public static void setCUDDManager() {
        PrismSparse.PS_SetCUDDManager(JDD.GetCUDDManager());
    }

    private static native void PS_SetMainLog(PrismLog var0);

    public static void setMainLog(PrismLog prismLog) {
        mainLog = prismLog;
        PrismSparse.PS_SetMainLog(prismLog);
    }

    private static native void PS_SetTechLog(PrismLog var0);

    public static void setTechLog(PrismLog prismLog) {
        techLog = prismLog;
        PrismSparse.PS_SetTechLog(prismLog);
    }

    private static native void PS_SetExportIterations(boolean var0);

    public static void SetExportIterations(boolean bl) {
        PrismSparse.PS_SetExportIterations(bl);
    }

    private static native String PS_GetErrorMessage();

    public static String getErrorMessage() {
        return PrismSparse.PS_GetErrorMessage();
    }

    private static PrismException generateExceptionForError() {
        String string = PrismSparse.getErrorMessage();
        if (string.contains("not supported")) {
            return new PrismNotSupportedException(string);
        }
        return new PrismException(string);
    }

    private static native long PS_ProbBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14);

    public static DoubleVector ProbBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12);

    public static DoubleVector ProbUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr());
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbUntilInterval(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14);

    public static DoubleVector ProbUntilInterval(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbUntilInterval(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, int var14);

    public static DoubleVector ProbCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbInstReward(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static DoubleVector ProbInstReward(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbInstReward(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbReachReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, long var16, long var18);

    public static DoubleVector ProbReachReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbReachReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr());
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbReachRewardInterval(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, long var16, long var18, long var20, long var22, int var24);

    public static DoubleVector ProbReachRewardInterval(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, JDDNode jDDNode8, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbReachRewardInterval(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), jDDNode8.ptr(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_ProbTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static DoubleVector ProbTransient(JDDNode jDDNode, ODDNode oDDNode, DoubleVector doubleVector, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_ProbTransient(jDDNode.ptr(), oDDNode.ptr(), doubleVector.getPtr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13, long var15, int var17, boolean var18);

    public static DoubleVector NondetBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode2, JDDNode jDDNode3, int n, boolean bl) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode2.ptr(), jDDNode3.ptr(), n, bl);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetUntil(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long var16, long var18, boolean var20, long var21);

    public static DoubleVector NondetUntil(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, IntegerVector integerVector) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetUntil(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), bl, integerVector == null ? 0L : integerVector.getPtr());
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetUntilInterval(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long var16, long var18, boolean var20, long var21, int var23);

    public static DoubleVector NondetUntilInterval(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, IntegerVector integerVector, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetUntilInterval(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), bl, integerVector == null ? 0L : integerVector.getPtr(), n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, int var16, int var17, boolean var18);

    public static DoubleVector NondetCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, int n, boolean bl) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), n, bl);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetInstReward(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, int var15, boolean var16, long var17);

    public static DoubleVector NondetInstReward(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, int n, boolean bl, JDDNode jDDNode3) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetInstReward(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), n, bl, jDDNode3.ptr());
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetReachReward(long var0, long var2, List<String> var4, long var5, long var7, long var9, long var11, int var13, long var14, int var16, long var17, int var19, long var20, long var22, long var24, boolean var26);

    public static DoubleVector NondetReachReward(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, JDDNode jDDNode3, JDDNode jDDNode4, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, boolean bl) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetReachReward(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, jDDNode3.ptr(), jDDNode4.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), bl);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_NondetReachRewardInterval(long var0, long var2, List<String> var4, long var5, long var7, long var9, long var11, int var13, long var14, int var16, long var17, int var19, long var20, long var22, long var24, long var26, long var28, boolean var30, int var31);

    public static DoubleVector NondetReachRewardInterval(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, JDDNode jDDNode3, JDDNode jDDNode4, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, JDDNode jDDNode8, JDDNode jDDNode9, boolean bl, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_NondetReachRewardInterval(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, jDDNode3.ptr(), jDDNode4.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), jDDNode8.ptr(), jDDNode9.ptr(), bl, n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native double[] PS_NondetMultiObj(long var0, long var2, int var4, long var5, int var7, long var8, int var10, boolean var11, long var12, long var14, long var16, List<String> var18, long[] var19, int[] var20, long[] var21, double[] var22, int[] var23);

    public static double[] NondetMultiObj(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, boolean bl, JDDNode jDDNode, NativeIntArray nativeIntArray, NDSparseMatrix nDSparseMatrix, List<String> list, DoubleVector[] doubleVectorArray, int[] nArray, NDSparseMatrix[] nDSparseMatrixArray, double[] dArray, int[] nArray2) throws PrismException {
        double[] dArray2;
        PrismSparse.checkNumStates(oDDNode);
        long[] lArray = null;
        if (nDSparseMatrixArray != null) {
            lArray = new long[nDSparseMatrixArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = nDSparseMatrixArray[i] != null ? nDSparseMatrixArray[i].getPtr() : 0L;
            }
        }
        long[] lArray2 = null;
        if (doubleVectorArray != null) {
            lArray2 = new long[doubleVectorArray.length];
            for (int i = 0; i < doubleVectorArray.length; ++i) {
                lArray2[i] = doubleVectorArray[i] != null ? doubleVectorArray[i].getPtr() : 0L;
            }
        }
        if ((dArray2 = PrismSparse.PS_NondetMultiObj(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), bl, jDDNode.ptr(), nativeIntArray.getPtr(), nDSparseMatrix.getPtr(), list, lArray2, nArray, lArray, dArray, nArray2)) == null) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return dArray2;
    }

    private static native double[] PS_NondetMultiObjGS(long var0, long var2, int var4, long var5, int var7, long var8, int var10, boolean var11, long var12, long var14, long var16, long[] var18, long[] var19, double[] var20);

    public static double[] NondetMultiObjGS(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, boolean bl, JDDNode jDDNode, NativeIntArray nativeIntArray, NDSparseMatrix nDSparseMatrix, DoubleVector[] doubleVectorArray, NDSparseMatrix[] nDSparseMatrixArray, double[] dArray) throws PrismException {
        double[] dArray2;
        PrismSparse.checkNumStates(oDDNode);
        long[] lArray = null;
        if (nDSparseMatrixArray != null) {
            lArray = new long[nDSparseMatrixArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = nDSparseMatrixArray[i] != null ? nDSparseMatrixArray[i].getPtr() : 0L;
            }
        }
        long[] lArray2 = null;
        if (doubleVectorArray != null) {
            lArray2 = new long[doubleVectorArray.length];
            for (int i = 0; i < doubleVectorArray.length; ++i) {
                lArray2[i] = doubleVectorArray[i] != null ? doubleVectorArray[i].getPtr() : 0L;
            }
        }
        if ((dArray2 = PrismSparse.PS_NondetMultiObjGS(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), bl, jDDNode.ptr(), nativeIntArray.getPtr(), nDSparseMatrix.getPtr(), lArray2, lArray, dArray)) == null) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return dArray2;
    }

    private static native double PS_NondetMultiReach(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long[] var16, int[] var17, double[] var18, long var19, long var21);

    public static double NondetMultiReach(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, List<JDDNode> list2, OpsAndBoundsList opsAndBoundsList, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        int n = list2.size();
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = list2.get(i).ptr();
            nArray[i] = opsAndBoundsList.getProbOperator(i).toNumber();
            dArray[i] = opsAndBoundsList.getProbBound(i);
        }
        double d = PrismSparse.PS_NondetMultiReach(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), lArray, nArray, dArray, jDDNode3.ptr(), jDDNode4.ptr());
        if (d == -1.0) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return d;
    }

    private static native double PS_NondetMultiReach1(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long[] var16, long[] var17, int[] var18, int[] var19, double[] var20, long var21, long var23);

    public static double NondetMultiReach1(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, List<JDDNode> list2, List<JDDNode> list3, List<Integer> list4, OpsAndBoundsList opsAndBoundsList, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        int n;
        PrismSparse.checkNumStates(oDDNode);
        int n2 = list2.size();
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            lArray[n] = list2.get(n).ptr();
            nArray[n] = opsAndBoundsList.getProbOperator(n).toNumber();
            dArray[n] = opsAndBoundsList.getProbBound(n);
        }
        long[] lArray2 = new long[list3.size()];
        int[] nArray2 = new int[list4.size()];
        for (n = 0; n < list3.size(); ++n) {
            lArray2[n] = list3.get(n).ptr();
        }
        for (n = 0; n < list4.size(); ++n) {
            nArray2[n] = list4.get(n);
        }
        double d = PrismSparse.PS_NondetMultiReach1(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), lArray, lArray2, nArray2, nArray, dArray, jDDNode3.ptr(), jDDNode4.ptr());
        if (d == -1.0) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return d;
    }

    private static native double PS_NondetMultiReachReward(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long[] var16, int[] var17, double[] var18, int[] var19, double[] var20, long var21, long var23, long[] var25, long var26);

    public static double NondetMultiReachReward(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, List<JDDNode> list2, OpsAndBoundsList opsAndBoundsList, JDDNode jDDNode3, JDDNode jDDNode4, List<JDDNode> list3, JDDNode jDDNode5) throws PrismException {
        int n;
        PrismSparse.checkNumStates(oDDNode);
        long[] lArray = new long[list2.size()];
        int[] nArray = new int[opsAndBoundsList.probSize()];
        double[] dArray = new double[opsAndBoundsList.probSize()];
        int[] nArray2 = new int[opsAndBoundsList.rewardSize()];
        double[] dArray2 = new double[opsAndBoundsList.rewardSize()];
        long[] lArray2 = new long[list3.size()];
        long l = jDDNode5.ptr();
        for (n = 0; n < list2.size(); ++n) {
            lArray[n] = list2.get(n).ptr();
        }
        for (n = 0; n < opsAndBoundsList.probSize(); ++n) {
            nArray[n] = opsAndBoundsList.getProbOperator(n).toNumber();
            dArray[n] = opsAndBoundsList.getProbBound(n);
        }
        for (n = 0; n < opsAndBoundsList.rewardSize(); ++n) {
            nArray2[n] = opsAndBoundsList.getRewardOperator(n).toNumber();
            dArray2[n] = opsAndBoundsList.getRewardBound(n);
        }
        for (n = 0; n < list3.size(); ++n) {
            lArray2[n] = list3.get(n).ptr();
        }
        double d = PrismSparse.PS_NondetMultiReachReward(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), lArray, nArray, dArray, nArray2, dArray2, jDDNode3.ptr(), jDDNode4.ptr(), lArray2, l);
        if (d == -1.0) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return d;
    }

    private static native double PS_NondetMultiReachReward1(long var0, long var2, List<String> var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, long[] var16, long[] var17, int[] var18, int[] var19, double[] var20, int[] var21, double[] var22, long var23, long var25, long[] var27, long var28);

    public static double NondetMultiReachReward1(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, List<JDDNode> list2, List<JDDNode> list3, List<Integer> list4, OpsAndBoundsList opsAndBoundsList, JDDNode jDDNode3, JDDNode jDDNode4, List<JDDNode> list5, JDDNode jDDNode5) throws PrismException {
        int n;
        PrismSparse.checkNumStates(oDDNode);
        long[] lArray = new long[list2.size()];
        int[] nArray = new int[opsAndBoundsList.probSize()];
        double[] dArray = new double[opsAndBoundsList.probSize()];
        int[] nArray2 = new int[opsAndBoundsList.rewardSize()];
        double[] dArray2 = new double[opsAndBoundsList.rewardSize()];
        long[] lArray2 = new long[list5.size()];
        long l = jDDNode5.ptr();
        for (n = 0; n < list2.size(); ++n) {
            lArray[n] = list2.get(n).ptr();
        }
        for (n = 0; n < opsAndBoundsList.probSize(); ++n) {
            nArray[n] = opsAndBoundsList.getProbOperator(n).toNumber();
            dArray[n] = opsAndBoundsList.getProbBound(n);
        }
        for (n = 0; n < opsAndBoundsList.rewardSize(); ++n) {
            nArray2[n] = opsAndBoundsList.getRewardOperator(n).toNumber();
            dArray2[n] = opsAndBoundsList.getRewardBound(n);
        }
        for (n = 0; n < list5.size(); ++n) {
            lArray2[n] = list5.get(n).ptr();
        }
        long[] lArray3 = new long[list3.size()];
        int[] nArray3 = new int[list4.size()];
        for (n = 0; n < list3.size(); ++n) {
            lArray3[n] = list3.get(n).ptr();
        }
        for (n = 0; n < list4.size(); ++n) {
            nArray3[n] = list4.get(n);
        }
        double d = PrismSparse.PS_NondetMultiReachReward1(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), lArray, lArray3, nArray3, nArray, dArray, nArray2, dArray2, jDDNode3.ptr(), jDDNode4.ptr(), lArray2, l);
        if (d == -1.0) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return d;
    }

    private static native long PS_StochBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, double var14, long var16);

    public static DoubleVector StochBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, double d, DoubleVector doubleVector) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = doubleVector == null ? 0L : doubleVector.getPtr();
        long l2 = PrismSparse.PS_StochBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), d, l);
        if (l2 == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l2, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_StochCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, double var14);

    public static DoubleVector StochCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_StochCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_StochSteadyState(long var0, long var2, long var4, long var6, int var8, long var9, int var11);

    public static DoubleVector StochSteadyState(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_StochSteadyState(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n());
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_StochTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, double var12);

    public static DoubleVector StochTransient(JDDNode jDDNode, ODDNode oDDNode, DoubleVector doubleVector, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_StochTransient(jDDNode.ptr(), oDDNode.ptr(), doubleVector.getPtr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native int PS_ExportMatrix(long var0, String var2, long var3, int var5, long var6, int var8, long var9, int var11, String var12);

    public static void ExportMatrix(JDDNode jDDNode, String string, JDDVars jDDVars, JDDVars jDDVars2, ODDNode oDDNode, int n, String string2) throws FileNotFoundException, PrismException {
        PrismSparse.checkNumStates(oDDNode);
        int n2 = PrismSparse.PS_ExportMatrix(jDDNode.ptr(), string, jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
        if (n2 == -2) {
            throw new PrismException("Out of memory building matrix for export");
        }
    }

    private static native int PS_ExportMDP(long var0, long var2, List<String> var4, String var5, long var6, int var8, long var9, int var11, long var12, int var14, long var15, int var17, String var18);

    public static void ExportMDP(JDDNode jDDNode, JDDNode jDDNode2, List<String> list, String string, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, ODDNode oDDNode, int n, String string2) throws FileNotFoundException, PrismException {
        PrismSparse.checkNumStates(oDDNode);
        int n2 = PrismSparse.PS_ExportMDP(jDDNode.ptr(), jDDNode2 == null ? 0L : jDDNode2.ptr(), list, string, jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
        if (n2 == -2) {
            throw new PrismException("Out of memory building matrix for export");
        }
    }

    private static native int PS_ExportSubMDP(long var0, long var2, String var4, long var5, int var7, long var8, int var10, long var11, int var13, long var14, int var16, String var17);

    public static void ExportSubMDP(JDDNode jDDNode, JDDNode jDDNode2, String string, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, ODDNode oDDNode, int n, String string2) throws FileNotFoundException, PrismException {
        PrismSparse.checkNumStates(oDDNode);
        int n2 = PrismSparse.PS_ExportSubMDP(jDDNode.ptr(), jDDNode2.ptr(), string, jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
        if (n2 == -2) {
            throw new PrismException("Out of memory building matrix for export");
        }
    }

    private static native long PS_Power(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14);

    public static DoubleVector Power(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_Power(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_PowerInterval(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, long var14, boolean var16, int var17);

    public static DoubleVector PowerInterval(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_PowerInterval(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDNode4.ptr(), bl, n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_JOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, boolean var15, double var16);

    public static DoubleVector JOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, boolean bl2, double d) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_JOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, bl2, d);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_JORInterval(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, long var14, boolean var16, boolean var17, double var18, int var20);

    public static DoubleVector JORInterval(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, boolean bl2, double d, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_JORInterval(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDNode4.ptr(), bl, bl2, d, n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_SOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, boolean var15, double var16, boolean var18);

    public static DoubleVector SOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, boolean bl2, double d, boolean bl3) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_SOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, bl2, d, bl3);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PS_SORInterval(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, long var14, boolean var16, boolean var17, double var18, boolean var20, int var21);

    public static DoubleVector SORInterval(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, boolean bl2, double d, boolean bl3, int n) throws PrismException {
        PrismSparse.checkNumStates(oDDNode);
        long l = PrismSparse.PS_SORInterval(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDNode4.ptr(), bl, bl2, d, bl3, n);
        if (l == 0L) {
            throw PrismSparse.generateExceptionForError();
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    static {
        try {
            System.loadLibrary("prismsparse");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

