/*
 * Decompiled with CFR 0.152.
 */
package simulator.networking;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import parser.Values;
import prism.PrismException;
import prism.ResultsCollection;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingException;
import settings.SettingOwner;
import settings.SingleLineStringSetting;
import simulator.networking.FileSystem;
import simulator.networking.RemoteHandler;
import simulator.networking.SSHHost;
import simulator.networking.SimulatorResultsFile;

public class SimulatorNetworkHandler
extends Observable
implements EntityResolver,
SettingOwner,
TreeNode,
TableModel {
    public static final String EXECUTABLE = "prismsimulator";
    public static final int NOT_RUNNING = 0;
    public static final int RUNNING = 1;
    public SingleLineStringSetting networkName;
    public SingleLineStringSetting sshCommand;
    public SingleLineStringSetting scpCommand;
    private int networkState;
    private Vector fileSystems;
    private File networkFile;
    private SettingDisplay display;
    private File simBinary;
    private long maxPathLength;
    private int noIterations;
    private boolean feedback;
    private boolean resultsFeedback;
    private SimulatorResultsFile srf = new SimulatorResultsFile();
    private Values modelConstants;
    private ArrayList propertyConstantRanges;
    private ResultsCollection resultsCollection;
    private AbstractTableModel tableModel = new AbstractTableModel(){

        public Class getColumnClass(int n) {
            if (n == 3) {
                return JProgressBar.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Status";
                }
                case 2: {
                    return "Iterations Total";
                }
                case 3: {
                    return "Current Progress";
                }
                case 4: {
                    return "Number of Starts";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            int n = 0;
            for (int i = 0; i < SimulatorNetworkHandler.this.getNumFileSystems(); ++i) {
                n += SimulatorNetworkHandler.this.getFileSystem(i).getNumHosts();
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SSHHost sSHHost = SimulatorNetworkHandler.this.getHost(n);
            switch (n2) {
                case 0: {
                    return sSHHost.getHostName();
                }
                case 1: {
                    Object object = "";
                    switch (sSHHost.getHostState()) {
                        case 0: 
                        case 1: {
                            object = "Ready";
                            break;
                        }
                        case 2: {
                            object = "Sending Files...";
                            break;
                        }
                        case 3: {
                            object = "Running...";
                            break;
                        }
                        case 5: {
                            object = "Retrieving Files...";
                            break;
                        }
                        case 7: {
                            return "Error: " + sSHHost.getErrorMessage();
                        }
                        case 6: {
                            return "Done";
                        }
                        case 8: {
                            return "Stopped";
                        }
                        default: {
                            return "";
                        }
                    }
                    if (sSHHost.isStopping()) {
                        object = (String)object + " (stopping)";
                    }
                    return object;
                }
                case 2: {
                    return "" + sSHHost.getTotalDone();
                }
                case 3: {
                    return sSHHost.getProgressBar();
                }
                case 4: {
                    return "" + sSHHost.getTotalStints();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };

    public SimulatorNetworkHandler() {
        this.fileSystems = new Vector();
        this.networkName = new SingleLineStringSetting("network name", "default", "A name for this network profile.  Each network profile is a collection of network clusters.  Each cluster has the characteristic that it has the same filesystem.", (SettingOwner)this, false);
        this.sshCommand = new SingleLineStringSetting("ssh command", "/usr/bin/ssh2", "The location on the network cluster's filesystem of the ssh command", (SettingOwner)this, true);
        this.scpCommand = new SingleLineStringSetting("scp command", "/usr/bin/scp2", "The location on the network cluster's filesystem of the scp command", (SettingOwner)this, true);
        this.setState(0);
    }

    public void setState(int n) {
        this.networkState = n;
        this.setChanged();
        this.notifyObservers();
    }

    public void setName(String string) throws SettingException {
        this.networkName.setValue(string);
    }

    public int getState() {
        return this.networkState;
    }

    public String getName() {
        return this.networkName.getStringValue();
    }

    public String getSSHCommand() {
        return this.sshCommand.getStringValue();
    }

    public String getSCPCommand() {
        return this.scpCommand.getStringValue();
    }

    public String toString() {
        return this.getSettingOwnerClassName() + " " + this.getSettingOwnerName();
    }

    public void newNetwork(String string) {
        try {
            this.networkName.setValue(string);
            this.sshCommand.setValue("/usr/bin/ssh2");
            this.scpCommand.setValue("/usr/bin/scp2");
        }
        catch (SettingException settingException) {
            // empty catch block
        }
        this.fileSystems.removeAllElements();
        this.setChanged();
        this.notifyObservers(null);
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return 3;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.networkName;
            }
            case 1: {
                return this.sshCommand;
            }
        }
        return this.scpCommand;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Network Profile";
    }

    @Override
    public int getSettingOwnerID() {
        return 18;
    }

    @Override
    public String getSettingOwnerName() {
        return this.getName();
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.notifyChanged(this);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    public int addFileSystem(String string, String string2, String string3) {
        FileSystem fileSystem = new FileSystem(this, string, string2, string3);
        this.fileSystems.add(fileSystem);
        return this.fileSystems.indexOf(fileSystem);
    }

    public void deleteFileSystem(FileSystem fileSystem) {
        this.fileSystems.remove(fileSystem);
        this.setChanged();
        this.notifyObservers(null);
    }

    public FileSystem getFileSystem(int n) {
        return (FileSystem)this.fileSystems.get(n);
    }

    public int getNumFileSystems() {
        return this.fileSystems.size();
    }

    public SimulatorResultsFile getResultsFile() {
        return this.srf;
    }

    public void removeAll() {
        this.fileSystems.clear();
    }

    public void doTesting() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SimulatorNetworkHandler.this.setState(1);
                    for (int i = 0; i < SimulatorNetworkHandler.this.getNumHosts(); ++i) {
                        SimulatorNetworkHandler.this.getHost(i).testHost();
                    }
                    while (SimulatorNetworkHandler.this.allNotTesting()) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SimulatorNetworkHandler.this.setState(0);
            }
        });
        thread.start();
    }

    private boolean allNotTesting() {
        for (int i = 0; i < this.getNumHosts(); ++i) {
            if (this.getHost(i).getHostState() != 4) continue;
            return false;
        }
        return true;
    }

    public void doNetworking(int n, long l, File file, boolean bl, boolean bl2) {
        this.doNetworking(n, l, file, bl, bl2, null, null, null);
    }

    public void doNetworking(int n, long l, File file, boolean bl, boolean bl2, Values values, ArrayList arrayList, ResultsCollection resultsCollection) {
        this.simBinary = file;
        this.maxPathLength = l;
        this.noIterations = n;
        this.feedback = bl;
        this.resultsFeedback = bl2;
        this.modelConstants = values;
        this.propertyConstantRanges = arrayList;
        this.resultsCollection = resultsCollection;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SSHHost sSHHost;
                    int n;
                    int n2;
                    System.out.println("RUNNING THE NETWORK");
                    SimulatorNetworkHandler.this.setState(1);
                    RemoteHandler.configure(SimulatorNetworkHandler.this.sshCommand.toString(), SimulatorNetworkHandler.this.scpCommand.toString());
                    for (n2 = 0; n2 < SimulatorNetworkHandler.this.fileSystems.size(); ++n2) {
                        SimulatorNetworkHandler.this.getFileSystem(n2).sendFiles(SimulatorNetworkHandler.this.simBinary);
                    }
                    n2 = SimulatorNetworkHandler.this.countReadyHosts();
                    int n3 = (SimulatorNetworkHandler.this.noIterations - SimulatorNetworkHandler.this.countIterationsDone()) / n2;
                    for (n = 0; n < SimulatorNetworkHandler.this.getNumHosts(); ++n) {
                        sSHHost = SimulatorNetworkHandler.this.getHost(n);
                        if (sSHHost.getHostState() != 1 && sSHHost.getHostState() != 0) continue;
                        sSHHost.startStint(n3, SimulatorNetworkHandler.this.maxPathLength, SimulatorNetworkHandler.this.simBinary.getName(), SimulatorNetworkHandler.this.feedback, SimulatorNetworkHandler.this.resultsFeedback);
                    }
                    SimulatorNetworkHandler.this.srf.reset();
                    try {
                        while (SimulatorNetworkHandler.this.countIterationsDone() < SimulatorNetworkHandler.this.noIterations && SimulatorNetworkHandler.this.countOkayHosts() > 0) {
                            for (n = 0; n < SimulatorNetworkHandler.this.getNumHosts(); ++n) {
                                sSHHost = SimulatorNetworkHandler.this.getHost(n);
                                int n4 = sSHHost.getHostState();
                                if (n4 == 7) {
                                    sSHHost.setErroneousStintToZero();
                                    continue;
                                }
                                if (n4 == 6) {
                                    sSHHost.doneSuccessfulStint();
                                    System.out.println("");
                                    System.out.println("");
                                    System.out.println("done a stint");
                                    System.out.println("");
                                    System.out.println("");
                                    SimulatorNetworkHandler.this.sortOutResultsFile(true);
                                    System.out.println("srf = " + SimulatorNetworkHandler.this.srf.toString());
                                    continue;
                                }
                                if (n4 != 1 && n4 != 0) continue;
                                int n5 = SimulatorNetworkHandler.this.noIterations - SimulatorNetworkHandler.this.countIterationsAssigned();
                                int n6 = n5;
                                if (n6 > 0) {
                                    System.out.println("use is " + n6);
                                }
                                if (n5 > 1000) {
                                    System.out.println("left is > 1000");
                                    int n7 = SimulatorNetworkHandler.this.getNumHosts() - SimulatorNetworkHandler.this.countOkayHosts();
                                    if (n7 > 0) {
                                        System.out.println("numfailed > 0");
                                        System.out.println("formula = " + SimulatorNetworkHandler.this.noIterations / SimulatorNetworkHandler.this.getNumHosts() * n7 / SimulatorNetworkHandler.this.countOkayHosts());
                                        System.out.println("noLeftToGo =" + n5);
                                        System.out.println("use = " + n6);
                                        n6 = Math.min(n6, SimulatorNetworkHandler.this.noIterations / SimulatorNetworkHandler.this.getNumHosts() * n7 / SimulatorNetworkHandler.this.countOkayHosts());
                                    }
                                    n6 = Math.max(1000, n6);
                                }
                                if (n6 <= 0) continue;
                                sSHHost.startStint(n6, SimulatorNetworkHandler.this.maxPathLength, SimulatorNetworkHandler.this.simBinary.getPath(), SimulatorNetworkHandler.this.feedback, SimulatorNetworkHandler.this.resultsFeedback);
                            }
                            if (SimulatorNetworkHandler.this.resultsFeedback) {
                                SimulatorNetworkHandler.this.sortOutResultsFile(true);
                            }
                            Thread.sleep(200L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (int i = 0; i < SimulatorNetworkHandler.this.getNumHosts(); ++i) {
                        sSHHost = SimulatorNetworkHandler.this.getHost(i);
                        if (sSHHost.getHostState() != 8) continue;
                        sSHHost.doneSuccessfulStint();
                    }
                    SimulatorNetworkHandler.this.sortOutResultsFile(false);
                    SimulatorNetworkHandler.this.setState(0);
                    System.out.println(SimulatorNetworkHandler.this.srf);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("error ");
                    SimulatorNetworkHandler.this.setState(0);
                }
            }
        });
        thread.start();
    }

    public void stopNetworking() throws PrismException {
        for (int i = 0; i < this.getNumHosts(); ++i) {
            this.getHost(i).stopStint();
        }
    }

    public void sortOutResultsFile(boolean bl) {
        int n;
        this.srf.reset();
        if (bl) {
            n = 1;
            for (int i = 0; i < this.getNumHosts() && n != 0; ++i) {
                n = !this.getHost(i).haveResultsChanged() ? 1 : 0;
            }
            if (n != 0) {
                return;
            }
        }
        for (n = 0; n < this.getNumHosts(); ++n) {
            SSHHost sSHHost = this.getHost(n);
            for (int i = 0; i < sSHHost.getTotalStints(); ++i) {
                File file = sSHHost.getResultsFile(i);
                try {
                    System.out.println("merging results file " + n + "," + i);
                    this.srf.mergeResultsFile(file);
                    continue;
                }
                catch (PrismException prismException) {
                    System.out.println("exception " + prismException.getMessage());
                }
            }
            if (!bl || !sSHHost.hasTempResults()) continue;
            try {
                this.srf.mergeResultsFile(sSHHost.getTempResults());
                continue;
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        if (this.resultsCollection != null && this.modelConstants != null && this.propertyConstantRanges != null) {
            for (n = 0; n < this.propertyConstantRanges.size(); ++n) {
                Values values = (Values)this.propertyConstantRanges.get(n);
                double d = this.srf.getResult(n);
                Double d2 = d < 0.0 ? null : new Double(d);
                this.resultsCollection.setResult(this.modelConstants, values, d2);
            }
        }
        this.srf.tellObservers();
    }

    public boolean stillRunning() {
        boolean bl = false;
        for (int i = 0; i < this.fileSystems.size() && !bl; ++i) {
            bl = this.getFileSystem(i).stillRunning();
        }
        return bl;
    }

    public int countReadyHosts() {
        int n = 0;
        for (int i = 0; i < this.getNumHosts(); ++i) {
            SSHHost sSHHost = this.getHost(i);
            if (sSHHost.getHostState() != 1 && sSHHost.getHostState() != 0) continue;
            ++n;
        }
        return n;
    }

    public int countOkayHosts() {
        int n = 0;
        for (int i = 0; i < this.getNumHosts(); ++i) {
            SSHHost sSHHost = this.getHost(i);
            if (sSHHost.getHostState() == 7 || sSHHost.getHostState() == 8) continue;
            ++n;
        }
        return n;
    }

    public int countIterationsDone() {
        int n = 0;
        for (int i = 0; i < this.getNumHosts(); ++i) {
            SSHHost sSHHost = this.getHost(i);
            n += sSHHost.getTotalDone();
        }
        return n;
    }

    public int countIterationsAssigned() {
        int n = 0;
        for (int i = 0; i < this.getNumHosts(); ++i) {
            SSHHost sSHHost = this.getHost(i);
            n += sSHHost.getNoToDoThisStint() + sSHHost.getTotalDone();
        }
        return n;
    }

    public void loadNetworkFromXML(File file) throws PrismException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this);
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            this.networkName.setValue(element.getAttribute("systemName"));
            this.sshCommand.setValue(element.getAttribute("sshCommand"));
            this.scpCommand.setValue(element.getAttribute("scpCommand"));
            NodeList nodeList = element.getChildNodes();
            this.removeAll();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("name");
                String string2 = element2.getAttribute("executeDir");
                String string3 = element2.getAttribute("binaryDir");
                String string4 = element2.getAttribute("resultsDir");
                this.addFileSystem(string, string3, string4);
                FileSystem fileSystem = this.getFileSystem(this.fileSystems.size() - 1);
                NodeList nodeList2 = element2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string5 = element3.getAttribute("hostName");
                    String string6 = element3.getAttribute("userName");
                    fileSystem.addHost(string5, string6);
                }
            }
        }
        catch (Exception exception) {
            this.removeAll();
            System.err.println("error in loading network " + exception);
            exception.printStackTrace();
            throw new PrismException(exception.getMessage());
        }
    }

    public void saveNetworkToXML(File file) throws PrismException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("prismNetwork");
            element.setAttribute("systemName", this.getName());
            element.setAttribute("sshCommand", this.getSSHCommand());
            element.setAttribute("scpCommand", this.getSCPCommand());
            for (int i = 0; i < this.getNumFileSystems(); ++i) {
                FileSystem fileSystem = this.getFileSystem(i);
                Element element2 = document.createElement("fileSystem");
                element2.setAttribute("name", fileSystem.getName());
                element2.setAttribute("executeDir", "");
                element2.setAttribute("binaryDir", fileSystem.getInputDir());
                element2.setAttribute("resultsDir", fileSystem.getOutputDir());
                for (int j = 0; j < fileSystem.getNumHosts(); ++j) {
                    SSHHost sSHHost = fileSystem.getHost(j);
                    Element element3 = document.createElement("host");
                    element3.setAttribute("hostName", sSHHost.getHostName());
                    element3.setAttribute("userName", sSHHost.getUserName());
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
            }
            document.appendChild(element);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-system", "prismnetwork.dtd");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
        }
        catch (DOMException dOMException) {
            throw new PrismException("Problem saving network settings: DOM Exception: " + dOMException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PrismException("Problem saving network settings: Parser Exception: " + parserConfigurationException.getMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new PrismException("Problem saving network settings: Error in creating XML: " + transformerConfigurationException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("Problem saving network settings: File Not Found: " + fileNotFoundException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new PrismException("Problem saving network settings: Transformer Exception: " + transformerException.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputStream inputStream;
        InputSource inputSource = null;
        if (string2.endsWith("dtd") && (inputStream = SimulatorNetworkHandler.class.getClassLoader().getResourceAsStream("dtds/prismnetwork.dtd")) != null) {
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    public void notifyChanged(TreeNode treeNode) {
        this.tableModel.fireTableDataChanged();
        this.setChanged();
        this.notifyObservers(treeNode);
    }

    public Enumeration children() {
        return this.fileSystems.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (TreeNode)this.fileSystems.get(n);
    }

    @Override
    public int getChildCount() {
        return this.fileSystems.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.fileSystems.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModel.addTableModelListener(tableModelListener);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableModel.getValueAt(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(n, n2);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModel.removeTableModelListener(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, n, n2);
    }

    private SSHHost getHost(int n) {
        for (int i = 0; i < this.getNumFileSystems(); ++i) {
            if (n >= this.getFileSystem(i).getNumHosts()) {
                n -= this.getFileSystem(i).getNumHosts();
                continue;
            }
            return this.getFileSystem(i).getHost(n);
        }
        return null;
    }

    private int getNumHosts() {
        int n = 0;
        for (int i = 0; i < this.getNumFileSystems(); ++i) {
            n += this.getFileSystem(i).getNumHosts();
        }
        return n;
    }
}

