/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import parser.State;
import parser.VarList;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class TransitionList {
    private ArrayList<Choice> choices = new ArrayList();
    private ArrayList<Integer> transitionIndices = new ArrayList();
    private ArrayList<Integer> transitionOffsets = new ArrayList();
    private int numChoices = 0;
    private int numTransitions = 0;
    private double probSum = 0.0;

    public void clear() {
        this.choices.clear();
        this.transitionIndices.clear();
        this.transitionOffsets.clear();
        this.numChoices = 0;
        this.numTransitions = 0;
        this.probSum = 0.0;
    }

    public void add(Choice choice) {
        this.choices.add(choice);
        int n = choice.size();
        for (int i = 0; i < n; ++i) {
            this.transitionIndices.add(this.choices.size() - 1);
            this.transitionOffsets.add(i);
        }
        ++this.numChoices;
        this.numTransitions += choice.size();
        this.probSum += choice.getProbabilitySum();
    }

    public void scaleProbabilitiesBy(double d) {
        for (int i = 0; i < this.numChoices; ++i) {
            this.getChoice(i).scaleProbabilitiesBy(d);
        }
    }

    public int getNumChoices() {
        return this.numChoices;
    }

    public int getNumTransitions() {
        return this.numTransitions;
    }

    public double getProbabilitySum() {
        return this.probSum;
    }

    public Choice getChoice(int n) {
        return this.choices.get(n);
    }

    public Choice getChoiceOfTransition(int n) {
        return this.choices.get(this.transitionIndices.get(n));
    }

    public int getChoiceIndexOfTransition(int n) {
        return this.transitionIndices.get(n);
    }

    public int getChoiceOffsetOfTransition(int n) {
        return this.transitionOffsets.get(n);
    }

    public int getTotalIndexOfTransition(int n, int n2) {
        return this.transitionIndices.indexOf(n) + n2;
    }

    public void getChoiceIndexByProbabilitySum(double d, Ref ref) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; d >= d3 && n < this.numChoices; d3 += d2, ++n) {
            d2 = this.getChoice(n).getProbabilitySum();
        }
        ref.i = n - 1;
        Choice choice = this.getChoice(n - 1);
        ref.offset = choice.size() > 1 ? choice.getIndexByProbabilitySum(d - (d3 - d2)) : 0;
    }

    public String getTransitionModuleOrAction(int n) {
        return this.getChoiceOfTransition(n).getModuleOrAction();
    }

    public int getTransitionModuleOrActionIndex(int n) {
        return this.getChoiceOfTransition(n).getModuleOrActionIndex();
    }

    public String getChoiceModuleOrAction(int n) {
        return this.getChoice(n).getModuleOrAction();
    }

    public int getChoiceModuleOrActionIndex(int n) {
        return this.getChoice(n).getModuleOrActionIndex();
    }

    public double getTransitionProbability(int n) {
        return this.getChoiceOfTransition(n).getProbability(this.transitionOffsets.get(n));
    }

    public String getTransitionUpdateString(int n, State state) throws PrismLangException {
        return this.getChoiceOfTransition(n).getUpdateString(this.transitionOffsets.get(n), state);
    }

    public String getTransitionUpdateStringFull(int n) {
        return this.getChoiceOfTransition(n).getUpdateStringFull(this.transitionOffsets.get(n));
    }

    public State computeTransitionTarget(int n, State state) throws PrismLangException {
        return this.getChoiceOfTransition(n).computeTarget(this.transitionOffsets.get(n), state);
    }

    public boolean isDeadlock() {
        return this.numChoices == 0;
    }

    public boolean isDeterministic() {
        return this.numTransitions == 1 && this.getChoice(0).getProbability(0) == 1.0;
    }

    public boolean isDeterministicSelfLoop(State state) {
        State state2 = new State(state);
        try {
            for (Choice choice : this.choices) {
                int n = choice.size();
                for (int i = 0; i < n; ++i) {
                    choice.computeTarget(i, state, state2);
                    if (state.equals(state2)) continue;
                    return false;
                }
            }
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
        return true;
    }

    public void checkValid(ModelType modelType) throws PrismException {
        for (Choice choice : this.choices) {
            choice.checkValid(modelType);
        }
    }

    public void checkForErrors(State state, VarList varList) throws PrismException {
        for (Choice choice : this.choices) {
            choice.checkForErrors(state, varList);
        }
    }

    public String toString() {
        Object object = "";
        boolean bl = true;
        for (Choice choice : this.choices) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + choice.toString();
        }
        return object;
    }

    public class Ref {
        public int i;
        public int offset;
    }
}

