/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class FormulaList
extends ASTElement {
    private Vector<String> names = new Vector();
    private Vector<Expression> formulas = new Vector();
    private Vector<ExpressionIdent> nameIdents = new Vector();

    public void addFormula(ExpressionIdent expressionIdent, Expression expression) {
        this.names.addElement(expressionIdent.getName());
        this.formulas.addElement(expression);
        this.nameIdents.addElement(expressionIdent);
    }

    public void setFormulaName(int n, ExpressionIdent expressionIdent) {
        this.names.set(n, expressionIdent.getName());
        this.nameIdents.set(n, expressionIdent);
    }

    public void setFormula(int n, Expression expression) {
        this.formulas.set(n, expression);
    }

    public int size() {
        return this.formulas.size();
    }

    public String getFormulaName(int n) {
        return this.names.elementAt(n);
    }

    public Expression getFormula(int n) {
        return this.formulas.elementAt(n);
    }

    public ExpressionIdent getFormulaNameIdent(int n) {
        return this.nameIdents.elementAt(n);
    }

    public int getFormulaIndex(String string) {
        return this.names.indexOf(string);
    }

    public void findCycles() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.getFormula(n).getAllFormulas();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n3 = this.getFormulaIndex((String)((Vector)object).elementAt(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in definition of formula \"" + this.getFormulaName(n) + "\"";
            throw new PrismLangException((String)object, this.getFormula(n));
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "formula " + this.getFormulaName(i);
            object = (String)object + " = " + this.getFormula(i) + ";\n";
        }
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        FormulaList formulaList = new FormulaList();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            formulaList.addFormula((ExpressionIdent)this.getFormulaNameIdent(i).deepCopy(), this.getFormula(i).deepCopy());
        }
        formulaList.setPosition(this);
        return formulaList;
    }
}

